package q02a.exe.comun.dataobjects;

import java.math.BigDecimal;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Vector;

import org.apache.commons.beanutils.BasicDynaBean;

import q02a.exe.arquitectura.dataobjects.Q02aDataBaseDAO;
import q02a.exe.comun.valueobjects.Q02aCoordenadas;
import q02a.exe.comun.valueobjects.Q02aPortal;
import q02a.exe.utils.Q02aFormatData;
import es.ejie.frmk.Q70Factoria;
import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;

/**
 * 
 * @author GADIMAAR
 *
 */
public class Q02aNoraDataBaseDAO extends Q02aDataBaseDAO {

	private static final long serialVersionUID = -8520551641771839103L;

	/**
     *
	 */
	public Q02aNoraDataBaseDAO() {

		super();

	}

	/**
     * 
     * @param conn conn
	 */
	public Q02aNoraDataBaseDAO(Connection conn) {

		super(conn);

	}

	
	/**
     * 
     * @param idCalle idCalle
     * @param bloque bloque
     * @param numero numero
     * @return coordenadas
     * @throws Exception Exception
	 */
	public Q02aCoordenadas obtenerCoordenadas (String idCalle, String bloque, String numero) throws Exception{
		Q02aCoordenadas coordenadas = new Q02aCoordenadas();
		
		try {
			if (tr.isTraceActive()) {
				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()	+ ":obtenerCoordenadas: entrando");
			}
			if ((!Q02aFormatData.esVacio(idCalle))&&(!Q02aFormatData.esVacio(numero))){	
				String propertiesCoordenadas  = q02a.exe.utils.Q02aConstantes.getString("tipoCoordenadas");
				ArrayList listaResultado = new ArrayList();
				//Vector que contendr las columnas a obtener
				Vector listaColumnas = new Vector(2);
				if (propertiesCoordenadas.equals("ED50")){
					listaColumnas.add("dx_ed50");
					listaColumnas.add("dy_ed50");
	
					StringBuffer cadSQLWhere = new StringBuffer("");
					cadSQLWhere.append("calle_id = '").append(idCalle).append("'");
					if (!Q02aFormatData.esVacio(bloque)){
					cadSQLWhere.append(" AND bloque = '").append(bloque).append("'");
					}
					cadSQLWhere.append(" AND numero = '").append(numero).append("'");
					listaResultado = Q70Factoria.getGestorTablasCodigos().selectRecordsFromTable("NORA_T17_PORTAL",cadSQLWhere.toString(),null,listaColumnas);
		
					for (int i=0;i<listaResultado.size();i++){
						//Se obtiene el objeto en concreto de la base de datos
						BasicDynaBean 		basicDynaBean 	= (BasicDynaBean)listaResultado.get(i);
						coordenadas.setCoordenadaX((BigDecimal)basicDynaBean.get("dx_ed50"));
						coordenadas.setCoordenadaY((BigDecimal)basicDynaBean.get("dy_ed50"));
					}
				} else if (propertiesCoordenadas.equals("ETRS89")){
					listaColumnas.add("dx_etrs89");
					listaColumnas.add("dy_etrs89");
	
					StringBuffer cadSQLWhere = new StringBuffer("");
					cadSQLWhere.append("calle_id = '").append(idCalle).append("'");
					if (!Q02aFormatData.esVacio(bloque)){
					cadSQLWhere.append(" AND bloque = '").append(bloque).append("'");
					}
					cadSQLWhere.append(" AND numero = '").append(numero).append("'");
					listaResultado = Q70Factoria.getGestorTablasCodigos().selectRecordsFromTable("NORA_T17_PORTAL",cadSQLWhere.toString(),null,listaColumnas);
		
					for (int i=0;i<listaResultado.size();i++){
						//Se obtiene el objeto en concreto de la base de datos
						BasicDynaBean 		basicDynaBean 	= (BasicDynaBean)listaResultado.get(i);
						coordenadas.setCoordenadaX((BigDecimal)basicDynaBean.get("dx_etrs89"));
						coordenadas.setCoordenadaY((BigDecimal)basicDynaBean.get("dy_etrs89"));
					}
				}
			}
		} catch (Exception ex) {
			java.io.StringWriter sw = new java.io.StringWriter();
			java.io.PrintWriter pw = new java.io.PrintWriter(sw);
			ex.printStackTrace(pw);
			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName()	+ ":obtenerCoordenadas: " + sw.getBuffer().toString());
			throw ex;
		}
		return coordenadas;
	}
	
	
	/**
     * 
     * @param codPortal codPortal
     * @return portal
     * @throws Exception Exception
	 */
	public Q02aPortal obtenerDatosPortal (String codPortal) throws Exception{
		//Q02aCoordenadas coordenadas = new Q02aCoordenadas();
		Q02aPortal portal=new Q02aPortal();
		
		try {
			if (tr.isTraceActive()) {
				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()	+ ":obtenerDatosPortal: entrando");
			}
				
			String where ="";
			if (!Q02aFormatData.esVacio(codPortal)){	
				String propertiesCoordenadas  = q02a.exe.utils.Q02aConstantes.getString("tipoCoordenadas");
				ArrayList listaResultado = new ArrayList();
				//Vector que contendr las columnas a obtener
				//Vector listaColumnas = new Vector(2);
				Vector listaColumnas = new Vector(5);
				if (propertiesCoordenadas.equals("ED50")){
					listaColumnas.add("dx_ed50");
					listaColumnas.add("dy_ed50");
					listaColumnas.add("bloque");
					listaColumnas.add("bis");
					listaColumnas.add("numero");
						
					where= " id="+codPortal; 
					listaResultado = Q70Factoria.getGestorTablasCodigos().selectRecordsFromTable("NORA_T17_PORTAL",where,null,listaColumnas);
		
					for (int i=0;i<listaResultado.size();i++){
						//Se obtiene el objeto en concreto de la base de datos
						BasicDynaBean 		basicDynaBean 	= (BasicDynaBean)listaResultado.get(i);
						portal.setCoordenadaX((BigDecimal)basicDynaBean.get("dx_ed50"));
						portal.setCoordenadaY((BigDecimal)basicDynaBean.get("dy_ed50"));
						portal.setBloq((String)basicDynaBean.get("bloque"));
						portal.setBis((String)basicDynaBean.get("bis"));
						portal.setNume((basicDynaBean.get("numero").toString()));			 				
					}
				} else if (propertiesCoordenadas.equals("ETRS89")){
					listaColumnas.add("dx_etrs89");
					listaColumnas.add("dy_etrs89");
					listaColumnas.add("bloque");
					listaColumnas.add("bis");
					listaColumnas.add("numero");
	
					
					where=" id="+codPortal; 
					listaResultado = Q70Factoria.getGestorTablasCodigos().selectRecordsFromTable("NORA_T17_PORTAL",where.toString(),null,listaColumnas);
		
					for (int i=0;i<listaResultado.size();i++){
						//Se obtiene el objeto en concreto de la base de datos
						BasicDynaBean 		basicDynaBean 	= (BasicDynaBean)listaResultado.get(i);
						portal.setCoordenadaX((BigDecimal)basicDynaBean.get("dx_etrs89"));
						portal.setCoordenadaY((BigDecimal)basicDynaBean.get("dy_etrs89"));
						portal.setBloq((String)basicDynaBean.get("bloque"));
						portal.setBis((String)basicDynaBean.get("bis"));
						portal.setNume(basicDynaBean.get("numero").toString());						
						
					}
				}
			}
		} catch (Exception ex) {
			java.io.StringWriter sw = new java.io.StringWriter();
			java.io.PrintWriter pw = new java.io.PrintWriter(sw);
			ex.printStackTrace(pw);
			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName()	+ ":obtenerDatosPortal: " + sw.getBuffer().toString());
			throw ex;
		}
		return portal;
	}

    /**
     * 
     * @param codCalle codCalle
     * @return idTipoVia
     * @throws Exception Exception
     */
    public String obtenerTViaCalle (String codCalle) throws Exception{
		    String idTipoVia="";
	   	   
		
		try {
			if (tr.isTraceActive()) {
				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()	+ ":obtenerTViaCalle: entrando");
			}			
    	    
			Vector listaColumnas = new Vector(1);
			ArrayList listaResultado = new ArrayList();
			listaColumnas.add("tipo_via_id");			
			listaResultado = Q70Factoria.getGestorTablasCodigos().selectRecordsFromTable("NORA_T17_CALLE"," id="+codCalle,null,listaColumnas);
			//for (int i=0;i<listaResultado.size();i++){
			if (listaResultado.size()>0) {
				//Se obtiene el objeto en concreto de la base de datos
				BasicDynaBean 		basicDynaBean 	= (BasicDynaBean)listaResultado.get(0);				
				idTipoVia=((String)basicDynaBean.get("tipo_via_id"));
			}
			//}
			if (tr.isTraceActive())
	   		{
	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerTViaCalle: saliendo");
	   		}
           return idTipoVia;
			
		} catch (Exception ex) {
			java.io.StringWriter sw = new java.io.StringWriter();
			java.io.PrintWriter pw = new java.io.PrintWriter(sw);
			ex.printStackTrace(pw);
			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName()	+ ":obtenerTViaCalle: " + sw.getBuffer().toString());
			throw ex;
		}
		
	}
}
