package q02a.exe.comun;

import java.sql.Connection;
import java.sql.ResultSet;

import q02a.exe.arquitectura.dataobjects.Q02aDataBaseDAO;
import q02a.exe.tablasBD.jdbc.oracle.Q02aTablaBDQ022IS01V02;
import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;
import es.ejie.frmk.infraestructura.traza.Q70Traza;

/**
 * 
 * @author GADIMAAR
 *
 */
public class Q02aUsuarioInformanteDataBaseDAO extends Q02aDataBaseDAO{

	private static final long serialVersionUID = -8520551641771839103L;
	private static Q70Traza tr = Q70Traza.getSingleton();
	private static final String COMPONENTE = "DAO_ACCESO_DATOS";
	
    /**
     * 
     *
     */
	public Q02aUsuarioInformanteDataBaseDAO() {
        super();                
    }
    
    /**
     * 
     * @param conn conn
     */
    public Q02aUsuarioInformanteDataBaseDAO(Connection conn) {
    	super(conn);     
    }
       
	/**
     * Mtodo que devuelve el dni de un informante 
     * @param  idUsuario idUsuario
     * @return dniInformante - String dni del informante
     * @throws Exception Exception
     */

    public String obtenerNiInformante(String idUsuario) throws Exception {
        
 		//se instancian los objetos necesarios para realizar la consulta.			
   		Q02aTablaBDQ022IS01V02 tabla022IS01V02 = null;
 		ResultSet rs = null;
 		
 		try{
 	    	if (tr.isTraceActive()){
 				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerDni: entrando");
 			}
 	    	//se instancia la clase del tablas bd a llamar pasandole la conexion
 	    	//se realiza la select
 	    	tabla022IS01V02 = new Q02aTablaBDQ022IS01V02(this.getConnection());
 	    	tabla022IS01V02.setQ022FT00_IDUSUARIO_WHERE(Integer.parseInt(idUsuario));
 	    	rs = tabla022IS01V02.select();
 	    	//aadimos el cursos para luego poder liberarlo ( en el freeResources)
 	    	tabla022IS01V02.addResultSet(rs); 
 	    	//se trata el resultado obtenido
 	    	String niInformante = "";

            if(rs.next()){
 	    		 niInformante = rs.getString(Q02aTablaBDQ022IS01V02.NOMCOLUMN_Q022IT00_ID_INF);
            }
            
 	    	return niInformante;    	
 		}catch(Exception ex){ 	   
     		java.io.StringWriter sw = new java.io.StringWriter();
     		java.io.PrintWriter pw = new java.io.PrintWriter(sw);
     		ex.printStackTrace(pw);
     		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerDni: " + sw.getBuffer ().toString());
     		throw ex;
 		}finally{
 		 	try{
 		 		//liberamos los recursos OJO! LOS QUE SE HAN AADIDO CON addResultSet
 		 		tabla022IS01V02.freeResourcesNotConnection();	
 			 }catch(Exception ex){
 			    if (tr.isTraceActive()){
 				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerDni: error liberando recursos.");
 	   	   	    }  
 			 }  		 			
 			 if (tr.isTraceActive()){
 				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerDni: saliendo.");                
 	         }   
 		}	
 	}
}

