package q02a.exe.comun;
 
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;

import javax.ejb.EJBException;

import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor.WHITE;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.hssf.util.Region;
 
public class Q02aImprimirExcel{
    
    
    private static final int TIPO2 = 0;
    private static final int TIPO3 = 1;
    private int iRow = 0;
    private static final int POSICION_4 = 4;
    private static final int POSICION_5 = 5;
    private static final int POSICION_8 = 8;
    private static final int POSICION_10 = 10;
    
    private HSSFWorkbook libroOrigen = null;
    private HSSFWorkbook libroDestino = null;
     
    private HashMap datos = new HashMap();
     
    private int columnas = 0;
    private int criterios = 0;
     
    private HSSFWorkbook getLibroOrigen(){
        return this.libroOrigen;
    }

    private void setLibroOrigen(HSSFWorkbook libroOrigen){
        this.libroOrigen = libroOrigen;
    }
 
    private HSSFWorkbook getLibroDestino(){
        return this.libroDestino;
    }

    private void setLibroDestino(HSSFWorkbook libroDestino){
        this.libroDestino = libroDestino;
    }

    private HSSFCellStyle cloneStyleFrom(HSSFCellStyle estiloOrigen, short numCell) {
        HSSFCellStyle estiloDestino = null;
 
        estiloDestino = getLibroDestino().createCellStyle();
        estiloDestino.setAlignment(estiloOrigen.getAlignment());
        estiloDestino.setBorderBottom(estiloOrigen.getBorderBottom());
        estiloDestino.setBorderLeft(estiloOrigen.getBorderLeft());
        estiloDestino.setBorderRight(estiloOrigen.getBorderRight());
        estiloDestino.setBorderTop(estiloOrigen.getBorderTop());
        estiloDestino.setBottomBorderColor(estiloOrigen.getBottomBorderColor());
        estiloDestino.setDataFormat(estiloOrigen.getDataFormat());
        estiloDestino.setFillBackgroundColor(estiloOrigen.getFillBackgroundColor());
        estiloDestino.setFillForegroundColor(estiloOrigen.getFillForegroundColor());
        estiloDestino.setFillPattern(estiloOrigen.getFillPattern());
 
        estiloDestino.setHidden(estiloOrigen.getHidden());
        estiloDestino.setIndention(estiloOrigen.getIndention());
        estiloDestino.setLeftBorderColor(estiloOrigen.getLeftBorderColor());
        estiloDestino.setLocked(estiloOrigen.getLocked());
        estiloDestino.setRightBorderColor(estiloOrigen.getRightBorderColor());
        estiloDestino.setTopBorderColor(estiloOrigen.getTopBorderColor());
        estiloDestino.setVerticalAlignment(estiloOrigen.getVerticalAlignment());
        estiloDestino.setWrapText(estiloOrigen.getWrapText());

        return estiloDestino;
   }
 
    public ByteArrayOutputStream escribirExcel(){
        
        String pathLibro = "/datos/q02a/file/";
        ByteArrayOutputStream out2 = new ByteArrayOutputStream();
        
            try {
                setLibroOrigen(new HSSFWorkbook(new FileInputStream(pathLibro + "Plantilla1.xls")));
 
                HSSFWorkbook xls = getLibroOrigen();//libro
                HSSFSheet sheet = xls.getSheetAt(0);//hoja
 
                HSSFWorkbook wb = new HSSFWorkbook();
                setLibroDestino(wb);

                HSSFSheet hojaSalida = wb.createSheet();

                this.iRow = 0;
                for (int j = 0; j < 10; j++){
                    HSSFRow row = sheet.getRow(j);
                        if (row != null){
                            HSSFRow r2 = hojaSalida.createRow((short)this.iRow);
                            r2.setHeight(row.getHeight());
     
                            crearHojaExcel(row, wb, hojaSalida, r2);
                        }
                    this.iRow += 1;
                }
 
                wb.write(out2);
                out2.close();
              }catch (FileNotFoundException fnfe){
                  fnfe.printStackTrace();
              }catch (IOException ioe){
                  ioe.printStackTrace();
              }
              return out2;
            }
 
        protected void crearHojaExcel(HSSFRow row, HSSFWorkbook wb, HSSFSheet hojaSalida, HSSFRow r2){
            int iDatos = 0;

            int iCell = 0;
            String s = "";
            
            for (int i = 0; i < getColumnas(); i++){
                HSSFCell cell = row.getCell((short)i);
 
                if (cell != null){
                    HSSFCellStyle cs = 
                    wb.createCellStyle();
                        //System.out.println("ROW= "+ row.getRowNum() + "//CELDA= " + cell.getCellNum() + "// ");
                    cs = cloneStyleFrom(cell.getCellStyle(), cell.getCellNum());
                    HSSFCell c2 = r2.createCell((short)iCell);
                    c2.setCellStyle(cs);

                    switch (cell.getCellType()){
                        case 0:
                            s = s + cell.getNumericCellValue();
                            Double amounts = new Double(s);
    
                            NumberFormat numberFormatters = NumberFormat.getNumberInstance();
                            s = numberFormatters.format(amounts);
     
                            wb.getSheetAt(0).addMergedRegion(new Region(this.iRow, (short)iCell, this.iRow, (short)(getColumnas() - 1)));

                            s = "";
                            break;
                        case 1:
                            
                            if ("Titulo".equals(cell.getStringCellValue())){
                                //System.out.println("entra en TITULO");
                                c2.setCellValue((String)this.datos.get("Titulo"));
                            }else if ("Criterios".equals(cell.getStringCellValue())){
                                //System.out.println("entra en CRITERIOS");
                                HSSFCellStyle csCrit = wb.createCellStyle();
 
                                csCrit = cloneStyleFrom(cell.getCellStyle(), cell.getCellNum());

                                i++;
                                cell = row.getCell((short)i);
 
                                String[] criterios = recuperarCriterios();

                                for (int k = 0; k < criterios.length; k++){
                                    if (criterios[k] == null){
                                        continue;}
                                    c2 = r2.createCell((short)iCell);
                                    c2.setCellStyle(csCrit);
                                    c2.setCellValue(criterios[k]);
    
                                    this.iRow += 1;
                                    r2 = hojaSalida.createRow((short)this.iRow);
                                    c2 = r2.createCell((short)iCell);
                                    c2.setCellStyle(cs);
                                }
 
                                c2 = r2.createCell((short)iCell);
                                c2.setCellStyle(cs);

                                for (int fila = 0; fila <= this.iRow; fila++){
                                    wb.getSheetAt(0).addMergedRegion( new Region(fila, (short)0, fila, (short)(getColumnas() - 1)) );
                                }

                            }else if ("Cabeceras".equals(cell.getStringCellValue())){
                                //System.out.println("entra en CABECERAS");
                                 String[] cabeceras = recuperarCabeceras();
                                 for (int k = 0; k < cabeceras.length; k++){
                                       if (cabeceras[k] != null) {
                                         c2 = r2.createCell((short)iCell);
                                         c2.setCellStyle(cs);
                                         c2.setCellValue(cabeceras[k]);
                                         iCell++;
                                       }
                                 }
 
                            }else{
                                //System.out.println("entra en VALORES -->" + cell.getStringCellValue() + "//");
                                if ( !"Valores".equals(cell.getStringCellValue()) ){
                                    break;
                                }
                                HSSFCellStyle csDatosDcha = asignarEstiloCelda(wb, cell);
                                 HSSFCellStyle csDatosIzq = wb.createCellStyle();
 
                                csDatosIzq = cloneStyleFrom(csDatosDcha, cell.getCellNum());
                                csDatosIzq.setAlignment((short)1);

                                TreeMap valores = recuperarTree();

                                Set keys = valores.keySet();
                                Iterator it2 = keys.iterator();
                                iDatos = 0;

                                while (it2.hasNext()){
                                    String keyStr = (String)it2.next();
                                    String[] elementos = keyStr.split("_");
                                    Integer key = new Integer(elementos[0]);

                                    if (iDatos != key.intValue()){
                                        iDatos = key.intValue();
                                        
                                        c2 = r2.createCell((short)iCell);
                                        c2.setCellStyle(cs);
 
                                        //wb.getSheetAt(0).addMergedRegion(new Region(this.iRow, (short)(getColumnas() - 1), this.iRow, (short)iCell));
                                        iCell++;
 
                                        this.iRow += 1;
                                        iCell = 0;
                                        r2 = hojaSalida.createRow((short)this.iRow);
                                    }
                                    c2 = r2.createCell((short)iCell);
               
                                    try{
                                        if ( valores.get(keyStr) != null && !"".equals(valores.get(keyStr).toString()) ){
                                            String cadenaUno = valores.get(keyStr).toString();
                                            //Alineo a la izda ao, mes y codlicencia
                                            if ( keyStr.indexOf("_00") != -1  || keyStr.indexOf("_01") != -1 ){
                                                if (cadenaUno.matches("[0-9]*")){
                                                    c2.setCellValue( Double.parseDouble( ((String)valores.get(keyStr)).replace(',', '.') ) );
                                                }
                                                c2.setCellStyle(csDatosIzq);
                                            }else{
                                                c2.setCellValue((String)valores.get(keyStr));
                                                c2.setCellStyle(csDatosDcha);
                                            }
                                            
                                        }else{
                                            c2.setCellValue("");
                                        }
                                            c2.getCellStyle().getAlignment();
                                    }catch (Exception ex){
                                        //System.out.println("EXCEP= "+ ex + " //" + (String)valores.get(keyStr)+ "//");
                                    }
                                    /*
                                    try{
                                        Double.parseDouble(((String)valores.get(keyStr)).replace(',', '.'));
                                        c2.setCellStyle(csDatosDcha);
                                        c2.setCellValue((String)valores.get(keyStr));
                                        c2.getCellStyle().getAlignment();
                                    }catch (Exception ex){
                                        c2.setCellStyle(csDatosIzq);
                                        c2.getCellStyle().getAlignment();
                                        c2.setCellValue((String)valores.get(keyStr));
                                        System.out.println("VER222="+ ex + " //" + (String)valores.get(keyStr)+ "//");
                                    }*/
                                    iCell++;
                                }

                                iCell--;
                                
                            }// fin else -- Acaba de escribir los valores 
 
                        break;
                    }
                }
                iCell++;
            }
        }

        protected String[] recuperarCriterios(){
            Set e = this.datos.keySet();
            Iterator it = e.iterator();
            String[] criterios = new String[getCriterios()];
            
            while (it.hasNext()){
                
                String key = (String)it.next();
                if ((!key.startsWith("crit")) || (key.startsWith("critValor"))){
                    continue;}
                int indice = Integer.parseInt( key.substring(4));
                criterios[indice] = ((String)this.datos.get(key));
            }
            return criterios;
        }
        
        protected String[] recuperarCabeceras(){
            Set e = this.datos.keySet();
            Iterator it = e.iterator();
            String[] cabeceras = new String[getColumnas()];
            while (it.hasNext()){
                String key = (String)it.next();
                if (!key.startsWith("Cabecera")){
                    continue;}
                int indice = Integer.parseInt(key.substring(8));
                cabeceras[indice] = ((String)this.datos.get(key));
            }
            return cabeceras;
       }

        protected TreeMap recuperarTree(){
            Set e = this.datos.keySet();
            Iterator it = e.iterator();
            TreeMap valores = new TreeMap();
            
            while (it.hasNext()){
                String key = (String)it.next();
                if (!key.startsWith("Valor")){
                    continue;}
                String subStr = key.substring(5, key.length());
                //System.out.println("PRUEBA=" + this.datos.get(key) + "//");
                if (this.datos.get(key) != null && !"".equals(this.datos.get(key))){
                    valores.put(subStr, this.datos.get(key));
                }else{
                    valores.put(subStr, "");
                }
            }
            
            //QUITAR
           /* valores = new TreeMap();
            valores.put("000_00", "2012");
            valores.put("000_01", "1");
            valores.put("000_02", "");
            valores.put("000_03", "1234567890123456789012346");
            valores.put("000_04", "");
            valores.put("000_05", "");
            valores.put("001_00", "2012");
            valores.put("001_01", "2");
            valores.put("001_02", "");
            valores.put("001_03", "Aran1_Prueba");
            valores.put("001_04", "");
            valores.put("001_05", "");/*
            valores.put("002_00", "2012");
            valores.put("002_01", "2");
            valores.put("002_02", "");
            valores.put("002_03", "");
            valores.put("002_04", "");
            valores.put("002_05", "");
            valores.put("003_00", "2012");
            valores.put("003_01", "4");
            valores.put("003_02", "");
            valores.put("003_03", "");
            valores.put("003_04", "");
            valores.put("003_05", "");*/
            
            //FIN QUITAR
            return valores;
        }

        protected HSSFCellStyle asignarEstiloCelda(HSSFWorkbook wb, HSSFCell cell){
            HSSFCellStyle csDatosDcha = wb.createCellStyle();
 
            csDatosDcha = cloneStyleFrom(cell.getCellStyle(), cell.getCellNum());
            csDatosDcha.setFillForegroundColor(new HSSFColor.WHITE().getIndex());
            csDatosDcha.setFillBackgroundColor(new HSSFColor.WHITE().getIndex());

            csDatosDcha.setBorderBottom((short)1);
            csDatosDcha.setBorderLeft((short)1);
            csDatosDcha.setBorderRight((short)1);
            csDatosDcha.setBorderTop((short)1);
            csDatosDcha.setAlignment((short)3);
            return csDatosDcha;
        }
 
    public HashMap getDatos(){
        return this.datos;
    }
 
    public void setDatos(HashMap datos){
        this.datos = datos;
    }
 
    public int getColumnas(){
        return this.columnas;
    }
 
    public void setColumnas(int columnas){
        this.columnas = columnas;
    }

    public int getCriterios(){
        return this.criterios;
    }

    public void setCriterios(int criterios){
       this.criterios = criterios;
    }
}
