package q02a.exe.comun;

import java.io.IOException;
import java.util.HashMap;
import java.util.Vector;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest; 
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import q02a.exe.seguridad.beans.Q02aSeguridadBean;
import q02a.exe.seguridad.valueobjects.Q02aUsuario;
import q02a.exe.utils.Q02aConstantes;

import q02a.exe.utils.Q02aFormatData;
import es.ejie.frmk.infraestructura.seguridad.Q70GestorSeguridad;
import es.ejie.frmk.infraestructura.seguridad.Q70InformacionSeguridadUsuario;
import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;
import es.ejie.frmk.infraestructura.traza.Q70Traza;
import es.ejie.frmk.listeners.base.Q70ListenerUtils;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;

import java.util.ArrayList;

/**  
 * <p>Ttulo:Q02aFiltroSeguridad</p>
 * <p>Descripcin: Clase que realiza un filtro de seguridad</p>
 * <p>Copyright: Copyright (c) 2005</p>
 * @version 1.0
 * @author sdf
 **/

public class Q02aFiltroSeguridad implements Filter{
    //Variables que no se modifican
    private static String ESTADO_ACTIVADO   ="on";
    private static String COMPONENTE        ="FILTRO_SEGURIDAD";
    private static String USUARIO_CONTEXTO  = "user";
    private static String NOMBRE_USUARIO_CONTEXTO = "nombrePresentacion";
    private static String PERFIL_CONTEXTO   = "perfil";
    private static String PROVINCIA_CONTEXTO    = "provincia";
    private static String DESCPROVINCIA_CONTEXTO    = "descProvincia";    
    private static String MUNICIPIO_CONTEXTO    = "municipio";
    private static String DESCMUNICIPIO_CONTEXTO    = "descMunicipio";
    private static String PLAZOS_CONTEXTO   = "listaPlazos";    
    private static String PAG_ERROR         = "Error";
    private static String PAG_ERROR_ACCESO  = "ErrorAcceso";
    private static String PAG_ERROR_USUARIO     = "ErrorUsuario";
    private final  String ERROR_AUTENTICACION       = "/comunJSP/q02aSubmitUserNookXLNets.do";
    private static String MUNICIPIOS_CONTEXTO   = "listaMunicipios";  
    private static String DNIUSUARIO_CONTEXTO   = "dniUsuario";
    private static String SINOUSUADMIN_CONTEXTO   = "sinoUsuAdmin";
    
    //Variable para mostrar las trazas
    private static Q70Traza tr = Q70Traza.getSingleton();
    
    //Variable que representa el propio filtro
    private   FilterConfig filterConfig = null; 
    
    //Bean de seguridad para acceder a la informacin del usuario
    protected Q02aSeguridadBean beanSeguridad = null;

    /**
     * Filtro que tiene 3 posibles estados, indicados en una variable "estado", en el archivo "web.xml":
     * DEBUG --> Aade actions a los archivos properties de los usuarios.
     * ON --> Activa el filtro para el acceso no permitido de usuarios.
     * OFF(cualquier otro valor) --> Desactiva el filtro.
     * @param servletRequest servletRequest
     * @param servletResponse servletResponse
     * @param filterChain filterChain
     * @return
     * @throws ServletException ServletException
     * @throws IOException IOException
     */
    public void doFilter(ServletRequest servletRequest,ServletResponse servletResponse, FilterChain filterChain) 
        throws ServletException, IOException {
        //Variables que no se van a modificar
        final String TRACE_METODO = ":doFilter:";
        
        //Variables que se obtienen de la request
        HttpServletRequest  request     = (HttpServletRequest) servletRequest;
        HttpSession         session     = request.getSession();

        try{     
            if (tr.isTraceActive()) {
                tr.trace(COMPONENTE, Q70TraceLevel.DEBUG,this.getClass().getName() + TRACE_METODO + " :entrando.");                
            }  
            if (tr.isTraceActive()) {
               tr.trace(COMPONENTE, Q70TraceLevel.DEBUG,this.getClass().getName() + TRACE_METODO + " :URI: " + request.getRequestURI());                
            }
            
            //Se obtiene el contexto
            Q70ContextoEJIE contexto = (Q70ContextoEJIE)session.getAttribute("contexto");
          

            //Esto lo dejamos para cuando se defina como va a ser el login
            //Si el contexto est activo y el usuario autenticado no me hace falta recuperar la variable Xlnets de la request
            //Se comprueba el nombre del proceso               
            String rutaProceso  = (String)request.getRequestURI().substring(1);//Ruta completa del proceso ej. q02aCuestionariosWar/cuestionariosAyunMenJSP/q02aCuestionariosAyunMenInicioOP.do         
            String action       = rutaProceso.substring(rutaProceso.indexOf("/")+1);
            String nombreMant   = "";//Nombre del mantenimiento
            String nombreProceso= "";// nombre del proceso ej. q02aCuestionariosAyunMenInicioOP
            String aplicacionProceso = null;
//          Variable acceso login
            boolean accesoLogin = true;    
            if(action.indexOf("/")!=-1){                               
                nombreMant = action.substring(0,action.indexOf("/"));                              
                action = action.substring(action.indexOf("/")+1);
                nombreProceso = action.substring(0,action.indexOf("."));
                if (tr.isTraceActive()){
                	tr.trace(COMPONENTE, Q70TraceLevel.DEBUG,this.getClass().getName() + TRACE_METODO + " :nombreMant: " + nombreMant);
                	tr.trace(COMPONENTE, Q70TraceLevel.DEBUG,this.getClass().getName() + TRACE_METODO + " :action: " + action);
                	tr.trace(COMPONENTE, Q70TraceLevel.DEBUG,this.getClass().getName() + TRACE_METODO + " :nombreProceso: " + nombreProceso);
                }
            }
            if (tr.isTraceActive()) {
                tr.trace(COMPONENTE, Q70TraceLevel.DEBUG,this.getClass().getName() + TRACE_METODO + " :contexto: " + contexto);                
            }
            
            //Se obtiene la aplicacion a travs del proceso         
            if(nombreProceso.indexOf("q02a")>=0){
                aplicacionProceso = "q02a";
            }
            String iniXlnets=request.getParameter("XLNets");
            if("q02ainicio".equals(nombreProceso) && iniXlnets!=null){
                if (tr.isTraceActive()) {
                    tr.trace(COMPONENTE, Q70TraceLevel.DEBUG,this.getClass().getName() + TRACE_METODO + " : ACCESO XLNETS");                
                } 
                accesoLogin = false;
            }
            //COMPROBACIONES DE AUTENTICACION DEL USUARIO
//          Se obtiene la aplicacin en la cual nos encontramos
            String aplicacionContextoNulo = null;
            if(nombreProceso.indexOf("q02a")>=0){  
                   aplicacionContextoNulo = "q02a";
            }    
             //Se comprueba el acceso del login
            if(!accesoLogin){
                //Mtodo privado que da acceso al login
                 this.inicioAccesoUsuarioPki(servletRequest,servletResponse,filterChain,contexto,nombreProceso);
            }else{              
                    if (contexto == null){
                         if (tr.isTraceActive()){    
                               tr.trace(COMPONENTE, Q70TraceLevel.DEBUG,this.getClass().getName() + TRACE_METODO + " Contexto NULL");
                               tr.trace(COMPONENTE, Q70TraceLevel.DEBUG,this.getClass().getName() + TRACE_METODO + " Comparacin inicio: " + nombreProceso.indexOf("inicio"));
                               tr.trace(COMPONENTE, Q70TraceLevel.DEBUG,this.getClass().getName() + TRACE_METODO + " Comparacin q02aLogin: " + nombreProceso.equals("q02aLogin"));
                           }
                           //TODO
                           if ( !nombreProceso.equals(aplicacionContextoNulo+"LoginCues_eu") 
                                   && !nombreProceso.equals(aplicacionContextoNulo+"LoginCues") 
                                   && !nombreProceso.equals(aplicacionContextoNulo+"Login") 
                                   &&  !nombreProceso.equals(aplicacionContextoNulo+"Login2008SM") 
                                   && !nombreProceso.equals(aplicacionContextoNulo+"LoginCMF") ){
                               //si intentan entrar a traves de una url pero sin contesto le mandamos al login:
                               this.redireccionarLogin(request,servletResponse,aplicacionContextoNulo);
                           }else{
                               //si hay contexto le mandamos a depachar
                               filterChain.doFilter(servletRequest, servletResponse);
                           } 
                    }else{
                         //TODO
                        if (!nombreProceso.equals(aplicacionContextoNulo+"LoginCues_eu") 
                                && !nombreProceso.equals(aplicacionContextoNulo+"LoginCues") 
                                && !nombreProceso.equals(aplicacionContextoNulo+"Login") 
                                &&  !nombreProceso.equals(aplicacionContextoNulo+"Login2008SM") 
                                && !nombreProceso.equals(aplicacionContextoNulo+"LoginCMF")){
                           //si hay contexto y es cualquier pgina menos el login le dejamos que siga a delante
                            this.inicioAccesoUsuario(servletRequest,servletResponse,filterChain,contexto,nombreMant,nombreProceso);                     
                        }else{
    //                      si hay contexto, pero es la de login (caso de que hayan hecho un reload le mandamos al login)
                            filterChain.doFilter(servletRequest, servletResponse);
                        }
                    }
            }
      }catch (Exception ex) {
          java.io.StringWriter  sw = new java.io.StringWriter();
          java.io.PrintWriter   pw = new java.io.PrintWriter(sw);
          ex.printStackTrace(pw);
          if (tr.isTraceActive()){    
              tr.trace(COMPONENTE, Q70TraceLevel.ERROR,this.getClass().getName() + TRACE_METODO + sw.getBuffer().toString());
          } 
          //Se redirecciona a la pgina de error
          this.redireccionarError(request,servletResponse,this.getFilterConfig());   
      }
    }
    
    /**
     * Mtodo que permite el acceso a un usuario de Xlnets
     * 
     * @param servletRequest servletRequest
     * @param servletResponse servletResponse
     * @param filterChain filterChain
     * @param contexto contexto
     * @param nombreProceso nombreProceso
     * 
     * @throws Exception Exception
     */
    private void inicioAccesoUsuarioPki(ServletRequest servletRequest,ServletResponse servletResponse,FilterChain filterChain,Q70ContextoEJIE contexto,String nombreProceso) throws Exception{
        //Se declaran las variables que no se van a modificar
        final String TRACE_METODO           = ":inicioAccesoUsuarioPki:";
        final String USUARIO_CONTEXTO       = "user";
        
        //Variables de Xlnets
        boolean xlnetsActivo                = false;
        boolean xlnetNoOk                   = false;
        
        //Variables que se obtienen de la request
        HttpServletRequest  request     = (HttpServletRequest) servletRequest;
        HttpSession         session     = request.getSession();
                
        try{
            if (tr.isTraceActive()){
                tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()  + TRACE_METODO + ":entrando");                
            }
            
            if("q02aSubmitUserNookXLNets".equals(nombreProceso)){
                if (tr.isTraceActive()) {
                   tr.trace(COMPONENTE, Q70TraceLevel.DEBUG,this.getClass().getName() + TRACE_METODO + " :URI: " + nombreProceso);                
                }  
                filterChain.doFilter(servletRequest, servletResponse);
            }else{
                //Se comprueba si el contexto tiene valor
                if(contexto!=null){
                    if (tr.isTraceActive()){
                        tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()  + TRACE_METODO + ":CONTEXTO NO NULO");                
                    }
                    //Variable que tendr valor en el caso de que estemos en XLNETs
                    String iniXlnets=request.getParameter("XLNets");
                    //Si la variable tiene valor
                    if(iniXlnets!=null ){
                        if (tr.isTraceActive()){
                            tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()  + TRACE_METODO + ":CONTEXTO NO NULO:Recogemos Parmetros");                
                        }
                        //Se obtiene una variable que indica si la obtencin de parmetros XLNETs ha ido correctamente
                        xlnetNoOk = this.registrarParametrosXlnets(servletRequest,servletResponse, true);
                    }  
                    if(xlnetNoOk){
                        if (tr.isTraceActive()) {
                            tr.trace(COMPONENTE, Q70TraceLevel.DEBUG,this.getClass().getName() + TRACE_METODO + " redireccionamos a error XLNets.");                
                        }  
                        //Te redirecciona a la URL de Xlnets
                        //this.redireccionarError(request,servletResponse,PAG_ERROR_USUARIO);
                        this.redireccionarError(request,servletResponse,this.getFilterConfig());
                    }else{                      
                        //Se invoca al mtodo que gestiona la peticin de request de Xlnets
                        contexto.set("esUsuarioXLNets",new Boolean(true));
                        if(this.estaAutenticado((String)contexto.get(USUARIO_CONTEXTO))){
                            xlnetsActivo = true;
                        }
                        this.accesoUsuario(servletRequest,servletResponse,filterChain,contexto, xlnetsActivo);                      
                    }       
                    //Se indica que tenemos usuario xlnets
                }//fin de contexto no nulo
            }
        }catch(Exception ex){
            java.io.StringWriter sw = new java.io.StringWriter();
            java.io.PrintWriter pw = new java.io.PrintWriter(sw);
            ex.printStackTrace(pw);
            tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + TRACE_METODO + ":estaAutenticado: " + sw.getBuffer ().toString());            
            throw ex;
        }finally{               
            if (tr.isTraceActive()){
                tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()  + TRACE_METODO + ": saliendo :");                
            }                   
        }    
    }
    
    /**
     * Mtodo que permite el acceso a un usuario de Xlnets
     * 
     * @param servletRequest servletRequest
     * @param servletResponse servletResponse
     * @param filterChain filterChain
     * @param contexto contexto
     * @param nombreProceso nombreProceso
     * @param nombreMant nombreMant
     * 
     * @throws Exception Exception
     */
    private void inicioAccesoUsuario(ServletRequest servletRequest,ServletResponse servletResponse,FilterChain filterChain,Q70ContextoEJIE contexto,String nombreMant,String nombreProceso) throws Exception{
        //Se declaran las variables que no se van a modificar
        final String TRACE_METODO = ":inicioAccesoUsuarioXlnets:";
        //Variables de Xlnets
        boolean xlnetsActivo                = false;
        boolean xlnetNoOk                   = false;
        //Variables que se obtienen de la request
        HttpServletRequest  request     = (HttpServletRequest) servletRequest;
        HttpSession         session     = request.getSession();
        
        try{  
            if (tr.isTraceActive()){
                tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()  + TRACE_METODO + ":entrando");                
            }
         
            if("q02aSubmitUserNookXLNets".equals(nombreProceso)){
                    if (tr.isTraceActive()) {
                       tr.trace(COMPONENTE, Q70TraceLevel.DEBUG,this.getClass().getName() + TRACE_METODO + " :URI: " + nombreProceso);                
                    }    
                    filterChain.doFilter(servletRequest, servletResponse);
            }else{  
                        //contexto.set("esUsuarioXLNets",new Boolean(true));
                        if(!this.estaAutenticado((String)contexto.get(USUARIO_CONTEXTO))){              
                            //Se obtiene una variable que indica si la obtencin de parmetros XLNETs ha ido correctamente
                            //y se obtienen los datos de conexin
                            xlnetNoOk = this.registrarParametrosXlnets(servletRequest,servletResponse, false);
                            if(xlnetNoOk){
                                if (tr.isTraceActive()) {
                                    tr.trace(COMPONENTE, Q70TraceLevel.DEBUG,this.getClass().getName() + TRACE_METODO + " redireccionamos a XLNets.");                
                                }  
                                //Te redirecciona a la URL de Xlnets
                                //this.redireccionarError(request,servletResponse,PAG_ERROR_USUARIO);
                                this.redireccionarError(request,servletResponse,this.getFilterConfig());
                            }else{                      
                                //Se invoca al mtodo que gestiona la peticin de request de Xlnets
                                this.accesoUsuario(servletRequest,servletResponse,filterChain,contexto, false);
                            }                   
        
                        }else{
                            //Si ya est autenticado, se actualiza el idioma con lo que viene del portal
                            this.accesoUsuario(servletRequest,servletResponse,filterChain,contexto, false);
                        }     
                        //Hay que comprobar si el proceso al que quiere entrar tiene acceso, en funcin de su perfil
                        
                        /*if(!this.esProcesoPermitido((String)contexto.get(PERFIL_CONTEXTO),nombreMant)){
                            //Error Acceso
                            this.redireccionarError(request,servletResponse,PAG_ERROR_ACCESO);
                        }*/
            }
        }catch(Exception ex){
            java.io.StringWriter sw = new java.io.StringWriter();
            java.io.PrintWriter pw = new java.io.PrintWriter(sw);
            ex.printStackTrace(pw);
            tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + TRACE_METODO + ":error= " + sw.getBuffer ().toString());            
            throw ex;
        }finally{               
            if (tr.isTraceActive()){
                tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()  + TRACE_METODO + ": saliendo :");                
            }                   
        }    
    }

   /**
     * Mtodo que redirecciona a una pgina en la que se le indica al usuario que no tiene permiso para acceder 
     * alguna parte.
     * @param request request
     * @param servletResponse  servletResponse
     * @param filterConfig filterConfig
     * @throws ServletException ServletException
     * @throws IOException IOException  
     */  
    public void redireccionarError(HttpServletRequest request, ServletResponse servletResponse,FilterConfig filterConfig)  throws ServletException, IOException{
        //Recuperamos la pgina de error a la que va a ir
        try{
            if (tr.isTraceActive()){
                tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":redireccionarError: entrando");
            }   
            
            //INICIO: CONSTRUCCIN DE LA RUTA // DEL ERROR 
            String rutaProceso  = "";//Ruta completa del proceso ej. s99bAnaliticasWar/comunJSP/s99binicio.do
            String action       = "";//accin a ejecutar  ej. s99binicio.do
            String nombreProceso= "";// nombre del proceso ej. s99binicio
            
            rutaProceso = (String)request.getRequestURI().substring(1);
            action      = rutaProceso.substring(rutaProceso.indexOf("/")+1);
            
            if(action.indexOf("/")!=-1){
               action           = action.substring(action.indexOf("/")+1);
               nombreProceso    = action.substring(0,action.indexOf("."));
            }
            //FIN: CONSTRUCCIN DE LA RUTA
            
            //Se comprueba la aplicacion en la cual nos entramos
            String aplicacion = null;
            if(nombreProceso.indexOf("q02a")>=0){
                aplicacion = "q02a";
            }    
            RequestDispatcher dispatcher = null;
            //Con esta condicin se evita un bucle infinito
            //Si se vuelve con el .do s99bErrorAcceso se redirige a la pgina de error
            if (nombreProceso.indexOf(aplicacion+"ErrorAcceso")< 0){
                dispatcher = filterConfig.getServletContext().getRequestDispatcher("/comunJSP/"+aplicacion+"ErrorAcceso.do");
            }else{
                //dispatcher = filterConfig.getServletContext().getRequestDispatcher("/comunJSP/"+aplicacion+"Error.jsp");
                dispatcher = filterConfig.getServletContext().getRequestDispatcher("/comunJSP/"+aplicacion+"ErrorAcceso.jsp");
            }
            dispatcher.forward(request, servletResponse);           
        }catch(ServletException sex){
            java.io.StringWriter sw = new java.io.StringWriter();
            java.io.PrintWriter pw = new java.io.PrintWriter(sw);
            sex.printStackTrace(pw);
            if (tr.isTraceActive()){
            	tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":redireccionarError: " + sw.getBuffer ().toString());
            }
            throw sex;
        }catch(IOException ioex){
            java.io.StringWriter    sw = new java.io.StringWriter();
            java.io.PrintWriter     pw = new java.io.PrintWriter(sw);
            ioex.printStackTrace(pw);
            if (tr.isTraceActive()){
            	tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":redireccionarError: " + sw.getBuffer ().toString());
            }
            throw ioex;
        }finally{               
            if (tr.isTraceActive()){
                tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()  + " redireccionarError: saliendo");                
            }                   
        }       
   }
   

    /**
     * Mtodo que comprueba si un usuario est autenticado.
     * @param niUsuario nmero interno del usuario
     * @return Si es null o vaco devuelve false, en caso contrario true.
     * @throws Exception Exception
     */

    public boolean estaAutenticado(String niUsuario) throws Exception {
        boolean estaAutenticado = false;
        try{ 
            if (tr.isTraceActive()){
                tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":estaAutenticado: entrando: " + ":niUsuario: " + niUsuario);
            }
            if (niUsuario != null && !niUsuario.equals("")){
                estaAutenticado = true;
            }
            return estaAutenticado;
        }catch(Exception ex){
            java.io.StringWriter sw = new java.io.StringWriter();
            java.io.PrintWriter pw = new java.io.PrintWriter(sw);
            ex.printStackTrace(pw);
            tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":estaAutenticado: " + sw.getBuffer ().toString());            
            throw ex;
        }finally{               
            if (tr.isTraceActive()){
                tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()  + " estaAutenticado: saliendo con " + estaAutenticado);                
            }                   
        }       
    }

    /**
     * Mtodo que obtiene los parmetros XLNETs y los registra en la sesion
     * 
     * @param servletRequest servletRequest
     * @param servletResponse servletResponse
     * @param pki pki
     * @return boolean
     *  
     * @throws Exception Exception
     */
    private boolean registrarParametrosXlnets(ServletRequest servletRequest,ServletResponse servletResponse, boolean pki) throws Exception{
        //Se declaran las variables que no se van a modificar
        final String TRACE_METODO       = ":registrarParametrosXlnets:";
        final String COD_USUARIO_XLNETS     = "codUsuarioXlnets";
        final String IDI_USUARIO_XLNETS     = "idiomaXlnets";
        final String DNI_USUARIO_XLNETS     = "dniXlnets";
        //Variables de Xlnets  
        String  codUsuarioXlnets            = null; 
        String  idiomaXlnets                = null;
        String  dniXlnets                   = null; 
        boolean xlnetNoOk                   = false;
        
        try{ 
            //Variables que se obtienen de la request
            HttpServletRequest  request     = (HttpServletRequest) servletRequest;
            HttpSession         session     = request.getSession();
            
            if (tr.isTraceActive()) {
                tr.trace(COMPONENTE, Q70TraceLevel.DEBUG,this.getClass().getName() + TRACE_METODO + " :entrando");                

            }  

            if (pki ){
                //Se invoca la clase de Geremua que contiene la informacin de seguridad del framework
                Q70GestorSeguridad gestorSeguridad = Q70GestorSeguridad.getSingleton();
                if (tr.isTraceActive()) {
                    tr.trace(COMPONENTE, Q70TraceLevel.DEBUG,this.getClass().getName() + TRACE_METODO + " :gestorSeguridad.createSecurityUserInfo(request): init " );                
                }  
                //Se obtiene la informacin de XLNets del usuario a partir de la request
                Q70InformacionSeguridadUsuario datosXLNets =gestorSeguridad.createSecurityUserInfo(request);
                if (tr.isTraceActive()) {
                    tr.trace(COMPONENTE, Q70TraceLevel.DEBUG,this.getClass().getName() + TRACE_METODO + " :datosXLNets.getSessionSecurityInf(&#8220;n38login&#8221): init " );                
                }
                //Se obtiene un vector con los datos correspondientes al login
                Vector vectorPermisos = (Vector)datosXLNets.getSessionSecurityInf("n38login");
                if (tr.isTraceActive()) {
                    tr.trace(COMPONENTE, Q70TraceLevel.DEBUG,this.getClass().getName() + TRACE_METODO + " :(String)vectorPermisos.get(0): init " );                
                }
                //Se obtiene el cdigo del usuario XLNets
                codUsuarioXlnets = (String)vectorPermisos.get(0);
                if (tr.isTraceActive()) {
                    tr.trace(COMPONENTE, Q70TraceLevel.DEBUG,this.getClass().getName() + TRACE_METODO + " :session.setAttribute(COD_USUARIO_XLNETS,codUsuarioXlnets): init :codUsuarioXlnets: " + codUsuarioXlnets );                
                } 
                //Se obtiene un vector con los datos correspondientes al idioma
                Vector vectorIdioma = (Vector) datosXLNets.getSessionSecurityInf("n38idioma") ;  
                //Se obtiene el idioma de la sesin XLNets
                idiomaXlnets = (String)vectorIdioma.get(0);
                if (tr.isTraceActive()) {
                    tr.trace(COMPONENTE, Q70TraceLevel.DEBUG,this.getClass().getName() + TRACE_METODO + " :n38idioma: " + datosXLNets.getSessionSecurityInf("n38idioma") );                
                }
                if (tr.isTraceActive()) {
                    tr.trace(COMPONENTE, Q70TraceLevel.DEBUG,this.getClass().getName() + TRACE_METODO + " :session.setAttribute(IDI_USUARIO_XLNETS,idiomaXlnets): init :idiomaXlnets: " + idiomaXlnets );                
                }
                //Se obtiene un vector con los datos correspondientes al dni
                Vector vectorDni = (Vector) datosXLNets.getSessionSecurityInf("dni") ;  
                //Se obtiene el dni de la sesin XLNets
                dniXlnets = (String)vectorDni.get(0);
                if (tr.isTraceActive()) {
                    tr.trace(COMPONENTE, Q70TraceLevel.DEBUG,this.getClass().getName() + TRACE_METODO + " :dni: " + datosXLNets.getSessionSecurityInf("dni") );                
                }
                if (tr.isTraceActive()) {
                    tr.trace(COMPONENTE, Q70TraceLevel.DEBUG,this.getClass().getName() + TRACE_METODO + " :session.setAttribute(DNI_USUARIO_XLNETS,dniXlnets): init :dniXlnets: " + dniXlnets );                
                }
                //Se indica en la sesin el valor de dicho cdigo
                session.setAttribute(COD_USUARIO_XLNETS,codUsuarioXlnets);
                session.setAttribute(IDI_USUARIO_XLNETS,idiomaXlnets);
                session.setAttribute(DNI_USUARIO_XLNETS,dniXlnets);
            }else{              
                //PRUEBAS IE
                //recuperamos los valores de un fichero de configuracin            
                session.setAttribute(IDI_USUARIO_XLNETS,Q70ListenerUtils.getApplicationProperty("idiomaUsuarioLogin"));
                session.setAttribute(DNI_USUARIO_XLNETS,Q70ListenerUtils.getApplicationProperty("dniUsuarioLogin"));
            }
        }catch(Exception ex){
            if (tr.isTraceActive()) {
                tr.trace(COMPONENTE, Q70TraceLevel.DEBUG,this.getClass().getName() + TRACE_METODO + " :controladorLDAP: n38ItemSesion no tiene n38login.");                
            }  
            java.io.StringWriter sw = new java.io.StringWriter();
            java.io.PrintWriter pw = new java.io.PrintWriter(sw);
            ex.printStackTrace(pw);
            tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + TRACE_METODO + sw.getBuffer ().toString());
            xlnetNoOk = true;
        } 
        return xlnetNoOk;
    }
    
        
    /**
     * Mtodo que actualiza en session el idioma que le llega en la request, 
     * porque puede haber cambios de idioma sin pasar por la identificacin del usuario
     * 
     * @param servletRequest servletRequest
     * @param contexto contexto
     * 
     * @throws Exception Exception
     * */
    private void actualizarIdiomaDePortal(ServletRequest servletRequest,Q70ContextoEJIE contexto) throws Exception
    {
        final String TRACE_METODO           = ":actualizarIdiomaDePortal:";
        final String NOMBRE_VAR_IDIOMA_PORTAL       = "NOMBRE_REQUEST_IDIOMA_PORTAL";
        final String IDIOMA_ES              = "IDIOMA_ES";
        final String IDIOMA_EU              = "IDIOMA_EU";
        final String IDIOMA_PORTAL_ES           = "IDIOMA_PORTAL_ES";
        final String CONTEXTO_IDIOMA            = "idioma";
       
       try{
           HttpServletRequest   request     = (HttpServletRequest) servletRequest;
           //INICIO: IDIOMA SE COGE DEL PORTAL DE APLICACIONES, viene es/eu
           String nombreVarIdiomaPortal = Q02aConstantes.getString(NOMBRE_VAR_IDIOMA_PORTAL);
           //System.out.println(this.getClass().getName() + TRACE_METODO + " Nombre de la variable que recupera el idioma del portal: " + nombreVarIdiomaPortal);                
           String idioma = request.getParameter(nombreVarIdiomaPortal);
           if (tr.isTraceActive()) {
                   tr.trace(COMPONENTE, Q70TraceLevel.DEBUG,this.getClass().getName() + TRACE_METODO + " idioma de PORTAL:" + idioma);                
           } 
           if(idioma != null && !idioma.equals("")){
            tr.trace(COMPONENTE, Q70TraceLevel.DEBUG,this.getClass().getName() + TRACE_METODO + "El idioma actualmente almecenado en sesion=" + contexto.get(CONTEXTO_IDIOMA));                
            //System.out.println(this.getClass().getName() + TRACE_METODO + " El idioma actualmente almecenado en sesion=" + contexto.get(CONTEXTO_IDIOMA));                
            if(!idioma.equals((contexto.get(CONTEXTO_IDIOMA)==null?"":contexto.get(CONTEXTO_IDIOMA)))){
                tr.trace(COMPONENTE, Q70TraceLevel.DEBUG,this.getClass().getName() + TRACE_METODO + "Se actualiza el idioma con el del Portal: . " + idioma);                
                //System.out.println("Se actualiza el idioma con el del Portal: . " + idioma);
                if(Q70ListenerUtils.getApplicationProperty(IDIOMA_PORTAL_ES).equals(idioma)){
                    //contexto.set(CONTEXTO_IDIOMA_COMPARTIDO,Q70ListenerUtils.getApplicationProperty(IDIOMA_ES));
                    contexto.set(CONTEXTO_IDIOMA,Q70ListenerUtils.getApplicationProperty(IDIOMA_ES));
                } else {//Si no es Castellano, el idioma ser euskera
                    //contexto.set(CONTEXTO_IDIOMA_COMPARTIDO,Q70ListenerUtils.getApplicationProperty(IDIOMA_EU));
                    contexto.set(CONTEXTO_IDIOMA,Q70ListenerUtils.getApplicationProperty(IDIOMA_EU));
                }
            }
           }
       }catch(Exception ex){
            java.io.StringWriter sw = new java.io.StringWriter();
            java.io.PrintWriter pw = new java.io.PrintWriter(sw);
            ex.printStackTrace(pw);
            //System.out.println("Error " + TRACE_METODO + ":" + ex.getMessage());
            tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":"+ TRACE_METODO + ":" + sw.getBuffer ().toString());            
            //throw ex;
        }
    }
    
     /**
     * Mtodo que permite el acceso a un usuario de Xlnets
     * 
     * @param servletRequest servletRequest
     * @param servletResponse servletResponse
     * @param filterChain filterChain
     * @param contexto contexto
     * @param xlnetsActivo xlnetsActivo
     * 
     * @throws Exception Exception
     */

    private void accesoUsuario(ServletRequest servletRequest,ServletResponse servletResponse,FilterChain filterChain,Q70ContextoEJIE contexto, boolean xlnetsActivo) throws Exception
    {
        //Se declaran las variables que no se van a modificar
          //Se declaran las variables que no se van a modificar

        final String TRACE_METODO               = ":accesoUsuario:";
        final String COD_USUARIO_XLNETS         = "codUsuarioXlnets";
        final String IDI_USUARIO_XLNETS         = "idiomaXlnets";
        final String DNI_USUARIO_XLNETS         = "dniXlnets";
        final String USUARIO_CONTEXTO           = "user";
        final String USUARIO_DENIED             = "userDenied";
        final String PASSWORD_EXPIRED           = "passwordExpired";
        final String IDIOMA_XLNETS_ES           = "IDIOMA_XLNETS_ES";
        final String IDIOMA_ES                  = "IDIOMA_ES";
        final String IDIOMA_EU                  = "IDIOMA_EU";
        final String CONTEXTO_IDIOMA            = "idioma";
        final String CONTEXTO_IDIOMA_COMPARTIDO = "idiomaCompartido";
        final String CONTEXTO_APLICACION        = "aplicacion";
        final String ID_SUPER_USER              = "ID_SUPER_USER";        
        final String NOMBRE_VAR_IDIOMA_PORTAL   = "NOMBRE_REQUEST_IDIOMA_PORTAL";

        //Variable usuario
        Q02aUsuario usuario         = null;
                
        //Se obtiene la request y la sesion
        HttpServletRequest  request = (HttpServletRequest) servletRequest;
        HttpSession         session = request.getSession();
 
        //INICIO: CONSTRUCCIN DE LA RUTA
        String rutaProceso  = "";//Ruta completa del proceso ej. q02aAnaliticasWar/comunJSP/q02ainicio.do
        String war      = ""; // nombre de modulo war ej. q02aAnaliticasWar
        String action       = "";//accin a ejecutar  ej. q02ainicio.do
        String strut        = "";// ej. comunJSP 
        String nombreProceso    = "";// nombre del proceso ej. q02ainicio       
//      Variable que indica si es un super-usuario
        boolean     esSuperUsuario  = false;
        boolean     chequeoPassword = false;
       
        try{            
            rutaProceso =(String)request.getRequestURI().substring(1);
            war         = rutaProceso.substring(0,rutaProceso.indexOf("/"));
            action      = rutaProceso.substring(rutaProceso.indexOf("/")+1);
        
            if(action.indexOf("/")!=-1){
               strut = action.substring(0,action.indexOf("/"));//Tenemos el strut y el action
               action = action.substring(action.indexOf("/")+1);
               nombreProceso = action.substring(0,action.indexOf("."));
            }
            //FIN: CONSTRUCCIN DE LA RUTA
            
            if (tr.isTraceActive()) {
                   tr.trace(COMPONENTE, Q70TraceLevel.DEBUG,this.getClass().getName() + TRACE_METODO + ":WAR:"+war+":strut:"+strut);                
            } 
        
            //Se obtiene la aplicacion a travs del proceso
            String aplicacionProceso = null;
            if(nombreProceso.indexOf("q02a")>=0){
                aplicacionProceso = "q02a";
            }   
            
            String iniXlnets=request.getParameter("XLNets"); 
            if((aplicacionProceso+"AccesoCuestionario").equals(nombreProceso) 
                        || (aplicacionProceso+"SeleccionIdioma").equals(nombreProceso)){
                 if (tr.isTraceActive()) {
                       tr.trace(COMPONENTE, Q70TraceLevel.DEBUG,this.getClass().getName() + TRACE_METODO + " accesoCuestionario, ventanas previas al Login");                
                   }
                 //Se redirecciona al .do entrante
                 filterChain.doFilter(servletRequest, servletResponse); 
            }else if((aplicacionProceso+"inicio").equals(nombreProceso) && !xlnetsActivo && iniXlnets == null){
                   if (tr.isTraceActive()) {
                       tr.trace(COMPONENTE, Q70TraceLevel.DEBUG,this.getClass().getName() + TRACE_METODO + " q02ainicio y xlnetsActivo no activo  (Paso 1): Envia a /comunJSP/q02aLogin.do.");                
                   }  
                   //Se redirecciona el flujo al login de Xlnets
                   this.redireccionarFlujo(request,servletResponse,"/comunJSP/"+aplicacionProceso+"LoginXLNets.do",this.getFilterConfig());    
            }else{
//              Si el contexto es nulo se redirecciona a la direccin
                if(contexto== null){   
                     if (tr.isTraceActive()) {
                       tr.trace(COMPONENTE, Q70TraceLevel.DEBUG,this.getClass().getName() + TRACE_METODO + aplicacionProceso+"Login.do y XlnetsActivo " +  xlnetsActivo + "  pero sin contexto (Paso 2).");                
                     }  
                     //Se redirecciona al .do entrante
                     filterChain.doFilter(servletRequest, servletResponse);
                 }else{     
                     //INICIO: CONTEXTO NO NULO  
                      if (tr.isTraceActive()) {
                           tr.trace(COMPONENTE, Q70TraceLevel.DEBUG,this.getClass().getName() + TRACE_METODO + aplicacionProceso+"Login.do y XlnetsActivo activo y con contexto (Paso 3).");                
                      }    
                      //Se obtiene la variable que indica si es super-usuario
                      esSuperUsuario = ((Boolean)contexto.get("esSuperUsuario")).booleanValue();    
                      //Se comprueba si el usuario est autenticado (mirando la variable del contexto)
                      if (!this.estaAutenticado((String)contexto.get(USUARIO_CONTEXTO)) 
                              || (request.getParameter("usuario") != null 
                              && request.getParameter("password") != null)){
                          if (tr.isTraceActive()) {
                               tr.trace(COMPONENTE, Q70TraceLevel.DEBUG,this.getClass().getName() + TRACE_METODO + " Usuario XLNets no autenticado. Comprobamos sus datos.");                
                           }   
                          
                           //Se obtiene el usuario Xlnets de la sesin
                           String dniUsuarioXlnets = (String)session.getAttribute(DNI_USUARIO_XLNETS);  
                           //String codUsuarioXlnets = (String)session.getAttribute(COD_USUARIO_XLNETS);
                           //Se obtiene el usuario   
                           //String dniDemo = request.getParameter("dniDemo");
                           String dniUsuario = request.getParameter("usuario");
                           String password = request.getParameter("password");
                           if (dniUsuario != null  && !dniUsuario.equals("")){
                               if (tr.isTraceActive()) {
                                   tr.trace(COMPONENTE, Q70TraceLevel.DEBUG,this.getClass().getName() + TRACE_METODO + ":dniUsuario="+dniUsuario);                
                               }                              
                               usuario = this.obtenerUsuario(dniUsuario);
                               HashMap mapaFiltro = new HashMap ();
                               
                               if ( usuario.getGrupoAdmin() != null && !"".equals(usuario.getGrupoAdmin()) ){
                                   mapaFiltro.put("usuAdmin","siAdmin");
                                   contexto.set("filtro", mapaFiltro);
                               }else{
                                   mapaFiltro.put("usuAdmin","noAdmin");
                                   contexto.set("filtro", mapaFiltro);
                               }
                               //dni
                               if ( usuario.getDni() != null && !"".equals(usuario.getDni()) ){
                                   mapaFiltro.put("dniUsuario",usuario.getDni());
                                   contexto.set("filtro", mapaFiltro);
                                   
                               }
                               //if (usuario != null)
                                   chequeoPassword=this.checkPassword(password,usuario.getPass());
                           }else{
                               usuario = this.obtenerUsuario(dniUsuarioXlnets);
                               
                               
                                HashMap mapaFiltro = new HashMap ();
                               
                               if ( usuario.getGrupoAdmin() != null && !"".equals(usuario.getGrupoAdmin()) ){
                                   mapaFiltro.put("usuAdmin","siAdmin");
                                   contexto.set("filtro", mapaFiltro);
                               }else{
                                   mapaFiltro.put("usuAdmin","noAdmin");
                                   contexto.set("filtro", mapaFiltro);
                               }
                               //dni
                               if ( usuario.getDni() != null && !"".equals(usuario.getDni()) ){
                                   mapaFiltro.put("dniUsuario",usuario.getDni());
                                   contexto.set("filtro", mapaFiltro);
                                   
                               }
                                                              
                               //no llega password , no es necesario chequerar la password
                               chequeoPassword=true;
                           }
                           
                           //Si el usuario existe entro
                           //Se obtiene el usuario
                           //usuario = this.obtenerUsuario(codUsuarioXlnets);

                           if (tr.isTraceActive()) {
                                   tr.trace(COMPONENTE, Q70TraceLevel.DEBUG,this.getClass().getName() + TRACE_METODO + ":Usuario="+usuario);                
                           } 

                           //Si el usuario existe y la contrasea es correcta entro
                           //if(usuario!=null && this.checkPassword(password,usuario.getPass())){
                           if(usuario!=null && chequeoPassword){
                               if (tr.isTraceActive()) {
                                   tr.trace(COMPONENTE, Q70TraceLevel.DEBUG,this.getClass().getName() + TRACE_METODO + " Usuario XLNets Ok en q02a.");                
                               } 

                               //Se indica que es un usuario vlido
                               session.setAttribute(USUARIO_DENIED, new Boolean("false"));
                               //Se borra de la sesin el cdigo Xlnets puesto que ya no hace falta
                               session.removeAttribute(COD_USUARIO_XLNETS);
                               //Se borra de la sesin el dni Xlnets puesto que ya no hace falta
                               session.removeAttribute(DNI_USUARIO_XLNETS);
                               
                               //INICIO: IDIOMA XLNETS
                               //INICIO: IDIOMA SE COGE DEL PORTAL DE APLICACIONES, viene es/eu
                                 if (tr.isTraceActive()) {
                                   tr.trace(COMPONENTE, Q70TraceLevel.DEBUG,this.getClass().getName() + TRACE_METODO + "dniUsuarioXlnets"+dniUsuarioXlnets);                
                                   } 
                                String  idiomaXlnets=null;

                                //Acceso PKI
                                if (dniUsuarioXlnets!=null &&  !dniUsuarioXlnets.equals(""))
                                {
                                    idiomaXlnets = (String)session.getAttribute(IDI_USUARIO_XLNETS);
                                    
                                    //Se comprueba si la variable idiomaXlnets tiene valor
                                   if (idiomaXlnets != null  && !idiomaXlnets.equals("")){
                                        if (tr.isTraceActive()) {
                                           tr.trace(COMPONENTE, Q70TraceLevel.DEBUG,this.getClass().getName() + TRACE_METODO + "Poner Idioma en contexto"+idiomaXlnets);                
                                        } 
                                       //Si el idioma es Castellano, se aplica al contexto de aplicacin dicho idioma
                                       if(Q70ListenerUtils.getApplicationProperty(IDIOMA_XLNETS_ES).equals(idiomaXlnets)){
                                           contexto.set(CONTEXTO_IDIOMA_COMPARTIDO,Q70ListenerUtils.getApplicationProperty(IDIOMA_ES));
                                           contexto.set(CONTEXTO_IDIOMA,Q70ListenerUtils.getApplicationProperty(IDIOMA_ES));
                                       } else {//Si no es Castellano, el idioma ser euskera
                                           contexto.set(CONTEXTO_IDIOMA_COMPARTIDO,Q70ListenerUtils.getApplicationProperty(IDIOMA_EU));
                                           contexto.set(CONTEXTO_IDIOMA,Q70ListenerUtils.getApplicationProperty(IDIOMA_EU));
                                       }    
                                   }else{
                                        //En el caso de que no tuviera valor se indica por defecto castellano
                                       contexto.set(CONTEXTO_IDIOMA_COMPARTIDO,Q70ListenerUtils.getApplicationProperty(IDIOMA_ES));
                                       contexto.set(CONTEXTO_IDIOMA,Q70ListenerUtils.getApplicationProperty(IDIOMA_ES));
                                   }
                                }

                               /*
                               String nombreVarIdiomaPortal = Q02aConstantes.getString(NOMBRE_VAR_IDIOMA_PORTAL);                              
                               String idiomaPortal = request.getParameter(nombreVarIdiomaPortal);
                               if (tr.isTraceActive()) {
                                   tr.trace(COMPONENTE, Q70TraceLevel.DEBUG,this.getClass().getName() + TRACE_METODO + " idiomaPortal: . " + idiomaPortal);                
                               }  
                               //Se obtiene el idioma de Xlnets
                           
                               if(idiomaPortal != null && !idiomaPortal.equals("")){                                    
                                   this.actualizarIdiomaDePortal(request, contexto);                                   
                               }else{ 
                                   //se recupera de XLNets
                                   String idiomaXlnets = (String)session.getAttribute(IDI_USUARIO_XLNETS);
                                   if (tr.isTraceActive()) {
                                       tr.trace(COMPONENTE, Q70TraceLevel.DEBUG,this.getClass().getName() + TRACE_METODO + " idiomaXlnets EN SESION: . " + idiomaXlnets);                
                                   }     
                                   //Se comprueba si la variable idiomaXlnets tiene valor
                                   if (idiomaXlnets != null  && !idiomaXlnets.equals("")){
                                       //Si el idioma es Castellano, se aplica al contexto de aplicacin dicho idioma
                                       if(Q70ListenerUtils.getApplicationProperty(IDIOMA_XLNETS_ES).equals(idiomaXlnets)){
                                           contexto.set(CONTEXTO_IDIOMA_COMPARTIDO,Q70ListenerUtils.getApplicationProperty(IDIOMA_ES));
                                           contexto.set(CONTEXTO_IDIOMA,Q70ListenerUtils.getApplicationProperty(IDIOMA_ES));
                                       } else {//Si no es Castellano, el idioma ser euskera
                                           contexto.set(CONTEXTO_IDIOMA_COMPARTIDO,Q70ListenerUtils.getApplicationProperty(IDIOMA_EU));
                                           contexto.set(CONTEXTO_IDIOMA,Q70ListenerUtils.getApplicationProperty(IDIOMA_EU));
                                       }    
                                   }else{
                                        //En el caso de que no tuviera valor se indica por defecto castellano
                                       contexto.set(CONTEXTO_IDIOMA_COMPARTIDO,Q70ListenerUtils.getApplicationProperty(IDIOMA_ES));
                                       contexto.set(CONTEXTO_IDIOMA,Q70ListenerUtils.getApplicationProperty(IDIOMA_ES));
                                   }  
                                   //Se borra de la sesin el idioma Xlnets puest
                                   session.removeAttribute(IDI_USUARIO_XLNETS);
                               }//fin de comprobacin de idiomas
                               */
                               if (tr.isTraceActive()) {
                                   tr.trace(COMPONENTE, Q70TraceLevel.DEBUG,this.getClass().getName() + TRACE_METODO + "Comprobamos si es Super-User.");                
                               }   
                               //Se obtiene el DNI del usuario
                               String usuarioDNI = usuario.getDni();
                               //Se comprueba si es un super-usuario
                               if(Q02aConstantes.getString(ID_SUPER_USER).indexOf(usuarioDNI)>=0){
                                   //Si el usuario es un super-usuario modificamos la variable del contexto
                                   //para poder acceder a ella siempre que se desee
                                   contexto.set("esSuperUsuario",new Boolean(true));
                                   //Se modifica la variable local
                                   esSuperUsuario = true;
                               }  
                               if (tr.isTraceActive()) {
                                   tr.trace(COMPONENTE, Q70TraceLevel.DEBUG,this.getClass().getName() + TRACE_METODO + " Es Super-User : " + esSuperUsuario);                
                               }
                               
                               //INICIO: CARGA DE AUTENTICADOR
                               if (tr.isTraceActive()) {
                                   tr.trace(COMPONENTE, Q70TraceLevel.DEBUG,this.getClass().getName() + TRACE_METODO + " :cargaAutenticador:init");                
                               } 
                               //Se carga el autenticador
                               this.cargaAutenticador(contexto, usuario);
                               this.cargaPlazos(contexto, usuario);
                               this.cargaMunicipios(contexto, usuario);
                               
                               if (tr.isTraceActive()) {
                                   tr.trace(COMPONENTE, Q70TraceLevel.DEBUG,this.getClass().getName() + TRACE_METODO + " :cargaAutenticador:fin");                
                               } 
                               //FIN: CARGA DE AUTENTICADOR  
                 
                               //Cargamos el nombre de la aplicacin
                               contexto.set("aplicacion",((HttpServletRequest) servletRequest).getSession().getServletContext().getInitParameter("aplicacion"));
                               //Se obtiene la aplicacion
                               String aplicacion = (String)contexto.get("aplicacion");
                               //Variable que contiene si se tiene acceso                                                      
                               boolean acceso = false;
                               //En caso de ser un super-usuario, siempre se tiene acceso
                               if(esSuperUsuario){
                                   acceso = true;
                               }else{
                                   //Se obtiene si tenemos permiso o no para un proceso determinado
                                   acceso = this.esProcesoPermitido(usuario.getId(),rutaProceso,aplicacion);
                               }            
                               //INICIO:MODULO WAR
                               if (tr.isTraceActive()) {
                                    tr.trace(COMPONENTE, Q70TraceLevel.DEBUG,this.getClass().getName() + TRACE_METODO + " :obtenerNombreModulo: init ");                
                               }
                               contexto.set("modulo",this.obtenerNombreModulo(request,contexto));
                               if (tr.isTraceActive()) { 
                                    tr.trace(COMPONENTE, Q70TraceLevel.DEBUG,this.getClass().getName() + TRACE_METODO + " :obtenerNombreModulo: fin ");                
                               }
                               //Si se tiene permiso se entra
                               if(acceso){
                                   if (tr.isTraceActive()) {
                                       tr.trace(COMPONENTE, Q70TraceLevel.DEBUG,this.getClass().getName() + TRACE_METODO + " Permiso concedido : " + acceso );                
                                   }  
                                   //Si no es un super-usuario, no se cargan los controles
                                   /*
                                   if(!esSuperUsuario){
                                       //Se cargan los controles
                                       long numProceso = this.esPermitido((String)contexto.get("user"),rutaProceso,aplicacion);

                                       this.cargarControles(this.obtenerControles((String)contexto.get("user"),numProceso),contexto);
                                   }
                                   */   
                                   filterChain.doFilter(servletRequest, servletResponse); 
                               }else{
                                   if (tr.isTraceActive()) {
                                       tr.trace(COMPONENTE, Q70TraceLevel.DEBUG,this.getClass().getName() + TRACE_METODO + " Permiso denegado : " + action );                
                                   }
                                   if(nombreProceso.indexOf(aplicacion+"ErrorAcceso")>=0){
                                       //Se redirige el flujo
                                       filterChain.doFilter(servletRequest, servletResponse); 
                                   }else if (nombreProceso.indexOf("PopUp")!=-1){
                                       this.redireccionarErrorPopUp(request,servletResponse,aplicacion,this.getFilterConfig());
                                   }else{ 
                                       this.redireccionarFlujo(request,servletResponse,"/comunJSP/"+aplicacion+"ErrorAcceso.do",this.getFilterConfig());
                                   }
                               }     
                           } else {//INICIO: USUARIO NO EXISTE (usuario es nulo)
                               //Se indica que es un usuario no vlido
                               if (tr.isTraceActive()) {
                                   tr.trace(COMPONENTE, Q70TraceLevel.DEBUG,this.getClass().getName() + TRACE_METODO + " Usuario XLNets no existe en s99b.");                
                               } 
                               //Usuario XLNets no existe en s99b
                               session.setAttribute(USUARIO_DENIED, new Boolean("true"));
                               //Se redirecciona el flujo a la URL de Xlnets
                               this.redireccionarFlujo(request,servletResponse,ERROR_AUTENTICACION,this.getFilterConfig());                                                
                           }//FIN: USUARIO NO EXISTE            
                      } else { //USUARIO AUTENTICADO volvemos a comprobar la seguridad
                          if (tr.isTraceActive()) {
                               tr.trace(COMPONENTE, Q70TraceLevel.DEBUG,this.getClass().getName() + TRACE_METODO + " Est autenticado: Pasa Filtro de seguridad al proceso.");                
                           }  
                           //Aplicacin en la que nos encontramos
                           xlnetsActivo = true;
                           String aplicacion = (String)contexto.get("aplicacion");
                           //Variable que contiene si se tiene acceso                                                      
                           boolean acceso = false;
                           //En caso de ser un super-usuario, siempre se tiene acceso
                           if(esSuperUsuario){
                               acceso = true;
                           }else{
                               //Se obtiene si tenemos permiso o no para un proceso determinado 
                               acceso = this.esProcesoPermitido((String)contexto.get("user"),rutaProceso,aplicacion);
                           }
                           if (tr.isTraceActive()) {
                               tr.trace(COMPONENTE, Q70TraceLevel.DEBUG,this.getClass().getName() + TRACE_METODO + " :esPermitido:" + acceso);                
                           }
                           //INICIO:MODULO WAR
                           if (tr.isTraceActive()) {
                                tr.trace(COMPONENTE, Q70TraceLevel.DEBUG,this.getClass().getName() + TRACE_METODO + " :obtenerNombreModulo: init ");                
                           }
                           contexto.set("modulo",this.obtenerNombreModulo(request,contexto));
                           if (tr.isTraceActive()) {
                                 tr.trace(COMPONENTE, Q70TraceLevel.DEBUG,this.getClass().getName() + TRACE_METODO + " :obtenerNombreModulo: fin ");                
                           }
                           if(acceso){
                               if (tr.isTraceActive()) {
                                   tr.trace(COMPONENTE, Q70TraceLevel.DEBUG,this.getClass().getName() + TRACE_METODO + " Permiso concedido : " + action );                
                               }  
                               filterChain.doFilter(servletRequest, servletResponse); 
                           }else{
                               if (tr.isTraceActive()) {
                                   tr.trace(COMPONENTE, Q70TraceLevel.DEBUG,this.getClass().getName() + TRACE_METODO + " Permiso denegado : " + action );                
                               }   
                               if(nombreProceso.indexOf(aplicacion+"ErrorAcceso")>=0){
                                   //Se redirige el flujo
                                   filterChain.doFilter(servletRequest, servletResponse); 
                               }else if (nombreProceso.indexOf("PopUp")!=-1){   
                                   this.redireccionarErrorPopUp(request,servletResponse,aplicacion,this.getFilterConfig());
                               }else{
                                   this.redireccionarError(request,servletResponse,this.getFilterConfig()); 
                               }
                           }    
                      }//FIN: USUARIO AUTENTICADO
                 }//FIN: CONTEXTO NO NULO                   
            }               
        }catch(Exception ex){ 
            java.io.StringWriter sw = new java.io.StringWriter();
            java.io.PrintWriter pw = new java.io.PrintWriter(sw);
            ex.printStackTrace(pw);
            tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + TRACE_METODO + sw.getBuffer ().toString());
            throw ex;
        }  
    }

    /**
     * Mtodo que llama a un Bean para recuperar los datos de un usuario
     * @param dniUsuario del Usuario
     * @return Q02aUsuario con los datos del usuario encontrado, null en caso de que el usuario no exista.
     * @throws Exception Exception
     */
    public Q02aUsuario obtenerUsuario(String dniUsuario) throws Exception {
        try{ 
            if (tr.isTraceActive()){
                tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerUsuario: entrando: "
                        + ":idUsuario: " + dniUsuario);
            }
            this.beanSeguridad = new Q02aSeguridadBean();
            if (tr.isTraceActive()){
                tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerUsuario: entrando: "
                        + ":idUsuario: " + dniUsuario);
            } 
            Q02aUsuario usuario= this.beanSeguridad.obtenerUsuario(dniUsuario);
            
            return usuario;
        }catch(Exception ex){
            java.io.StringWriter sw = new java.io.StringWriter();
            java.io.PrintWriter pw = new java.io.PrintWriter(sw);
            ex.printStackTrace(pw);
            tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerUsuario: " + sw.getBuffer ().toString());            
            throw ex;
        }finally{               
            if (tr.isTraceActive()){
                tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()  + ":obtenerUsuario: saliendo");                
            }                   
        }       
    }
    
     /**
     * Mtodo que carga en el contexto los datos necesarios del usuario.
     * @param contexto Q70ContextoEJIE.
     * @param usuario Datos del usuario.
     * @throws Exception  Exception
     */        
    public void cargaAutenticador( Q70ContextoEJIE contexto, Q02aUsuario usuario) throws Exception {
          
        try{   
            //System.out.println("El vo de usuario tiene " +  usuario);
            //Cargamos en el contexto de usuario de aplicacin los datos de autenticacin recuperados para ese usuario
            //tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":cargaAutenticador: usuario= " +usuario );
            contexto.set(USUARIO_CONTEXTO , usuario.getId());  
            contexto.set(NOMBRE_USUARIO_CONTEXTO, usuario.getNombre() + " " + usuario.getApellido1() + " " + usuario.getApellido2() );
            contexto.set(PERFIL_CONTEXTO, usuario.getNiPerfil());
            contexto.set(PROVINCIA_CONTEXTO, Q02aFormatData.esNull(usuario.getNiProvincia()));              //
            contexto.set(DESCPROVINCIA_CONTEXTO, Q02aFormatData.esNull(usuario.getDescProvincia()));            //
            contexto.set(MUNICIPIO_CONTEXTO, Q02aFormatData.esNull(usuario.getNiMunicipio()));          
            contexto.set(DESCMUNICIPIO_CONTEXTO, Q02aFormatData.esNull(usuario.getDescMunicipio()));            //
            contexto.set( DNIUSUARIO_CONTEXTO, Q02aFormatData.esNull( usuario.getDni()) );
            String sinoAdminis = "";
            if ( usuario.getGrupoAdmin() != null && !"".equals(usuario.getGrupoAdmin()) ){
                sinoAdminis = "siAdmin";
            }else{
                sinoAdminis = "noAdmin";
            }
            contexto.set( SINOUSUADMIN_CONTEXTO, Q02aFormatData.esNull( sinoAdminis ));
        }catch(Exception ex){
            java.io.StringWriter sw = new java.io.StringWriter();
            java.io.PrintWriter pw = new java.io.PrintWriter(sw);
            ex.printStackTrace(pw);
            tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":cargaAutenticador: " + sw.getBuffer ().toString());            
            throw ex;
        }finally{   
            if (tr.isTraceActive()){
                tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()  + " cargaAutenticador: saliendo");                
            }                   
       }        
    } 

    /**
     * Mtodo que carga en el contexto los datos necesarios del usuario.
     * @param contexto Q70ContextoEJIE.
     * @param usuario Datos del usuario.
     * @throws Exception Exception
     */        
    public void cargaPlazos( Q70ContextoEJIE contexto, Q02aUsuario usuario) throws Exception {
        ArrayList listaPlazos = new ArrayList();
        try{
            if (tr.isTraceActive()){
                tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":cargaPlazos: entrando: ");
            }
            this.beanSeguridad = new Q02aSeguridadBean();           
            listaPlazos = this.beanSeguridad.obtenerPlazos(usuario);
            contexto.set(PLAZOS_CONTEXTO , listaPlazos);  
        }catch(Exception ex){
            java.io.StringWriter sw = new java.io.StringWriter();
            java.io.PrintWriter pw = new java.io.PrintWriter(sw);
            ex.printStackTrace(pw);
            tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":cargaPlazos: " + sw.getBuffer ().toString());            
            throw ex;
        }finally{               
            if (tr.isTraceActive()){
                tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()  + " cargaPlazos: saliendo");                
            }                   
       }        
    }    
    

    /**
     * Mtodo que comprueba si un usuario tiene permiso para ejecutar un proceso.
     * @param niUsuario nmero interno del usuario en bbdd. 
     * @param rutaProceso Ruta completa del proceso a ejecutar ej. s99bAnaliticasWar\comunJSP\s99binicio.do.
     * @param aplicacion Aplicacin en la que nos encontramos
     * 
     * @return nmero interno del proceso al que se tiene permiso, -1 en caso de no tener permiso.
     * @throws Exception Exception
     */    
    public boolean esProcesoPermitido(String niUsuario,String rutaProceso,String aplicacion) throws Exception {
        boolean esPermitido = false;
        String perfilesAcceso = "";
        try{
            if (tr.isTraceActive()){
                tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":esPermitido: entrando"
                        + "niUsuario:" + niUsuario
                        + "rutaProceso: " + rutaProceso);   
            }    
        /*
            if(!"".equals(rutaProceso)){
                if (rutaProceso.indexOf(aplicacion+"ErrorAcceso")!= -1  || rutaProceso.indexOf(aplicacion+"Login")!= -1){
                    esPermitido = true;
                }else{
                    this.beanSeguridad = new Q02aSeguridadBean();
//                  Se accede al properties, a ver si ese Mant tiene acesso el perfil del Usuario
                    perfilesAcceso = Q02aConstantes.getString(rutaProceso);
                    tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":esProcesoPermitido:-> perfilesAcceso: "+ perfilesAcceso);
                    if(perfilesAcceso != null && !perfilesAcceso.equals("")){
                        if (perfilesAcceso.indexOf(niUsuario)!= -1)
                            esPermitido = true;
                    }
                    //numProceso = this.beanSeguridad.e .esProcesoPermitido(niUsuario,rutaProceso);
                }
            } */
            esPermitido = true; 
            return esPermitido;
        }catch(Exception ex){
            java.io.StringWriter sw = new java.io.StringWriter();
            java.io.PrintWriter pw = new java.io.PrintWriter(sw);
            ex.printStackTrace(pw);
            tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":esPermitido: " + sw.getBuffer ().toString());            
            throw ex;
        }finally{               
            if (tr.isTraceActive()){
                tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()  + " esPermitido: saliendo con " + esPermitido);                
            }                   
        }       
    }
   
    /**
     * Mtodo que devuelve el nombre del Mdulo War
     * 
     * @param request request
     * @param contexto contexto
     * 
     * @throws Exception Exception
     * @return nombreModulo
     */
    private String obtenerNombreModulo(HttpServletRequest request, Q70ContextoEJIE contexto) throws Exception {
        //Definicin de variables que no van a variar
        final String METODO                 = ":obtenerNombreModulo:";
        String nombreModulo                 = "";
        String rutaCompleta                 = null; 
        
        try{
            if (tr.isTraceActive()){
                tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + METODO + " entrando ");
            }
            //Se obtiene la ruta completa: ser de la forma s99bXXXXWar/YYYYJSP/s99bZZZZ.do
            rutaCompleta =(String)request.getRequestURI().substring(1);
            //Se comprueba que la ruta exista
            if(!Q02aFormatData.esVacio(rutaCompleta) && contexto!=null){
                //Se obtiene la aplicacion
                String aplicacion       = (String)contexto.get("aplicacion");
                //Se obtiene el modulo: s99bXXXXWar
                nombreModulo    = rutaCompleta.substring(0,rutaCompleta.indexOf("/"));
                //Se obtiene el parmetro XXXXX
                String moduloAux = nombreModulo.replaceFirst(aplicacion,"");
                nombreModulo = moduloAux.substring(0,moduloAux.indexOf("W"));   
            }
            
            return nombreModulo;
        }catch(Exception ex){
            java.io.StringWriter sw = new java.io.StringWriter();
            java.io.PrintWriter pw = new java.io.PrintWriter(sw);
            ex.printStackTrace(pw);
            tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + METODO + sw.getBuffer ().toString());            
            throw ex;
        }finally{               
            if (tr.isTraceActive()){
                tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()  + METODO + " saliendo ");                
            }                   
        }   
    }
    
    /**
     * Mtodo que redirecciona a un pop up en la que se le indica al usuario que no tiene permiso para acceder 
     * alguna parte.
     * @param request  request
     * @param servletResponse  servletResponse
     * @param aplicacion aplicacion
     * @param filterConfig filterConfig
     * 
     * @throws IOException IOException
     * @throws ServletException ServletException  
     */  
    public void redireccionarErrorPopUp(HttpServletRequest request,ServletResponse servletResponse,
            String aplicacion,FilterConfig filterConfig) 
        throws ServletException, IOException{
        //recuperamos la pgina de error a la que va a ir
        try{
            if (tr.isTraceActive()){
                tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":redireccionarErrorPopUp: entrando");
            }   
            RequestDispatcher dispatcher = filterConfig.getServletContext().getRequestDispatcher("/comunJSP/"+aplicacion+"ErrorAccesoPopUp.do");
            dispatcher.forward(request, servletResponse);
        }catch(ServletException sex){
            java.io.StringWriter sw = new java.io.StringWriter();
            java.io.PrintWriter pw = new java.io.PrintWriter(sw);
            sex.printStackTrace(pw);
            tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":redireccionarErrorPopUp: " + sw.getBuffer ().toString());            
            throw sex;
        }catch(IOException ioex){
            java.io.StringWriter sw = new java.io.StringWriter();
            java.io.PrintWriter pw = new java.io.PrintWriter(sw);
            ioex.printStackTrace(pw);
            tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":redireccionarErrorPopUp: " + sw.getBuffer ().toString());            
            throw ioex;
        }finally{               
            if (tr.isTraceActive()){
                tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()  + " redireccionarErrorPopUp: saliendo");                
            }                   
        }       
    }

    /**
    * Mtodo que redirecciona el flujo a una parte concreta que se le indica
    * 
     * @param request  request
     * @param servletResponse  servletResponse
     * @param patron patron
     * @param filterConfig filterConfig
     * @return 
     * @throws IOException IOException
     * @throws ServletException ServletException   
     */  
    public void redireccionarFlujo(HttpServletRequest request,ServletResponse servletResponse,
            String patron,FilterConfig filterConfig) throws ServletException, IOException{
        //Variables que no se modifican
        final String METODO = ":redireccionarFlujo:";
        //recuperamos la pgina de error a la que va a ir
        try{
            if (tr.isTraceActive()){
                tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + METODO + " entrando");
            }
            RequestDispatcher dispatcher = filterConfig.getServletContext().getRequestDispatcher(patron);
            dispatcher.forward(request, servletResponse);
        }catch(ServletException sex){
            java.io.StringWriter sw = new java.io.StringWriter();
            java.io.PrintWriter pw = new java.io.PrintWriter(sw);
            sex.printStackTrace(pw);
            tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + METODO + sw.getBuffer ().toString());            
            throw sex;
        }catch(IOException ioex){
            java.io.StringWriter sw = new java.io.StringWriter();
            java.io.PrintWriter pw = new java.io.PrintWriter(sw);
            ioex.printStackTrace(pw);
            tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + METODO + sw.getBuffer ().toString());            
            throw ioex;
        }finally{               
            if (tr.isTraceActive()){
                tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()  + METODO + " saliendo");                
            }                   
        }       
    }

   /**
     * Mtodo que redirecciona a una pgina en la que se le indica al usuario que no tiene permiso para acceder alguna parte.
     * @param request  request
     * @param servletResponse servletResponse
     * @param aplicacion aplicacion
     * @return 
     * 
     * @throws IOException IOException
     * @throws ServletException ServletException 
     */  
     public void redireccionarLogin(HttpServletRequest request,ServletResponse servletResponse,String aplicacion) throws ServletException, IOException{
        //recuperamos la pgina de error a la que va a ir
        try{
            if (tr.isTraceActive()){
                tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":redireccionarLogin: entrando");
            }
            RequestDispatcher dispatcher = filterConfig.getServletContext().getRequestDispatcher("/comunJSP/"+aplicacion+"Login.do");
            dispatcher.forward(request, servletResponse);
        }catch(ServletException sex){
            java.io.StringWriter sw = new java.io.StringWriter();
            java.io.PrintWriter pw = new java.io.PrintWriter(sw);
            sex.printStackTrace(pw);
            tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":redireccionarLogin: " + sw.getBuffer ().toString());            
            throw sex;
        }catch(IOException ioex){
            java.io.StringWriter sw = new java.io.StringWriter();
            java.io.PrintWriter pw = new java.io.PrintWriter(sw);
            ioex.printStackTrace(pw);
            tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":redireccionarLogin: " + sw.getBuffer ().toString());            
            throw ioex;
        }finally{               
            if (tr.isTraceActive()){
                tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()  + " redireccionarLogin: saliendo");                
            }                   
        }       
    }
    /* (non-Javadoc)
     * @see javax.servlet.Filter#init(javax.servlet.FilterConfig)
     */
     /**
      * @param filterConfig filterConfig
      */
    public void init(FilterConfig filterConfig) {
        this.filterConfig = filterConfig;    
    }

    /* (non-Javadoc)
     * @see javax.servlet.Filter#destroy()
     */
    /**
     * 
     */
    public void destroy(){
        this.filterConfig = null;
    }

    /* (non-Javadoc)
     * @see javax.servlet.Filter#getFilterConfig()
     */
    /**
     * @return filterConfig
     */
    public FilterConfig getFilterConfig() {
        return this.filterConfig;
    }
    
    /* (non-Javadoc)
     * @see javax.servlet.Filter#setFilterConfig()
     */
    /**
     * @param f f
     */
    public void setFilterConfig(FilterConfig f) {
        this.filterConfig = f;
    }
     
    /**
     * Mtodo que comprueba si la contrasea introducida por el usuario es correcta
     * @param passIntroducida contrasea introducida por pantalla
     * @param pass contrasea obtenida de la BD 
     * @return Si no es correcta false, en caso contrario true.
     * @throws Exception Exception
     */
    public boolean checkPassword(String passIntroducida, String pass) throws Exception {
        boolean esValido = false;
        try{ 
            if (tr.isTraceActive()){
                tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":checkPassword: entrando: " + ":passIntroducida: " + passIntroducida);
            }
            if (passIntroducida != null && !passIntroducida.equals("")){
                //Se desencripta en el mtodo obtenerUsuario al obtener sus datos.
                //passIntroducida = Q02aEncrypt.encrypPassWordDes(Q02aConstantes.getString("Q02_CIFER_ALG"), passIntroducida);
                if(pass.equals(passIntroducida)){
                    esValido = true;
                }
            }
            return esValido;
        }catch(Exception ex){
            java.io.StringWriter sw = new java.io.StringWriter();
            java.io.PrintWriter pw = new java.io.PrintWriter(sw);
            ex.printStackTrace(pw);
            tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":checkPassword: " + sw.getBuffer ().toString());            
            throw ex;
        }finally{               
            if (tr.isTraceActive()){
                tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()  + " checkPassword: saliendo con " + esValido);                
            }                   
        }       
    }

    /**
     * Mtodo que carga en el contexto los municipios del usuario.
     * @param contexto Q70ContextoEJIE.
     * @param usuario Datos del usuario.
     * @throws Exception Exception
     */        

    public void cargaMunicipios( Q70ContextoEJIE contexto, Q02aUsuario usuario) throws Exception {

        ArrayList listaMunicipios = new ArrayList();

        try{
            if (tr.isTraceActive()){
                tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":cargaMunicipios: entrando: ");
            }
            this.beanSeguridad = new Q02aSeguridadBean();           
            listaMunicipios = this.beanSeguridad.obtenerMunicipiosUsuario(usuario);
            contexto.set(MUNICIPIOS_CONTEXTO , listaMunicipios);  
        }catch(Exception ex){
            java.io.StringWriter sw = new java.io.StringWriter();
            java.io.PrintWriter pw = new java.io.PrintWriter(sw);
            ex.printStackTrace(pw);
            tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":cargaMunicipios: " + sw.getBuffer ().toString());            
            throw ex;

        }finally{               
            if (tr.isTraceActive()){
                tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()  + " cargaMunicipios: saliendo");                
            }                   
       }        
    }   

}  
  