/*
 * XMLBuilder.java
 *
 * Created on 4 de julio de 2003, 8:50
 */
 
package q02a.exe.arquitectura.utils.xml;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.Element;

/**
 * Clase de utilidades para la creacin de documentos XML
 * @author  sergio.navarro
 */

public abstract class Q02aXMLUtils {
    
	/** DocumentBuilderFactory esttico para no instanciar uno cada vez que se va a crear un documento */
    protected static javax.xml.parsers.DocumentBuilderFactory factory = null;

	/** DocumentBuilderFactory esttico para no instanciar uno cada vez que se va a crear un documento */
    protected static javax.xml.parsers.DocumentBuilder builder = null;

	/** CachedXPathAPI para realizar las bsquedas. OJO! no es threadsafe!!!! */
    public static final org.apache.xpath.CachedXPathAPI XPATH = new org.apache.xpath.CachedXPathAPI();

	/** Encoding por defecto para la serializacin*/
    public static final String DEFAULT_ENCODING ="ISO-8859-1";
    
	/**
	 * Devuelve un objeto DocumentBuilder para la creacin de documentos xml
     * @return builder
     * @throws javax.xml.parsers.ParserConfigurationException javax.xml.parsers.ParserConfigurationException
	 */
    public static javax.xml.parsers.DocumentBuilder getDocumentBuilder() throws javax.xml.parsers.ParserConfigurationException{
        if(builder==null){
            factory = javax.xml.parsers.DocumentBuilderFactory.newInstance();
            builder = factory.newDocumentBuilder();
        }
        
        return builder;
    }
    
	/**
	 * Serializa un documento xml con el encoding por defecto
	 * @param doc Documento xml a serializar
	 * @param out Destino de la serializacin
     * 
     * @throws java.io.IOException java.io.IOException
     * @throws javax.xml.parsers.ParserConfigurationException javax.xml.parsers.ParserConfigurationException
	 */
    public static void serializeXML(Element doc , java.io.PrintStream out) 
    throws java.io.IOException,javax.xml.parsers.ParserConfigurationException{
        serializeXML(doc,out,DEFAULT_ENCODING,false);
    }

	/**
	 * Serializa un documento xml con el encoding por defecto
	 * @param doc Documento xml a serializar
	 * @param out Destino de la serializacin
     * 
     * @throws java.io.IOException java.io.IOException
     * @throws javax.xml.parsers.ParserConfigurationException javax.xml.parsers.ParserConfigurationException
     */    
    public static void serializeXML(Document doc , java.io.PrintStream out)throws java.io.IOException,javax.xml.parsers.ParserConfigurationException{
        serializeXML(doc,out,DEFAULT_ENCODING,false);
    }
    
	/**
	 * Serializa un documento xml con el encoding por defecto
	 * @param node Documento xml a serializar
	 * @param out Destino de la serializacin
     * 
	 * @throws java.io.IOException java.io.IOException
     * @throws javax.xml.parsers.ParserConfigurationException javax.xml.parsers.ParserConfigurationException
     */
    public static void serializeXML(Node node , java.io.PrintStream out) throws java.io.IOException,javax.xml.parsers.ParserConfigurationException{
        serializeXML(node,out,DEFAULT_ENCODING,false);
    }
    
	/**
	 * Serializa un documento xml.
	 * @param doc Documento xml a serializar
	 * @param out Destino de la serializacin
	 * @param encoding Encoding a utilizar
	 * @param omitXMLDeclaration Si es true, no se incluir en la serializacin la cabecera de declaracin XML
     * 
     * @throws java.io.IOException java.io.IOException
     * @throws javax.xml.parsers.ParserConfigurationException javax.xml.parsers.ParserConfigurationException
     */
    public static void serializeXML(Element doc , java.io.PrintStream out,String encoding,boolean omitXMLDeclaration)
    throws java.io.IOException, javax.xml.parsers.ParserConfigurationException{
        org.apache.xml.serialize.OutputFormat of = new org.apache.xml.serialize.OutputFormat();
        of.setIndenting(true);
        of.setEncoding(encoding);
        of.setOmitXMLDeclaration(omitXMLDeclaration);
        org.apache.xml.serialize.XMLSerializer serializer = new org.apache.xml.serialize.XMLSerializer(out,of);
        
        serializer.serialize(doc);
    }
    
	/**
	 * Serializa un documento xml.
	 * @param doc Documento xml a serializar
	 * @param out Destino de la serializacin
	 * @param encoding Encoding a utilizar
	 * @param omitXMLDeclaration Si es true, no se incluir en la serializacin la cabecera de declaracin XML
     * 
     * @throws java.io.IOException java.io.IOException
     * @throws javax.xml.parsers.ParserConfigurationException javax.xml.parsers.ParserConfigurationException
     */
    public static void serializeXML(Document doc , java.io.PrintStream out,String encoding,boolean omitXMLDeclaration)throws java.io.IOException, javax.xml.parsers.ParserConfigurationException{
        org.apache.xml.serialize.OutputFormat of = new org.apache.xml.serialize.OutputFormat();
        of.setIndenting(true);
        of.setEncoding(encoding);
        of.setOmitXMLDeclaration(omitXMLDeclaration);
        org.apache.xml.serialize.XMLSerializer serializer = new org.apache.xml.serialize.XMLSerializer(out,of);
        
        serializer.serialize(doc);
    }
    
	/**
	 * Serializa un documento xml.
	 * @param node Documento xml a serializar
	 * @param out Destino de la serializacin
	 * @param encoding Encoding a utilizar
     * @param omitXMLDeclaration Si es true, no se incluir en la serializacin la cabecera de declaracin XML
     * 
     * @throws java.io.IOException java.io.IOException
     * @throws javax.xml.parsers.ParserConfigurationException javax.xml.parsers.ParserConfigurationException
     */
    public static void serializeXML(Node node , java.io.PrintStream out,String encoding,boolean omitXMLDeclaration)
    throws java.io.IOException,javax.xml.parsers.ParserConfigurationException{
        Document doc = getDocumentBuilder().newDocument();
        doc.appendChild(doc.importNode(node.cloneNode(true),true));
        serializeXML(doc,out,encoding,omitXMLDeclaration);
    } 
    
    
}
