package q02a.exe.arquitectura.utils;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;

/**
 * 
 * @author GADIMAAR
 *
 */
public class Q02aEncoder {
    
    /** Flag to indicate if the Java 1.4 encoding method (with encoding parameter) is supported by the JVM */
    private static boolean C_NEW_ENCODING_SUPPORTED = true;

    /** Flag to indicate if the Java 1.4 decoding method (with encoding parameter) is supported by the JVM */
    private static boolean C_NEW_DECODING_SUPPORTED = true;
    
    /** Default encoding for JavaScript decodeUriComponent methods is UTF-8 by w3c standard */
    public static final String C_URI_ENCODING = "UTF-8";

    /**
     * Constructor
     */
    public Q02aEncoder() {}
    
    /**
     * This method is a substitute for <code>URLEncoder.encode()</code>.
     * Use this in all OpenCms core classes to ensure the encoding is
     * always handled the same way.<p>
     * 
     * In case you don't know what encoding to use, set the value of 
     * the <code>encoding</code> parameter to <code>null</code>. 
     * This will use the default encoding, which is propably the right one.<p>
     * 
     * It also solves a backward compatiblity issue between Java 1.3 and 1.4,
     * since 1.3 does not support an explicit encoding parameter and always uses
     * the default system encoding.<p>
     * 
     * @param source the String to encode
     * @param encoding the encoding to use (if null, the system default is used)
     * @param fallbackToDefaultEncoding If true, the method will fallback to the default encoding (Java 1.3 style), 
     * 
     * if false, the source String will be returned unencoded 
     * @return the encoded source String
     */
    public static String encode(String source, String encoding, boolean fallbackToDefaultEncoding) {
        if (source == null) {return null;}
        if (encoding != null) {
            if (C_NEW_ENCODING_SUPPORTED) {
                try {
                    return URLEncoder.encode(source, encoding); 
//					return URLEncoder.encode(source); //Para el jdk1.3
                } 
                catch (java.io.UnsupportedEncodingException e) {/*nada*/}
                catch (java.lang.NoSuchMethodError n) {
                    C_NEW_ENCODING_SUPPORTED = false;
                }
            }
            if (! fallbackToDefaultEncoding) {return source;}
        }
        // Fallback to default encoding
        return URLEncoder.encode(source);//Para el jdk1.3
    }
    
    /**
     * Encodes a String using the default encoding.
     * 
     * @param source the String to encode
     * @return String the encoded source String
     */
    public static String encode(String source) {
        return encode(source, C_URI_ENCODING, true);
    }

    /**
     * This method is a substitute for <code>URLDecoder.decode()</code>.
     * Use this in all OpenCms core classes to ensure the encoding is
     * always handled the same way.<p>
     * 
     * In case you don't know what encoding to use, set the value of 
     * the <code>encoding</code> parameter to <code>null</code>. 
     * This will use the default encoding, which is propably the right one.<p>
     * 
     * It also solves a backward compatiblity issue between Java 1.3 and 1.4,
     * since 1.3 does not support an explicit encoding parameter and always uses
     * the default system encoding.<p>
     * 
     * @param source The string to decode
     * @param encoding The encoding to use (if null, the system default is used)
     * @param fallbackToDefaultDecoding If true, the method will fallback to the default encoding (Java 1.3 style), 
     * if false, the source String will be returned undecoded
     * @return The decoded source String
     */
    public static String decode(String source, String encoding, boolean fallbackToDefaultDecoding) {
        if (source == null) {return null;}
        if (encoding != null) {
            if (C_NEW_DECODING_SUPPORTED) {
                try {
                    //return URLDecoder.decode(source, encoding); 
					return URLDecoder.decode(source); 
                } 
                //catch (java.io.UnsupportedEncodingException e) {}
                catch (java.lang.NoSuchMethodError n) {
                    C_NEW_DECODING_SUPPORTED = false;
                }
            }
            if (! fallbackToDefaultDecoding) {return source;}
        }
        // Fallback to default decoding
        return URLDecoder.decode(source);        
    }
    
    /**
     * Decodes a String using the default encoding.
     * 
     * @param source the String to decode
     * @return String the decoded source String
     */
    public static String decode(String source) {
        return decode(source, C_URI_ENCODING, true);
    }    

    /**
     * Encodes a String in a way that is compatible with the JavaScript escape function.
     * 
     * @param source The textstring to be encoded.
     * @param encoding The textstring to be encoded.
     * @return The JavaScript escaped string.
     */
    public static String escape(String source, String encoding) {
        /*
        StringBuffer ret = new StringBuffer();

        // URLEncode the text string. This produces a very similar encoding to JavaSscript
        // encoding, except the blank which is not encoded into a %20.
        String enc = encode(source, encoding, true);
        
        
        StringTokenizer t = new StringTokenizer(enc, "+");
        while(t.hasMoreTokens()) {
            ret.append(t.nextToken());
            if(t.hasMoreTokens()) {
                ret.append("%20");
            }
        }
        
        return replaceAll(ret.toString(),"%2B","+");
        */
        return escapeWBlanks(source,encoding);
    }
    
    /**
     * Sustituye un String (a) por otro (b) dentro de un String (s)
     * @param s String donde hacer la sustitucin
     * @param a String a buscar
     * @param b String a sustituir
     * @return String sustitudo
     */
    public static final String replaceAll(String s,String a,String b){
        StringBuffer sb = new StringBuffer();
        
        int pos = 0;
        int pos2 = 0;
        
        while(pos<s.length()){
            pos2 = s.indexOf(a,pos);
            if(pos2<0){
                sb.append(s.substring(pos));
                break;
            }else{
                sb.append(s.substring(pos,pos2));
                sb.append(b);
                pos = pos2 + a.length();
            }
        }
        return sb.toString();
    }

    /**
     * Encodes a String in a way that is compatible with the JavaScript escape function.
     * Muliple blanks are encoded _multiply _with %20.
     * 
     * @param source The textstring to be encoded.
     * @param encoding encoding
     * @return The JavaScript escaped string.
     */
    public static String escapeWBlanks(String source, String encoding) {
        if(source == null) {
            return null;
        }
        StringBuffer ret = new StringBuffer();

        // URLEncode the text string. This produces a very similar encoding to JavaSscript
        // encoding, except the blank which is not encoded into a %20.
        String enc = encode(source, encoding, true);
        
        
        for(int z = 0;z < enc.length();z++) {
            if(enc.charAt(z) == '+') {
                ret.append("%20");
            }
            else {
                ret.append(enc.charAt(z));
            }
        }
        
        return ret.toString();
        //return replaceAll(ret.toString(),"%2B","+");
    }

    /**
     * Escapes a String so it may be printed as text content or attribute
     * value in a HTML page or an XML file.<p>
     * 
     * This method replaces the following characters in a String:
     * <ul>
     * <li><b>&lt;</b> with &amp;lt;
     * <li><b>&gt;</b> with &amp;gt;
     * <li><b>&amp;</b> with &amp;amp;
     * <li><b>&quot;</b> with &amp;quot;
     * </ul>
     * 
     * @param source the string to escape
     * @return the escaped string
     * 
     * @see #escapeHtml(String)
     */
    public static String escapeXml(String source) {
        if (source == null) {return null;}
        StringBuffer result = new StringBuffer(source.length()*2);
        for(int i = 0;i < source.length(); ++i) {
            char ch = source.charAt(i);
            switch (ch) {
                case '<' :
                    result.append("&lt;");
                    break;
                case '>' :
                    result.append("&gt;");
                    break;
                case '&' :
                    result.append("&amp;");
                    break;
                case '"' :
                    result.append("&quot;");
                    break;
                default :
                    result.append(ch);
            }
        }
        return new String(result);
    }   

    /**
     * Escapes special characters in a HTML-String with their number-based 
     * entity representation, for example &amp; becomes &amp;#38;.<p>
     * 
     * A character <code>num</code> is replaced if<br>
     * <code>((ch !=  32) && ((ch > 122) || (ch < 48) || (ch == 60) || (ch == 62)))</code><p>
     * 
     * @param source the String to escape
     * @return String the escaped String
     * 
     * @see #escapeXml(String)
     */
    public static String escapeHtml(String source) {
        if (source == null) {return null;}
        StringBuffer result = new StringBuffer(source.length()*2);
        for(int i = 0;i < source.length();i++) {
            int ch = source.charAt(i);
            if((ch !=  32) && ((ch > 122) || (ch < 48) || (ch == 60) || (ch == 62))) {
                result.append("&#");
                result.append(ch);
                result.append(";");
            }
            else {
                result.append((char)ch);
            }
        }
        return new String(result);
    }

    /**
     * Decodes a String in a way that is compatible with the JavaScript 
     * unescape function.
     * 
     * @param source The String to be decoded.
     * @param encoding encoding
     * @return The JavaScript unescaped String.
     */
    public static String unescape(String source, String encoding) {
        if(source == null){
            return null;
        }
        
        //Reemplazamos los caracteres + por %2B ya que el mtodo decode toma los + como espacios
        String s = source;//replaceAll(source,"+","%2B");
        
        int len = s.length();
        // to use standard decoder we need to replace '+' with "%20" (space)
        StringBuffer preparedSource = new StringBuffer(len);
        for (int i = 0; i < len; i++) {
            char c = s.charAt(i);
            if (c == '+') {
                preparedSource.append("%20");
            } else {
                preparedSource.append(c);
            }
        }
        return decode(preparedSource.toString(), encoding, true);
    }
    
    /**
     * Changes the encoding of a byte array that represents a String.<p>
     * 
     * @param input the byte array to convert
     * @param oldEncoding the current encoding of the byte array
     * @param newEncoding the new encoding of the byte array
     * @return byte[] the byte array encoded in the new encoding
     */
    public static byte[] changeEncoding(byte[] input, String oldEncoding, String newEncoding) {
        if ((oldEncoding == null) || (newEncoding == null)) {return input;}
        if (oldEncoding.trim().equalsIgnoreCase(newEncoding.trim())) {return input;}
        byte[] result = input;
        try {
            result = (new String(input, oldEncoding)).getBytes(newEncoding);
        } catch (UnsupportedEncodingException e) {
            // return value will be input value
        }
        return result;
    }
    
 /**
     * Sustituye los caracteres  por sus "acutes" de html correspondientes 
     * @param s String donde sustituiremos los caracteres
     * @return String con los caracteres sustituidos
     */
    public static final String fixAcutes(String s){
        StringBuffer sb = new StringBuffer();
        int max = s.length();
        char c = ' ';
        for (int i = 0; i < max; i++) {
            c = s.charAt(i);
            
            switch(c){
                case '':
                case '':
                case '':
                case '':
                case '':
                case '':
                case '':
                case '':
                case '':
                case '':
                case '':
                case '':
                case '':
                case '':
                    sb.append(escapeHtml(new Character(c).toString()));
                    break;
                default:
                    sb.append(c);
            }
        }
        
        return sb.toString();
        
    }
}
