/*
 * Copyright 2001 by IENET, Inc.
 *
 * Private and Confidential
 * Code contained in this document is the property of IENET.
 * It is for the exclusive use of designated employees
 * and not for distribution without prior written
 * authorization.
 */
/*
 * BaseDAO.java
 *
 * Created on 31 de mayo de 2001, 10:19
 */

package q02a.exe.arquitectura.dataobjects;

// Java classes import

import es.ejie.frmk.infraestructura.traza.Q70Traza;
import java.util.ArrayList;
import java.util.HashMap;

/** Clase que se utiliza como base para todos los DAO.
 * <p>
 * Los DAO (DataAccessObject) son los objetos encargados del acceso a los
 * recursos (LDAP, Bases de datos, etc.). Un DAO se compone de 3 o ms clases:
 * <ul>
 * <li>Interface: donde definimos los mtodos y constantes que debern tener las clases
 * que realmente accedean a los recursos.</li>
 * <li>ValueObject(s): una o ms clases que contendrn los datos que devuelven los DAO (tanto el
 * interface como las clases que lo implementen</li>
 * <li>Clases de implementacin: estas clases implementarn el interface que hemos creado anteriormente,
 * y heredarn, directa o indirectamente de BaseDAO.
 * </li>
 * </ul>
 * <p>
 * Para instanciar una Clase que herede de BaseDAO, utilizaremos el mtodo getInstance, pasando como parmetro
 * la clase base de ese DAO (normalmente un interface del tipo IClientesDAO). En base al nombre de la clase,
 * buscaremos en la configuracin, qu clase instanciable le corresponde, y la instanciaremos utilizando el
 * constructor vaco. Ejemplo:<br>
 * q02a.exe.arquitectura.besaidenet.dataobjects.IInfovinculosDAO dao = (q02a.exe.arquitectura.besaidenet.dataobjects.IInfovinculosDAO) BaseDAO.getInstance(q02a.exe.arquitectura.besaidenet.dataobjects.IInfovinculosDAO);
 * <p>
 * Por lo tanto, el constructor vaco de todas las clases hijas de BaseDAO deber crear una instancia ya inicializada
 * (conexiones a bases de datos, LDAP, etc...).
 * @author Antonio.Vieiro
 * @version 1.0
 */
public abstract class Q02aBaseDAO extends Object implements java.io.Serializable{
   
    /** Objeto Log para escribir trazas */
    protected static Q70Traza tr = Q70Traza.getSingleton();
    
    /** Holds value of property nombreClaseSinPackage. */
    protected String nombreClaseSinPackage;
    
    /** Variables obtenidas del contexto de la aplicacin */
    protected String 	user				= null;
    protected String 	idioma				= null;
    protected ArrayList	roles			  	= null;
    protected HashMap 	mapaRestricciones	= null;
    
   
    /** Crea un nuevo BaseDAO
     */
    public Q02aBaseDAO() {
        initNombreClaseSinPackage();
    }
    
    
    /**
     * Libera los recursos de un objeto DAO
     * @param dao Dao cuyos recursos hay que liberar
     * @throws Q02aDAOException si hay algn error
     */
    public static void freeResources(Object dao) throws Q02aDAOException {
        try{
            if(dao==null){
                return;
            }
            ((Q02aBaseDAO)dao).freeResources();
        }catch(Exception ex){
            //log.error("BaseDAO  Failed: " + ex.getMessage() + ". freeResources",log.CAT_APP);
            throw new Q02aDAOException(ex);
        }
    }
    
    /**
     * Libera los recursos del DAO.
     */
    public abstract void freeResources();
    
    /** Utilizaremos este mtodo para instanciar cualquier clase que extienda de BaseDAO.
     * <p>
     * Pasaremos como parmetro una clase (Normalmente un interface, por ejemplo IClientesDAO).
     * Con el nombre de esta clase, buscaremos en un fichero de propiedades, la clase que realmente vamos a
     * instanciar.<br>
     * De este modo, podemos configurar si queremos instanciar la clase que accede a los clientes mediante
     * LDAP, base de datos, HOST, etc...
     * @param clase Interface del que queremos instanciar el DAO.
     * @return Instancia de BaseDAO
     * @throws DAOException Si se produce cualquier error
     */
    
    
    
    /** 
     * Inicializa la propiedad nombreClaseSinPackage
     */
    public void initNombreClaseSinPackage() {
        String nombreFiltrado;
        String nombreClase = getClass().getName();
        
        try {
            if (nombreClase != null){
                nombreFiltrado = nombreClase.substring( nombreClase.lastIndexOf(".") + 1);
            }
            else{
                nombreFiltrado = "ClaseDesconocida";
            }
        }catch (java.lang.Exception e){
            nombreFiltrado = "ClaseDesconocida";
        }
        
        nombreClaseSinPackage = nombreFiltrado;
    }
    
     /** Getter for property nombreClaseSinPackage.
     * @return Value of property nombreClaseSinPackage.
     */
    public String getNombreClaseSinPackage() {
        return this.nombreClaseSinPackage;
    }
    
    /**
     * 
     * @return user
     */
    public String getUser() {
		return user;
	}
    /**
     * 
     * @param user user
     */
	public void setUser(String user) {
		this.user = user;
	}
	/**
     * 
     * @return idioma
	 */
	public String getIdioma() {
		return this.idioma;
	}
    /**
     * 
     * @param idioma idioma
     */
	public void setIdioma(String idioma) {
		this.idioma = idioma;
	}
	/**
     * 
     * @return roles
	 */
	public ArrayList getRoles() {
		return this.roles;
	}
    /**
     * 
     * @param roles roles
     */
	public void setRoles(ArrayList roles) {
		this.roles = roles;
	}
	/**
     * 
     * @return mapaRestricciones
	 */
	public HashMap getMapaRestricciones(){
		return this.mapaRestricciones;
	}
	/**
     * 
     * @param mapaRestricciones mapaRestricciones
	 */
	public void setMapaRestricciones(HashMap mapaRestricciones){
		this.mapaRestricciones = mapaRestricciones;
	}
	
	/**
	 * Devuelve los roles separados por comas para poder introducirlos en una query
	 * @return String
	 */
	public String obtenerRolesSeparadosComas(){
		String 		rolesStr 	= "";
		for(int i=0;i<this.roles.size();i++){
			rolesStr += (String)this.roles.get(i);
			if(i!=(this.roles.size()-1)){
				rolesStr += ",";
			}
		}
		return rolesStr;
	}
    
}

