/*
 * BaseJspBean.java
 *
 * Created on 5 de febrero de 2002, 13:21
 */

package q02a.exe.arquitectura.beans;

import java.sql.Connection;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import q02a.exe.arquitectura.dataobjects.Q02aDAOException;
import q02a.exe.arquitectura.webCommon.utils.gdtp.Q02aGenericDataTransferProtocol;
import es.ejie.frmk.conectores.conectorJDBC.Q70ConectorJDBC;

import es.ejie.frmk.listeners.base.Q70ListenerUtils;
import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;
import es.ejie.frmk.infraestructura.traza.Q70Traza;

import q02a.exe.comun.Q02aAutenticador;

/**
 * Clase base para los beans que se usan "directamente" en los jsp.<br>
 * Contiene un objeto request y un objeto response <b> que no se serializan</b>. A partir del objeto
 * request, el bean puede obtener informacin para realizar las acciones que tenga encomendadas. A travs
 * del objeto response, el bean puede incluso redireccionar la peticin a otro jsp.
 * <p>
 * La manera de instaciar un bean desde un jsp es con el tag UseBean
 * Una vez instanciado, hay que llamar al mtodo init(Request, Response) y si esto devuelve true, hacer un return.<br>
 * if( bean.init(request,response) ) return; <br>
 * Si queremos que el bean sea de sesin, pero hay que diferenciarlo entre ventanas, usar
 * if( bean.init(request,response,"nombreEnSesion") ) return; <br>
 * <p>
 * Si este bean guarda objetos en la sesin, lo podemos hacer de 2 formas: <br>
 * 1.- Mediante la propiedad session
 * 2.- Mediante el mtodo setValueToSession si queremos que se diferencie el contenido de la sesin entre dos ventanas
 * del navegador.
 * <p>
 * Contiene una propiedad esttica log que contendr el objeto log a utilizar para escribir trazas. Antes de utilizar el objeto
 * log, tiene que haber sido inicializado llamando al mtodo esttico initLog
 * @author  sergio.navarro
 * @version 1.0
 */
public abstract class Q02aBaseBean implements java.io.Serializable{
    /** Nombre de la cookie que guarda el nombre de la ventana para la gestin multiventana*/
    public static final String ID_NOMBRE_VENTANA = "NOMBRE_VENTANA";
    protected static final String COMPONENTE = "BEAN_ACCESO_DATOS";	
    protected String Q02_JNDI_DATASOURCE = Q70ListenerUtils.getApplicationProperty("Q02aCentrosBean",null,"Q02_JNDI_DATASOURCE");
    protected HttpSession httpSession = null;   
    /** Este string guarda el nombre de la ventana, que se recoge de la cookie NOMBRE_VENTANA para la gestin multiventana*/
    protected String nombreVentana = null;
    protected Q02aGenericDataTransferProtocol gdtp = null;
    /** Holds value of property request. */
    protected transient HttpServletRequest request;
    protected Connection conn = null;
    /** Holds value of property response. */
    protected transient HttpServletResponse response;
    /** Variable que contiene informacin del contexto de la aplicacin */   
    protected Q02aAutenticador autenticador	= null;
    
    /** Objeto log que utilizarn todos los beans. Se inicializa con el metodo setLog() */
    protected static Q70Traza tr = Q70Traza.getSingleton();
    
    /** Holds value of property nombreClaseSinPackage. */
    protected String nombreClaseSinPackage;
    
    /** Crea una instancia de la clase y llama al mtodo initNombreClaseSinPackage*/
    public Q02aBaseBean() {
        super();
        
        initNombreClaseSinPackage();
    }
    
    /**
     * @throws Exception Exception
     */
    protected void finalize () throws Exception {
    	try{
	        if (!this.conn.isClosed() ) {
	        	 this.conn.close();
	        	 tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, this.getClass().getName() + ":conexin NO CERRADA: " );
	        }
    	}catch(Exception ex){}
    }

    /**
     * 
     * @param request request
     * @param response response
     * @throws q02a.exe.arquitectura.dataobjects.Q02aDAOException q02a.exe.arquitectura.dataobjects.Q02aDAOException
     */
    public Q02aBaseBean(HttpServletRequest request,HttpServletResponse response) throws q02a.exe.arquitectura.dataobjects.Q02aDAOException{
        this();
        init(request,response);
    }
    
    /**
	 * @param conn The conn to set.
	 */
	public void setConn(Connection conn) {
		this.conn = conn;
	}

	/**
	 * @return Returns the conn.
	 */
	public Connection getConn() {
		return conn;
	}

	
    
    /** Getter for property request.
     * @return Value of property request.
     */
    public HttpServletRequest getRequest() {
        return request;
    }
    
    /** Setter for property request.
     * @param request New value of property request.
     */
    public void setRequest(HttpServletRequest request) {
        this.request = request;
    }
    
    /** Getter for property response.
     * @return Value of property response.
     */
    public HttpServletResponse getResponse() {
        return response;
    }
    
    /** Setter for property response.
     * @param response New value of property response.
     */
    public void setResponse(HttpServletResponse response) {
        this.response = response;
    }
    
    /**
     * Este mtodo se utiliza en los bean tontos, cuando se quiere que el bean sea multiventana. Es decir, que en diferentes ventanas de la misma sesin,
     * el bean sea diferente (una nueva instancia). <p>
     * En esta clase, este mtodo simplemente llama al mtodo init(Request, Response).
     * @param request Para la propiedad request del objeto
     * @param response Para la propiedad response del objeto
     * @return boolean true si se ha hecho un forward.
     *
     *@throws q02a.exe.arquitectura.dataobjects.Q02aDAOException q02a.exe.arquitectura.dataobjects.Q02aDAOException
     */
    public boolean init(HttpServletRequest request,HttpServletResponse response) throws q02a.exe.arquitectura.dataobjects.Q02aDAOException{
        return init(request,response);
    }
    
   /**
    * 
    * @throws Exception Exception
    */
    public void abrirConexion() throws Exception{
		try{
			this.conn = Q70ConectorJDBC.getSingleton().getConnection(Q02_JNDI_DATASOURCE);
			this.conn.setAutoCommit(false);			
		}catch(Exception ex){
			java.io.StringWriter sw = new java.io.StringWriter();
            java.io.PrintWriter pw = new java.io.PrintWriter(sw);
            ex.printStackTrace(pw);
            if (tr.isTraceActive()){
				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":abrirConexion: " + sw.getBuffer ().toString());
			}
            throw ex;
		}
	}
	
    /**
     * 
     * @param error error
     * @throws Exception Exception
     */
	public void cerrarConexion(boolean error) throws Exception{
		 //Si el bean hace la gestin de la conexin
      try{
         if (error){
        	 this.conn.rollback();
         }else{
        	 this.conn.commit();
         }
         try{
        	 this.conn.close();
        	 tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, this.getClass().getName() + ":cerrarrConexion: cerrada." );
         }catch(Exception e){
        	 java.io.StringWriter sw = new java.io.StringWriter();
             java.io.PrintWriter pw = new java.io.PrintWriter(sw);
             e.printStackTrace(pw);
             tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":cerrarrConexion: error cerrando la conexin." + sw.getBuffer ().toString());             
             throw e; 
         }
      }catch(Exception e){
          java.io.StringWriter sw = new java.io.StringWriter();
          java.io.PrintWriter pw = new java.io.PrintWriter(sw);
          e.printStackTrace(pw);
          tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":cerrarrConexion: " + sw.getBuffer ().toString());
          throw e;
      }finally{
    	  tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":cerrarrConexion: saliendo." );
      }
	}
    
   
    
    /**
     * Obtiene un objeto log. Debe haberse inicializado llamando al mtodo initLog.
     * @return Value of property log.
     */
    public static Q70Traza getLog() {
        return tr;
    }
    
    
    /**
     * Inicializa la propiedad esttica log.
     * @param newTr log New value of property log.
     */
    public static void initLog(Q70Traza newTr) {
        tr = newTr;
    }
    
    /** Getter for property nombreClaseSinPackage.
     * @return Value of property nombreClaseSinPackage.
     */
    public String getNombreClaseSinPackage() {
        return this.nombreClaseSinPackage;
    }
    
    /** 
     * Inicializa la propiedad nombreClaseSinPackage
     */
    public void initNombreClaseSinPackage() {
        String nombreFiltrado;
        String nombreClase = getClass().getName();
        
        try {
            if (nombreClase != null){
                nombreFiltrado = nombreClase.substring( nombreClase.lastIndexOf(".") + 1);
            }
            else{
                nombreFiltrado = "ClaseDesconocida";
            }
        }catch (java.lang.Exception e){
            nombreFiltrado = "ClaseDesconocida";
        }
        
        nombreClaseSinPackage = nombreFiltrado;
    }
    
    /**
     * 
     * @param GDTP GDTP
     */
    public void setGDTP(Q02aGenericDataTransferProtocol GDTP ){
    	this.gdtp = GDTP;    
    }
    //recupera el GDTP de local, de la sesin o de la request:
    /**
     *  @throws Q02aDAOException Q02aDAOException
     *  @return gdtp
     */
    protected Q02aGenericDataTransferProtocol getGDTP() throws Q02aDAOException{
    	try{
            if  ( this.gdtp == null){
                httpSession = request.getSession();
                if ( httpSession.getAttribute("GDTP") != null ){
                    this.gdtp = ( Q02aGenericDataTransferProtocol )httpSession.getAttribute("GDTP");
                }else{

                    String data = request.getParameter("GDTP_DATA");
                    if(data==null){
                            data = request.getParameter("GDTP_DATA_1");		
                    }
                    if(data!=null){
                            this.gdtp = Q02aGenericDataTransferProtocol.parse(data);			
                    }	
                }
            }
            return this.gdtp;
    	}catch(Exception e){
            java.io.StringWriter sw = new java.io.StringWriter();
            java.io.PrintWriter pw = new java.io.PrintWriter(sw);
            e.printStackTrace(pw);
            throw new Q02aDAOException(e);                                                                                                    
    	}    
    }  
    /**
     * 
     * @return getGroupPropertyMap("APP_DATA")
     * @throws Q02aDAOException Q02aDAOException
     */
    protected Map getMapaDatos()throws Q02aDAOException{
       return this.getGDTP().getGroupPropertyMap("APP_DATA");    
    }
    /**
     * 
     * @param nombre nombre
     * @return nombre
     * @throws Q02aDAOException Q02aDAOException
     */
    protected String getParametro(String nombre)throws Q02aDAOException{
   	 return (String)this.getMapaParametros().get(nombre);
   }
    
    /**
     * 
     * @return APP_PARAMETERS
     * @throws Q02aDAOException Q02aDAOException
     */
    protected Map getMapaParametros()throws Q02aDAOException{
        return this.getGDTP().getGroupPropertyMap("APP_PARAMETERS");    
    }

    /**
     * 
     * @return gdtpRespuesta
     */
    protected Q02aGenericDataTransferProtocol respuestaOK(){

		Q02aGenericDataTransferProtocol gdtpRespuesta = new Q02aGenericDataTransferProtocol();
		gdtpRespuesta.addGroup("RESULT_1");	
		gdtpRespuesta.addProperty("RESULT_1","RESULT","OK");		
		return gdtpRespuesta;
    }
    
    /**
     * 
     * @return gdtpRespuesta
     */
    protected Q02aGenericDataTransferProtocol respuestaNoOK(){
//    	Crear GDTP
		Q02aGenericDataTransferProtocol gdtpRespuesta = new Q02aGenericDataTransferProtocol();
		gdtpRespuesta.addGroup("RESULT_1");
		gdtpRespuesta.addProperty("RESULT_1","RESULT","NOK");
		
		return gdtpRespuesta;
    }

      
   /**
    * Procesa una excepcin llamando a ErrorFactory.
   * @param ex Excepcin a procesar
   * @param aplicacion aplicacion
   * @return Mapa con los datos de la excecpcin
   * @throws Q02aDAOException Si se produce algn error
   */
     protected Q02aGenericDataTransferProtocol processException(Throwable ex, String aplicacion) throws Q02aDAOException{
          try{
          	Q02aGenericDataTransferProtocol gdtpRespuesta = new Q02aGenericDataTransferProtocol();

          	gdtpRespuesta = processException(ex, aplicacion,gdtpRespuesta,null);
  	        
  			return gdtpRespuesta;
          }catch(Q02aDAOException exc){
              throw exc;
          }catch(Exception exc){
              throw new Q02aDAOException(exc);
          }
      }
     
     /**
      * Procesa una excepcin llamando a ErrorFactory.
     * @param ex Excepcin a procesar
     * @return Mapa con los datos de la excecpcin
     * @throws Exception Si se produce algn error
     */
       protected Q02aGenericDataTransferProtocol processException(Throwable ex) throws Exception{
            return this.processException(ex,null);
        }
       /**
        * 
        * @param ex ex
        * @param aplicacion aplicacion
        * @param gdtpRespuesta gdtpRespuesta
        * @return processException
        * @throws Exception Exception
        */
       protected Q02aGenericDataTransferProtocol processException(Throwable ex, String aplicacion, Q02aGenericDataTransferProtocol gdtpRespuesta) throws Exception{
       		return processException(ex, aplicacion,gdtpRespuesta,null);      	
       }
       
       /**
        * 
        * @param ex ex
        * @param aplicacion aplicacion
        * @param gdtpRespuesta gdtpRespuesta
        * @param arguments arguments
        * @return gdtpRespuesta
        * @throws Q02aDAOException Q02aDAOException
        */
       protected Q02aGenericDataTransferProtocol processException(Throwable ex, String aplicacion, Q02aGenericDataTransferProtocol gdtpRespuesta,Object[] arguments) throws Q02aDAOException{
           try{        				  
           	if (gdtpRespuesta==null) {gdtpRespuesta = new Q02aGenericDataTransferProtocol();}
   	        
   	        int i = 1;
   	        while (gdtpRespuesta.getGroupPropertyMap("ERROR_" + i)!=null){
   	        	i++;
   	        }
   			return gdtpRespuesta;
          
           }catch(Exception exc){
               throw new Q02aDAOException(exc);
           }
       }
       
       /** Obtener y dar valor al autenticador 
        * @return autenticador
        * */
       public Q02aAutenticador getAutenticador() {
   		return this.autenticador;
	   }
       /**
        * 
        * @param autenticador autenticador
        */
	   public void setAutenticador(Q02aAutenticador autenticador) {
	   		this.autenticador = autenticador;
	   }   
}