CREATE OR REPLACE VIEW Q022AV01
(Q022AT00_NIPLAZO, Q022AT00_ANO, MUN_PROV, MUN_MUNI, Q022AT00_PLAZO, 
 Q022AT00_PLAZO_DIA, Q022AT00_FEC_ALTA, Q022AT00_FEC_MOD, Q022NT00_CODIGO, PROVINCIA_DS_O, 
 MUNICIPIO_DS_O, Q022NT00_DESC_ES, Q022NT00_DESC_EU)
AS 
SELECT 
  Q022AT00_NIPLAZO   ,
  Q022AT00_ANO       ,
  MUN_PROV           ,
  MUN_MUNI           ,
  Q022AT00_PLAZO     ,
  Q022AT00_PLAZO_DIA ,
  Q022AT00_FEC_ALTA  ,
  Q022AT00_FEC_MOD   ,
  Q022AS00.Q022NT00_CODIGO , 
  NORA_T17_PROVINCIA.DS_O,
  NORA_T17_MUNICIPIO.DS_O,
  Q022NS00.Q022NT00_DESC_ES,
  Q022NS00.Q022NT00_DESC_EU
FROM 
Q022AS00,
NORA_T17_PROVINCIA, 
NORA_T17_MUNICIPIO, Q022NS00 
WHERE
Q022AS00.MUN_PROV =NORA_T17_PROVINCIA.ID (+) and
Q022AS00.MUN_MUNI =NORA_T17_MUNICIPIO.ID(+) and
Q022AS00.MUN_PROV  =NORA_T17_MUNICIPIO.PROVINCIA_ID (+) and
Q022AS00.Q022NT00_CODIGO=Q022NS00.Q022NT00_CODIGO(+)
/


CREATE OR REPLACE VIEW Q022DV02
(Q022BT00_ID_GRUPO, Q022DT00_ID_CUES, Q022DT00_IDEN_LICEN, Q022DT00_FEC_ENT, Q022DT00_ESTADO_LICEN, 
 Q022DT00_CAUSA_BAJA, Q022DT00_ENTI, Q022DT00_TVIA, Q022DT00_CALLE, Q022DT00_POR_CL_POR, 
 Q022DT00_BLOQ, Q022DT00_NUME, Q022DT00_BIS, Q022DT00_CDIR, Q022DT00_RS_PROMO, 
 Q022DT00_CIF_DNI, Q022DT00_MUN_PROV, Q022DT00_MUN_MUNI, Q022DT00_ENTI_PRO, Q022DT00_TVIA_PRO, 
 Q022DT00_CALLE_PRO, Q022DT00_POR_CL_POR_PRO, Q022DT00_BLOQ_PRO, Q022DT00_NUME_PRO, Q022DT00_BIS_PRO, 
 Q022DT00_CDIR_PRO, Q022DT00_TLF, Q022DT00_MAIL, Q022DT00_FAX, Q022DT00_WEB, 
 Q022DT00_PRESUPUESTO, Q022DT00_F_INI, Q022DT00_F_FIN, Q022DT00_TIPO_OBRA, Q022DT00_USO_RES, 
 Q022DT00_ACTIVIDAD, Q022DT00_NVN, Q022DT00_NVR, Q022DT00_NVL, Q022DT00_NVVPO, 
 Q022DT00_NVVS, Q022DT00_NVPOT, Q022DT00_NVALDOT, Q022DT00_NVREAL, Q022DT00_NVVTMG, 
 Q022DT00_NVVTME, Q022DT00_NTOT, Q022DT00_NSP45, Q022DT00_NSP75, Q022DT00_NSP90, 
 Q022DT00_NSP120, Q022DT00_NSPT, Q022DT00_PRINC_USO, Q022DT00_PU_ESPECIF, Q022DT00_PRECIO_MED, 
 Q022DT00_OBS, Q022DT00_NORA_T17_LOCALIZACION, Q022DT00_DIR_PRO_EXTERNO, Q022DT00_DIR_NUEVA)
AS 
SELECT 
  Q022BT00_ID_GRUPO        ,
  Q022DT00_ID_CUES         ,
  Q022DT00_IDEN_LICEN      ,
  Q022DT00_FEC_ENT         ,
  Q022DT00_ESTADO_LICEN    ,
  Q022DT00_CAUSA_BAJA      ,
  Q022DT00_ENTI            ,
  Q022DT00_TVIA            ,
  Q022DT00_CALLE           ,
  Q022DT00_POR_CL_POR      ,
  Q022DT00_BLOQ            ,
  Q022DT00_NUME            ,
  Q022DT00_BIS             ,
  Q022DT00_CDIR            ,
  Q022DT00_RS_PROMO        ,
  Q022DT00_CIF_DNI         ,
  Q022DT00_MUN_PROV        ,
  Q022DT00_MUN_MUNI        ,
  Q022DT00_ENTI_PRO        ,
  Q022DT00_TVIA_PRO        ,
  Q022DT00_CALLE_PRO       ,
  Q022DT00_POR_CL_POR_PRO  ,
  Q022DT00_BLOQ_PRO        ,
  Q022DT00_NUME_PRO        ,
  Q022DT00_BIS_PRO         ,
  Q022DT00_CDIR_PRO        ,
  Q022DT00_TLF             ,
  Q022DT00_MAIL            ,
  Q022DT00_FAX             ,
  Q022DT00_WEB             ,
  Q022DT00_PRESUPUESTO     ,
  Q022DT00_F_INI           ,
  Q022DT00_F_FIN           ,
  Q022DT00_TIPO_OBRA       ,
  Q022DT00_USO_RES         ,
  Q022DT00_ACTIVIDAD       ,
  Q022DT00_NVN             ,
  Q022DT00_NVR             ,
  Q022DT00_NVL             ,
  Q022DT00_NVVPO           ,
  Q022DT00_NVVS            ,
  Q022DT00_NVPOT           ,
  Q022DT00_NVALDOT         ,
  Q022DT00_NVREAL          ,
  Q022DT00_NVVTMG          ,
  Q022DT00_NVVTME          ,
  Q022DT00_NTOT            ,
  Q022DT00_NSP45           ,
  Q022DT00_NSP75           ,
  Q022DT00_NSP90           ,
  Q022DT00_NSP120          ,
  Q022DT00_NSPT            ,
  Q022DT00_PRINC_USO       ,
  Q022DT00_PU_ESPECIF      ,
  Q022DT00_PRECIO_MED      ,
  Q022DT00_OBS  ,
   CASE WHEN ( TRIM(Q022DT00_CALLE) = 0 OR TRIM(Q022DT00_CALLE) = '' OR TRIM(Q022DT00_CALLE) IS NULL) THEN NORA_T17_LOCALIDAD.DS_O
       ELSE NORA_T17_LOCALIDAD.DS_O  || DECODE(NORA_T17_LOCALIDAD.DS_O,'','',', ')  || NORA_T17_CALLE.DS_O || ' ' ||  DECODE ( Q022DT00_BLOQ, '0' , '','','', 'Bloque:'||Q022DT00_BLOQ)  || ' '  || DECODE ( Q022DT00_NUME, '0' , '','','',  'N:'||Q022DT00_NUME) || ' '||  DECODE( Q022DT00_BIS, '0','','','','Bis: '||Q022DT00_BIS)
  END DIRECCION,
  Q022DT00_DIR_PRO_EXTERNO,
  Q022DT00_DIR_NUEVA
FROM Q022DS00, NORA_T17_LOCALIDAD,NORA_T17_CALLE 
where Q022DS00.Q022DT00_ENTI=NORA_T17_LOCALIDAD.ID(+)   and
Q022DS00.Q022DT00_CALLE=NORA_T17_CALLE.ID(+)
/


CREATE OR REPLACE VIEW Q022DV03
(LIC_TERR, LIC_MUN, LIC_ANNO, LIC_MES, LIC_MLIC, 
 LIC_NCUL, LIC_ID_GRUPO, LIC_CULN, LIC_CLIC, LIC_FENT, 
 LIC_SITLIC, LIC_CBAJA, LIC_ENTI, LIC_ENTID, LIC_TVIA, 
 LIC_CALLE, LIC_CALLED, LIC_CALLED_E, LIC_POR_CL_POR, LIC_BLOQ, 
 LIC_NUME, LIC_BIS, LIC_CDIR, LIC_NOMBRE, LIC_CIF, 
 LIC_PROVD, LIC_PROV_P, LIC_MUNID_P, LIC_MUNI_P, LIC_ENTI_P, 
 LIC_TVIA_P, LIC_CALLED_P, LIC_CALLED_P_E, LIC_CALLE_P, LIC_POR_CL_POR_P, 
 LIC_BLOQ_P, LIC_NUME_P, LIC_BIS_P, LIC_CDIR_P, LIC_TELF, 
 LIC_EMAIL, LIC_FAX, LIC_WEB, LIC_PSPO, LIC_FINIC, 
 LIC_FFIN, LIC_TIPOM, LIC_RESID, LIC_USEDI, LIC_NVIN, 
 LIC_NVIR, LIC_NLIBRE, LIC_NVPOG, LIC_NVPOE, LIC_NVPOT, 
 LIC_NALOD, LIC_NREAL, LIC_NVTMG, LIC_NVTME, LIC_NVTOT, 
 LIC_NSP45, LIC_NSP75, LIC_NSP90, LIC_NSP90M, LIC_NSPT, 
 LIC_USOV, LIC_OTRU, LIC_PRECIO, LIC_OBSLI)
AS 
select
Q022BS00.FCA02T00_CODPROVINC, Q022BS00.FCA02T00_CODMUNICIP,
Q022BS00.Q022BT00_ANO, Q022BS00.Q022BT00_MES, Q022BS00.Q022BT00_CONCEDIDO_LICEN, CONTADOR.num ,
Q022DS00.Q022BT00_ID_GRUPO      ,     
Q022DT00_ID_CUES       ,      
Q022DT00_IDEN_LICEN    ,      
Q022DT00_FEC_ENT       ,      
Q022DT00_ESTADO_LICEN  ,      
Q022DT00_CAUSA_BAJA    ,      
Q022DT00_ENTI          ,   
NORA_T17_LOCALIDAD.DS_O,   
Q022DT00_TVIA          ,      
Q022DT00_CALLE         , 
NORA_T17_CALLE.DS_O, NORA_T17_CALLE.DS_E,     
Q022DT00_POR_CL_POR    ,      
Q022DT00_BLOQ          ,      
Q022DT00_NUME          ,      
Q022DT00_BIS           ,      
Q022DT00_CDIR          ,      
Q022DT00_RS_PROMO      ,      
Q022DT00_CIF_DNI       ,
NORA_T17_PROVINCIA.DS_O,       
Q022DT00_MUN_PROV      ,
NORA_T17_MUNICIPIO.DS_O,       
Q022DT00_MUN_MUNI      ,      
Q022DT00_ENTI_PRO      ,      
Q022DT00_TVIA_PRO      , 
NORA_T17_CALLE_PROMO.DS_O, 
NORA_T17_CALLE_PROMO.DS_E,     
Q022DT00_CALLE_PRO     ,      
Q022DT00_POR_CL_POR_PRO,      
Q022DT00_BLOQ_PRO      ,      
Q022DT00_NUME_PRO      ,      
Q022DT00_BIS_PRO       ,      
Q022DT00_CDIR_PRO      ,      
Q022DT00_TLF           ,      
Q022DT00_MAIL          ,      
Q022DT00_FAX           ,      
Q022DT00_WEB           ,      
Q022DT00_PRESUPUESTO   ,      
Q022DT00_F_INI         ,      
Q022DT00_F_FIN         ,      
Q022DT00_TIPO_OBRA     ,      
Q022DT00_USO_RES       ,      
Q022DT00_ACTIVIDAD     ,      
Q022DT00_NVN           ,      
Q022DT00_NVR           ,      
Q022DT00_NVL           ,      
Q022DT00_NVVPO         ,      
Q022DT00_NVVS          ,      
Q022DT00_NVPOT         ,      
Q022DT00_NVALDOT       ,      
Q022DT00_NVREAL        ,      
Q022DT00_NVVTMG        ,      
Q022DT00_NVVTME        ,      
Q022DT00_NTOT          ,      
Q022DT00_NSP45         ,      
Q022DT00_NSP75         ,      
Q022DT00_NSP90         ,      
Q022DT00_NSP120        ,      
Q022DT00_NSPT          ,      
Q022DT00_PRINC_USO     ,      
Q022DT00_PU_ESPECIF    ,      
Q022DT00_PRECIO_MED    ,      
Q022DT00_OBS              
from Q022DS00, Q022BS00, NORA_T17_CALLE, NORA_T17_PROVINCIA, NORA_T17_MUNICIPIO, NORA_T17_CALLE NORA_T17_CALLE_PROMO,
(select Q022BT00_ID_GRUPO, count(*) num from Q022DS00
group by Q022BT00_ID_GRUPO)  CONTADOR, NORA_T17_LOCALIDAD
where Q022DS00.Q022BT00_ID_GRUPO=Q022BS00.Q022BT00_ID_GRUPO and
Q022DS00.Q022DT00_CALLE=NORA_T17_CALLE.ID(+) and 
Q022DS00.Q022DT00_MUN_PROV=NORA_T17_PROVINCIA.ID (+) and
Q022DS00.Q022DT00_MUN_MUNI=NORA_T17_MUNICIPIO.ID(+) and
Q022DS00.Q022DT00_MUN_PROV=NORA_T17_MUNICIPIO.PROVINCIA_ID (+) and
Q022DS00.Q022DT00_CALLE_PRO= NORA_T17_CALLE_PROMO.ID(+) and
Q022DS00.Q022BT00_ID_GRUPO=CONTADOR.Q022BT00_ID_GRUPO (+) and 
Q022DS00.Q022DT00_ENTI=NORA_T17_LOCALIDAD.ID(+)
/


CREATE OR REPLACE VIEW Q022EV02
(Q022CT00_ID_GRUPO, MUN_PROV, MUN_MUNI, Q022CT00_ANO, Q22CT00_MES, 
 Q022ET00_ID_CUES, Q022ET00_CLASU, Q022ET00_SUPSU, Q022ET00_SUPTE, Q022ET00_VALSU, 
 Q022ET00_NVPOG, Q022ET00_NVPOE, Q022ET00_NVTMG, Q022ET00_NVTME, Q022ET00_NALOD, 
 Q022ET00_NREAL, Q022ET00_NVTOT, Q022ET00_FEC_ALTA, Q022ET00_FEC_MOD, Q022ET00_FEC_BAJA, 
 Q022ET00_FIRMADO, Q022ET00_CDEXP, Q022ET00_NVPOT, Q022ET00_NLIBRE, Q022ET00_OBSSU, 
 Q022ET00_FADQ, Q022ET00_ENTI, Q022ET00_TVIA, Q022ET00_CALLE, Q022ET00_POR_CL_POR, 
 Q022ET00_BLOQ, Q022ET00_NUME, Q022ET00_BIS, Q022ET00_CDIR, Q022ET00_TIPADQ, 
 Q022ET00_NORA_T17_LOCALIZACION, Q022ET00_DIR_NUEVA)
AS 
select 
  Q022CS00.Q022CT00_ID_GRUPO   ,
   MUN_PROV,
  MUN_MUNI,
  Q022CT00_ANO,
  Q22CT00_MES        ,
  Q022ET00_ID_CUES    ,
  Q022ET00_CLASU      ,
  Q022ET00_SUPSU      ,
  Q022ET00_SUPTE      ,
  Q022ET00_VALSU      ,
  Q022ET00_NVPOG      ,
  Q022ET00_NVPOE      ,
  Q022ET00_NVTMG      ,
  Q022ET00_NVTME      ,
  Q022ET00_NALOD      ,
  Q022ET00_NREAL      ,
  Q022ET00_NVTOT      ,
  Q022ET00_FEC_ALTA   ,
  Q022ET00_FEC_MOD    ,
  Q022ET00_FEC_BAJA   ,
  Q022ET00_FIRMADO    ,
  Q022ET00_CDEXP      ,
  Q022ET00_NVPOT      ,
  Q022ET00_NLIBRE     ,
  Q022ET00_OBSSU      ,
  Q022ET00_FADQ       ,
  Q022ET00_ENTI       ,
  Q022ET00_TVIA       ,
  Q022ET00_CALLE      ,
  Q022ET00_POR_CL_POR ,
  Q022ET00_BLOQ       ,
  Q022ET00_NUME       ,
  Q022ET00_BIS        ,
  Q022ET00_CDIR       ,
  Q022ET00_TIPADQ ,
 CASE WHEN ( TRIM(Q022ET00_CALLE) = 0 OR TRIM(Q022ET00_CALLE) = '' OR TRIM(Q022ET00_CALLE) IS NULL) THEN NORA_T17_LOCALIDAD.DS_O
       ELSE NORA_T17_LOCALIDAD.DS_O  || DECODE(NORA_T17_LOCALIDAD.DS_O,'','',', ')  || NORA_T17_CALLE.DS_O || ' ' ||  DECODE ( Q022ET00_BLOQ, '0' , '','','',  Q022ET00_BLOQ)  || ' '  || DECODE ( Q022ET00_NUME, '0' , '','','',  Q022ET00_NUME) || ' '||  DECODE( Q022ET00_BIS, '0','','','',Q022ET00_BIS)
  END DIRECCION,
  Q022ET00_DIR_NUEVA  
from Q022CS00 ,Q022ES00, NORA_T17_LOCALIDAD,NORA_T17_CALLE 
where 
Q022CS00.Q022CT00_ID_GRUPO=Q022ES00.Q022CT00_ID_GRUPO and
Q022ES00.Q022ET00_ENTI=NORA_T17_LOCALIDAD.ID(+)   and
Q022ES00.Q022ET00_CALLE=NORA_T17_CALLE.ID(+)
/


CREATE OR REPLACE VIEW Q022EV03
(SUE_TERR, SUE_MUN, SUE_ANNO, SUE_MES, SUE_MSUE, 
 SUE_NCUS, SUE_GRUPO, SUE_CUSN, SUE_CDEXP, SUE_CLASU, 
 SUE_FADQ, SUE_TIPADQ, SUE_ENTI, SUE_ENTID, SUE_TVIA, 
 SUE_CALLE, SUE_CALLED, SUE_CALLED_E, SUE_POR_CL_POR, SUE_BLOQ, 
 SUE_NUME, SUE_BIS, SUE_CDIR, SUE_SUPSU, SUE_SUPTE, 
 SUE_VALSU, SUE_NLIBRE, SUE_NVPOG, SUE_NVPOE, SUE_NVPOT, 
 SUE_NALOD, SUE_NREAL, SUE_NVTMG, SUE_NVTME, SUE_NVTOT, 
 SUE_FEC_ALTA, SUE_FEC_MOD, SUE_FEC_BAJA, SUE_FIRMADO, SUE_OBSSU)
AS 
SELECT 
 Q022CS00.MUN_PROV, 
 Q022CS00.MUN_MUNI, 
 Q022CS00.Q022CT00_ANO, 
 Q022CS00.Q22CT00_MES,
 Q022CS00.Q022CT00_REALIZA_ACTUACION, 
 Q022CS00.Q022CT00_NCUS, 
 Q022ES00.Q022CT00_ID_GRUPO   , 
 Q022ET00_ID_CUES    , 
 Q022ET00_CDEXP      , 
 Q022ET00_CLASU      , 
 Q022ET00_FADQ       , 
 Q022ET00_TIPADQ     ,
 Q022ET00_ENTI       , 
 NORA_T17_LOCALIDAD.DS_O , 
 Q022ET00_TVIA       ,
 Q022ET00_CALLE      ,
  NORA_T17_CALLE.DS_O, NORA_T17_CALLE.DS_E,  
  Q022ET00_POR_CL_POR , 
  Q022ET00_BLOQ       , 
  Q022ET00_NUME       , 
  Q022ET00_BIS        , 
  Q022ET00_CDIR       ,  
  Q022ET00_SUPSU      , 
  Q022ET00_SUPTE      , 
  Q022ET00_VALSU      , 
  Q022ET00_NLIBRE     ,    
  Q022ET00_NVPOG      , 
  Q022ET00_NVPOE      , 
  Q022ET00_NVPOT      , 
  Q022ET00_NALOD      , 
   Q022ET00_NREAL      ,   
  Q022ET00_NVTMG      , 
  Q022ET00_NVTME      ,
  Q022ET00_NVTOT      , 
  Q022ET00_FEC_ALTA   , 
  Q022ET00_FEC_MOD    , 
  Q022ET00_FEC_BAJA   , 
  Q022ET00_FIRMADO    ,  
  Q022ET00_OBSSU      
  FROM    Q022ES00, Q022CS00, NORA_T17_CALLE, NORA_T17_LOCALIDAD
  where Q022ES00.Q022CT00_ID_GRUPO=Q022CS00.Q022CT00_ID_GRUPO  and
  Q022ES00.Q022ET00_CALLE =NORA_T17_CALLE.ID(+) and
  Q022ES00.Q022ET00_ENTI=NORA_T17_LOCALIDAD.ID(+)
/

COMMENT ON COLUMN Q022EV03.SUE_TERR IS '#INF#SUE_TERR#INF#'
/

COMMENT ON COLUMN Q022EV03.SUE_MUN IS '#INF#SUE_MUN#INF#'
/

COMMENT ON COLUMN Q022EV03.SUE_ANNO IS '#INF#SUE_ANNO#INF#'
/

COMMENT ON COLUMN Q022EV03.SUE_MES IS '#INF#SUE_MES#INF#'
/

COMMENT ON COLUMN Q022EV03.SUE_MSUE IS '#INF#SUE_MSUE#INF#'
/

COMMENT ON COLUMN Q022EV03.SUE_NCUS IS '#INF#SUE_NCUS#INF#'
/

COMMENT ON COLUMN Q022EV03.SUE_GRUPO IS '#INF#SUE_GRUPO#INF#'
/

COMMENT ON COLUMN Q022EV03.SUE_CUSN IS '#INF#SUE_CUSN#INF#'
/

COMMENT ON COLUMN Q022EV03.SUE_CDEXP IS '#INF#SUE_CDEXP#INF#'
/

COMMENT ON COLUMN Q022EV03.SUE_CLASU IS '#INF#SUE_CLASU#INF#'
/

COMMENT ON COLUMN Q022EV03.SUE_FADQ IS '#INF#SUE_FADQ#INF#'
/

COMMENT ON COLUMN Q022EV03.SUE_TIPADQ IS '#INF#SUE_TIPADQ#INF#'
/

COMMENT ON COLUMN Q022EV03.SUE_ENTI IS '#INF#SUE_ENTI#INF#'
/

COMMENT ON COLUMN Q022EV03.SUE_ENTID IS '#INF#SUE_ENTID#INF#'
/

COMMENT ON COLUMN Q022EV03.SUE_TVIA IS '#INF#SUE_TVIA#INF#'
/

COMMENT ON COLUMN Q022EV03.SUE_CALLE IS '#INF#SUE_CALLE#INF#'
/

COMMENT ON COLUMN Q022EV03.SUE_CALLED IS '#INF#SUE_CALLED#INF#'
/

COMMENT ON COLUMN Q022EV03.SUE_CALLED_E IS '#INF#SUE_CALLED_E#INF#'
/

COMMENT ON COLUMN Q022EV03.SUE_POR_CL_POR IS '#INF#SUE_POR_CL_POR#INF#'
/

COMMENT ON COLUMN Q022EV03.SUE_BLOQ IS '#INF#SUE_BLOQ#INF#'
/

COMMENT ON COLUMN Q022EV03.SUE_NUME IS '#INF#SUE_NUME#INF#'
/

COMMENT ON COLUMN Q022EV03.SUE_BIS IS '#INF#SUE_BIS#INF#'
/

COMMENT ON COLUMN Q022EV03.SUE_CDIR IS '#INF#SUE_CDIR#INF#'
/

COMMENT ON COLUMN Q022EV03.SUE_SUPSU IS '#INF#SUE_SUPSU#INF#'
/

COMMENT ON COLUMN Q022EV03.SUE_SUPTE IS '#INF#SUE_SUPTE#INF#'
/

COMMENT ON COLUMN Q022EV03.SUE_VALSU IS '#INF#SUE_VALSU#INF#'
/

COMMENT ON COLUMN Q022EV03.SUE_NLIBRE IS '#INF#SUE_NLIBRE#INF#'
/

COMMENT ON COLUMN Q022EV03.SUE_NVPOG IS '#INF#SUE_NVPOG#INF#'
/

COMMENT ON COLUMN Q022EV03.SUE_NVPOE IS '#INF#SUE_NVPOE#INF#'
/

COMMENT ON COLUMN Q022EV03.SUE_NVPOT IS '#INF#SUE_NVPOT#INF#'
/

COMMENT ON COLUMN Q022EV03.SUE_NALOD IS '#INF#SUE_NALOD#INF#'
/

COMMENT ON COLUMN Q022EV03.SUE_NREAL IS '#INF#SUE_NREAL#INF#'
/

COMMENT ON COLUMN Q022EV03.SUE_NVTMG IS '#INF#SUE_NVTMG#INF#'
/

COMMENT ON COLUMN Q022EV03.SUE_NVTME IS '#INF#SUE_NVTME#INF#'
/

COMMENT ON COLUMN Q022EV03.SUE_NVTOT IS '#INF#SUE_NVTOT#INF#'
/

COMMENT ON COLUMN Q022EV03.SUE_OBSSU IS '#INF#SUE_OBSSU#INF#'
/


CREATE OR REPLACE VIEW Q022FV01
(Q022FT00_IDUSUARIO, Q022FT00_NOMBRE, Q022FT00_APELLIDO1, Q022FT00_APELLIDO2, Q022FT00_NIF, 
 Q022FT00_EMAIL, Q022FT00_PASSWORD, MUN_PROV, DESC_PROV, MUN_MUNI, 
 DESC_MUNI, Q022FT00_FECHA_ACTIVACION, Q022FT00_FECHA_DESACTIVACION, Q021AT00_CODPERFIL, Q022FT00_NI_MULTIPLE, 
 Q022FT00_NOMBRE_COMPLETO)
AS 
(
select
Q022FT00_IDUSUARIO,
Q022FT00_NOMBRE,
Q022FT00_APELLIDO1,
Q022FT00_APELLIDO2,
Q022FT00_NIF,
Q022FT00_EMAIL,
Q022FT00_PASSWORD,
MUN_PROV,
provincias.DS_O,
MUN_MUNI,
municipios.DS_O,
Q022FT00_FECHA_ACTIVACION,
Q022FT00_FECHA_DESACTIVACION,
Q021AT00_CODPERFIL,
Q022FT00_IDUSUARIO||'#'||Q022FT00_NOMBRE||' '||Q022FT00_APELLIDO1||' '||Q022FT00_APELLIDO2,
Q022FT00_NOMBRE||' '||Q022FT00_APELLIDO1||' '||Q022FT00_APELLIDO2
FROM Q022FS00 usuarios,
NORA_T17_PROVINCIA provincias,
NORA_T17_MUNICIPIO municipios
WHERE 
usuarios.MUN_PROV= provincias.ID(+)
AND
usuarios.MUN_MUNI= municipios.ID(+)
AND
usuarios.MUN_PROV= municipios.PROVINCIA_ID(+)
)
/


CREATE OR REPLACE VIEW Q022GV01
(ALQ_ID_CUES, ALQ_ANNO, ALQ_MALQ, ALQ_TERR, ALQ_MUN, 
 ALQ_PRV1A, ALQ_ADQVI1, ALQ_NADQ1, ALQ_PROVI1, ALQ_NPRO1, 
 ALQ_OTRVI1, ALQ_OTRLT1, ALQ_NOTR1, ALQ_NTOT1, ALQ_PRV4A, 
 ALQ_ADQVI4, ALQ_NADQ4, ALQ_PROVI4, ALQ_NPRO4, ALQ_OTRVI4, 
 ALQ_OTRLT4, ALQ_NOTR4, ALQ_NTOT4, ALQ_TALQ, ALQ_NALQ, 
 ALQ_NSP45, ALQ_NSP75, ALQ_NSP90, ALQ_NSP90M, ALQ_NSPT, 
 ALQ_NRSP45, ALQ_NRSP75, ALQ_NRSP90, ALQ_NRSP90M, ALQ_NRSPT, 
 ALQ_NOCUP, ALQ_NDESA, ALQ_NDESO, ALQ_NDESOT, ALQ_DESOTR, 
 ALQ_NOCUT, ALQ_NVPOG, ALQ_NVPOE, ALQ_NVPOT, ALQ_NALOD, 
 ALQ_NREAL, ALQ_NLIBRE, ALQ_NVTMG, ALQ_NVTME, ALQ_NVTOT, 
 ALQ_NANT60M, ALQ_NANT30, ALQ_NANT10, ALQ_NANT10M, ALQ_NANTT, 
 ALQ_OBSAL, ALQ_OBSSU)
AS 
SELECT
  Q022GT00_ID_CUES         , 
  Q022GT00_ANO             , 
  Q022GT00_CONCEDIDO_LICEN , 
  Q022GT00_MUN_PROV        , 
  Q022GT00_MUN_MUNI        , 
  Q022GT00_PRV1A           , 
  Q022GT00_ADQVI1          , 
  Q022GT00_NADQ1           , 
  Q022GT00_PROVI1          , 
  Q022GT00_NPRO1           , 
  Q022GT00_OTRVI1          , 
  Q022GT00_OTRLT1          , 
  Q022GT00_NOTR1           , 
  Q022GT00_NTOT1           , 
  Q022GT00_PRV4A           , 
  Q022GT00_ADQVI4          , 
  Q022GT00_NADQ4           , 
  Q022GT00_PROVI4          , 
  Q022GT00_NPRO4           , 
  Q022GT00_OTRVI4          , 
  Q022GT00_OTRLT4          , 
  Q022GT00_NOTR4           , 
  Q022GT00_NTOT4           , 
  Q022GT00_TALQ            , 
  Q022GT00_NALQ            , 
  Q022GT00_NSP45           , 
  Q022GT00_NSP75           , 
  Q022GT00_NSP90           , 
  Q022GT00_NSP90M          , 
  Q022GT00_NSPT            , 
  Q022GT00_NRSP45          , 
  Q022GT00_NRSP75          , 
  Q022GT00_NRSP90          , 
  Q022GT00_NRSP90M         , 
  Q022GT00_NRSPT           , 
  Q022GT00_NOCUP           , 
  Q022GT00_NDESA           , 
  Q022GT00_NDESO           , 
  Q022GT00_NDESOT          , 
  Q022GT00_DESOTR          , 
  Q022GT00_NOCUT           , 
  Q022GT00_NVPOG           , 
  Q022GT00_NVPOE           , 
  Q022GT00_NVPOT           , 
  Q022GT00_NALOD           , 
  Q022GT00_NREAL           , 
  Q022GT00_NLIBRE          , 
  Q022GT00_NVTMG           , 
  Q022GT00_NVTME           , 
  Q022GT00_NVTOT           , 
  Q022GT00_NANT60M         , 
  Q022GT00_NANT30          , 
  Q022GT00_NANT10          , 
  Q022GT00_NANT10M         , 
  Q022GT00_NANTT           , 
  Q022GT00_OBSAL           , 
  Q022GT00_OBSSU            
FROM  Q022GS00
/

COMMENT ON COLUMN Q022GV01.ALQ_ID_CUES IS '#INF#ALQ_ID_CUES#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_ANNO IS '#INF#ALQ_ANNO#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_MALQ IS '#INF#ALQ_MALQ#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_TERR IS '#INF#ALQ_TERR#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_MUN IS '#INF#ALQ_MUN#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_PRV1A IS '#INF#ALQ_PRV1A#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_ADQVI1 IS '#INF#ALQ_ADQVI1#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_NADQ1 IS '#INF#ALQ_NADQ1#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_PROVI1 IS '#INF#ALQ_PROVI1#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_NPRO1 IS '#INF#ALQ_NPRO1#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_OTRVI1 IS '#INF#ALQ_OTRVI1#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_OTRLT1 IS '#INF#ALQ_OTRLT1#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_NOTR1 IS '#INF#ALQ_NOTR1#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_NTOT1 IS '#INF#ALQ_NTOT1#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_PRV4A IS '#INF#ALQ_PRV4A#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_ADQVI4 IS '#INF#ALQ_ADQVI4#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_NADQ4 IS '#INF#ALQ_NADQ4#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_PROVI4 IS '#INF#ALQ_PROVI4#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_NPRO4 IS '#INF#ALQ_NPRO4#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_OTRVI4 IS '#INF#ALQ_OTRVI4#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_OTRLT4 IS '#INF#ALQ_OTRLT4#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_NOTR4 IS '#INF#ALQ_NOTR4#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_NTOT4 IS '#INF#ALQ_NTOT4#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_TALQ IS '#INF#ALQ_TALQ#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_NALQ IS '#INF#ALQ_NALQ#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_NSP45 IS '#INF#ALQ_NSP45#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_NSP75 IS '#INF#ALQ_NSP75#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_NSP90 IS '#INF#ALQ_NSP90#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_NSP90M IS '#INF#ALQ_NSP90M#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_NSPT IS '#INF#ALQ_NSPT#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_NRSP45 IS '#INF#ALQ_NRSP45#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_NRSP75 IS '#INF#ALQ_NRSP75#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_NRSP90 IS '#INF#ALQ_NRSP90#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_NRSP90M IS '#INF#ALQ_NRSP90M#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_NRSPT IS '#INF#ALQ_NRSPT#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_NOCUP IS '#INF#ALQ_NOCUP#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_NDESA IS '#INF#ALQ_NDESA#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_NDESO IS '#INF#ALQ_NDESO#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_NDESOT IS '#INF#ALQ_NDESOT#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_DESOTR IS '#INF#ALQ_DESOTR#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_NOCUT IS '#INF#ALQ_NOCUT#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_NVPOG IS '#INF#ALQ_NVPOG#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_NVPOE IS '#INF#ALQ_NVPOE#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_NVPOT IS '#INF#ALQ_NVPOT#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_NALOD IS '#INF#ALQ_NALOD#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_NREAL IS '#INF#ALQ_NREAL#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_NLIBRE IS '#INF#ALQ_NLIBRE#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_NVTMG IS '#INF#ALQ_NVTMG#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_NVTME IS '#INF#ALQ_NVTME#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_NVTOT IS '#INF#ALQ_NVTOT#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_NANT60M IS '#INF#ALQ_NANT60M#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_NANT30 IS '#INF#ALQ_NANT30#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_NANT10 IS '#INF#ALQ_NANT10#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_NANT10M IS '#INF#ALQ_NANT10M#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_NANTT IS '#INF#ALQ_NANTT#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_OBSAL IS '#INF#ALQ_OBSAL#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_OBSSU IS '#INF#ALQ_OBSSU#INF#'
/


CREATE OR REPLACE VIEW Q022HV01
(Q022HT00_ID_OFI, Q022HT00_PROV, Q022HT00_MUNI, Q022HT00_DESC, Q022HT00_DESC_EUS, 
 Q022HT00_TVIA, Q022HT00_CALLE, Q022HT00_BLOQ, Q022HT00_NUME, Q022HT00_BIS, 
 Q022HT00_ESCA, Q022HT00_PISO, Q022HT00_MANO, Q022HT00_PUER, Q022HT00_CODP, 
 Q022HT00_CDIR, Q022HT00_DEPA, Q022HT00_EMAILD, Q022HT00_TELF1D, Q022HT00_TELF2D, 
 Q022HT00_FAXD, Q022HT00_WEB, NORA_T17_PROVINCIA_DS, NORA_T17_MUNICIPIO_DS, NORA_T17_LOCALIZACION)
AS 
SELECT                      
  Q022HT00_ID_OFI   ,      
  Q022HT00_PROV     ,      
  Q022HT00_MUNI     ,      
  Q022HT00_DESC     ,      
  Q022HT00_DESC_EUS ,      
  Q022HT00_TVIA     ,      
  Q022HT00_CALLE    ,      
  Q022HT00_BLOQ     ,      
  Q022HT00_NUME     ,      
  Q022HT00_BIS      ,      
  Q022HT00_ESCA     ,      
  Q022HT00_PISO     ,      
  Q022HT00_MANO     ,      
  Q022HT00_PUER     ,      
  Q022HT00_CODP     ,      
  Q022HT00_CDIR     ,      
  Q022HT00_DEPA     ,      
  Q022HT00_EMAILD   ,      
  Q022HT00_TELF1D   ,      
  Q022HT00_TELF2D   ,      
  Q022HT00_FAXD     ,      
  Q022HT00_WEB   ,
  NORA_T17_PROVINCIA.DS_O,
  NORA_T17_MUNICIPIO.DS_O, Q022HT00_TVIA || ' ' || NORA_T17_CALLE.DS_O || ' ' ||  Q022HT00_BLOQ || ' '  ||  Q022HT00_NUME || ' '||  Q022HT00_BIS          
FROM Q022HS00,
 NORA_T17_PROVINCIA, NORA_T17_MUNICIPIO,  NORA_T17_CALLE 
WHERE
Q022HS00.Q022HT00_PROV =NORA_T17_PROVINCIA.ID (+) and
Q022HS00.Q022HT00_MUNI =NORA_T17_MUNICIPIO.ID(+) and
Q022HS00.Q022HT00_PROV=NORA_T17_MUNICIPIO.PROVINCIA_ID (+) and
Q022HS00.Q022HT00_CALLE  =NORA_T17_CALLE.ID(+)
/


CREATE OR REPLACE VIEW Q022IV01
(Q022IT00_ID_INF, Q022IT00_ID_OFI, Q022IT00_NOMB, Q022IT00_APE1, Q022IT00_APE2, 
 Q022IT00_CARGO, Q022IT00_DEPA, Q022IT00_EMAIL, Q022IT00_TELF1, Q022IT00_TELF2, 
 Q022IT00_FAX, Q022IT00_FELEC, Q022IT00_PRINCPL, Q022HT00_PROV, Q022HT00_MUNI, 
 Q022HT00_DESC, Q022HT00_DESC_EUS, NORA_T17_PROVINCIA_DS, NORA_T17_MUNICIPIO_DS)
AS 
SELECT 
  Q022IT00_ID_INF   ,
  Q022IT00_ID_OFI   ,
  Q022IT00_NOMB     ,
  Q022IT00_APE1     ,
  Q022IT00_APE2     ,
  Q022IT00_CARGO    ,
  Q022IT00_DEPA     ,
  Q022IT00_EMAIL    ,
  Q022IT00_TELF1    ,
  Q022IT00_TELF2    ,
  Q022IT00_FAX      ,
  Q022IT00_FELEC    ,
  Q022IT00_PRINCPL  ,    
  Q022HT00_PROV    ,
  Q022HT00_MUNI    ,
  Q022HT00_DESC    ,
  Q022HT00_DESC_EUS,
  NORA_T17_PROVINCIA.DS_O, 
  NORA_T17_MUNICIPIO.DS_O
FROM Q022IS00, Q022HS00, NORA_T17_PROVINCIA, NORA_T17_MUNICIPIO
WHERE Q022IS00.Q022IT00_ID_OFI=Q022HS00.Q022HT00_ID_OFI AND
Q022HS00.Q022HT00_PROV =NORA_T17_PROVINCIA.ID (+) and
Q022HS00.Q022HT00_MUNI =NORA_T17_MUNICIPIO.ID(+) and
Q022HS00.Q022HT00_PROV =NORA_T17_MUNICIPIO.PROVINCIA_ID (+) 



--CREATE SYNONYM Q022IS01V01 FOR Q022IV01
/


CREATE OR REPLACE VIEW Q022JV01
(Q022JT00_ID_AGEN, Q022JT00_ID_OFI, Q022JT00_NOMB, Q022JT00_APE1, Q022JT00_APE2, 
 Q022JT00_CODAG, Q022JT00_CODJF, Q022JT00_EMAILA, Q022JT00_TELF1A, Q022JT00_TELF2A, 
 Q022HT00_PROV, Q022HT00_MUNI, Q022HT00_DESC, Q022HT00_DESC_EUS, NORA_T17_PROVINCIA_DS, 
 NORA_T17_MUNICIPIO_DS)
AS 
SELECT 
  Q022JS00.Q022JT00_ID_AGEN  ,
  Q022ZS00.Q022HT00_ID_OFI   ,
  Q022JT00_NOMB     ,
  Q022JT00_APE1     ,
  Q022JT00_APE2     ,
  Q022JT00_CODAG    ,
  Q022JT00_CODJF    ,
  Q022JT00_EMAILA   ,
  Q022JT00_TELF1A   ,
  Q022JT00_TELF2A   ,   
  Q022HT00_PROV    ,
  Q022HT00_MUNI    ,
  Q022HT00_DESC    ,
  Q022HT00_DESC_EUS,
  NORA_T17_PROVINCIA.DS_O, 
  NORA_T17_MUNICIPIO.DS_O
FROM Q022JS00, Q022HS00, NORA_T17_PROVINCIA, NORA_T17_MUNICIPIO,Q022ZS00
WHERE 
Q022JS00.Q022JT00_ID_AGEN=Q022ZS00.Q022JT00_ID_AGEN (+) and
Q022ZS00.Q022HT00_ID_OFI=Q022HS00.Q022HT00_ID_OFI (+) AND
--Q022JT00.Q022JT00_ID_OFI=Q022HT00.Q022HT00_ID_OFI AND
Q022HS00.Q022HT00_PROV =NORA_T17_PROVINCIA.ID (+) and
Q022HS00.Q022HT00_MUNI =NORA_T17_MUNICIPIO.ID(+) and
Q022HS00.Q022HT00_PROV =NORA_T17_MUNICIPIO.PROVINCIA_ID (+)
/


CREATE OR REPLACE VIEW Q022MV01
(Q022MT00_ID_AYUN, Q022MT00_PROV, Q022MT00_MUNI, Q022MT00_DESC, Q022MT00_DESC_EUS, 
 Q022MT00_TVIA, Q022MT00_CALLE, Q022MT00_BLOQ, Q022MT00_NUME, Q022MT00_BIS, 
 Q022MT00_ESCA, Q022MT00_PISO, Q022MT00_MANO, Q022MT00_PUER, Q022MT00_CODP, 
 Q022MT00_CDIR, Q022MT00_EMAIL, Q022MT00_TELF1, Q022MT00_TELF2, Q022MT00_FAX, 
 Q022MT00_WEB, NORA_T17_PROVINCIA_DS, NORA_T17_MUNICIPIO_DS, NORA_T17_LOCALIZACION)
AS 
select  Q022MT00_ID_AYUN   ,
  Q022MT00_PROV      ,
  Q022MT00_MUNI      ,
  Q022MT00_DESC      ,
  Q022MT00_DESC_EUS  ,
  Q022MT00_TVIA      ,
  Q022MT00_CALLE     ,
  Q022MT00_BLOQ      ,
  Q022MT00_NUME      ,
  Q022MT00_BIS       ,
  Q022MT00_ESCA      ,
  Q022MT00_PISO      ,
  Q022MT00_MANO      ,
  Q022MT00_PUER      ,
  Q022MT00_CODP      ,
  Q022MT00_CDIR      ,
  Q022MT00_EMAIL     ,
  Q022MT00_TELF1     ,
  Q022MT00_TELF2     ,
  Q022MT00_FAX       ,
  Q022MT00_WEB       ,
  NORA_T17_PROVINCIA.DS_O,
  NORA_T17_MUNICIPIO.DS_O, Q022MT00_TVIA || ' ' || NORA_T17_CALLE.DS_O || ' ' ||  Q022MT00_BLOQ || ' '  ||  Q022MT00_NUME || ' '||  Q022MT00_BIS
from Q022MS00, NORA_T17_PROVINCIA, NORA_T17_MUNICIPIO,  NORA_T17_CALLE 
WHERE
Q022MS00.Q022MT00_PROV =NORA_T17_PROVINCIA.ID (+) and
Q022MS00.Q022MT00_MUNI =NORA_T17_MUNICIPIO.ID(+) and
Q022MS00.Q022MT00_PROV=NORA_T17_MUNICIPIO.PROVINCIA_ID (+) and
Q022MS00.Q022MT00_CALLE =NORA_T17_CALLE.ID(+)
/


CREATE OR REPLACE VIEW Q022ZV01
(Q022HT00_ID_OFI, Q022JT00_ID_AGEN, Q022HT00_DESC, Q022HT00_DESC_EUS, Q022HT00_PROV, 
 Q022HT00_MUNI, NORA_T17_MUNICIPIO_DS, NORA_T17_PROVINCIA_DS)
AS 
select
Q022ZS00.Q022HT00_ID_OFI,
Q022ZS00.Q022JT00_ID_AGEN,
Q022HS00.Q022HT00_DESC, 
Q022HS00.Q022HT00_DESC_EUS, 
Q022HS00.Q022HT00_PROV,
Q022HS00.Q022HT00_MUNI,
NORA_T17_MUNICIPIO.DS_O,
NORA_T17_PROVINCIA.DS_O
from Q022ZS00, Q022HS00,
NORA_T17_PROVINCIA,NORA_T17_MUNICIPIO
where 
Q022ZS00.Q022HT00_ID_OFI=Q022HS00.Q022HT00_ID_OFI and
Q022HS00.Q022HT00_PROV =NORA_T17_PROVINCIA.ID (+) and
Q022HS00.Q022HT00_MUNI=NORA_T17_MUNICIPIO.ID(+) and
Q022HS00.Q022HT00_PROV=NORA_T17_MUNICIPIO.PROVINCIA_ID (+)
/


CREATE OR REPLACE VIEW T17_PORTAL
(ID, BLOQUE, NUMERO, BIS, CALLE_ID, 
 ESTADO, LOCALIDAD_ID, CODIGO_POSTAL, ACEPCION, DX_ED50, 
 DY_ED50, DX_ETRS89, DY_ETRS89)
AS 
SELECT 
ID, BLOQUE, NUMERO, BIS, CALLE_ID, 
 ESTADO, LOCALIDAD_ID, CODIGO_POSTAL, ACEPCION, DX_ED50, 
 DY_ED50, DX_ETRS89, DY_ETRS89
  FROM NORA_T17_PORTAL
/


