DECLARE
   l_count   PLS_INTEGER;
BEGIN
-- BORRAR TODOS LOS SINONIMOS DE Q02A QUE TIRAN DE Q02b
   DBMS_OUTPUT.put_line ('BORRANDO SINONIMOS DE Q02A SOBRE Q02B ');
   l_count := 0;

   FOR reg IN (SELECT owner,
                      synonym_name,
                      table_owner,
                      table_name
                 FROM all_synonyms
                WHERE table_owner = 'Q02B' AND owner = 'Q02A')
   LOOP
      EXECUTE IMMEDIATE 'drop synonym ' || reg.synonym_name;

      l_count := l_count + 1;
   END LOOP;

   DBMS_OUTPUT.put_line ('SINONIMOS BORRADOS: ' || l_count);
-- regenerar todos los sinonimos propios de Q02B (tablas y vistas)
-- en el modelo de Q02a sobre objetos reales de Q02b
   DBMS_OUTPUT.put_line ('***************************************');
   DBMS_OUTPUT.put_line ('GENERANDO SINONIMOS DE Q02B, DESDE Q02A');
   DBMS_OUTPUT.put_line ('***************************************');
   DBMS_OUTPUT.put_line ('GENERANDO SINONIMOS DE TABLAS');
   l_count := 0;

   FOR reg IN (SELECT owner,
                      table_name
                 FROM all_tables
                WHERE owner = 'Q02B')
   LOOP
      EXECUTE IMMEDIATE    'create or replace synonym '
                        || reg.table_name
                        || ' for '
                        || reg.owner
                        || '.'
                        || reg.table_name;

      l_count := l_count + 1;
   END LOOP;

   DBMS_OUTPUT.put_line ('SINONIMOS DE TABLAS CREADOS EN Q02A: ' || l_count);
   DBMS_OUTPUT.put_line ('***************************************');
   DBMS_OUTPUT.put_line ('GENERANDO SINONIMOS DE VISTAS');
   l_count := 0;

   FOR reg IN (SELECT owner,
                      view_name
                 FROM all_views
                WHERE owner = 'Q02B')
   LOOP
      EXECUTE IMMEDIATE    'create or replace synonym '
                        || reg.view_name
                        || ' for '
                        || reg.owner
                        || '.'
                        || reg.view_name;

      l_count := l_count + 1;
   END LOOP;

   DBMS_OUTPUT.put_line ('SINONIMOS DE VISTAS CREADOS EN Q02A: ' || l_count);
   DBMS_OUTPUT.put_line ('***************************************');
   DBMS_OUTPUT.put_line ('GENERANDO SINONIMOS DE SEQUENCES');
   l_count := 0;

   FOR reg IN (SELECT sequence_owner,
                      sequence_name
                 FROM all_sequences
                WHERE sequence_owner = 'Q02B')
   LOOP
      EXECUTE IMMEDIATE    'create or replace synonym '
                        || reg.sequence_name
                        || ' for '
                        || reg.sequence_owner
                        || '.'
                        || reg.sequence_name;

      l_count := l_count + 1;
   END LOOP;

   DBMS_OUTPUT.put_line ('SINONIMOS DE VISTAS CREADOS EN Q02A: ' || l_count);
   DBMS_OUTPUT.put_line ('***************************************');
   DBMS_OUTPUT.put_line ('GENERANDO SINONIMOS DE SINONIMOS');
   l_count := 0;

   FOR reg IN (SELECT owner,
                      synonym_name,
                      table_owner,
                      table_name
                 FROM all_synonyms
                WHERE table_owner = 'Q02B' AND owner = 'Q02B')
   LOOP
      EXECUTE IMMEDIATE    'create or replace synonym '
                        || reg.synonym_name
                        || ' for '
                        || reg.table_owner
                        || '.'
                        || reg.table_name;

      l_count := l_count + 1;
   END LOOP;

   DBMS_OUTPUT.put_line ('SINONIMOS CREADOS EN Q02A: ' || l_count);
   DBMS_OUTPUT.put_line ('***************************************');
   -- generando sinonimos propios de Q02a sobre elementos de codigo
   -- funciones, paquetes y procedimiento del modelo de Q02b
   DBMS_OUTPUT.put_line ('GENERANDO SINONIMOS DE CODIGO PL/SQL');
   l_count := 0;

   FOR reg IN (SELECT   owner,
                        object_name
                   FROM all_objects
                  WHERE owner = 'Q02B'
                    AND object_type IN ('PACKAGE', 'FUNCTION', 'PROCEDURE')
                    AND object_name NOT LIKE 'Q02B_MIGRAR%'
               ORDER BY object_type,
                        object_name)
   LOOP
      EXECUTE IMMEDIATE    'create or replace synonym '
                        || reg.object_name
                        || ' for '
                        || reg.owner
                        || '.'
                        || reg.object_name;

      l_count := l_count + 1;
   END LOOP;

   DBMS_OUTPUT.put_line ('SINONIMOS CREADOS EN Q02A (CODIGO Q02B): '
                         || l_count
                        );
END;
/