#****************************************
#obtener_copia_bk.sh
#****************************************

clear

echo "\r\r\r"

echo "***************************************************"
echo "* EXPORT DE LA BASE DE DATOS ACTUAL				 *"
echo "***************************************************"

#****************************************************
# EJECUTAMOS LA EXPORT DE LA BASE DE DATOS
#****************************************************

#************************************************************
# OBTENER USUARIO Y PASSWORD DE CONEXION A LA BASE DE DATOS
#************************************************************

. n38bd 32306 01 STRING
salida=$?
if [ "salida" -gt 0 ]; then
echo "Error al obtener los parametros de conexion"
echo "*******************************************"
echo "NO SE HA PODIDO REALIZAR LA COPIA DE BBDD."
echo "*******************************************"
exit 1
fi

USUARIO=`echo $STRING |cut -d '#' -f2`
PASSWORD=`echo $STRING |cut -d '#' -f3` 


#**************************************
#Localizacion de ficheros 
#**************************************
DIR_LOG=/datos/q02a/copias
DIR_SCRIPTS=/aplic/q02a/scripts

echo "Eliminando todos los objetos de la Base de Datos ......"

sqlplus ${USUARIO}/${PASSWORD} @${DIR_SCRIPTS}/vaciar_bd.sql

echo "Exportando base de datos a ${DIR_LOG}/copiabbdd.dmp"
imp ${USUARIO}/${PASSWORD} file=${DIR_LOG}/copiabbdd.dmp log=${DIR_LOG}/copiabbdd_imp.log ignore=y commit=y

echo "Recompilando objetos de la base de datos ......"

sqlplus ${USUARIO}/${PASSWORD} @${DIR_SCRIPTS}/recompilar.sql


if [ "${?}" -ne 0 ]; then
	echo "Error al realizar la export"
else
	echo "Export de la BD realizado correctamente"	
fi

