/*
 * Decompiled with CFR 0.152.
 */
package es.ejie.frmk.presentacion.anomala;

import es.ejie.frmk.control.apilamiento.Q70GestorDeApilamiento;
import es.ejie.frmk.control.excepciones.Q70FrameworkException;
import es.ejie.frmk.infraestructura.logs.incidencias.Q70LogIncidencias;
import es.ejie.frmk.infraestructura.logs.navegacion.Q70LogNavegacion;
import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;
import es.ejie.frmk.infraestructura.traza.Q70Traza;
import es.ejie.frmk.presentacion.anomala.Q70DobleClickBean;
import es.ejie.frmk.presentacion.anomala.Q70NavegacionAnomalaException;
import es.ejie.frmk.presentacion.base.Q70PasosOPMapping;
import es.ejie.frmk.presentacion.base.Q70Workflow;
import es.ejie.frmk.presentacion.base.Q70WorkflowContainer;
import es.ejie.frmk.presentacion.operacion.Q70AdaptadorLogicaOperacionDePresentacion;
import es.ejie.frmk.presentacion.operacion.Q70LogicaOperacionDePresentacion;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.config.ForwardConfig;

public class Q70GestorDeNavegacionAnomala {
    private static Q70GestorDeNavegacionAnomala instance = null;
    private static final String COMPONENTE = "NAV_ANOMALA";
    public static final String DOBLE_CLICK_KEY = "es.ejie.frmk.presentacion.anomala.doble.click";
    private static Q70Traza tr = Q70Traza.getSingleton();
    private static Q70LogIncidencias logInc = Q70LogIncidencias.getSingleton();
    private static Q70LogNavegacion logNav = Q70LogNavegacion.getSingleton();

    private Q70GestorDeNavegacionAnomala() {
    }

    public static Q70GestorDeNavegacionAnomala getInstance() {
        if (instance == null) {
            instance = new Q70GestorDeNavegacionAnomala();
        }
        return instance;
    }

    public boolean processRupturaFlujo(Q70AdaptadorLogicaOperacionDePresentacion q70AdaptadorLogicaOperacionDePresentacion, Q70PasosOPMapping q70PasosOPMapping, Q70WorkflowContainer q70WorkflowContainer, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Q70FrameworkException {
        try {
            boolean bl = true;
            if (!q70PasosOPMapping.hasNoWorkflowChecksSet()) {
                Set set;
                String string;
                Object object;
                Collection collection;
                if (tr.isTraceActive()) {
                    tr.trace(COMPONENTE, Q70TraceLevel.INFO, "Chequeando ruptura de flujo.");
                }
                Q70Workflow q70Workflow = q70WorkflowContainer.getPrimary();
                String string2 = q70WorkflowContainer.getPrimaryLabel();
                if (null != q70Workflow && !(collection = q70Workflow.getDefinedNextStates()).isEmpty()) {
                    object = q70PasosOPMapping.getWorkflowData(string2);
                    if (null != object) {
                        string = ((Q70PasosOPMapping.WorkflowData)object).getNewState();
                        if (null == string) {
                            string = q70Workflow.getCurrentState();
                        }
                    } else {
                        string = q70Workflow.getCurrentState();
                    }
                    if (null == string || !collection.contains(string)) {
                        bl = false;
                        q70WorkflowContainer.remove(httpServletRequest, string2);
                        set = q70PasosOPMapping.findForward(Q70LogicaOperacionDePresentacion.WORKFLOW_VIOLATION_FORWARD_PREFIX + string2);
                        httpServletRequest.setAttribute("es.ejie.frmk.presentacion.operacion.LogicaOperacionPresentacion.nextStateViolationPath", (Object)httpServletRequest.getServletPath());
                        this.writeLog("processRupturaFlujo", "Navegaci\u00f3n an\u00f3mala detectada.");
                        q70AdaptadorLogicaOperacionDePresentacion.processForwardConfig(httpServletRequest, httpServletResponse, (ForwardConfig)set);
                    }
                }
                if (bl) {
                    collection = q70PasosOPMapping.getWorkflows();
                    string = null;
                    if (0 < collection.size()) {
                        object = collection.iterator();
                        while (object.hasNext() && bl) {
                            string = (String)object.next();
                            set = q70PasosOPMapping.getWorkflowData(string).getPrevStates();
                            if (null == set || set.isEmpty()) continue;
                            Q70Workflow q70Workflow2 = q70WorkflowContainer.get(string);
                            if (null == q70Workflow2) {
                                bl = false;
                                continue;
                            }
                            String string3 = q70Workflow2.getCurrentState();
                            bl = null != string3 && set.contains(string3);
                        }
                    }
                    if (!bl) {
                        q70WorkflowContainer.remove(httpServletRequest, string);
                        object = q70PasosOPMapping.findForward(Q70LogicaOperacionDePresentacion.WORKFLOW_VIOLATION_FORWARD_PREFIX + string);
                        this.writeLog("processRupturaFlujo", "Navegaci\u00f3n an\u00f3mala detectada.");
                        q70AdaptadorLogicaOperacionDePresentacion.processForwardConfig(httpServletRequest, httpServletResponse, (ForwardConfig)object);
                    }
                }
            }
            return bl;
        }
        catch (Exception exception) {
            throw new Q70NavegacionAnomalaException(this.getClass().toString(), "processRupturaFlujo", "Error al detectar una ruptura de flujo.", exception);
        }
    }

    public boolean processDobleClick(Q70PasosOPMapping q70PasosOPMapping, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Q70FrameworkException {
        try {
            boolean bl = true;
            if (null == q70PasosOPMapping.getForward() && null == q70PasosOPMapping.getInclude() && !Q70GestorDeApilamiento.getSingleton().isReturnToSuperOp(httpServletRequest, q70PasosOPMapping.getSubOp())) {
                Hashtable<String, Q70DobleClickBean> hashtable = (Hashtable<String, Q70DobleClickBean>)httpServletRequest.getSession().getAttribute(DOBLE_CLICK_KEY);
                Q70DobleClickBean q70DobleClickBean = null;
                if (tr.isTraceActive()) {
                    tr.trace(COMPONENTE, Q70TraceLevel.INFO, "An\u00e1lisis de Doble-click: Comprobando si ha finalizado la ultima petici\u00f3n del recurso actual para el usuario. ");
                }
                if (null != hashtable) {
                    if (tr.isTraceActive()) {
                        tr.trace(COMPONENTE, Q70TraceLevel.INFO, "Lista de peticiones no finalizadas para el usuario: " + hashtable.toString());
                    }
                    if (null != (q70DobleClickBean = (Q70DobleClickBean)hashtable.get(httpServletRequest.getRequestURI()))) {
                        this.writeLog("processDobleClick", "Doble-click detectado para el recurso " + httpServletRequest.getRequestURI() + " a\u00fan no finalizado. Retardo = " + q70DobleClickBean.calcularRetardo() + " milisegundos.");
                        bl = false;
                    } else {
                        q70DobleClickBean = new Q70DobleClickBean();
                    }
                } else {
                    q70DobleClickBean = new Q70DobleClickBean();
                    hashtable = new Hashtable<String, Q70DobleClickBean>(1);
                }
                q70DobleClickBean.setTimestamp();
                q70DobleClickBean.setResponse(httpServletResponse);
                hashtable.put(httpServletRequest.getRequestURI(), q70DobleClickBean);
                httpServletRequest.getSession().setAttribute(DOBLE_CLICK_KEY, hashtable);
            }
            return bl;
        }
        catch (Exception exception) {
            throw new Q70NavegacionAnomalaException(this.getClass().toString(), "processDobleClick", "Error al detectar un doble click.", exception);
        }
    }

    public void cleanDobleClick(HttpServletRequest httpServletRequest) {
        Hashtable hashtable = (Hashtable)httpServletRequest.getSession().getAttribute(DOBLE_CLICK_KEY);
        if (null != hashtable) {
            hashtable.remove(httpServletRequest.getRequestURI());
        }
    }

    public HttpServletResponse getDobleClickResponse(HttpServletRequest httpServletRequest) {
        Q70DobleClickBean q70DobleClickBean;
        HttpServletResponse httpServletResponse = null;
        Hashtable hashtable = (Hashtable)httpServletRequest.getSession().getAttribute(DOBLE_CLICK_KEY);
        if (null != hashtable && null != (q70DobleClickBean = (Q70DobleClickBean)hashtable.get(httpServletRequest.getRequestURI()))) {
            httpServletResponse = q70DobleClickBean.getResponse();
        }
        return httpServletResponse;
    }

    private void writeLog(String string, String string2) {
        if (tr.isTraceActive()) {
            tr.trace(COMPONENTE, Q70TraceLevel.ERROR, string2);
        }
        if (logNav.isEnabled()) {
            logNav.log("NAV. ANOMALA", "ENTRADA");
        }
        if (logInc.isEnabled()) {
            Q70NavegacionAnomalaException q70NavegacionAnomalaException = new Q70NavegacionAnomalaException(this.getClass().toString(), string, string2, null);
            logInc.log((Throwable)((Object)q70NavegacionAnomalaException), COMPONENTE, "WARN");
        }
    }
}

