/*
 * Decompiled with CFR 0.152.
 */
package org.displaytag.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;

public class Href {
    private String url;
    private HashMap parameters;

    public Href(String baseUrl) {
        this.parameters = new HashMap();
        if (baseUrl.indexOf("?") == -1) {
            this.url = baseUrl;
        } else {
            StringTokenizer tokenizer = new StringTokenizer(baseUrl, "?");
            this.url = tokenizer.nextToken();
            if (tokenizer.hasMoreTokens()) {
                StringTokenizer paramTokenizer = new StringTokenizer(tokenizer.nextToken(), "&");
                while (paramTokenizer.hasMoreTokens()) {
                    String[] keyValue = StringUtils.split((String)paramTokenizer.nextToken(), (String)"=");
                    this.parameters.put(StringEscapeUtils.escapeHtml((String)keyValue[0]), StringEscapeUtils.escapeHtml((String)keyValue[1]));
                }
            }
        }
    }

    public Href(Href href) {
        this.url = href.getBaseUrl();
        this.parameters = href.getParameterMap();
    }

    public void addParameter(String name, Object value) {
        this.parameters.put(name, value);
    }

    public void addParameter(String name, int value) {
        this.parameters.put(name, new Integer(value));
    }

    public HashMap getParameterMap() {
        return (HashMap)this.parameters.clone();
    }

    public void setParameterMap(Map parametersMap) {
        this.parameters = new HashMap(parametersMap.size());
        this.addParameterMap(parametersMap);
    }

    public void addParameterMap(Map parametersMap) {
        Iterator mapIterator = parametersMap.entrySet().iterator();
        while (mapIterator.hasNext()) {
            Map.Entry entry = mapIterator.next();
            String key = StringEscapeUtils.escapeHtml((String)((String)entry.getKey()));
            String value = StringEscapeUtils.escapeHtml((String)((String)entry.getValue()));
            this.parameters.put(key, value);
        }
    }

    public String getBaseUrl() {
        return this.url;
    }

    public String toString() {
        if (this.parameters.size() == 0) {
            return this.url;
        }
        StringBuffer buffer = new StringBuffer(30);
        buffer.append(this.url).append('?');
        Set parameterSet = this.parameters.entrySet();
        Iterator iterator = parameterSet.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            buffer.append(entry.getKey()).append('=').append(entry.getValue());
            if (!iterator.hasNext()) continue;
            buffer.append("&amp;");
        }
        return buffer.toString();
    }
}

