<?xml version="1.0" encoding="UTF-8" ?>
<!-- 

	Developed by Ibai Sistemas <ibai@ibai.com>
	
	> http://www.europeana.eu/schemas/ese/ESE-V3.4.xsd

 -->

<xsl:stylesheet
  xmlns:doc="http://www.lyncode.com/xoai"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  version="1.0">
	<xsl:output omit-xml-declaration="yes" method="xml" indent="yes" />
	
        
   
	
	<xsl:template match="/">
		
			<europeana:record xmlns:europeana="http://www.europeana.eu/schemas/ese/" 
			xmlns:dc="http://purl.org/dc/elements/1.1/">
			<!--DC.DATE-->
			<xsl:choose>
				<xsl:when test="doc:metadata/doc:element[@name='dc']/doc:element[@name='date']/doc:element/doc:field[@name='value'] != ''">
					<dc:date><xsl:value-of select="doc:metadata/doc:element[@name='dc']/doc:element[@name='date']/doc:element/doc:field[@name='value']"/></dc:date>
				</xsl:when>
				<xsl:otherwise>
					<dc:date><xsl:value-of select="(doc:metadata/doc:element[@name='dc']/doc:element[@name='date']/doc:element/doc:element/doc:field[@name='value'])[3]"/></dc:date>
				</xsl:otherwise>
			</xsl:choose>
			<!--<xsl:value-of select="./node()" />-->
				<!--DC.CREATOR-->	
					<xsl:for-each select="doc:metadata/doc:element[@name='dc']/doc:element[@name='creator']/doc:element/doc:field[@name='value']">
						<dc:creator><xsl:value-of select="." /></dc:creator>
					</xsl:for-each>
				<!--DC.CONTRIBUTOR-->	
					<xsl:for-each select="doc:metadata/doc:element[@name='dc']/doc:element[@name='contributor']/doc:element[@name!='author']/doc:element/doc:field[@name='value']">
						<dc:creator><xsl:value-of select="." /></dc:creator>
					</xsl:for-each>	
				<!--DC.IDENTIFIER-->
					<xsl:for-each select="doc:metadata/doc:element[@name='dc']/doc:element[@name='identifier']/doc:element/doc:element/doc:field[@name='value']">
						<dc:identifier><xsl:value-of select="." /></dc:identifier>
					</xsl:for-each>		
				<!--DC.DESCRIPTION-->		
					<xsl:for-each select="doc:metadata/doc:element[@name='dc']/doc:element[@name='description']/doc:element/doc:field[@name='value']">
						<dc:description><xsl:value-of select="." /></dc:description>
					</xsl:for-each>
				<!--DC.FORMAT-->	
					<xsl:for-each select="doc:metadata/doc:element[@name='bitstreams']/doc:element[@name='bitstream']/doc:field[@name='format']">
						<dc:format><xsl:value-of select="." /></dc:format>
					</xsl:for-each>	
				<!--DC.LANGUAGE-->	
					<xsl:for-each select="doc:metadata/doc:element[@name='dc']/doc:element[@name='language']/doc:element/doc:field[@name='value']">
						<dc:language><xsl:value-of select="." /></dc:language>
					</xsl:for-each>	
				<!--DC.RIGHTS-->	
					<xsl:for-each select="doc:metadata/doc:element[@name='dc']/doc:element[@name='rights']/doc:element/doc:element/doc:field[@name='value']">
						<dc:rights><xsl:value-of select="." /></dc:rights>
					</xsl:for-each>
					<xsl:for-each select="doc:metadata/doc:element[@name='dc']/doc:element[@name='rights']/doc:element/doc:field[@name='value']">
						<dc:rights><xsl:value-of select="." /></dc:rights>
					</xsl:for-each>	
				<!--DC.SUBJECT-->	
					<xsl:for-each select="doc:metadata/doc:element[@name='dc']/doc:element[@name='subject']/doc:element/doc:field[@name='value']">
						<dc:subject><xsl:value-of select="." /></dc:subject>
					</xsl:for-each>
				<!--DC.TITLE-->
					<xsl:for-each select="doc:metadata/doc:element[@name='dc']/doc:element[@name='title']/doc:element/doc:field[@name='value']">
						<dc:title><xsl:value-of select="." /></dc:title>
					</xsl:for-each>
				<!--DC.TYPE-->	
					<xsl:for-each select="doc:metadata/doc:element[@name='dc']/doc:element[@name='type']/doc:element/doc:field[@name='value']">
						<dc:type><xsl:value-of select="." /></dc:type>
					</xsl:for-each>
				<!--DC.RELATION-->
					<xsl:for-each select="doc:metadata/doc:element[@name='dc']/doc:element[@name='relation']/doc:element/doc:element/doc:field[@name='value']">
						<dc:relation><xsl:value-of select="." /></dc:relation>
					</xsl:for-each>
					<xsl:for-each select="doc:metadata/doc:element[@name='dc']/doc:element[@name='relation']/doc:element/doc:field[@name='value']">
						<dc:relation><xsl:value-of select="." /></dc:relation>
					</xsl:for-each>
				<!--DC.COVERAGE-->	
					<xsl:for-each select="doc:metadata/doc:element[@name='dc']/doc:element[@name='coverage']/doc:element/doc:field[@name='value']">
						<dc:coverage><xsl:value-of select="." /></dc:coverage>
					</xsl:for-each>
					<xsl:for-each select="doc:metadata/doc:element[@name='dc']/doc:element[@name='coverage']/doc:element/doc:element/doc:field[@name='value']">
						<dc:coverage><xsl:value-of select="." /></dc:coverage>
					</xsl:for-each>
				<!--DC.PUBLISHER-->	
					<xsl:for-each select="doc:metadata/doc:element[@name='dc']/doc:element[@name='publisher']/doc:element/doc:field[@name='value']">
						<dc:publisher><xsl:value-of select="." /></dc:publisher>
					</xsl:for-each>
					<xsl:for-each select="doc:metadata/doc:element[@name='dc']/doc:element[@name='publisher']/doc:element/doc:element/doc:field[@name='value']">
						<dc:publisher><xsl:value-of select="." /></dc:publisher>
					</xsl:for-each>
					<!--DC.SOURCE-->
					<xsl:for-each select="doc:metadata/doc:element[@name='dc']/doc:element[@name='source']/doc:element/doc:field[@name='value']">
						<dc:source><xsl:value-of select="." /></dc:source>
					</xsl:for-each>
					<xsl:for-each select="doc:metadata/doc:element[@name='dc']/doc:element[@name='source']/doc:element/doc:element/doc:field[@name='value']">
						<dc:source><xsl:value-of select="." /></dc:source>
					</xsl:for-each>
				<!--EUROPEANA:unstored-->
				<xsl:for-each select="doc:metadata/doc:element[@name='europeana']/doc:element[@name='unstored']/doc:element/doc:field[@name='value']">
					<europeana:unstored><xsl:value-of select="." /></europeana:unstored>
				</xsl:for-each>
				<!--EUROPEANA:object-->
				<xsl:for-each select="doc:metadata/doc:element[@name='europeana']/doc:element[@name='object']/doc:element/doc:field[@name='value']">
					<europeana:object><xsl:value-of select="." /></europeana:object>
				</xsl:for-each>
				<!--EUROPEANA:provider-->
				<xsl:for-each select="doc:metadata/doc:element[@name='europeana']/doc:element[@name='provider']/doc:element/doc:field[@name='value']">
					<europeana:provider><xsl:value-of select="." /></europeana:provider>
				</xsl:for-each>
				<!--EUROPEANA:type-->
				<xsl:for-each select="doc:metadata/doc:element[@name='europeana']/doc:element[@name='type']/doc:element/doc:field[@name='value']">
					<europeana:type><xsl:value-of select="." /></europeana:type>
				</xsl:for-each>
				<!--EUROPEANA:rights-->
				<xsl:for-each select="doc:metadata/doc:element[@name='europeana']/doc:element[@name='rights']/doc:element/doc:field[@name='value']">
					<europeana:rights><xsl:value-of select="." /></europeana:rights>
				</xsl:for-each>
				<!--EUROPEANA:dataProvider-->
				<xsl:for-each select="doc:metadata/doc:element[@name='europeana']/doc:element[@name='dataProvider']/doc:element/doc:field[@name='value']">
					<europeana:dataProvider><xsl:value-of select="." /></europeana:dataProvider>
				</xsl:for-each>
				<!--EUROPEANA:isShownBy-->
				<xsl:for-each select="doc:metadata/doc:element[@name='europeana']/doc:element[@name='isShownBy']/doc:element/doc:field[@name='value']">
					<europeana:isShownBy><xsl:value-of select="." /></europeana:isShownBy>
				</xsl:for-each>	
				<!--EUROPEANA:isShownAt-->
				<xsl:for-each select="doc:metadata/doc:element[@name='europeana']/doc:element[@name='isShownAt']/doc:element/doc:field[@name='value']">
					<europeana:isShownAt><xsl:value-of select="." /></europeana:isShownAt>
				</xsl:for-each>
				
			</europeana:record>
		
	</xsl:template>
</xsl:stylesheet>
