/**
 * The contents of this file are subject to the license and copyright
 * detailed in the LICENSE and NOTICE files at the root of the source
 * tree and available online at
 *
 * http://www.dspace.org/license/
 */

package org.dspace.xoai.filter;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.content.Bundle;
import org.dspace.content.Item;
import org.dspace.core.Constants;
import org.dspace.core.Context;
import org.dspace.handle.HandleManager;
import org.dspace.xoai.data.DSpaceItem;

import org.dspace.core.ConfigurationManager;

/**
 * 
 * @author Lyncode Development Team <dspace@lyncode.com>
 */
public class DSpaceEuropeanaIncunablesFilter extends DSpaceFilter
{
    private static Logger log = LogManager
            .getLogger(DSpaceAuthorizationFilter.class);

    @Override
    public DatabaseFilterResult getWhere(Context context)
    {
        List<Object> params = new ArrayList<Object>();
        return new DatabaseFilterResult("EXISTS (SELECT p.action_id FROM "
                + "resourcepolicy p, " + "bundle2bitstream b, " + "bundle bu, "
                + "item2bundle ib " + "WHERE " + "p.resource_type_id=0 AND "
                + "p.resource_id=b.bitstream_id AND "
                + "p.epersongroup_id=0 AND " + "b.bundle_id=ib.bundle_id AND "
                + "bu.bundle_id=b.bundle_id AND " + "bu.name='ORIGINAL' AND "
                + "ib.item_id=i.item_id)", params);
    }

    @Override
    public boolean isShown(DSpaceItem item)
    {
        return true;
    }

    @Override
    public SolrFilterResult getQuery()
    {
    	  String collections = ConfigurationManager.getProperty("incunables.hdl_collection");
    	  String filter = "";
    	  String[] collections_parts = collections.trim().split(",");
    	  for (int i = 0; i < collections_parts.length; ++i) {
    	  	if (!filter.equals("")) filter += " OR ";
          filter += "item.collections:col_" + collections_parts[i].replace("/","_");
        }
        return new SolrFilterResult("(" + filter + ")");
    }

}
