package org.ibai.app.webui.servlet;

import java.io.IOException;
import java.sql.SQLException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.Cookie;

import org.apache.log4j.Logger;
import org.apache.commons.lang.StringUtils;
import org.dspace.app.webui.util.JSPManager;
import org.dspace.authorize.AuthorizeException;
import org.dspace.core.Context;

//***************************************************************//
//Dos disenos a la vez
import java.sql.*;
import org.dspace.core.ConfigurationManager;
//***************************************************************//

public class PDVotarServlet extends org.dspace.app.webui.servlet.DSpaceServlet
{
    private static Logger log = Logger.getLogger(PDVotarServlet.class);

    protected void doDSGet(Context context, HttpServletRequest request,
            HttpServletResponse response) throws ServletException, IOException,
            SQLException, AuthorizeException
    {
    	
    		//***************************************************************//
    		//Dos disenos a la vez
    		
    		String ui = request.getParameter("ui");
    		String carpeta_ui = "prestamo-digital";
    		//Parametro para el diseno en BD
    		Connection conexion = null;
			 	ResultSet resultado = null;
			 	try {
			 			conexion = conecta();				
						PreparedStatement  preparedStatement=conexion.prepareStatement("SELECT VALOR FROM PD_CONFIGURACION WHERE NOMBRE='config_ui'");
						resultado = preparedStatement.executeQuery();
					  if (resultado.next()) {
					  	String ui_bd = resultado.getString("VALOR");
					  	if (ui_bd.equals("responsive")) carpeta_ui = "prestamo-digital-responsive";
					  }
				}
				catch(SQLException e) { }
				finally {
					if (resultado != null) resultado.close();
					if (conexion != null)  conexion.close();
				}
    		
    		//Parametro para el diseno desde parametro url
    		if (ui != null) {
    				if (ui.equals("responsive")) carpeta_ui = "prestamo-digital-responsive";
    		}
    		//***************************************************************//
    
    	  
  			String libro = request.getParameter("libro");
  			if (libro != null) request.setAttribute("libro", libro);
  			String puntuacion = request.getParameter("puntuacion");
  			if (puntuacion != null) request.setAttribute("puntuacion", puntuacion);
  			
  			
  			HttpSession session = request.getSession(true);
    	  if ((isNullOrBlank((String)session.getAttribute("usuario"))) || (!"usuario".equals((String)session.getAttribute("usuario_tipo")))) {
    	  		request.setAttribute("usuario", "anonimo");
    	  }
    		else {
    				request.setAttribute("usuario", (String)session.getAttribute("usuario"));
    		}
  			
  			
				if ((libro == null) || (puntuacion == null)) response.sendRedirect(response.encodeRedirectURL(request.getContextPath() + "/error"));
				else {
					String nombre_cookie = "votos_eliburutegia";
  				String libros_votados = "";
  				boolean tiene_cookie = false;
  				Cookie cookie_eliburutegia = null;
  				Cookie[] cookies = request.getCookies();
					for(Cookie cookie : cookies){
					    if(nombre_cookie.equals(cookie.getName())) cookie_eliburutegia = cookie;
					}
					if (cookie_eliburutegia != null) {
							libros_votados = cookie_eliburutegia.getValue();
							if (!libros_votados.contains("_" + libro + "_")) {
									cookie_eliburutegia.setValue(libros_votados + libro + "_");
  								response.addCookie(cookie_eliburutegia);
  								JSPManager.showJSP(request, response, "/" + carpeta_ui + "/estrellas_votar.jsp");
							}
							else response.sendRedirect(response.encodeRedirectURL(request.getContextPath() + "/error"));
					}
					else {
						Cookie cookie = new Cookie(nombre_cookie, "_" + libro + "_");
						//2 meses = 60 dias (el ultimo numero)
						cookie.setMaxAge(60*60*24*60); 
						response.addCookie(cookie);
						JSPManager.showJSP(request, response, "/" + carpeta_ui + "/estrellas_votar.jsp");
					}
  			}
    		
    }
    
    protected void doPost(HttpServletRequest request,
            HttpServletResponse response) throws ServletException, IOException
    {
        doGet(request, response);
    }
    
    private static boolean isNullOrBlank(String param) { 
		    return param == null || param.trim().length() == 0;
		}
		
		protected static Connection conecta() { 
				try {
					String bd      = ConfigurationManager.getProperty("db.url");
					String usuario = ConfigurationManager.getProperty("db.username");
					String pass    = ConfigurationManager.getProperty("db.password");
					return DriverManager.getConnection(bd, usuario, pass); 
				}
				catch (Exception er) { return null; } 
		}

}
