package org.ibai.app.webui.servlet;

import java.io.IOException;
import java.sql.SQLException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.log4j.Logger;
import org.apache.commons.lang.StringUtils;
import org.dspace.app.webui.util.JSPManager;
import org.dspace.authorize.AuthorizeException;
import org.dspace.core.Context;

public class PDDescargarZIP extends org.dspace.app.webui.servlet.DSpaceServlet
{
    private static Logger log = Logger.getLogger(PDDescargarZIP.class);

    protected void doDSGet(Context context, HttpServletRequest request,
            HttpServletResponse response) throws ServletException, IOException,
            SQLException, AuthorizeException
    {
    	  HttpSession session = request.getSession(true);
    	  if ((isNullOrBlank((String)session.getAttribute("usuario"))) || (!"usuario".equals((String)session.getAttribute("usuario_tipo")))) response.sendRedirect(response.encodeRedirectURL(request.getContextPath() + "/login"));
    		else {
    			String prestamo_id = request.getParameter("id");
	    		if (prestamo_id != null) {
	    				if (StringUtils.isNumeric(prestamo_id)) request.setAttribute("prestamo_id", prestamo_id);
		    			else JSPManager.showJSP(request, response, "/error");
	    		}
    			JSPManager.showJSP(request, response, "/prestamo-digital/descargar_zip.jsp");
    		}
    }
    
    protected void doPost(HttpServletRequest request,
            HttpServletResponse response) throws ServletException, IOException
    {
        doGet(request, response);
    }
    
    private static boolean isNullOrBlank(String param) { 
		    return param == null || param.trim().length() == 0;
		}

}
