/**
 * The contents of this file are subject to the license and copyright
 * detailed in the LICENSE and NOTICE files at the root of the source
 * tree and available online at
 *
 * http://www.dspace.org/license/
 */
package org.dspace.app.webui.jsptag;

import java.io.IOException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.jstl.fmt.LocaleSupport;
import javax.servlet.jsp.tagext.TagSupport;

import org.apache.commons.lang.ArrayUtils;
import org.dspace.content.Community;

/**
 * Tag for display a list of communities
 * 
 * @author Robert Tansley
 * @version $Revision$
 */
public class CommunityListTag extends TagSupport
{
    /** Communities to display */
    private transient Community[] communities;

    private static final long serialVersionUID = 5788338729470292501L;

    public CommunityListTag()
    {
        super();
    }

    public int doStartTag() throws JspException
    {
        JspWriter out = pageContext.getOut();

        try
        {
        		//Cambio para GV: estilo de la tabla
            out.println("<table cellpadding=\"0\" cellspacing=\"0\" align=\"center\" class=\"miscTable\" title=\"Community List\">");

            // Write column headings
            out.print("<tr><th id=\"t5\" class=\"oddRowOddCol\">"
                            + LocaleSupport.getLocalizedMessage(pageContext,
                                    "org.dspace.app.webui.jsptag.CommunityListTag.communityName")
                    + "</th></tr>");

            // Row: toggles between Odd and Even
            String row = "even";

            for (int i = 0; i < communities.length; i++)
            {
                // name
                String name = communities[i].getMetadata("name");

                // first and only column is 'name'
                out.print("<tr><td headers=\"t5\" class=\"" + row + "RowEvenCol\">");
                out.print("<a href=\"");

                HttpServletRequest hrq = (HttpServletRequest) pageContext.getRequest();
                out.print(hrq.getContextPath() + "/handle/");
                out.print(communities[i].getHandle());
                out.print("\">");
                
                //Cambio para GV: traduccion del nombre de la comunidad
                String nombre_comunidad = name;
			    	    if ((nombre_comunidad != null) && (!nombre_comunidad.equals(""))) {
			      	    char[] nombre_comunidad_sep = nombre_comunidad.toCharArray();
			      	    if (nombre_comunidad_sep[4] == '@') {
			        	    nombre_comunidad =  LocaleSupport.getLocalizedMessage(pageContext, nombre_comunidad.substring(4));
			        		}
				    		}                
                
                out.print(nombre_comunidad);
                
                out.print("</a>");

                out.println("</td></tr>");

                row = (row.equals("odd") ? "even" : "odd");
            }

            out.println("</table>");
        }
        catch (IOException ie)
        {
            throw new JspException(ie);
        }

        return SKIP_BODY;
    }

    /**
     * Get the communities to list
     * 
     * @return the communities
     */
    public Community[] getCommunities()
    {
        return (Community[]) ArrayUtils.clone(communities);
    }

    /**
     * Set the communities to list
     * 
     * @param communitiesIn
     *            the communities
     */
    public void setCommunities(Community[] communitiesIn)
    {
        communities = (Community[]) ArrayUtils.clone(communitiesIn);
    }

    public void release()
    {
        communities = null;
    }
}
