package org.ibai.app.webui.prestamo_digital;

import org.dspace.core.ConfigurationManager;
import org.dspace.storage.rdbms.DatabaseManager;

import java.io.File;
import java.sql.*;
import java.sql.SQLException;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Properties;  
import javax.mail.Message;  
import javax.mail.MessagingException;  
import javax.mail.Session;  
import javax.mail.Transport;  
import javax.mail.internet.InternetAddress;  
import javax.mail.internet.MimeMessage;

import java.util.Date;
import java.text.DateFormat;
import java.text.SimpleDateFormat; 

import org.apache.log4j.Logger;

public class PDPublicarLibrosApp {
    
    /** log4j logger */
		private static Logger log = Logger.getLogger(PDPublicarLibrosApp.class);
		private static final Properties properties = new Properties();
		private static Session session;
	
		private static Connection conecta() { 
				try {
					Class.forName("oracle.jdbc.OracleDriver");
					String bd      = ConfigurationManager.getProperty("db.url");
					String usuario = ConfigurationManager.getProperty("db.username");
					String pass    = ConfigurationManager.getProperty("db.password");
					return DriverManager.getConnection(bd, usuario, pass);
				}
				catch (Exception er) {
					System.out.println("Error conecta: " + er.getMessage());
					log.info("Error conecta: " + er.getMessage());
					return null;
				} 
		}
		
		private static void init(String direccion_mail) {  
        properties.put("mail.smtp.host", ConfigurationManager.getProperty("mail.server"));  
        properties.put("mail.smtp.mail.sender", direccion_mail);  
        properties.put("mail.smtp.user", ConfigurationManager.getProperty("mail.server.username"));  
        properties.put("mail.smtp.pass", ConfigurationManager.getProperty("mail.server.password"));  
        session = Session.getDefaultInstance(properties);
    }  
	
		private static String textoHTML(String cadena) {
    		String result = cadena;
    		if ("".equals(result)) return "";
    		result = result.replace("á", "&aacute;");
    		result = result.replace("é", "&eacute;");
    		result = result.replace("í", "&iacute;");
    		result = result.replace("ó", "&oacute;");
    		result = result.replace("ú", "&uacute;");
    		result = result.replace("ñ", "&ntilde;");
    		result = result.replace("ü", "&uuml;");
    		result = result.replace("¿", "&iquest;");
    		result = result.replace("?", "&#63;");
    		
    		
    		result = result.replace("Á", "&Aacute;");
    		result = result.replace("É", "&Eacute;");
    		result = result.replace("Í", "&Iacute;");
    		result = result.replace("Ó", "&Oacute;");
    		result = result.replace("Ú", "&Uacute;");
    		result = result.replace("Ñ", "&Ntilde;");
    		result = result.replace("Ü", "&Uuml;");
    		return result;
    }
	
		public static void main(String[] argv) throws Exception {
				Connection conexion_mail = null;
				String direccion_mail = "";
				PreparedStatement ps_direccion_mail = null;
				ResultSet rs_direccion_mail = null;
				try {
					conexion_mail = conecta();
					String consulta = "SELECT VALOR FROM PD_CONFIGURACION WHERE NOMBRE='config_email_sugerencias'";
					ps_direccion_mail = conexion_mail.prepareStatement(consulta);
					rs_direccion_mail = ps_direccion_mail.executeQuery();
					if (rs_direccion_mail.next())  {
							direccion_mail = rs_direccion_mail.getString("VALOR");
					}
				}
				catch(SQLException ex) {
						System.out.println("Error: " + ex.getMessage());
						log.info("Error: "+ ex.getMessage());
				}	
				finally {
					if (rs_direccion_mail != null) rs_direccion_mail.close();
					if (ps_direccion_mail != null) ps_direccion_mail.close();
					if (conexion_mail != null) conexion_mail.close();
				}
				
				
				System.out.println("......................");
				log.info("......................");
				System.out.println("Publicar libros desde aplicacion carga automatica...");
				log.info("Publicar libros desde aplicacion carga automatica...");
				publicar_libros_app(direccion_mail);
    }
    
    
    public static void enviar_mail(String direccion_mail, String cuerpo_mail_isbns) throws SQLException {
        init(direccion_mail);
				String email = "";
				String id_email = "";
				int contador = 0;
				try {
						String texto = "Los siguientes libros se han publicado en eLiburutegia:<br/>" + cuerpo_mail_isbns + "<br/><br/>Saludos";
            MimeMessage message = new MimeMessage(session);
            message.setFrom(new InternetAddress((String)properties.get("mail.smtp.mail.sender")));
            message.addRecipient(Message.RecipientType.TO, new InternetAddress((String)properties.get("mail.smtp.mail.sender")));  
            message.setSubject("eLiburutegia: Libros publicados");
            message.setHeader("Content-Type", "text/html");
            message.setContent(textoHTML(texto), "text/html");
            Transport t = session.getTransport("smtp");  
            t.connect((String)properties.get("mail.smtp.user"), (String)properties.get("mail.smtp.pass"));  
            t.sendMessage(message, message.getAllRecipients());
            t.close();
            log.info("Email enviado a: " + email);
				}
				catch(Exception ex) {
					if (ex instanceof SQLException || ex instanceof MessagingException) {
						log.info("Error: " + ex.getMessage());
					}
				}
    }
    
    
    private static void publicar_libros_app(String direccion_mail) throws Exception {
				Connection conexion = null;
				PreparedStatement ps = null;
				PreparedStatement sentencia_update = null;
				ResultSet rs = null;
				int id_libros = 0;
				String titulo = "";
				String isbn = "";
				String fichero = "";
				String portada = "";
				try {
						conexion = conecta();
						String consulta = "SELECT ID_LIBROS,TITULO,ISBN,FICHERO,PORTADA FROM PD_LIBROS WHERE ORIGEN='aut' AND PUBLICADO='no'";
						ps = conexion.prepareStatement(consulta);
						rs = ps.executeQuery();
						String cuerpo_mail_isbns = "";
						while (rs.next())  {
								id_libros = rs.getInt("ID_LIBROS");
								titulo    = rs.getString("TITULO");
								isbn      = rs.getString("ISBN");
								fichero   = rs.getString("FICHERO");
								portada   = rs.getString("PORTADA");
								
								//Fichero epub
								String ruta_fichero = "/datos/x20/dspace/assetstore/libros/" + fichero;
								File file_fichero = new File(ruta_fichero);
								boolean existe_epub = file_fichero.exists();
								
								//Ficheros streaming
								String ruta_streaming = "/aplic/x20/dspace/webapps/jspui/prestamo-digital/libros/streaming/" + isbn;
								File file_streaming = new File(ruta_streaming);
								boolean existe_streaming = file_streaming.exists();
								
								//Fichero portada
								String ruta_portada = "/aplic/x20/dspace/webapps/jspui/prestamo-digital/libros/portadas/" + portada;
								File file_portada = new File(ruta_portada);
								boolean existe_portada = file_portada.exists();
								
								if ((existe_epub) && (existe_streaming) && (existe_portada)) {
										sentencia_update = conexion.prepareStatement("UPDATE PD_LIBROS SET PUBLICADO='si', FECHA_INCORPORACION=SYSDATE WHERE ID_LIBROS=?");
									  sentencia_update.setInt(1, id_libros);
										int registro = sentencia_update.executeUpdate();
										conexion.commit();
										System.out.println("************** Libro publicado: id:" + id_libros + " isbn:" + isbn + "************** ");
										log.info("************** Libro publicado: id:" + id_libros + " isbn:" + isbn + "************** ");
										
										cuerpo_mail_isbns += "<br/>" + isbn + ": " + titulo;
										
								}
						}
						if (!"".equals(cuerpo_mail_isbns)) enviar_mail(direccion_mail, cuerpo_mail_isbns);
				}
				catch(SQLException ex) {
						System.out.println("Error: " + ex.getMessage());
						log.info("Error: "+ ex.getMessage());
				}	
				finally {
					if (rs != null) rs.close();
					if (ps != null) ps.close();
					if (sentencia_update != null) sentencia_update.close();
					if (conexion != null) conexion.close();
				}
		}
    
}