package org.ibai.app.webui.prestamo_digital;

import org.dspace.core.ConfigurationManager;
import org.dspace.storage.rdbms.DatabaseManager;

import java.sql.*;
import java.sql.SQLException;
import java.util.ArrayList;

import java.util.Properties;  
import javax.mail.Message;  
import javax.mail.MessagingException;  
import javax.mail.Session;  
import javax.mail.Transport;  
import javax.mail.internet.InternetAddress;  
import javax.mail.internet.MimeMessage;  
import org.apache.log4j.Logger;

public class PDMandarMails{
		/** log4j logger */
		private static Logger log = Logger.getLogger(PDMandarMails.class);
		private static final Properties properties = new Properties();  
      
  
    private static Session session;
    
    private static void mostrar_traza(String mensaje) {
    		System.out.println(mensaje);
        log.info(mensaje);
    }
    
    private static String textoHTML(String cadena) {
    		String result = cadena;
    		if ("".equals(result)) return "";
    		result = result.replace("á", "&aacute;");
    		result = result.replace("é", "&eacute;");
    		result = result.replace("í", "&iacute;");
    		result = result.replace("ó", "&oacute;");
    		result = result.replace("ú", "&uacute;");
    		result = result.replace("ñ", "&ntilde;");
    		result = result.replace("ü", "&uuml;");
    		result = result.replace("¿", "&iquest;");
    		result = result.replace("?", "&#63;");
    		
    		
    		result = result.replace("Á", "&Aacute;");
    		result = result.replace("É", "&Eacute;");
    		result = result.replace("Í", "&Iacute;");
    		result = result.replace("Ó", "&Oacute;");
    		result = result.replace("Ú", "&Uacute;");
    		result = result.replace("Ñ", "&Ntilde;");
    		result = result.replace("Ü", "&Uuml;");
    		return result;
    }
  
    private static void init() {  
        properties.put("mail.smtp.host", ConfigurationManager.getProperty("mail.server"));  
        properties.put("mail.smtp.mail.sender",ConfigurationManager.getProperty("ibai.pd.direccion_mailing"));  
        properties.put("mail.smtp.user", ConfigurationManager.getProperty("mail.server.username"));  
        properties.put("mail.smtp.pass", ConfigurationManager.getProperty("mail.server.password"));  
        session = Session.getDefaultInstance(properties);
    }  
    
		public static void main(String[] argv) throws Exception {
			mostrar_traza("Envio de mail recordatorio");
    	sendEmail();
			mostrar_traza("Fin envio de mail recordatorio");
    }
  
    public static void sendEmail() throws SQLException {
        init();
		    Connection conexion = null;
				PreparedStatement ps = null;
				ResultSet rs = null;
				String consulta = "";
				String titulo = "";
				String email = "";
				String id_email = "";
				int contador = 0;
				ArrayList<String> direcciones_enviados_libro = new ArrayList<String>();
				try {
						conexion = DatabaseManager.getConnection();
						//consulta = "SELECT P.USUARIO,U.EMAIL,ID_LIBROS,TITULO FROM PD_PRESTAMOS P, PD_LIBROS L, PD_USUARIOS_ABSYS U, PD_EDITORIALES E WHERE P.LIBRO=L.ID_LIBROS AND L.EDITORIAL=E.ID_EDITORIALES AND U.USUARIO=P.USUARIO AND TO_DATE(TO_CHAR(FECHA, 'DD/MM/YYYY'))+(DURACION_PRESTAMO-5)=TO_DATE(TO_CHAR(SYSDATE, 'DD/MM/YYYY'))"; 
						
						/* Cambio Azkuna					
						
						consulta  = "SELECT P.USUARIO,U.EMAIL,ID_LIBROS,TITULO FROM PD_PRESTAMOS P, PD_LIBROS L, PD_USUARIOS_ABSYS U, PD_EDITORIALES E ";
						consulta += "WHERE P.LIBRO=L.ID_LIBROS AND L.EDITORIAL=E.ID_EDITORIALES AND U.USUARIO=P.USUARIO ";
						consulta += "AND TO_DATE(TO_CHAR(FECHA, 'DD/MM/YYYY'))+(DURACION_PRESTAMO-5)=TO_DATE(TO_CHAR(SYSDATE, 'DD/MM/YYYY')) ";
						consulta += "UNION ";
						consulta += "SELECT P.USUARIO,U.EMAIL,ID_LIBROS,TITULO FROM PD_PRESTAMOS P, PD_LIBROS L, PD_USUARIOS_AZKUNA U, PD_EDITORIALES E ";
						consulta += "WHERE P.LIBRO=L.ID_LIBROS AND L.EDITORIAL=E.ID_EDITORIALES AND U.USUARIO=P.USUARIO ";
						consulta += "AND TO_DATE(TO_CHAR(FECHA, 'DD/MM/YYYY'))+(DURACION_PRESTAMO-5)=TO_DATE(TO_CHAR(SYSDATE, 'DD/MM/YYYY'))";
						*/
						
						/* Cambio Donosti */					
						
						consulta  = "SELECT P.USUARIO,U.EMAIL,ID_LIBROS,TITULO FROM PD_PRESTAMOS P, PD_LIBROS L, PD_USUARIOS_ABSYS U, PD_EDITORIALES E ";
						consulta += "WHERE P.LIBRO=L.ID_LIBROS AND L.EDITORIAL=E.ID_EDITORIALES AND U.USUARIO=P.USUARIO ";
						consulta += "AND TO_DATE(TO_CHAR(FECHA, 'DD/MM/YYYY'))+(DURACION_PRESTAMO-5)=TO_DATE(TO_CHAR(SYSDATE, 'DD/MM/YYYY')) ";
						consulta += "UNION ";
						consulta += "SELECT P.USUARIO,U.EMAIL,ID_LIBROS,TITULO FROM PD_PRESTAMOS P, PD_LIBROS L, PD_USUARIOS_AZKUNA U, PD_EDITORIALES E ";
						consulta += "WHERE P.LIBRO=L.ID_LIBROS AND L.EDITORIAL=E.ID_EDITORIALES AND U.USUARIO=P.USUARIO ";
						consulta += "AND TO_DATE(TO_CHAR(FECHA, 'DD/MM/YYYY'))+(DURACION_PRESTAMO-5)=TO_DATE(TO_CHAR(SYSDATE, 'DD/MM/YYYY'))";
						consulta += "UNION ";
						consulta += "SELECT P.USUARIO,U.EMAIL,ID_LIBROS,TITULO FROM PD_PRESTAMOS P, PD_LIBROS L, PD_USUARIOS_DK U, PD_EDITORIALES E ";
						consulta += "WHERE P.LIBRO=L.ID_LIBROS AND L.EDITORIAL=E.ID_EDITORIALES AND U.USUARIO=P.USUARIO ";
						consulta += "AND TO_DATE(TO_CHAR(FECHA, 'DD/MM/YYYY'))+(DURACION_PRESTAMO-5)=TO_DATE(TO_CHAR(SYSDATE, 'DD/MM/YYYY'))";
						
						ps = conexion.prepareStatement(consulta);
						rs = ps.executeQuery();
						while (rs.next())  {
								email = rs.getString("EMAIL");
								if ((email != null) && (email != "")  && (!email.equals(""))) {
										id_email = rs.getInt("ID_LIBROS") + "_" + email;
									  if (!direcciones_enviados_libro.contains(id_email)) {
									  		titulo = rs.getString("TITULO");
									  		String texto = "Le recordamos que faltan 5 días para que caduque su préstamo del libro: " + titulo;
									  		texto += "<br/><br/>Gogorarazten dizugu 5 egun falta direla liburuaren mailegua bukatzeko: " + titulo;
									  		texto += "<br/><br/>We remind you that your book loan expires in five days: " + titulo;

									  		direcciones_enviados_libro.add(id_email);
						            MimeMessage message = new MimeMessage(session);
						            message.setFrom(new InternetAddress((String)properties.get("mail.smtp.mail.sender")));
						            message.addRecipient(Message.RecipientType.TO, new InternetAddress(email));  
						            message.setSubject("eLiburutegia: Recordatorio préstamo digital");
						            message.setHeader("Content-Type", "text/html");
						            message.setContent(textoHTML(texto), "text/html");
						            Transport t = session.getTransport("smtp");  
						            t.connect((String)properties.get("mail.smtp.user"), (String)properties.get("mail.smtp.pass"));  
						            t.sendMessage(message, message.getAllRecipients());
						            t.close();
						            log.info("Email enviado a: "+ email);
						            contador++;
						         }
			          }
					  }
					  if (contador == 0) {
					  		mostrar_traza("No hay préstamos que caduquen en 5 días.");
					  }
				}
				catch(Exception ex) {
					if (ex instanceof SQLException || ex instanceof MessagingException) {
						mostrar_traza("Error: " + ex.getMessage());
					}
				}
				
				finally {
					if (rs != null) rs.close();
					if (ps != null) ps.close();
					if (conexion != null) conexion.close();
				}
          
    }
	}