package org.ibai.app.webui.prestamo_digital;

import org.dspace.core.ConfigurationManager;
import org.dspace.storage.rdbms.DatabaseManager;

import java.io.File;
import java.sql.*;
import java.sql.SQLException;

import org.apache.log4j.Logger;

public class PDEliminarEpub{
		/** log4j logger */
		private static Logger log = Logger.getLogger(PDEliminarEpub.class);
		
		private static void borrar_fichero(String ruta_fichero) {
				try {
	        File fileTemp = new File(ruta_fichero);
          if (fileTemp.exists()) fileTemp.delete();
	      }
	      catch(Exception e) {
	      	System.out.println(e.getMessage());
	      	log.info("Error: "+ e.getMessage());
	      }
		}
		
		private static boolean borrar_directorio(File path) {
			if( path.exists() ) {
				File[] files = path.listFiles();
				for(int i=0; i<files.length; i++) {
 				if(files[i].isDirectory()) borrar_directorio(files[i]);
   				else                     files[i].delete();
				}
			}
			return( path.delete() );
		}
  
		public static void main(String[] argv) throws Exception {
			  System.out.println("Proceso eliminar epub");
				log.info("Proceso eliminar epub");
    		Connection conexion = null;
				PreparedStatement ps = null;
				ResultSet rs = null;
				PreparedStatement ps_prestamos = null;
				PreparedStatement st_delete_prestamos = null;
				PreparedStatement st_delete_libro     = null;
				ResultSet rs_prestamos = null;
				try {
						conexion = DatabaseManager.getConnection();
						String consulta = "SELECT ID_LIBROS,TITULO,FICHERO,LIBRE_ACCESO,TO_CHAR(FECHA_RENOVACION, 'DD/MM/YYYY') FECHA_RENOVACION FROM PD_LIBROS WHERE FECHA_RENOVACION IS NOT NULL AND TO_DATE(TO_CHAR(FECHA_RENOVACION, 'DD/MM/YYYY'))<=SYSDATE AND PRESTAMOS_RESTANTES=0"; 
						ps = conexion.prepareStatement(consulta);
						rs = ps.executeQuery();
						while (rs.next())  {
							int identificador_libro = rs.getInt("ID_LIBROS");
							String titulo_libro     = rs.getString("TITULO");
							String consulta_prestamos = "SELECT COUNT(*) TOTAL FROM PD_PRESTAMOS WHERE LIBRO=? AND ESTADO='activo'"; 
							ps_prestamos = conexion.prepareStatement(consulta_prestamos);
							ps_prestamos.setInt(1, identificador_libro);
							rs_prestamos = ps_prestamos.executeQuery();
							if (rs_prestamos.next())  {
									int prestamos_activos = rs_prestamos.getInt("TOTAL");
									if (prestamos_activos == 0) {
										  //Borrar fichero epub
											String ruta_fichero = "";
											if ("si".equals(rs.getString("LIBRE_ACCESO"))) ruta_fichero = "/aplic/x20/dspace/webapps/jspui/prestamo-digital/libros/assetstore" + "/" + rs.getString("FICHERO");
											else                                           ruta_fichero = "/datos/x20/dspace/assetstore/libros" + "/" + rs.getString("FICHERO");
											borrar_fichero(ruta_fichero);
											
											//Borrar ficheros streaming
											String ruta_directorio = "/aplic/x20/dspace/webapps/jspui/prestamo-digital/libros/streaming/" + rs.getString("FICHERO").replace(".epub", "");
											borrar_directorio(new File(ruta_directorio));
											
											//Borrar prestamos de pd_prestamos
											st_delete_prestamos = conexion.prepareStatement("DELETE FROM PD_PRESTAMOS WHERE LIBRO=?");
											st_delete_prestamos.setInt(1, identificador_libro);
										 	int delete_prestamos = st_delete_prestamos.executeUpdate();
											
											//Borrar libro de pd_libros
											st_delete_libro = conexion.prepareStatement("DELETE FROM PD_LIBROS WHERE ID_LIBROS=?");
											st_delete_libro.setInt(1, identificador_libro);
										 	int delete_libro = st_delete_libro.executeUpdate();
										 	System.out.println("Libro eliminado: " + titulo_libro);
										 	log.info("Libro eliminado: " + titulo_libro);
											
										 	conexion.commit();
											//TODO Estadisticas??
									}
							}
					
						}
					 	conexion.commit();
				}
				catch(SQLException ex) {
						System.out.println("Error: " + ex.getMessage());
						log.info("Error: "+ ex.getMessage());
				}	
				finally {
					if (rs != null) rs.close();
					if (ps != null) ps.close();
					if (conexion != null) conexion.close();
				}
    }
}