package org.ibai.app.webui.prestamo_digital;

import org.dspace.core.ConfigurationManager;
import org.dspace.storage.rdbms.DatabaseManager;

import java.io.File;
import java.sql.*;
import java.sql.SQLException;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;

import java.util.Date;
import java.text.DateFormat;
import java.text.SimpleDateFormat;

import org.apache.log4j.Logger;

public class PDActualizarUsuarios {
	
		private static Connection conecta() { 
				try {
					Class.forName("oracle.jdbc.OracleDriver");
					String bd      = ConfigurationManager.getProperty("db.url");
					String usuario = ConfigurationManager.getProperty("db.username");
					String pass    = ConfigurationManager.getProperty("db.password");
					return DriverManager.getConnection(bd, usuario, pass);
				}
				catch (Exception er) {
					System.out.println("Error conecta: " + er.getMessage());
					return null;
				} 
		}
	
		private static String corregirLineaFichero(String cadena) {
				String result = cadena;
				result = result.replace("\\|@", "@");
				result = result.replace("\\|", "@");
				result = result.replace("&euskalnet","@euskalnet");
				result = result.replace("jorge&mda","jorge_mda");
				result = result.replace("&","");
				result = result.replace("mada34@|hotmail.es","mada34@hotmail.es");
				result = result.replace("i.eizagirre|@terra.es","i.eizagirre@terra.es");
				result = result.replace("balenkalekua|@euskalnet.net","balenkalekua@euskalnet.net");
				result = result.replace("OTXOA1966|@HOTMAIL.COM","OTXOA1966@HOTMAIL.COM");
				result = result.replace("aaron-4_pasai|@hotmail.com","aaron-4_pasai@hotmail.com");
				result = result.replace("churru00|hotmail.com", "churru00@hotmail.com");
				result = result.replace("ingoikoetxea@|guggenheim-bilbao.es", "ingoikoetxea@guggenheim-bilbao.es");
				result = result.replace("jc.juanocelis@|gmail.com", "jc.juanocelis@gmail.com");
				result = result.replace("zancarron33@|hotmail.com", "zancarron33@hotmail.com");
				result = result.replace("TUAMI60X02@|HOTMAIL.COM", "TUAMI60X02@HOTMAIL.COM");
				result = result.replace("wjmoraa|euskalnet.net", "wjmoraa@euskalnet.net");
				result = result.replace("blancamm|ono.com", "blancamm@ono.com");
				result = result.replace("koldo9431|gmail.com", "koldo9431@gmail.com");
				
				/*atodamarcha_fiesta@hotmail.com//wendylopez_funez@*/
				/* saifeddin ouafi elouafi2000@ */
				
				return result;
		}
	
		private static String corregirCaracteres(String cadena) {
				String result = cadena;
				result = result.replace("'", "");
				return result;
		}
	
		/** log4j logger */
		private static Logger log = Logger.getLogger(PDActualizarUsuarios.class);
		
		public static void main(String[] argv) throws Exception {
    		Connection conexion = null;
				PreparedStatement st_update_usuario = null;
				PreparedStatement st_insert_usuario = null;
				PreparedStatement ps = null;
				ResultSet rs = null;
				int total_modificados = 0;
				int registros_modificados = 0;
				int registros_insertados  = 0;
				String insert_sql = "";
				String update_sql = "";
				DateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
				try {
						String fichero_usuarios = ConfigurationManager.getProperty("ibai.pd.fichero_usuarios_absysnet");
						boolean existe = (new File(fichero_usuarios)).exists();
						if (existe) {
								System.out.println("");
								System.out.println("Inicio: " + dateFormat.format(new Date()));
								log.info("Inicio actualizar usuarios: " + dateFormat.format(new Date()));
								System.out.println("");
							  System.out.println("Actualizando usuarios...");
							  log.info("Actualizando usuarios...");
								String[] campos = null;
								String identificador     = "";
								String codigo_biblioteca = "";
								String codigo_sucursal   = "";
								String nombre            = "";
								String apellidos         = "";
								String direccion         = "";
								String ciudad            = "";
								String telefono          = "";
								String movil             = "";
								String email             = "";
								String fecha_nacimiento  = "";
								String es_adulto         = "";
								
								BufferedReader br = new BufferedReader(new FileReader(fichero_usuarios));
								try {
						        
						        conexion = conecta();
						        
						        st_insert_usuario = conexion.prepareStatement("DROP TABLE PD_USUARIOS_ABSYS CASCADE CONSTRAINTS");
									 	total_modificados = st_insert_usuario.executeUpdate();
									 	conexion.commit();
									 	
									 	st_insert_usuario = conexion.prepareStatement("DROP SEQUENCE PD_USUARIOS_ABSYS_SEQ");
									 	total_modificados = st_insert_usuario.executeUpdate();
									 	conexion.commit();
									 	System.out.println("Tabla eliminada.");
									 	
									 	String create_table = "";
									 	create_table += "CREATE TABLE PD_USUARIOS_ABSYS (";
										create_table += " ID_USUARIOS_ABSYS INTEGER NOT NULL,";
										create_table += " USUARIO           VARCHAR2(512 BYTE) NOT NULL,";
										create_table += " NOMBRE            VARCHAR2(512 BYTE),";
										create_table += " APELLIDOS         VARCHAR2(512 BYTE),";
										create_table += " DIRECCION         VARCHAR2(512 BYTE),";
										create_table += " CIUDAD            VARCHAR2(512 BYTE),";
										create_table += " TELEFONO          VARCHAR2(512 BYTE),";
										create_table += " MOVIL             VARCHAR2(512 BYTE),";
										create_table += " EMAIL             VARCHAR2(512 BYTE),";
										create_table += " FECHA_NACIMIENTO  TIMESTAMP(6),";
										create_table += " ES_ADULTO         INTEGER,";
										create_table += " CODIGO_BIBLIOTECA VARCHAR2(64 BYTE),";
										create_table += " CODIGO_SUCURSAL   VARCHAR2(64 BYTE),";
										create_table += " FECHA_ACTUALIZACION TIMESTAMP(6),";
										create_table += " CONSTRAINT PD_USUARIOS_ABSYS_PKEY PRIMARY KEY (ID_USUARIOS_ABSYS)";
										create_table += ")";
										
										st_insert_usuario = conexion.prepareStatement(create_table);
									 	total_modificados = st_insert_usuario.executeUpdate();
									 	conexion.commit();
									 	
									 	String create_sequence = "";
									 	create_sequence += "CREATE SEQUENCE PD_USUARIOS_ABSYS_SEQ";
										create_sequence += " START WITH 1";
										create_sequence += " MAXVALUE 999999999999999999999999999";
										create_sequence += " MINVALUE 1";
										create_sequence += " NOCYCLE";
										create_sequence += " CACHE 20";
										create_sequence += " NOORDER";
										
										st_insert_usuario = conexion.prepareStatement(create_sequence);
									 	total_modificados = st_insert_usuario.executeUpdate();
									 	conexion.commit();
									 	System.out.println("Tabla creada.");
									 	
									 	String linea = br.readLine();
									 	//System.out.println(linea);
									 	
						        while (linea != null) {
						        		linea = corregirLineaFichero(linea);
						        		campos = linea.split("\\|");
						        		identificador     = campos[0];
						        		codigo_biblioteca = campos[5];
						        		codigo_sucursal   = campos[6];
						        		nombre            = corregirCaracteres(campos[11]);
												apellidos         = corregirCaracteres(campos[8]);
												direccion         = corregirCaracteres(campos[12]);
												ciudad            = corregirCaracteres(campos[13]);
												telefono          = corregirCaracteres(campos[18]);
												movil             = corregirCaracteres(campos[20]);
												email             = corregirCaracteres(campos[21]);
												fecha_nacimiento  = corregirCaracteres(campos[34]);
												es_adulto         = corregirCaracteres(campos[24]);
												if (es_adulto.equals("")) es_adulto = "0";
												
												
												/*
												System.out.println("identificador: " + identificador);
												System.out.println("codigo_biblioteca: " + codigo_biblioteca);
												System.out.println("codigo_sucursal: " + codigo_sucursal);
												System.out.println("nombre: " + nombre);
												System.out.println("apellidos: " + apellidos);
												System.out.println("direccion: " + direccion);
												System.out.println("ciudad: " + ciudad);
												System.out.println("telefono: " + telefono);
												System.out.println("movil: " + movil);
												System.out.println("email: " + email);
												System.out.println("fecha_nacimiento: " + fecha_nacimiento);
												System.out.println("es_adulto: " + es_adulto);
												
												*/
												
												insert_sql = "INSERT INTO PD_USUARIOS_ABSYS (ID_USUARIOS_ABSYS, USUARIO, CODIGO_BIBLIOTECA," +
																					"CODIGO_SUCURSAL, NOMBRE, APELLIDOS, DIRECCION, CIUDAD, TELEFONO, MOVIL, EMAIL, FECHA_NACIMIENTO, ES_ADULTO, FECHA_ACTUALIZACION) VALUES (" +
																					"PD_USUARIOS_ABSYS_SEQ.nextval, '" + identificador + "', '" + codigo_biblioteca + "', '" + codigo_sucursal + "', '" + nombre + "', " +
																					"'" + apellidos + "', '" + direccion + "', '" + ciudad + "', '" + telefono + "', " +
																					"'" + movil + "', '" + email + "', TO_DATE('" + fecha_nacimiento + "', 'YYYY-MM-DD HH24:MI:SS'), " + es_adulto + ",TO_CHAR(SYSDATE, 'DD/MM/YYYY HH24:MI:SS'))";
																					
																					
												/*System.out.println(insert_sql);*/
																					
												st_insert_usuario = conexion.prepareStatement(insert_sql);
											 	total_modificados = st_insert_usuario.executeUpdate();
											 	conexion.commit();
											 	registros_insertados++;
											 	
											 	
												
												
												if (rs != null) rs.close();
												if (ps != null) ps.close();
												if (st_update_usuario != null) st_update_usuario.close();
												if (st_insert_usuario != null) st_insert_usuario.close();
												
												
												/*
												
												ALTER TABLE PD_USUARIOS_ABSYS ADD FECHA_ACTUALIZACION TIMESTAMP(6);
												
												*/
												System.out.println("identificador ok: " + identificador);
												
												
												
												

						        		linea = br.readLine();
						        }
						        if (conexion != null) conexion.close();
						    }
						    finally {  br.close(); }
						}
						else {
								System.out.println("No existe el fichero de usuarios: " + fichero_usuarios);
								log.info("No existe el fichero de usuarios: " + fichero_usuarios);
						}
						System.out.println("Registros insertados: "+ registros_insertados);
						System.out.println("Registros actualizados: "+ registros_modificados);
						System.out.println("");
						System.out.println("Fin: " + dateFormat.format(new Date()));
						System.out.println("");
						
				    log.info("Registros insertados: "   + registros_insertados);
				    log.info("Registros actualizados: " + registros_modificados);
				    log.info("Fin: "                    + dateFormat.format(new Date()));
				    
				}
				catch(SQLException ex) {
						System.out.println("Error: " + ex.getMessage());
						log.info("Error: "+ ex.getMessage());
				}	
				finally {
					if (rs != null) rs.close();
					if (ps != null) ps.close();
					if (st_update_usuario != null) st_update_usuario.close();
					if (st_insert_usuario != null) st_insert_usuario.close();
					if (conexion != null) conexion.close();
				}
    }
}