package org.ibai.app.webui.prestamo_digital;

import org.dspace.core.ConfigurationManager;
import org.dspace.storage.rdbms.DatabaseManager;

import java.io.File;
import java.sql.*;
import java.sql.SQLException;

import org.apache.log4j.Logger;

public class PDActualizarEstadoPrestamos{
		/** log4j logger */
		private static Logger log = Logger.getLogger(PDActualizarEstadoPrestamos.class);
		
		private static void borrar_fichero(String ruta_fichero) {
				try {
	        File fileTemp = new File(ruta_fichero);
          if (fileTemp.exists()) fileTemp.delete();
	      }
	      catch(Exception e) {
	      	System.out.println(e.getMessage());
	      	log.info("Error borrando directorio: " + ruta_fichero + " " + e.getMessage());
	      }
		}   
  
		public static void main(String[] argv) throws Exception {
    		Connection conexion = null;
				PreparedStatement st_update_estado = null;
				PreparedStatement ps = null;
				ResultSet rs = null;
				int total_modificados = 0;
				try {
						conexion = DatabaseManager.getConnection();
						//String consulta = "SELECT NOMBRE_DESCARGA FROM PD_PRESTAMOS WHERE ESTADO='activo' AND TO_DATE(TO_CHAR(FECHA, 'DD/MM/YYYY'))+21<=SYSDATE"; 
						String consulta = "SELECT NOMBRE_DESCARGA FROM PD_PRESTAMOS PRESTAMOS, PD_LIBROS LIBROS, PD_EDITORIALES EDITORIALES WHERE PRESTAMOS.LIBRO=LIBROS.ID_LIBROS AND LIBROS.EDITORIAL=EDITORIALES.ID_EDITORIALES AND ESTADO='activo' AND TO_DATE(TO_CHAR(FECHA, 'DD/MM/YYYY'))+DURACION_PRESTAMO<=SYSDATE"; 
						ps = conexion.prepareStatement(consulta);
						rs = ps.executeQuery();
						while (rs.next())  {
								String fichero_descarga = rs.getString("NOMBRE_DESCARGA");
								if ((fichero_descarga != null) && (!fichero_descarga.equals(""))) {
									String ruta_fichero = "/aplic/x20/dspace/webapps/jspui/prestamo-digital/descargas/" + fichero_descarga;
									borrar_fichero(ruta_fichero);
								}
						}
						//st_update_estado = conexion.prepareStatement("UPDATE PD_PRESTAMOS SET ESTADO='inactivo',NOMBRE_DESCARGA='' WHERE ESTADO='activo' AND TO_DATE(TO_CHAR(FECHA, 'DD/MM/YYYY'))+21<=SYSDATE");
						st_update_estado = conexion.prepareStatement("UPDATE PD_PRESTAMOS SET ESTADO='inactivo',NOMBRE_DESCARGA='' WHERE ID_PRESTAMOS IN (SELECT ID_PRESTAMOS FROM PD_PRESTAMOS PRESTAMOS, PD_LIBROS LIBROS, PD_EDITORIALES EDITORIALES WHERE PRESTAMOS.LIBRO=LIBROS.ID_LIBROS AND LIBROS.EDITORIAL=EDITORIALES.ID_EDITORIALES AND ESTADO='activo' AND TO_DATE(TO_CHAR(FECHA, 'DD/MM/YYYY'))+DURACION_PRESTAMO<=SYSDATE)");
					 	total_modificados = st_update_estado.executeUpdate();
					 	conexion.commit();
						System.out.println("Registros actualizados: "+ total_modificados);
				    log.info("Registros actualizados: "+ total_modificados);
				}
				catch(SQLException ex) {
						System.out.println("Error: " + ex.getMessage());
						log.info("Error: "+ total_modificados);
				}	
				finally {
					if (rs != null) rs.close();
					if (ps != null) ps.close();
					if (st_update_estado != null) st_update_estado.close();
					if (conexion != null) conexion.close();
				}
    }
}