package org.dspace.newsletter;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;

import java.util.Collections;
import java.util.List;

import org.dspace.core.ConfigurationManager;

import org.apache.log4j.Logger;

import org.ibai.lucene.queryParser.ParseException;

public class Main {

    private static final int DEFAULT_RESULT_SIZE = 100;

    private static final Logger log = Logger.getLogger(Main.class);

    public static void main(String[] args) throws IOException, ParseException {

	if (args != null && args.length > 0) {
	    if (args[0].equals("newsletter-index-init")) {
		NewsletterIndexer indexer = new NewsletterIndexer();
		indexer.indexar();
	    } else if (args[0].equals("newsletter-index-publication") && args[1] != null) {
		NewsletterIndexer indexer = new NewsletterIndexer();
		indexer.indexarPublicacion(args[1]);
	    }
	} else {

	    BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
	    String input;
	    System.out.println("Escribe Q/q para salir.");
	    System.out.println("Escribe 1 para indexar.");
	    System.out.println("Escribe 2 para indexar.");
	    System.out.println("Escribe 3 para buscar por fichero " + DEFAULT_RESULT_SIZE + " resultados.");
    	    System.out.println("Escribe 4 para buscar por contenido " + DEFAULT_RESULT_SIZE + " resultados.");
	    System.out.println("Escribe 5 para buscar por contenido todos los resultados.");
	    do {

		System.out.print("Comando: ");
		input = reader.readLine();
		if (input.equalsIgnoreCase("q")) {
		    break;
		}

		int i = 0;
		int total = 0;
		long start = System.currentTimeMillis();

		if (input.equals("1")) {
		    try {
			NewsletterIndexer indexer = new NewsletterIndexer();
			total = indexer.indexar();
		    } catch (Exception e) {
			log.error(e);
			System.out.println(e.toString());
		    }
		    long end = System.currentTimeMillis();
		    System.out.println(total + " ficheros indexados en " + (end - start) + " milisegundos");

		} else if (input.equals("2")) {

		    try {
			System.out.print("Introduce la publicacion a indexar: ");
			input = reader.readLine();
			NewsletterIndexer indexer = new NewsletterIndexer();
			total = indexer.indexarPublicacion(input.trim());
		    } catch (Exception e) {
			log.error(e);
			System.out.println(e.toString());
		    }
		    long end = System.currentTimeMillis();
    		    System.out.println(total + " ficheros indexados en " + (end - start) + " milisegundos");

		} else if (input.equals("3")) {
		    System.out.print("Introduce publicacion y fichero a buscar: ");
		    input = reader.readLine();
		    Searcher searcher = new Searcher(input);
		    input = reader.readLine();
		    List<IndexItem> result = searcher.searchByFile(input);
		    print(result);

		} else if (input.equals("4")) {
		    System.out.print("Introduce publicacion y contenido a buscar: ");
		    input = reader.readLine();
		    Searcher searcher = new Searcher(input);
		    input = reader.readLine();
		    List<IndexItem> result = searcher.searchByContenido(input);
		    print(result);

		} else if (input.equals("5")) {
		    System.out.print("Introduce publicacion y contenido a buscar: ");
		    input = reader.readLine();
		    Searcher searcher = new Searcher(input);
		    input = reader.readLine();
		    boolean ascendente = true;
		    List<IndexItem> result = searcher.search(input, ascendente);
		    System.out.println("orden ascendente");
		    print(result);

		    IndexItemComparable iic = new IndexItemComparable();
		    iic.orden = 2;
		    Collections.sort(result, iic);
		    System.out.println("orden descendente");
		    print(result);
		}

	    } while (true);
	}
    }

    private static void print(List<IndexItem> result) {
	for (IndexItem item : result) {
	    System.out.println(item);
	}
	System.out.println("Resultados: " + result.size());
    }
}
