package org.dspace.newsletter;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Constructor;

import org.dspace.core.ConfigurationManager;

import org.apache.log4j.Logger;

import org.ibai.lucene.analysis.Analyzer;
import org.ibai.lucene.analysis.standard.StandardAnalyzer;
import org.ibai.lucene.document.Document;  
import org.ibai.lucene.document.Field;
import org.ibai.lucene.index.IndexWriter;
import org.ibai.lucene.index.IndexWriterConfig;  
import org.ibai.lucene.index.Term;
import org.ibai.lucene.store.FSDirectory;
import org.ibai.lucene.store.Directory;
import org.ibai.lucene.util.Version;

import org.apache.commons.io.FileUtils;
import java.nio.charset.Charset;


public class Indexer {
    
      private IndexWriter writer;
      private String fecha;
      private boolean loggingContent = false;
      private static final Logger log = Logger.getLogger(Indexer.class);
      
      
      public Indexer(String indexDir, String analyzerClassName) throws IOException {
          
		  String aux = ConfigurationManager.getProperty("search.extended.encoding.loggingContent");
		  if (aux!= null && aux.equals("true")){
				loggingContent = true;
		  }
		  Directory dir = FSDirectory.open(new File(indexDir));
          
		  
          if(writer == null) {
              try{
                  //Class analyzerClass = Class.forName("org.dspace.search.DSAnalyzer");
        	  		  log.info("Se va a utilizar el analizador: " + analyzerClassName);
                  Class analyzerClass = Class.forName(analyzerClassName);
                  Constructor constructor = analyzerClass.getDeclaredConstructor(Version.class);
                  constructor.setAccessible(true);
                  
                  Analyzer analyzer = (Analyzer) constructor.newInstance(Version.LUCENE_36);
                  writer = new IndexWriter(dir, new IndexWriterConfig(Version.LUCENE_36, analyzer));
				//writer = new IndexWriter(dir, new IndexWriterConfig(Version.LUCENE_36, new StandardAnalyzer(Version.LUCENE_36) ));
              }catch(Exception ex){ 
					  		log.error(ex.getMessage());
		        	  log.error("Se obliga a utilizar el StandardAnalyzer");
		        	  writer = new IndexWriter(dir, new IndexWriterConfig(Version.LUCENE_36, new StandardAnalyzer(Version.LUCENE_36) ));
              }
          }  
      }  
    
      
      public Document getDocument(File f) throws Exception{
          Document doc = new Document();  
          doc.add(new Field(IndexItem.FECHA, 	 fecha		     , Field.Store.YES, Field.Index.NOT_ANALYZED));
          doc.add(new Field(IndexItem.PATH, 	 f.getCanonicalPath(), Field.Store.YES, Field.Index.NOT_ANALYZED));  
          //doc.add(new Field(IndexItem.CONTENIDO, new FileReader(f)));
          String ocr = file2String(f);
				  if (loggingContent){
						log.info("fecha: " + fecha + " -- " + ocr.substring(0, (ocr.length()<100? ocr.length()-1:99) ) );
				  }
          doc.add(new Field(IndexItem.CONTENIDO, ocr                 , Field.Store.NO, Field.Index.ANALYZED));
          return doc;
      }
      
      public static String file2String(File f){
			  String encoding = ConfigurationManager.getProperty("search.extended.encoding");
			  String ocr = "";
			  try{
				  if(encoding!=null && !encoding.equals("")){
						ocr = FileUtils.readFileToString(f, encoding);
				  }else{
						ocr = FileUtils.readFileToString(f);
				  }
			  }
			  catch(Exception ex){
			      log.error(ex.getMessage());
			  }
			  return ocr;	  
      }
      
      
      public void indexFile(File f) throws Exception{
				  fecha = f.getName();
				  fecha = fecha.substring(0, fecha.length()-4);
				  //OBTENER SOLO FECHA
				  if ( (fecha.length() - 10)>0){
				      fecha = fecha.substring(fecha.length() - 10, fecha.length());
				  }
				  if ( (fecha.length() - 8)==0){
				      fecha = fecha.substring(fecha.length() - 8, fecha.length());
				      fecha = fecha.substring(0,4) + "_" + fecha.substring(4,6) + "_" + fecha.substring(6,8);
				  }
        	if (fecha.matches("\\d{4}_\\d{2}_\\d{2}")){          
	          writer.deleteDocuments(new Term(IndexItem.FECHA, fecha));
	          Document doc = getDocument(f);
	          writer.addDocument(doc);
          }
          else{
          		log.error("No se puede indexar el siguiente fichero porque no está nombrado correctamente: " + f.getAbsolutePath() );
          }
      }
    
      
      public void close() throws IOException {  
          writer.close();  
      }
  
}
