package org.dspace.newsletter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import org.dspace.core.ConfigurationManager;

import org.apache.log4j.Logger;

import org.ibai.lucene.index.IndexReader;
import org.ibai.lucene.search.Collector;
import org.ibai.lucene.search.ScoreDoc;
import org.ibai.lucene.search.Scorer;



public class AllDocCollector extends Collector{
    
    List<ScoreDoc> docs = new ArrayList<ScoreDoc>();
    private Scorer scorer;
    private int docBase;
    
    private static final Logger log = Logger.getLogger(AllDocCollector.class);

    
    public boolean acceptsDocsOutOfOrder(){
	return true;
    }

    
    public void setScorer(Scorer scorer) throws IOException {
	this.scorer = scorer;
    }
 
    
    public void setNextReader(IndexReader reader, int docBase) throws IOException{
	this.docBase = docBase;
    }

    
    public void collect(int doc) throws IOException {
	docs.add(new ScoreDoc(doc+docBase,scorer.score()));
	//System.out.println("doc=" + doc + " docBase=" + docBase + " score=" + scorer.score());
	
    }
	
    
    public void reset() {
	docs.clear();
    }

    
    public List<ScoreDoc> getHits() {
	return docs;
    }
	
}