/*
 * Decompiled with CFR 0.152.
 */
package org.ibai.lucene.search;

import java.io.IOException;
import org.ibai.lucene.index.IndexReader;
import org.ibai.lucene.search.DocIdSet;
import org.ibai.lucene.search.FieldCache;
import org.ibai.lucene.search.FieldCacheDocIdSet;
import org.ibai.lucene.search.Filter;
import org.ibai.lucene.util.FixedBitSet;

public class FieldCacheTermsFilter
extends Filter {
    private String field;
    private String[] terms;

    public FieldCacheTermsFilter(String field, String ... terms) {
        this.field = field;
        this.terms = terms;
    }

    public FieldCache getFieldCache() {
        return FieldCache.DEFAULT;
    }

    public DocIdSet getDocIdSet(IndexReader reader) throws IOException {
        final FieldCache.StringIndex fcsi = this.getFieldCache().getStringIndex(reader, this.field);
        final FixedBitSet bits = new FixedBitSet(fcsi.lookup.length);
        for (int i = 0; i < this.terms.length; ++i) {
            int termNumber = fcsi.binarySearchLookup(this.terms[i]);
            if (termNumber <= 0) continue;
            bits.set(termNumber);
        }
        return new FieldCacheDocIdSet(reader){

            protected final boolean matchDoc(int doc) {
                return bits.get(fcsi.order[doc]);
            }
        };
    }
}

