/*
 * Decompiled with CFR 0.152.
 */
package org.ibai.lucene.index;

import java.io.IOException;
import org.ibai.lucene.index.ByteBlockPool;
import org.ibai.lucene.index.CharBlockPool;
import org.ibai.lucene.index.DocInverterPerField;
import org.ibai.lucene.index.DocInverterPerThread;
import org.ibai.lucene.index.DocumentsWriter;
import org.ibai.lucene.index.FieldInfo;
import org.ibai.lucene.index.IntBlockPool;
import org.ibai.lucene.index.InvertedDocConsumerPerField;
import org.ibai.lucene.index.InvertedDocConsumerPerThread;
import org.ibai.lucene.index.TermsHash;
import org.ibai.lucene.index.TermsHashConsumerPerThread;
import org.ibai.lucene.index.TermsHashPerField;

final class TermsHashPerThread
extends InvertedDocConsumerPerThread {
    final TermsHash termsHash;
    final TermsHashConsumerPerThread consumer;
    final TermsHashPerThread nextPerThread;
    final CharBlockPool charPool;
    final IntBlockPool intPool;
    final ByteBlockPool bytePool;
    final boolean primary;
    final DocumentsWriter.DocState docState;

    public TermsHashPerThread(DocInverterPerThread docInverterPerThread, TermsHash termsHash, TermsHash nextTermsHash, TermsHashPerThread primaryPerThread) {
        this.docState = docInverterPerThread.docState;
        this.termsHash = termsHash;
        this.consumer = termsHash.consumer.addThread(this);
        if (nextTermsHash != null) {
            this.charPool = new CharBlockPool(termsHash.docWriter);
            this.primary = true;
        } else {
            this.charPool = primaryPerThread.charPool;
            this.primary = false;
        }
        this.intPool = new IntBlockPool(termsHash.docWriter);
        this.bytePool = new ByteBlockPool(termsHash.docWriter.byteBlockAllocator);
        this.nextPerThread = nextTermsHash != null ? nextTermsHash.addThread(docInverterPerThread, this) : null;
    }

    InvertedDocConsumerPerField addField(DocInverterPerField docInverterPerField, FieldInfo fieldInfo) {
        return new TermsHashPerField(docInverterPerField, this, this.nextPerThread, fieldInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void abort() {
        this.reset(true);
        try {
            this.consumer.abort();
            Object var2_1 = null;
            if (this.nextPerThread != null) {
                this.nextPerThread.abort();
            }
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            if (this.nextPerThread != null) {
                this.nextPerThread.abort();
            }
            throw throwable;
        }
    }

    public void startDocument() throws IOException {
        this.consumer.startDocument();
        if (this.nextPerThread != null) {
            this.nextPerThread.consumer.startDocument();
        }
    }

    public DocumentsWriter.DocWriter finishDocument() throws IOException {
        DocumentsWriter.DocWriter doc = this.consumer.finishDocument();
        DocumentsWriter.DocWriter doc2 = this.nextPerThread != null ? this.nextPerThread.consumer.finishDocument() : null;
        if (doc == null) {
            return doc2;
        }
        doc.setNext(doc2);
        return doc;
    }

    void reset(boolean recyclePostings) {
        this.intPool.reset();
        this.bytePool.reset();
        if (this.primary) {
            this.charPool.reset();
        }
    }
}

