/*
 * Decompiled with CFR 0.152.
 */
package org.ibai.lucene.index;

import java.io.IOException;
import org.ibai.lucene.index.DefaultSkipListWriter;
import org.ibai.lucene.index.FieldInfo;
import org.ibai.lucene.index.FieldInfos;
import org.ibai.lucene.index.FormatPostingsFieldsConsumer;
import org.ibai.lucene.index.FormatPostingsTermsConsumer;
import org.ibai.lucene.index.FormatPostingsTermsWriter;
import org.ibai.lucene.index.SegmentWriteState;
import org.ibai.lucene.index.TermInfosWriter;
import org.ibai.lucene.store.Directory;
import org.ibai.lucene.util.IOUtils;

final class FormatPostingsFieldsWriter
extends FormatPostingsFieldsConsumer {
    final Directory dir;
    final String segment;
    TermInfosWriter termsOut;
    final FieldInfos fieldInfos;
    FormatPostingsTermsWriter termsWriter;
    final DefaultSkipListWriter skipListWriter;
    final int totalNumDocs;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public FormatPostingsFieldsWriter(SegmentWriteState state, FieldInfos fieldInfos) throws IOException {
        this.dir = state.directory;
        this.segment = state.segmentName;
        this.totalNumDocs = state.numDocs;
        this.fieldInfos = fieldInfos;
        boolean success = false;
        try {
            this.termsOut = new TermInfosWriter(this.dir, this.segment, fieldInfos, state.termIndexInterval);
            this.skipListWriter = new DefaultSkipListWriter(this.termsOut.skipInterval, this.termsOut.maxSkipLevels, this.totalNumDocs, null, null);
            this.termsWriter = new FormatPostingsTermsWriter(state, this);
            return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException(this.termsOut, this.termsWriter);
            throw throwable;
        }
    }

    FormatPostingsTermsConsumer addField(FieldInfo field) {
        this.termsWriter.setField(field);
        return this.termsWriter;
    }

    void finish() throws IOException {
        IOUtils.close(this.termsOut, this.termsWriter);
    }
}

