/*
 * Decompiled with CFR 0.152.
 */
package org.ibai.lucene.index;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.ibai.lucene.index.DocFieldConsumer;
import org.ibai.lucene.index.DocFieldConsumerPerField;
import org.ibai.lucene.index.DocFieldConsumerPerThread;
import org.ibai.lucene.index.DocFieldProcessorPerThread;
import org.ibai.lucene.index.DocInverterPerField;
import org.ibai.lucene.index.DocInverterPerThread;
import org.ibai.lucene.index.FieldInfos;
import org.ibai.lucene.index.InvertedDocConsumer;
import org.ibai.lucene.index.InvertedDocConsumerPerField;
import org.ibai.lucene.index.InvertedDocConsumerPerThread;
import org.ibai.lucene.index.InvertedDocEndConsumer;
import org.ibai.lucene.index.InvertedDocEndConsumerPerField;
import org.ibai.lucene.index.InvertedDocEndConsumerPerThread;
import org.ibai.lucene.index.SegmentWriteState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DocInverter
extends DocFieldConsumer {
    final InvertedDocConsumer consumer;
    final InvertedDocEndConsumer endConsumer;

    public DocInverter(InvertedDocConsumer consumer, InvertedDocEndConsumer endConsumer) {
        this.consumer = consumer;
        this.endConsumer = endConsumer;
    }

    @Override
    void setFieldInfos(FieldInfos fieldInfos) {
        super.setFieldInfos(fieldInfos);
        this.consumer.setFieldInfos(fieldInfos);
        this.endConsumer.setFieldInfos(fieldInfos);
    }

    @Override
    void flush(Map<DocFieldConsumerPerThread, Collection<DocFieldConsumerPerField>> threadsAndFields, SegmentWriteState state) throws IOException {
        HashMap<InvertedDocConsumerPerThread, Collection<InvertedDocConsumerPerField>> childThreadsAndFields = new HashMap<InvertedDocConsumerPerThread, Collection<InvertedDocConsumerPerField>>();
        HashMap<InvertedDocEndConsumerPerThread, Collection<InvertedDocEndConsumerPerField>> endChildThreadsAndFields = new HashMap<InvertedDocEndConsumerPerThread, Collection<InvertedDocEndConsumerPerField>>();
        for (Map.Entry<DocFieldConsumerPerThread, Collection<DocFieldConsumerPerField>> entry : threadsAndFields.entrySet()) {
            DocInverterPerThread perThread = (DocInverterPerThread)entry.getKey();
            HashSet<InvertedDocConsumerPerField> childFields = new HashSet<InvertedDocConsumerPerField>();
            HashSet<InvertedDocEndConsumerPerField> endChildFields = new HashSet<InvertedDocEndConsumerPerField>();
            for (DocFieldConsumerPerField field : entry.getValue()) {
                DocInverterPerField perField = (DocInverterPerField)field;
                childFields.add(perField.consumer);
                endChildFields.add(perField.endConsumer);
            }
            childThreadsAndFields.put(perThread.consumer, childFields);
            endChildThreadsAndFields.put(perThread.endConsumer, endChildFields);
        }
        this.consumer.flush(childThreadsAndFields, state);
        this.endConsumer.flush(endChildThreadsAndFields, state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void abort() {
        try {
            this.consumer.abort();
            Object var2_1 = null;
            this.endConsumer.abort();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.endConsumer.abort();
            throw throwable;
        }
    }

    @Override
    public boolean freeRAM() {
        return this.consumer.freeRAM();
    }

    @Override
    public DocFieldConsumerPerThread addThread(DocFieldProcessorPerThread docFieldProcessorPerThread) {
        return new DocInverterPerThread(docFieldProcessorPerThread, this);
    }
}

