/*
 * Decompiled with CFR 0.152.
 */
package org.ibai.lucene.index;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import org.ibai.lucene.index.DocConsumer;
import org.ibai.lucene.index.DocConsumerPerThread;
import org.ibai.lucene.index.DocFieldConsumer;
import org.ibai.lucene.index.DocFieldConsumerPerField;
import org.ibai.lucene.index.DocFieldConsumerPerThread;
import org.ibai.lucene.index.DocFieldProcessorPerThread;
import org.ibai.lucene.index.DocumentsWriter;
import org.ibai.lucene.index.DocumentsWriterThreadState;
import org.ibai.lucene.index.FieldInfos;
import org.ibai.lucene.index.IndexFileNames;
import org.ibai.lucene.index.SegmentWriteState;
import org.ibai.lucene.index.StoredFieldsWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DocFieldProcessor
extends DocConsumer {
    final DocumentsWriter docWriter;
    final FieldInfos fieldInfos;
    final DocFieldConsumer consumer;
    final StoredFieldsWriter fieldsWriter;

    public DocFieldProcessor(DocumentsWriter docWriter, DocFieldConsumer consumer) {
        this.docWriter = docWriter;
        this.consumer = consumer;
        this.fieldInfos = docWriter.getFieldInfos();
        consumer.setFieldInfos(this.fieldInfos);
        this.fieldsWriter = new StoredFieldsWriter(docWriter, this.fieldInfos);
    }

    @Override
    public void flush(Collection<DocConsumerPerThread> threads, SegmentWriteState state) throws IOException {
        HashMap<DocFieldConsumerPerThread, Collection<DocFieldConsumerPerField>> childThreadsAndFields = new HashMap<DocFieldConsumerPerThread, Collection<DocFieldConsumerPerField>>();
        for (DocConsumerPerThread thread : threads) {
            DocFieldProcessorPerThread perThread = (DocFieldProcessorPerThread)thread;
            childThreadsAndFields.put(perThread.consumer, perThread.fields());
            perThread.trimFields(state);
        }
        this.fieldsWriter.flush(state);
        this.consumer.flush(childThreadsAndFields, state);
        String fileName = IndexFileNames.segmentFileName(state.segmentName, "fnm");
        this.fieldInfos.write(state.directory, fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abort() {
        try {
            this.fieldsWriter.abort();
            Object var2_1 = null;
            this.consumer.abort();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.consumer.abort();
            throw throwable;
        }
    }

    @Override
    public boolean freeRAM() {
        return this.consumer.freeRAM();
    }

    @Override
    public DocConsumerPerThread addThread(DocumentsWriterThreadState threadState) throws IOException {
        return new DocFieldProcessorPerThread(threadState, this);
    }
}

