/*
 * Decompiled with CFR 0.152.
 */
package org.ibai.lucene.analysis;

import java.io.IOException;
import org.ibai.lucene.analysis.PorterStemmer;
import org.ibai.lucene.analysis.TokenFilter;
import org.ibai.lucene.analysis.TokenStream;
import org.ibai.lucene.analysis.tokenattributes.CharTermAttribute;
import org.ibai.lucene.analysis.tokenattributes.KeywordAttribute;

public final class PorterStemFilter
extends TokenFilter {
    private final PorterStemmer stemmer = new PorterStemmer();
    private final CharTermAttribute termAtt = this.addAttribute(CharTermAttribute.class);
    private final KeywordAttribute keywordAttr = this.addAttribute(KeywordAttribute.class);

    public PorterStemFilter(TokenStream in) {
        super(in);
    }

    public final boolean incrementToken() throws IOException {
        if (!this.input.incrementToken()) {
            return false;
        }
        if (!this.keywordAttr.isKeyword() && this.stemmer.stem(this.termAtt.buffer(), 0, this.termAtt.length())) {
            this.termAtt.copyBuffer(this.stemmer.getResultBuffer(), 0, this.stemmer.getResultLength());
        }
        return true;
    }
}

