/*
 * Decompiled with CFR 0.152.
 */
package org.ibai.lucene.analysis;

import java.io.IOException;
import org.ibai.lucene.analysis.TokenFilter;
import org.ibai.lucene.analysis.TokenStream;

public final class LimitTokenCountFilter
extends TokenFilter {
    private final int maxTokenCount;
    private int tokenCount = 0;

    public LimitTokenCountFilter(TokenStream in, int maxTokenCount) {
        super(in);
        this.maxTokenCount = maxTokenCount;
    }

    public boolean incrementToken() throws IOException {
        if (this.tokenCount < this.maxTokenCount && this.input.incrementToken()) {
            ++this.tokenCount;
            return true;
        }
        return false;
    }

    public void reset() throws IOException {
        super.reset();
        this.tokenCount = 0;
    }
}

