
/*
 * @package    atto_elhuyartts
 * 
 */

/**
 * @module moodle-atto_elhuyartts-button
 */

/**
 * Atto text editor elhuyar tts plugin.
 *
 * @namespace M.atto_elhuyartts
 * @class button
 * @extends M.editor_atto.EditorPlugin
 */

var COMPONENTNAME = 'atto_elhuyartts',


CSS = {
		TESTUAINPUT: 'atto_elhuyartts_testua_sartu',
		HIZKUNTZAINPUT: 'atto_elhuyartts_hizkuntza_sartu',
		GENEROAINPUT:'atto_elhuyartts_generoa_sartu',
		GENEROAEMAKUMEZKOAINPUT:'atto_elhuyartts_generoa_emakumezkoa_sartu',
		GENEROAGIZONEZKOAINPUT:'atto_elhuyartts_generoa_gizonezkoa_sartu',
		ABIADURAINPUT:'atto_elhuyartts_abiadura_sartu',
		AUDIOFORMATUAINPUT:'atto_elhuyartts_audioformatua_sartu',
		ITXURAINPUT:'atto_elhuyartts_itxura_sartu'
},
SELECTORS = {
		TESTUAINPUT: '.atto_elhuyartts_testua_sartu',
		HIZKUNTZAINPUT: '.atto_elhuyartts_hizkuntza_sartu',
		GENEROAINPUT:'atto_elhuyartts_generoa_sartu',
		GENEROAEMAKUMEZKOAINPUT:'atto_elhuyartts_generoa_emakumezkoa_sartu',
		GENEROAGIZONEZKOAINPUT:'atto_elhuyartts_generoa_gizonezkoa_sartu',
		ABIADURAINPUT:'atto_elhuyartts_abiadura_sartu',
		AUDIOFORMATUAINPUT:'atto_elhuyartts_audioformatua_sartu',
		ITXURAINPUT:'atto_elhuyartts_itxura_sartu'
},

TEMPLATE = '' +
	'<form class="atto_form">' +
		'<label for="{{elementid}}_{{CSS.TESTUAINPUT}}" class="sameline">{{get_string "entertestua" component}}</label>' +
		'<input class="fullwidth testua {{CSS.TESTUAINPUT}} sameline" id="{{elementid}}_{{CSS.TESTUAINPUT}}" size="32" /><br/>' +
		'<label for="{{elementid}}_{{CSS.HIZKUNTZAINPUT}}" class="sameline">{{get_string "enterhizkuntza" component}}</label>' +
		'<select class="{{CSS.HIZKUNTZAINPUT}} hizkuntza" id="{{elementid}}_{{CSS.HIZKUNTZAINPUT}}" >' +
			'<option value="eu" class="hizkuntzaeu">{{get_string "euskara" component}}' + '</option>' +
			'<option value="cat" class="hizkuntzacat">{{get_string "katalana" component}}' + '</option>' +
			'<option value="ga" class="hizkuntzaga">{{get_string "galegoa" component}}' + '</option>' +
			'<option value="es" class="hizkuntzaes">{{get_string "gaztelania" component}}' + '</option>' +
			'<option value="en" class="hizkuntzaen">{{get_string "ingelesa" component}}' + '</option>' +
		'</select>' +
		'<br/>' +
		'<label for="{{elementid}}_{{CSS.GENEROAINPUT}}" class="sameline">{{get_string "entergeneroa" component}}</label>' +
		'<input type="radio" name="{{CSS.GENEROAINPUT}}" class="{{CSS.GENEROAEMAKUMEZKOAINPUT}} generoaE" id="{{elementid}}_{{CSS.GENEROAEMAKUMEZKOAINPUT}}"> {{get_string "emakumezkoa" component}} </input> ' +
		'<input type="radio" name="{{CSS.GENEROAINPUT}}" class="{{CSS.GENEROAGIZONEZKOAINPUT}} generoaG" id="{{elementid}}_{{CSS.GENEROAGIZONEZKOAINPUT}}"> {{get_string "gizonezkoa" component}} </input>' +
		'<br/>' +
		'<label for="{{elementid}}_{{CSS.ABIADURAINPUT}}" class="sameline">{{get_string "enterabiadura" component}}</label>' +
		'<input class="{{CSS.ABIADURAINPUT}} abiadura" type="number" value="93" id="{{elementid}}_{{CSS.ABIADURAINPUT}}" size="8" min="40" max="160" />' +
		'<br/>' +
		'<label for="{{elementid}}_{{CSS.AUDIOFORMATUAINPUT}}" class="sameline">{{get_string "enteraudioformatua" component}}</label>' +
		'<select class="{{CSS.AUDIOFORMATUAINPUT}} audioformatua" id="{{elementid}}_{{AUDIOFORMATUAINPUT}}">' +
			'<option value="mp3" class="mp3">{{get_string "MP3" component}}' + '</option>' +
			'<option value="opus" class="opus">{{get_string "OPUS" component}}' + '</option>' +
			'<option value="ogg" class="ogg">{{get_string "OGG" component}}' + '</option>' +
		'</select>' +
		'<br/>' +
		'<label for="{{elementid}}_{{CSS.ITXURAINPUT}}" class="sameline">{{get_string "enteritxura" component}}</label>' +
		'<select class="{{CSS.ITXURAINPUT}} itxura" id="{{elementid}}_{{CSS.ITXURAINPUT}}" >' +
			'<option value="esteka" class="itxuraesteka">{{get_string "esteka" component}}' + '</option>' +
			'<option value="barra" class="itxurabarra">{{get_string "barra" component}}' + '</option>' +
		'</select>' +
		'<br/>' +
		'<br/>' +
		'<div class="mdl-align">' +
			'<br/>' +
			'<button type="submit" class="submit">{{get_string "txertatu" component}}</button>' +
		'</div>' +
	'</form>';

Y.namespace('M.atto_elhuyartts').Button = Y.Base.create('button', Y.M.editor_atto.EditorPlugin, [], {

   
	_momentukoElementua: null,
	
	_templatekoedukia: null,
	
	_editatzen: false,
	
	_momentukoEsteka:null,
	
	_momentukoUrl:null,
	
	_momentukoElementuMota:null,
	
	
	initializer: function() {
		
		var ikonoak = ['elhuyarico'];
		
		Y.Array.each(ikonoak, function(ikonoa) {
			this.addButton({
				icon: 'ed/' + ikonoa,
				iconComponent: 'atto_elhuyartts',
				buttonName:ikonoa,
				callback: this._displayDialogue,
				tags: 'a',
				tagMatchRequiresAll: false
			});
		}, this);
	},
    
	_displayDialogue: function() {
		var width=800;
		this._momentukoElementua = this.get('host').getSelection();
		
		if (this._momentukoElementua === false) {
			return;
		}
		
		var dialogue = this.getDialogue({
			headerContent: M.util.get_string('dialoguetituloa', COMPONENTNAME),
//			focusAfterHide: true,
			focusOnShowSelector: SELECTORS.TESTUAINPUT
		});
		
		if(dialogue.width !== width + 'px'){
			dialogue.set('width',width+'px');
		}
		
		dialogue.set('bodyContent', this._getDialogueContent());
		
		this._erauziDatuak();
		
		var testuEdukia=this._templatekoedukia.one('.testua').getAttribute('value');
		
		if(testuEdukia===''){
			this._getDefektuzkoParametroezOsatu();
			this._editatzen=false;
		}else{
			this._editatzen=true;
		}
		
		dialogue.show();
	},
   
	_getDefektuzkoParametroezOsatu:function(){
		var hizkuntzaParam = this.get('hizkuntza');
		var generoaParam = this.get('generoa');
		var abiaduraParam=this.get('abiadura');
		var audioformatuaParam=this.get('audioformatua');
		var itxuraParam=this.get('itxura');
		var erabiltzailekodeaParam=this.get('erabiltzailekodea');
		
		// generoa
		if (generoaParam === 'F') {
			this._templatekoedukia.one('.generoaE').setAttribute('checked', 'checked');
		} else {
			this._templatekoedukia.one('.generoaG').setAttribute('checked', 'checked');
		}

		// hizkuntza
		switch (hizkuntzaParam) {
			case 'eu':
				this._templatekoedukia.one('.hizkuntzaeu').setAttribute('selected');
				break;
			case 'es':
				this._templatekoedukia.one('.hizkuntzaes').setAttribute('selected');
				break;
			case 'en':
				this._templatekoedukia.one('.hizkuntzaen').setAttribute('selected');
				break;
			case 'cat':
				this._templatekoedukia.one('.hizkuntzacat').setAttribute('selected');
				break;
			case 'ga':
				this._templatekoedukia.one('.hizkuntzaga').setAttribute('selected');
				break;
			default:
				this._templatekoedukia.one('.hizkuntzaeu').setAttribute('selected');
				break;
		}
	
		//abiadura
		this._templatekoedukia.one('.abiadura').setAttribute('value', abiaduraParam);
		
		//audio formatua
		switch(audioformatuaParam) {
			case 'mp3':
				this._templatekoedukia.one('.mp3').setAttribute('selected');
				break;
			case 'ogg':
				this._templatekoedukia.one('.ogg').setAttribute('selected');
				break;
			case 'opus':
				this._templatekoedukia.one('.opus').setAttribute('selected');
				break;
			default:
				this._templatekoedukia.one('.mp3').setAttribute('selected');
				break;
		}
		
		//itxura
		if(itxuraParam==='barra'){
			this._templatekoedukia.one('.itxurabarra').setAttribute('selected');
		}else{
			this._templatekoedukia.one('.itxuraesteka').setAttribute('selected');
		}
			
	},
    
   
	_getDialogueContent: function() {
		
		var template = Y.Handlebars.compile(TEMPLATE);
		
		this._templatekoedukia = Y.Node.create(template({
			
			elementid: this.get('host').get('elementid'),
			component: COMPONENTNAME,
			CSS: CSS
			}));
		
		this._templatekoedukia.one('.submit').on('click', this._sortuEsteka, this);

		return this._templatekoedukia;
	},

	_sortuEsteka: function(e) {
		
		e.preventDefault();
		
		var estekaobjektua,hautatutakoelementua;
		var testuaInput,testua, testuaNoEncode;
		var hizkuntza, hizkuntzaInput;
		var generoa, generoaInput;
		var abiadura, abiaduraInput;
		var audioformatua, audioformatuaInput;
		var itxura, itxuraInput;
		
		var host = this.get('host');
		
		testuaInput = this._templatekoedukia.one('.testua');
		testua = testuaInput.get('value');
		itxuraInput = this._templatekoedukia.one('.itxura');
		itxura = itxuraInput.get('value');
		
		if (testua !== '') {
			
			var erabiltzailekodeaParam=this.get('erabiltzailekodea');
			
			hizkuntzaInput = this._templatekoedukia.one('.hizkuntza');
			hizkuntza = hizkuntzaInput.get('value');
			
			generoaInput = this._templatekoedukia.one('.generoaE');
			generoa = generoaInput.get('checked');
			
			if(generoa){generoa='F';}else{generoa='M';}
			
			abiaduraInput = this._templatekoedukia.one('.abiadura');
			abiadura = abiaduraInput.get('value');
			
			audioformatuaInput = this._templatekoedukia.one('.audioformatua');
			audioformatua = audioformatuaInput.get('value');
			
			testuaNoEncode=testua;
			testua=encodeURI(testua);
			
			var esteka='ahots_sintesia_moodle/?testua='+testua+
			'&hizkuntza=' + hizkuntza + '&response=' + audioformatua + '&gender='
			+ generoa + "&speed=" + abiadura + "&kodea=" + erabiltzailekodeaParam;
			
			if(this._editatzen){
				
				var nodokotestua = this._momentukoElementua.get('nodeValue');
				
				if(nodokotestua){
					if(nodokotestua.includes("ELHUYARTTS")){
						if(itxura==='barra'){
							this._momentukoElementua.set('nodeValue', '{ELHUYARTTS: source='+esteka+', type=audio}');
							this._momentukoElementuMota='audio'; 
							
						}else{
							
							this._momentukoElementua.set('nodeValue', '{ELHUYARTTS: source='+esteka+', text='+testuaNoEncode+', type=link}');
							this._momentukoElementuMota='link';
						}
					}
				}
				
			}else{ 
			
				if(itxura==='barra'){
					var irteera='<span class="elhuyarttsfilter">{ELHUYARTTS: source='+esteka+', type=audio}</span>';
					
					this.editor.focus();
					this.get('host').insertContentAtFocusPoint(irteera);
					this._momentukoElementuMota='audio'; 
					
				}else{
					var irteera='<span class="elhuyarttsfilter">{ELHUYARTTS: source='+esteka+', text='+testuaNoEncode+', type=link}</span>';
					this.editor.focus();
					this.get('host').insertContentAtFocusPoint(irteera);
					this._momentukoElementuMota='link'; 
				}
				this.markUpdated();
				
			}
	}
	
	
	
//	if (this._momentukoElementua) {
        this.getDialogue({focusAfterHide: this.editor }).hide();
//	}
		
		
	},
	
	
_erauziDatuak: function() {
		
		var hautatutakoelementua = this.get('host').getSelectionParentNode(),url,audioa;
		
		if (!hautatutakoelementua) {
			return;
		}
		
		
		this._momentukoElementua = Y.one(hautatutakoelementua)
		this._bilatuHautatutakoElementua(Y.one(hautatutakoelementua));
		
		if(this._momentukoElementuMota){
			if(this._momentukoElementuMota=='link'){
				
				this._templatekoedukia.one('.itxuraesteka').setAttribute('selected');
			}else{
				this._templatekoedukia.one('.itxurabarra').setAttribute('selected');
			}
		}
		
		if (this._momentukoUrl) {
			var paramTestua = /testua=([^&]+)/.exec(this._momentukoUrl)[1];
			var paramHizkuntza = /hizkuntza=([^&]+)/.exec(this._momentukoUrl)[1];
			var paramAudioa = /response=([^&]+)/.exec(this._momentukoUrl)[1];
			var paramGeneroa = /gender=([^&]+)/.exec(this._momentukoUrl)[1];
			var paramAbiadura = /speed=([^&]+)/.exec(this._momentukoUrl)[1];
			
			var erabiltzailekodeaParam=this.get('erabiltzailekodea');
			paramTestua=decodeURI(paramTestua);
			
			//testua
			this._templatekoedukia.one('.testua').setAttribute('value', paramTestua);
			
			//abiadura
			this._templatekoedukia.one('.abiadura').setAttribute('value', paramAbiadura);
			
			//generoa
			if(paramGeneroa==='F'){
				this._templatekoedukia.one('.generoaE').setAttribute('checked', 'checked');
			}else{
				this._templatekoedukia.one('.generoaG').setAttribute('checked', 'checked');
			}
			
			//hizkuntza
			switch(paramHizkuntza) {
				case 'eu':
					this._templatekoedukia.one('.hizkuntzaeu').setAttribute('selected');
					break;
				case 'es':
					this._templatekoedukia.one('.hizkuntzaes').setAttribute('selected');
					break;
				case 'en':
					this._templatekoedukia.one('.hizkuntzaen').setAttribute('selected');
					break;
				case 'cat':
					this._templatekoedukia.one('.hizkuntzacat').setAttribute('selected');
					break;
				case 'ga':
					this._templatekoedukia.one('.hizkuntzaga').setAttribute('selected');
					break;
				default:
					this._templatekoedukia.one('.hizkuntzaeu').setAttribute('selected');
					break;
			}
			
			//audio formatua
			switch(paramAudioa) {
				case 'mp3':
					this._templatekoedukia.one('.mp3').setAttribute('selected');
					break;
				case 'ogg':
					this._templatekoedukia.one('.ogg').setAttribute('selected');
					break;
				case 'opus':
					this._templatekoedukia.one('.opus').setAttribute('selected');
					break;
				default:
					this._templatekoedukia.one('.mp3').setAttribute('selected');
					break;
			}
		}
	},
	
	_bilatuHautatutakoElementua: function(nodoa) {
		var emaitza;
		
		var nodokotestua = nodoa.get('nodeValue');
		
		if(nodokotestua){
			if(nodokotestua.includes("ELHUYARTTS")){
				
				this._momentukoUrl=nodokotestua.substring(nodokotestua.indexOf("source=")+7,nodokotestua.indexOf("type=")-2);
				
				var momentukoElementua=nodokotestua.substring(nodokotestua.indexOf("type="), nodokotestua.length-1);
				if(momentukoElementua.includes("type=link")){
					this._momentukoElementuMota='link';
				}else{
					this._momentukoElementuMota='audio'; 
				}
				
			}else{
				
				this._momentukoUrl=null;
				this._momentukoElementuMota=null;
			}

		}else{
			this._momentukoUrl=null;
			this._momentukoElementuMota=null;
		}
	}
    
    
}, { 
	ATTRS: {
	
		hizkuntza: {value: 'eu'},
		
		generoa: {value: 'M'},
		
		abiadura: {value: 93},
		
		audioformatua: {value: 'MP3'},
		
		itxura: {value: 'esteka'},
		
		erabiltzailekodea: {value: '1234'}
	}
});
