<?php


/**
 * elhuyartts settings.
 *
 * @package   atto_elhuyartts
 * @copyright COPYRIGHTINFO
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */


defined('MOODLE_INTERNAL') || die();

$ADMIN->add('editoratto', new admin_category('atto_elhuyartts', new lang_string('pluginname', 'atto_elhuyartts')));

$settings = new admin_settingpage('atto_elhuyartts_settings', new lang_string('settings', 'atto_elhuyartts'));


if ($ADMIN->fulltree) {

	
	//hizkuntza
	$options = array(
			'eu' => new lang_string('euskara', 'atto_elhuyartts'),
			'cat' => new lang_string('katalana', 'atto_elhuyartts'),
			'ga' => new lang_string('galegoa', 'atto_elhuyartts'),
			'es' => new lang_string('gaztelania', 'atto_elhuyartts'),
			'en' => new lang_string('ingelesa', 'atto_elhuyartts')
	);
	
	$name = get_string('hizkuntza', 'atto_elhuyartts');
	$desc = get_string('defaulthizkuntza_desk', 'atto_elhuyartts');
	$default = 'eu';
	$setting = new admin_setting_configselect('atto_elhuyartts/hizkuntza', $name, $desc, $default, $options);
	$settings->add($setting);
	
	//generoa
	$options = array(
			'F' => new lang_string('emakumezkoa', 'atto_elhuyartts'),
			'M' => new lang_string('gizonezkoa', 'atto_elhuyartts')
	);
	$name = get_string('generoa', 'atto_elhuyartts');
	$desc = get_string('defaultgeneroa_desk', 'atto_elhuyartts');
	$default = 'F';
	$setting = new admin_setting_configselect('atto_elhuyartts/generoa', $name, $desc, $default, $options);
	$settings->add($setting);
	
	//abiadura
	$name = get_string('abiadura', 'atto_elhuyartts');
	$desc = get_string('defaultabiadura_desk', 'atto_elhuyartts');
	$default = '93';
	$setting = new admin_setting_configtext('atto_elhuyartts/abiadura', $name, $desc, $default, PARAM_INT, 8);
	$settings->add($setting);
	
	//audio formatua
	$options = array(
			'mp3' => new lang_string('MP3', 'atto_elhuyartts'),
			'ogg' => new lang_string('OGG', 'atto_elhuyartts'),
			'opus' => new lang_string('OPUS', 'atto_elhuyartts')
	);
	$name = get_string('audioformatua', 'atto_elhuyartts');
	$desc = get_string('defaultaudioformatua_desk', 'atto_elhuyartts');
	$default = 'MP3';
	$setting = new admin_setting_configselect('atto_elhuyartts/audioformatua', $name, $desc, $default, $options);
	$settings->add($setting);
	
	//itxura
	$options = array(
			'esteka' => new lang_string('esteka', 'atto_elhuyartts'),
			'barra' => new lang_string('barra', 'atto_elhuyartts')
	);
	$name = get_string('itxura', 'atto_elhuyartts');
	$desc = get_string('defaultitxura_desk', 'atto_elhuyartts');
	$default = 'barra';
	$setting = new admin_setting_configselect('atto_elhuyartts/itxura', $name, $desc, $default, $options);
	$settings->add($setting);
	
	//erabiltzaile kodea
	$name = get_string('erabiltzailekodea', 'atto_elhuyartts');
	$desc = get_string('defaulterabiltzailekodea_desk', 'atto_elhuyartts');
	$default = '1234';
	$setting = new admin_setting_configtext('atto_elhuyartts/erabiltzailekodea', $name, $desc, $default, PARAM_TEXT, 30);
	$settings->add($setting);
	
			
}