<?php


/**
 * Atto text editor integration version file.
 *
 * @package    atto_elhuyartts
 */

defined('MOODLE_INTERNAL') || die();


/**
 * Initialise the js strings required for this module.
 * @param string $elementid
 */
function atto_elhuyartts_strings_for_js() {
    global $PAGE;
   
    $PAGE->requires->strings_for_js(array(
    		'dialoguetituloa',
    		'entertestua',
    		'enterhizkuntza',
    		'entergeneroa',
    		'enterabiadura',
    		'enteraudioformatua',
    		'enteritxura',
    		'txertatu',
    		'emakumezkoa',
    		'gizonezkoa',
    		'euskara',
    		'katalana',
    		'galegoa',
    		'gaztelania',
    		'ingelesa',
    		'MP3',
    		'OPUS',
    		'OGG',
    		'esteka',
    		'barra',
    		'entzun',
    		'audioa',
    		'generoa',
    		'defaultgeneroa_desk',
    		'hizkuntza',
    		'defaulthizkuntza_desk',
    		'abiadura',
    		'defaultabiadura_desk',
    		'audioformatua',
    		'defaultaudioformatua_desk',
    		'itxura',
    		'defaultitxura_desk',
    		'erabiltzailekodea',
    		'defaulterabiltzailekodea_desk',
    		'pluginname',
    		'settings',
    		'createttsElhuyar',
    		'browse'
    		
    		),
    		'atto_elhuyartts');
   
}



/**
 * Return the js params required for this module.
 * @return array of additional params to pass to javascript init function for this module.
 */


function atto_elhuyartts_params_for_js($elementid, $options, $fpoptions) {
	global $USER, $COURSE;
	//coursecontext
	$coursecontext=context_course::instance($COURSE->id);	
	
	//usercontextid
	$usercontextid=context_user::instance($USER->id)->id;
	$disabled=false;
	
	//config our array of data
	$params = array();
	$params['usercontextid'] = $usercontextid;
	$params['hizkuntza'] = get_config('atto_elhuyartts','hizkuntza');
	$params['generoa'] = get_config('atto_elhuyartts','generoa');
	$params['abiadura'] = get_config('atto_elhuyartts','abiadura');
	$params['audioformatua'] = get_config('atto_elhuyartts','audioformatua');
	$params['itxura'] = get_config('atto_elhuyartts','itxura');
	$params['erabiltzailekodea'] = get_config('atto_elhuyartts','erabiltzailekodea');
   
    return $params;
}






