//*******************************************************************************
// * Funcin: montarURI(tipo,idFormulario,idTabla)							     			
// * Autor: Jonatan Gonzlez																
// * Objetivo:	Modifica la URI de la tabla para pasar como parametros el tipo de
// *			multiseleccin (ordenar/paginar) y los elementos seleccionados en 
// * 			caso de 'paginar'
// *                                                                            
// * Parmetros: tipo -> distinque el tipo de multiseleccin (ordenar/paginar)
// * 			 idFormulario -> identificativo del formulario
// * 			 idTabla -> identificativo de la tabla que se pagina
//*******************************************************************************
function montarURI(tipo,idFormulario,idVariable,idTabla){

	var formulario = document.getElementById(idFormulario);
	var variable = document.getElementsByName(document.getElementById(idVariable).name);
	
	//Creamos el parametro por defecto para los dos tipos
	var parametro = "?tipoMultiSelec="+tipo+"&";
	
	
	if (tipo=="paginar"){

		//Si paginamos, aadimos los elementos seleccionados separados por "_"
		var elementos = "elementos=";
		for (var i = 0; i <	variable.length; i++){
			if (variable[i].checked)
				elementos = elementos + variable[i].value + "_";
		}
		parametro = parametro + elementos + "&";
		
		//Cambiamos la URI en los enlaces (esta parte es igual que en paginar())
			//Coger padre de los enlaces
			var spans = document.getElementsByTagName("span");
			var enlaces;
			for (var i = 0, j = spans.length;  i<j; i++){
				if(spans[i].className == "pagelinks"){
					enlaces = spans[i];
				}
			}
			//En este punto ya tengo el objeto padre de los enlaces
			if(enlaces!=null){
				//Coger Array de enlaces
				var as = enlaces.getElementsByTagName("a");
				for (var k = 0, j = as.length;  k<j; k++){
					//Separamos por ? y metemos el parametro en medio
					var href = as[k].href;
					var arrayHref = href.split("?");
					href = arrayHref[0] + parametro + arrayHref[1];
					as[k].href = href;
				}
			}
	}
	else{ //tipo=="ordenar"
	
		//Cambiamos la URI en los enlaces (esta parte es igual que en ordenar())
			var tr = document.getElementById(idTabla).childNodes[0].childNodes[0];
			for (var i = 1; i < tr.childNodes.length;  i++){
					//Separamos por ? y metemos el parametro en medio
					var href = tr.childNodes[i].childNodes[0].href;
					var arrayHref = href.split("?");
					href = arrayHref[0] + parametro + arrayHref[1];
					tr.childNodes[i].childNodes[0].href = href;
				
			}
	}
}

//*******************************************************************************
// * Funcin: paginar(idFormulario)									     			
// * Autor: Jonatan Gonzlez																
// * Objetivo:	Aadir en el evento 'onClick' de cada enlace de pginacion. En este
// *			evento se llama a la funcion montarURI, que mete parametros en la URI
// *                                                                            
// * Parmetros: idFormulario -> identificativo del formulario
//*******************************************************************************
function paginar(idFormulario){
	//Coger padre de los enlaces
	var spans = document.getElementsByTagName("span");
	var enlaces;
	for (var i = 0, j = spans.length;  i<j; i++){
		if(spans[i].className == "pagelinks"){
			enlaces = spans[i];
		}
	}
	//En este punto ya tengo el objeto padre de los enlaces
	if(enlaces!=null){
		var formulario = document.getElementById(idFormulario);
		//Coger Array de enlaces
		var as = enlaces.getElementsByTagName("a");
		for (var k = 0, j = as.length;  k<j; k++){
			as[k].onclick = function() { montarURI("paginar",idFormulario,'selec'); } 
		}
	}
}

//*******************************************************************************
// * Funcin: ordenar(idFormulario, idTabla)								     			
// * Autor: Jonatan Gonzlez																
// * Objetivo:	Aadir en el evento 'onClick' de cada enlace de pginacion. En este
// *			evento se llama a la funcion montarURI, que mete parametros en la URI
// *                                                                            
// * Parmetros: idFormulario -> identificativo del formulario
// * 			 idTabla -> identificativo de la tabla que se pagina
//*******************************************************************************
function ordenar(idFormulario, idTabla){
	var formulario = document.getElementById(idFormulario);
	var tr = document.getElementById(idTabla).childNodes[0].childNodes[0];
	for (var i = 1; i < tr.childNodes.length;  i++){
		tr.childNodes[i].childNodes[0].onclick = function() { montarURI("ordenar",idFormulario,'selec',idTabla); } 
	}
}
