//*******************************************************************************
// * Funcion: fncMostrarTamConsulta()  
// * Autor: llaparra
// * Objetivo: Funcin para actualizar el valor mostrado de la lngitud restante de un textarea en onkeydown
//*******************************************************************************
function fncMostrarTamConsulta(tamMax, idDivDisplay, objArea){
	$(idDivDisplay).innerHTML=tamMax-objArea.value.length;
	//objArea.innerHTML=objArea.value.substring(0,tamMax);
	//$(idDivDisplay).className="separarIzq5b floatIzq";
}

//*******************************************************************************
// * Funcion: fncOcultarTamConsulta()  
// * Autor: llaparra
// * Objetivo: Funcin para actualizar el valor mostrado de la lngitud restante de un textarea en onkeyup
//******************************************************************************* 
function fncOcultarTamConsulta(tamMax, idDivDisplay, objArea){
	if(tamMax-objArea.value.length>=0){
		$(idDivDisplay).innerHTML=tamMax-objArea.value.length;
	} else {
		objArea.innerHTML=objArea.value.substring(0,tamMax);
	}
	//$(idDivDisplay).className="oculto";
}
	
//*******************************************************************************
// * Funcion: fncParseaCP()  
// * Autor: Jonatan Gonz?lez
// * Objetivo: Parsea el CP de tal manera que tenga 5 d?gitos
//*******************************************************************************
function fncParseaCP(CP) {
	if (CP.length > 0) {
		var bucle = 5 - CP.length;
		var rdo = "";
		for (var i = 0; i < bucle; i++) {
			rdo = rdo + "0";
		}
		rdo = rdo + CP;
		return rdo;
	} else {
		return "";
	}
}
//*******************************************************************************
// * Funcion: fncReplaceAll()
// * Autor: Irune Prado
// * Objetivo: Realiza un replaceAll de una variable usando el replace de js
//*******************************************************************************
function fncReplaceAll(string, charViejo, charNuevo) {
	temp = "" + string;
	while (temp.indexOf(charViejo) > -1) {
		pos = temp.indexOf(charViejo);
		temp = "" + (temp.substring(0, pos) + charNuevo + temp.substring((pos + charViejo.length), temp.length));
	}
	return temp;
}
//****************************************************
// * Funcion: fncBorrarFormulario()
// * Autor: Jonatan Gonzalez
// * Fecha Creacion:  18/01/2006
// * Objetivo: Borra todos los campos de un formulario
// *
// * Parametros: el objeto document
// *
// * Retorno:
// * NOTA: Los radios deben reseleccionarse.
//*******************************************************************************
//*******************************************************************************
function fncBorrarFormulario(doc) {
	var inputs = doc.getElementsByTagName("input");
	for (var i = 0; i < inputs.length; i++) {
		if (inputs[i].name != "v50bstrTituloKey") {
			inputs[i].value = "";
		}
	}
	var selects = doc.getElementsByTagName("select");
	for (var i = 0; i < selects.length; i++) {
		selects[i].selectedIndex = 0;
	}
}//Fin fncEnableCombos

//*******************************************************************************
// * Funcion: fncBorraBoton(posBoton)
// * Autor: Jonatan Gonzalez
// * Fecha Creacion:  18/01/2006
// * Objetivo: Borra un bot?n de la botonera
// *
// * Parametros: posicion -> posicion que ocupa el boton
//*******************************************************************************
//*******************************************************************************
function fncBorraBoton(posicion) {
	obj = document.getElementById("Herramientas").childNodes[0];
	if (obj != null) {
		obj.removeChild(obj.childNodes[posicion]);
	}
}//Fin fncNuevosCritBusq

//*******************************************************************************
// * Funcion: fncVacia()
// * Fecha Creacion:  18/01/2006
// * Objetivo:No hace nada
//*******************************************************************************
function fncVacia() {
}

//
//*******************************************************************************
// * Funcion: fncBorrarTablaSinPaginacion()
// * Autor: I?aki Cantalapiedra Bernal
// * Fecha Creacion:  17/01/2006
// * Objetivo: Vaciar una tabla Geremua por Javascript dejandola en estado inicial
// * 			de estas tablas.
// *
// * Parametros: idioma: idioma del la aplicacion.
// *
//*******************************************************************************
//*******************************************************************************
function fncBorrarTablaSinPaginacion(idioma, idTabla) {
	var objTable = document.getElementById(idTabla);
	while (objTable.rows.length > 1) {
		objTable.deleteRow(1);
	}
	var objRow = objTable.insertRow();
	var objCell = objRow.insertCell(0);
	numCols = objTable.childNodes[0].childNodes[0].childNodes.length + 1;
	objCell.colSpan = numCols;
	if (idioma != null && idioma == "es") {
		objCell.innerHTML = "No se ha encontrado nada que mostrar";
	} else {
		objCell.innerHTML = "Ez dago ezer erakusteko";
	}
}//fncBorrarTablaSinPaginacion


//*******************************************************************************
// * Funcion: fncNuevosCritBusq()
// * Autor: Jonatan Gonzalez
// * Fecha Creacion:  22/11/2005
// * Objetivo: Oculta boton imprimir si existe, y habilita nueva busqueda
// *
// * Parametros: posicion -> posicion que ocupa el boton imprimir
//*******************************************************************************
//*******************************************************************************
function fncNuevosCritBusq(posicion) {
	
	//Boton 'Imprimir'
	/*obj = document.getElementById("botonImprimir");
	if (obj!=null)
		obj.parentNode.parentNode.removeChild(obj.parentNode.parentNode.childNodes[posicion]);
	*/
	//Nuevos criterios
	nuevosCriterios = true;
}//Fin fncNuevosCritBusq

//*******************************************************************************
// * Funcion: fncGetCambioTabla()
// * Autor: Jonatan Gonzalez
// * Fecha Creacion:  22/11/2005
// * Objetivo: Determina si una tabla ha sido modificada
// *
// * Parametros: posicion -> posicion que ocupa la comlumna dentro de la tabla
// *			 valor -> caracter que ha de compararse en la columna
// * Retorno: true/false que indica si hay modificaciones sobre la tabla
//*******************************************************************************
//*******************************************************************************
function fncGetCambioTabla(posicion, valor) {
	var filas = document.getElementById("idTabla").childNodes[1];

	//Comprobamos que la tabla no este vacia
	if (eval(filas.childNodes[0].childNodes.length) > 1) {
		//Recorremos las filas
		for (i = 0; i < filas.childNodes.length; i++) {
			//Comprobamos que la columna no tiene NULL
			if (filas.childNodes[i].childNodes[posicion].firstChild != null) {
				//Comprobamos que la columna tiene el VALOR esperado
				if (filas.childNodes[i].childNodes[posicion].firstChild.nodeValue == valor) {
				}
				return true;
			}
		}
	}
	return false;
}//Fin fncGetCambioTabla


//*******************************************************************************
// * Funci?n: fncCambiarPestanya()
// * Autor: Susana G?mez
// * Fecha Creaci?n:  04/10/2005
// * Objetivo: muestra ?nicamente la capa a la que hace referencia el objeto pasado
// *
// * Par?metros: objCelda - Objeto al que se le aplica la funcion.
// *
// * Retorno:
//*******************************************************************************
//*******************************************************************************
function fncCambiarPestanya(objCelda) {
	var nombreCapa = objCelda.getAttribute("id");
	var capaVisible = document.getElementById("id" + nombreCapa);
	//cogemos el objeto UL --> la lista que contiene las pesta?as
	var listaPes = document.getElementById("Pestanias_j81");
	for (i = 0; i < listaPes.childNodes.length; i++) {
		nombreCapaCelda = "id" + listaPes.childNodes[i].firstChild.getAttribute("id");
		capaCelda = document.getElementById(nombreCapaCelda);
			//hago invisible la capa seleccionada	
		capaCelda.style.display = "none";	
			//pongo a la pesta?a el estilo correspondiente
		listaPes.childNodes[i].firstChild.className = "aPestanias_j81";
	}//fin for
	//hago visible la capa seleccionada	
	capaVisible.style.display = "block";
	//pongo a la pesta?a el estilo correspondiente
	objCelda.className = "aPestaniasActivas_j81";
}
/**
* Limita el tamanyo maximo de un textarea
* @param objTextArea: TextArea
* @param intTamanyo: Tamanyo maximo
*/
function fncLimitarTextArea(objTextArea, intTamanyo) {
	if (objTextArea.value.length >= intTamanyo) {
		//objTextArea.value = objTextArea.value.substring(0, intTamanyo - 1);
		/*
		Me parece que el -1 sobra ya que substring(start,stop) incluye el caracter en start y excluye
		el caracter en stop.
		*/
		objTextArea.value = objTextArea.value.substring(0, intTamanyo);
	}
}//fin fncLimitarTextArea
/*function fncLimitarTextArea(objTextArea, intTamanyo) {	
	var strTexto=objTextArea.value;
	var arrSaltos=strTexto.split(String.fromCharCode(10));//para contar los saltos de linea	
    	if (objTextArea.value.length + arrSaltos.length-1 >= intTamanyo) {
        	objTextArea.value = objTextArea.value.substring(0, intTamanyo-1-arrSaltos.length+1);        
    	}
    
}*/

//*******************************************************************************
// * Funcion: fncActCombosParaInput()
// * Autor: I?aki Cantalapiedra
// * Fecha Creacion:  19/10/2005
// * Objetivo: Cargar el combo asociado con el valor asignado en el input objInputPadre
// *
// * Parametros:
// *
// * Retorno:
//*******************************************************************************
//*******************************************************************************
function fncActCombosParaInput(objCombo, objInputPadre, objInputHijo) {
	if (objInputPadre.value != "") {
		for (i = 1; i < objCombo.options.length + 1; i++) {
			if (objCombo.options[i] != null) {
				if (objCombo.options[i].value == objInputPadre.value) {
					objCombo.options[i].selected = true;
				}
			}
		}
		if (objCombo.options[objCombo.selectedIndex].value != objInputPadre.value) {
			objCombo.options[0].selected = true;
		}
	} else {
		objCombo.options[0].selected = true;
	}
	if (objInputHijo != null && objInputHijo.value != "") {
		objInputHijo.value = "";
	}
}//Fin fncActCombosParaInput

//*******************************************************************************
// * Funcion: fncActCombosParaCombo()
// * Autor: I?aki Cantalapiedra
// * Fecha Creacion:  19/10/2005
// * Objetivo:
// *
// * Parametros:
// *
// * Retorno:
//*******************************************************************************
//*******************************************************************************
function fncActCombosParaCombo(objCombo, objInputPadre, objInputHijo) {
	objInputPadre.value = objCombo.options[objCombo.selectedIndex].value;
	if (objInputHijo != null && objInputHijo.value != "") {
		objInputHijo.value = "";
	}
}//Fin fncActCombosParaCombo

//*******************************************************************************
// * Funci?n: fncTrimCadena()
// * Autor: Lorea Alonso
// * Fecha Creaci?n:  13/02/2004
// * Objetivo: Elimina los caracteres en blanco que la cadena pasada por parametro
// * tenga por la izquierda y por la derecha.
// * Par?metros:-strPfCadena, cadena.
//*******************************************************************************
function fncTrimCadena(strPfCadena) {
	var strCadenaizq = fncLtrimCadena(strPfCadena);
	var strCadenafinal = strCadenaizq;
	if (strCadenaizq.indexOf(" ") != -1) {
		strCadenafinal = fncRtrimCadena(strCadenaizq);
	}
	return strCadenafinal;
}

//*******************************************************************************
// * Funci?n: fncRtrimCadena()
// * Autor: Lorea Alonso
// * Fecha Creaci?n:  13/02/2004
// * Objetivo: Elimina los caracteres en blanco por la derecha que la cadena pasada por parametro
// * tenga por la izquierda y por la derecha.
// * Par?metros:-strPfCadena, cadena.
//*******************************************************************************
function fncRtrimCadena(VALUE) {
	var w_space = String.fromCharCode(32);
	var v_length = VALUE.length;
	var strTemp = "";
	if (v_length < 0) {
		return "";
	}
	var iTemp = v_length - 1;
	while (iTemp > -1) {
		if (VALUE.charAt(iTemp) == w_space) {
		} else {
			strTemp = VALUE.substring(0, iTemp + 1);
			break;
		}
		iTemp = iTemp - 1;
	} //End While
	return strTemp;
} //End Function


//*******************************************************************************
// * Funci?n: fncLtrimCadena()
// * Autor: Lorea Alonso
// * Fecha Creaci?n:  13/02/2004
// * Objetivo: Elimina los caracteres en blanco por la izquierda que la cadena pasada por parametro
// * tenga por la izquierda y por la derecha.
// * Par?metros:-strPfCadena, cadena.
//*******************************************************************************
function fncLtrimCadena(VALUE) {
	var w_space = String.fromCharCode(32);
	if (v_length < 1) {
		return "";
	}
	var v_length = VALUE.length;
	var strTemp = "";
	var iTemp = 0;
	while (iTemp < v_length) {
		if (VALUE.charAt(iTemp) == w_space) {
		} else {
			strTemp = VALUE.substring(iTemp, v_length);
			break;
		}
		iTemp = iTemp + 1;
	} //End While
	return strTemp;
} //End Function

//*******************************************************************************
// * Funci?n: fncLtrimCadena()
// * Autor: Oscar Martinez
// * Fecha Creaci?n:  27/06/2008
// * Objetivo: Elimina los caracteres en blanco
// * Par?metros:
//*******************************************************************************
function fncTrim(obj){
obj.value=obj.value.replace(/^\s+|\s+$/g,"");
}




//*******************************************************************************
// * Funcion: fncDecimalConPunto()
// * Autor:
// * Fecha Creacion:
// * Objetivo: Convierte un String javascript con comas a uno con puntos.
// *           (XXX,YY --> XXX.YY).
// *
// * Parametros: String a convertir
// *
// * Retorno: String convertido.
//*******************************************************************************
//*******************************************************************************
function fncDecimalConPunto(objPfDecimal) {
	var strPfDecimal = objPfDecimal;
	var strResult = 0;
	if (strPfDecimal.indexOf(",") != -1) {
		strEntera = strPfDecimal.substring(0, strPfDecimal.indexOf(","));
		strDecimal = strPfDecimal.substring((strPfDecimal.indexOf(",") + 1), strPfDecimal.length);
		strResult = strEntera + "." + strDecimal;
	} else {
		strResult = strPfDecimal;
	}
	return strResult;
}//Fin fncDecimalConPunto

//*******************************************************************************
// * Funcion: fncDecimalConComa()
// * Autor:
// * Fecha Creacion:
// * Objetivo: Convierte un String con puntos a uno con comas (XXX.YY --> XXX,YY)
// *
// * Parametros: String a convertir.
// *
// * Retorno: String convertido.
//*******************************************************************************
//*******************************************************************************
function fncDecimalConComa(objPfDecimal) {
	var strPfDecimal = objPfDecimal;
	var strResult = 0;
	if (strPfDecimal.indexOf(".") != -1) {
		strEntera = strPfDecimal.substring(0, strPfDecimal.indexOf("."));
		strDecimal = strPfDecimal.substring((strPfDecimal.indexOf(".") + 1), strPfDecimal.length);
		strResult = strEntera + "," + strDecimal;
	} else {
		strResult = strPfDecimal;
	}
	return strResult;
}//Fin fncDecimalConComa

//*******************************************************************************
// * Funcion: fncEnableCombos()
// * Autor: I?aki Cantalapiedra Bernal
// * Fecha Creacion:
// * Objetivo: Habilita todos los combos del formulario.
// *
// * Parametros: el objeto document
// *
// * Retorno:
//*******************************************************************************
//*******************************************************************************
function fncEnableCombos(doc) {
	var selects = doc.getElementsByTagName("select");
	for (var i = 0; i < selects.length; i++) {
		selects[i].disabled = false;
	}
}//Fin fncEnableCombos


//*******************************************************************************
// * Funcion: fncEnableForm()
// * Autor:
// * Fecha Creacion:
// * Objetivo: Habilita todo el formulario.
// *
// * Parametros: El objeto document
// *
// * Retorno:
//*******************************************************************************
//*******************************************************************************
function fncEnableForm(doc) {
	var selects = doc.getElementsByTagName("select");
	for (var i = 0; i < selects.length; i++) {
		selects[i].disabled = false;
	}
	var text = doc.getElementsByTagName("input");
	for (var j = 0; j < text.length; j++) {
		text[j].disabled = false;
	}
	var textArea = doc.getElementsByTagName("textarea");
	for (var i = 0; i < textArea.length; i++) {
		textArea[i].disabled = false;
	}
}//Fin fncEnbleForm

//*******************************************************************************
// * Funcion: fncDisableForm()
// * Autor:
// * Fecha Creacion:
// * Objetivo: Deshabilita todo el formulario.
// *
// * Parametros: El objeto document
// *
// * Retorno:
//*******************************************************************************
//*******************************************************************************
function fncDisableForm(doc) {
	var selects = doc.getElementsByTagName("select");
	for (var i = 0; i < selects.length; i++) {
		selects[i].disabled = true;
	}
	var text = doc.getElementsByTagName("input");
	for (var j = 0; j < text.length; j++) {
		text[j].disabled = true;
	}
}//Fin fncDisableForm

//*******************************************************************************
// * Funcion: v50bAlert()
// * Autor: I?aki Cantalapiedra Bernal
// * Fecha Creacion:
// * Objetivo: Muestra un ventana modal en pantalla con el mensaje y tipo
// * 	       pasados por parametros.
// * Parametros: elMensaje: mensaje a poner en la ventana.
// *			 tipo: tipo de ventana (info, error).
// *	         webrootv50b: constante a pasar siempre (webrootv50b).
// * Retorno:
//*******************************************************************************
//*******************************************************************************
function v50bAlert(elMensaje, tipo, webrootv50b) {
	var properties = "dialogWidth:300px;dialogHeight:150px;dialogLeft:250px;dialogTop:250px;scroll:no;status:no;";
	window.showModalDialog(webrootv50b + "/comunJSP/v50bfrmalert.jsp?mensaje=" + escape(elMensaje) + "&tipo=" + tipo, "v50bAlert1", properties);
}//Fin v50bAlert

//*******************************************************************************
// * Funcion: v50bConfirm()
// * Autor: I?aki Cantalapiedra Bernal
// * Fecha Creacion:
// * Objetivo: Muestra un ventana modal de confirmacion en pantalla con el mensaje
// * 	        y tipo pasados por parametros.
// *
// * Parametros: elMensaje: mensaje a poner en la ventana.
// *	         webrootv50: constante a pasar siempre (webrootv50b).
// *
// * Retorno:
//*******************************************************************************
//*******************************************************************************
function v50bConfirm(elMensaje, webrootv50b) {
	var properties = "dialogWidth:300px;dialogHeight:150px;dialogLeft:250px;dialogTop:250px;scroll:no;status:no;";
	return window.showModalDialog(webrootv50b + "/comunJSP/v50bfrmconfirm.jsp?mensaje=" + escape(elMensaje), "v50bAlert2", properties);
}//Fin v50bConfirm

//*******************************************************************************
// * Funcion: v50bAlertNoModal()
// * Autor: I?aki Cantalapiedra Bernal
// * Fecha Creacion:
// * Objetivo: Muestra un ventana NO modal en pantalla con el mensaje y tipo
// * 	       pasados por parametros.
// * Parametros: elMensaje: mensaje a poner en la ventana.
// *			 tipo: tipo de ventana (info, error).
// *	         webrootv50: constante a pasar siempre (webrootv50b).
// * Retorno:
//*******************************************************************************
//*******************************************************************************
function v50bAlertNoModal(elMensaje, tipo, webrootv50b) {
	var properties = "width=300,height=100,left=250,top=250,scrollbars=no,statusBar=no";
	window.open(webrootv50b + "/comunJSP/v50bfrmalert.jsp?mensaje=" + escape(elMensaje) + "&tipo=" + tipo, "v50bAlert1", properties);
}//Fin v50bAlertNoModal


//*******************************************************************************
// * Funcion: v50bConfirmNoModal()
// * Autor: I?aki Cantalapiedra Bernal
// * Fecha Creacion:
// * Objetivo: Muestra un ventana NO modal de confirmacion en pantalla con el mensaje
// * 	        y tipo pasados por parametros.
// *
// * Parametros: elMensaje: mensaje a poner en la ventana.
// *	         webrootv50: constante a pasar siempre (webrootv50b).
// *
// * Retorno:
//*******************************************************************************
//*******************************************************************************
function v50bConfirmNoModal(elMensaje, webrootv50b) {
	var properties = "width=300,height=100,left=250,top=250,scrollbars=no,statusBar=no";
	window.open(webrootv50b + "/comunJSP/v50bfrmconfirm.jsp?mensaje=" + escape(elMensaje), "v50bAlert2", properties);
}//Fin v50bConfirmNoModal

//*******************************************************************************
// * Funcion: v50PantallaNoModal()
// * Autor: Jonatan Gonz?lez Castilla
// * Fecha Creacion:  27/01/06
// * Objetivo: Muestra un ventana no modal en pantalla con el mensaje y tipo
// * 	       pasados por parametros.
// * Parametros: elMensaje: mensaje a poner en la ventana.
// *			 tipo: tipo de ventana (info, error).
// *	         webrootv50: constante a pasar siempre (webrootv50).
// * Retorno:
//*******************************************************************************
//*******************************************************************************
function v50PantallaNoModal(elMensaje, tipo, lista, webrootv50) {
	var properties = "width=400,height=200,left=250,top=250,scrollbars=no,statusBar=no";
	window.open(webrootv50 + "/comunJSP/v50frmalertlistado.jsp?mensaje=" + escape(elMensaje) + "&tipo=" + tipo + "&lista=" + escape(lista), "v50Alert1", properties);
}//Fin v50PantallaModal

//*******************************************************************************
// * Funcion: fncFormateaMoneda()
// * Autor: I?aki Cantalapiedra Bernal
// * Fecha Creacion:
// * Objetivo: Formatea un campo a moneda.(X.XXX.XXX,YY)
// *
// * Parametros: num: el String con el valor a formatear, con decimales con '.'
// *
// * Retorno: el String formateado
//*******************************************************************************
//*******************************************************************************
function fncFormateaMoneda(num) {
	num = fncDecimalConPunto(num);
	num = num.toString().replace(/\,/g, "");
	if (isNaN(num)) {
		num = "0";
	}
	sign = (num == (num = Math.abs(num)));
	num = Math.floor(num * 100 + 0.50000000001);
	cents = num % 100;
	num = Math.floor(num / 100).toString();
	if (cents < 10) {
		cents = "0" + cents;
	}
	for (var i = 0; i < Math.floor((num.length - (1 + i)) / 3); i++) {
		num = num.substring(0, num.length - (4 * i + 3)) + "." + num.substring(num.length - (4 * i + 3));
	}
	return (((sign) ? "" : "-") + num + "," + cents);
}//Fin fncFormateaMoneda

//*******************************************************************************
// * Funcion: fncFormateaMonedaObj()
// * Autor: I?aki Cantalapiedra Bernal
// * Fecha Creacion:
// * Objetivo: Formatea un campo a moneda.(X.XXX.XXX,YY)
// *
// * Parametros: num: el String con el valor a formatear, con decimales con '.'
// *
// * Retorno: el String formateado
//*******************************************************************************
//*******************************************************************************
function fncFormateaMonedaObj(objNum) {
	num = fncDecimalConPunto(objNum.value);
	num = num.toString().replace(/\,/g, "");
	sign = (num == (num = Math.abs(num)));
	num = Math.floor(num * 100 + 0.50000000001);
	cents = num % 100;
	num = Math.floor(num / 100).toString();
	if (cents < 10) {
		cents = "0" + cents;
	}
	for (var i = 0; i < Math.floor((num.length - (1 + i)) / 3); i++) {
		num = num.substring(0, num.length - (4 * i + 3)) + "." + num.substring(num.length - (4 * i + 3));
	}
	objNum.value = (((sign) ? "" : "-") + num + "," + cents);
	return true;
}//Fin fncFormateaMoneda

//*******************************************************************************
// * Funcion: fncFormateaImporteObj()
// * Autor: I?aki Cantalapiedra Bernal
// * Fecha Creacion:
// * Objetivo: Formatea un campo a moneda.(X.XXX.XXX,YY)
// *
// * Parametros: num: el String con el valor a formatear, con decimales con '.'
// *
// * Retorno: el String formateado
//*******************************************************************************
//*******************************************************************************
function fncFormateaImporteObjNuevo(objNum) {
	if (objNum.value.indexOf(",") != -1) {
		while (objNum.value.indexOf(".") != -1) {
			objNum.value = objNum.value.replace(".", "");
		}
	}
	num = fncDecimalConPunto(objNum.value);
	num = num.toString().replace(/\,/g, "");
	sign = (num == (num = Math.abs(num)));
	num = Math.floor(num * 100 + 0.50000000001);
	cents = num % 100;
	num = Math.floor(num / 100).toString();
	if (cents < 10) {
		cents = "0" + cents;
	}
	for (var i = 0; i < Math.floor((num.length - (1 + i)) / 3); i++) {
		num = num.substring(0, num.length - (4 * i + 3)) + "." + num.substring(num.length - (4 * i + 3));
	}
	if ((((sign) ? "" : "-") + num + "," + cents) != "-NaN,NaN") {
		objNum.value = (((sign) ? "" : "-") + num + "," + cents);
	}
	return true;
}//Fin fncFormateaMoneda

function fncFormateaImporteObj(objNum) {
	if(objNum.value!=""){
		if(objNum.value.indexOf(",")!=-1)
	{
		while(objNum.value.indexOf(".")!=-1)
			objNum.value=objNum.value.replace(".","");
	}
	num = fncDecimalConPunto(objNum.value);
	num = num.toString().replace(/\,/g,'');
	sign = (num == (num = Math.abs(num)));
	num = Math.floor(num*100+0.50000000001);
	cents = num%100;
	num = Math.floor(num/100).toString();
	if(cents<10) cents = "0" + cents;
	
	for (var i = 0; i < Math.floor((num.length-(1+i))/3); i++) num = num.substring(0,num.length-(4*i+3))+'.'+ num.substring(num.length-(4*i+3));
	
	if((((sign)?'':'-') + num + ',' + cents)!="-NaN,NaN")
		objNum.value=(((sign)?'':'-') + num + ',' + cents);
	}
	
	return true;
}//Fin fncFormateaMoneda

//*******************************************************************************
// * Funcion: fncFormateaFecha()
// * Autor: I?aki Cantalapiedra Bernal
// * Fecha Creacion:
// * Objetivo: Formatea correctamente una hora. P.e: 1800=18:00
// * Parametros: Campo q contiene la hora
// *
// *
//*******************************************************************************
//*******************************************************************************
function fncCompletarHora(ohora){
	if(ohora==null || ohora.value=="")
		ohora.value="";
	else{
		if(ohora.value.length=="1"){
			ohora.value = fncMakeHourFormat("00","0"+ohora.value);
			return;
		}
		else if(ohora.value.length=="2"){
			ohora.value = fncMakeHourFormat("00",ohora.value);
			return;
		}
		for (var i=ohora.value.length;i<4;i++)
			ohora.value="0"+ohora.value;
		if(ohora.value.indexOf(":")==-1){
			var sH = ohora.value.substr(0, 2);
			var sM = ohora.value.substr(2, 4);
			var sHour = fncMakeHourFormat(sM,sH);
			var patron = new RegExp("^[0-2]?[0-9]:[0-5][0-9]$");
			if (sHour.search(patron)==0 && parseFloat(sH)<25)
				ohora.value=sHour;
		}
	}
}

function fncMakeHourFormat(sMin, sHour){
	var sRes;
	sRes =sHour+ ":" + sMin;
	return sRes;
}
//*******************************************************************************
// * Funcion: fncFormateaImporteObj()
// * Autor: Soraya Gonz?lez
// * Fecha Creacion:
// * Objetivo: Formatea un campo a moneda.(X.XXX.XXX,YY)
// *
// * Parametros: num: el String con el valor a formatear, con decimales con '.'
// *
// * Retorno: el String formateado
//*******************************************************************************
function fncFormateaHoraObj(objNum) {
	num = fncFormateaHora(objNum.value);
	objNum.value = num;
}//Fin fncFormateaMoneda

//*******************************************************************************
// * Funcion: fncFormateaImporteObj()
// * Autor: Soraya Gonz?lez
// * Fecha Creacion:
// * Objetivo: Formatea un campo a moneda.(X.XXX.XXX,YY)
// *
// * Parametros: num: el String con el valor a formatear, con decimales con '.'
// *
// * Retorno: el String formateado
//*******************************************************************************
function fncFormateaHora(num) {
	if (num.indexOf(":") != -1) {
		var hora = num.split(":");
		if (parseFloat(hora[1]) == 60 && (!isNaN(parseFloat(hora[1]))) && (!isNaN(parseFloat(hora[0])))) {
			hora[1] = parseFloat(hora[1]) - 60;
			hora[0] = parseFloat(hora[0]) + 1;
		}
		if (!isNaN(parseFloat(hora[1])) && parseFloat(hora[1]) < 60) {
			while (hora[0].toString().length < 2) {
				hora[0] = "0" + hora[0];
			}
			while (hora[1].toString().length < 2) {
				hora[1] = "0" + hora[1];
			}
			num = hora[0] + ":" + hora[1];
		}
	}
	else 
	//Son todo horas
	if (!isNaN(num.toString().replace(",", "."))) {
		num = fncFormatearFloatAHora(num);
	}
	return num;
}//Fin fncFormateaMoneda

//*******************************************************************************
// * Funcion: fncFormatearHoraAFloat()
// * Autor: Soraya Gonz?lez
// * Fecha Creacion:
// * Objetivo: Formatea un campo a moneda.(X.XXX.XXX,YY)
// *
// * Parametros: num: el String con el valor a formatear, con decimales con '.'
// *
// * Retorno: el String formateado
//*******************************************************************************
//*******************************************************************************
function fncFormatearHoraAFloat(num) {
	if (num.indexOf(":") != -1) {
		var hora = num.split(":");
		if (!isNaN(parseFloat(hora[1])) && parseFloat(hora[1]) < 60) {
			return Math.round((parseFloat(hora[0]) + (parseFloat(hora[1]) / 60)) * Math.pow(10, 2)) / Math.pow(10, 2);
		}
	} else {
		return 0;
	}
}//Fin fncFormateaMoneda

//*******************************************************************************
// * Funcion: fncFormatearFloatAHora()
// * Autor: Soraya Gonz?lez
// * Fecha Creacion:
// * Objetivo: Formatea un campo a moneda.(X.XXX.XXX,YY)
// *
// * Parametros: num: el String con el valor a formatear, con decimales con '.'
// *
// * Retorno: el String formateado
//*******************************************************************************
//*******************************************************************************
function fncFormatearFloatAHora(horaFloat) {
	var hF = horaFloat.toString().replace(",", ".") + "";
	if (!isNaN(hF)) {
		var num = "" + hF;
		if (num.indexOf(".") != -1) {
			var hora = num.split(".");
			var decimales = parseFloat("0." + hora[1].toString());
			decimales = Math.round(decimales * 0.6 * Math.pow(10, 2)) / Math.pow(10, 2);
			var dec = decimales.toString().split(".");
			if (dec.length == 2) {
				hora[1] = dec[1];
			} else {
				hora[1] = dec;
			}
			while (hora[1].toString().length < 2) {
				hora[1] = hora[1] + "0";
			}
			if (parseFloat(hora[1]) == 60) {
				hora[1] = parseFloat(hora[1]) - 60;
				hora[0] = parseFloat(hora[0]) + 1;
				while (hora[1].toString().length < 2) {
					hora[1] = hora[1] + "0";
				}
			}
		} else {
			var hora = new Array(num, "00");
		}
		while (hora[0].toString().length < 2) {
			hora[0] = "0" + hora[0];
		}
		return hora[0] + ":" + hora[1];
	}
}//Fin fncFormatearFloatAHora


//*******************************************************************************
// * Funcion: fncCifraDesdeImporte()
// * Autor: I?aki Cantalapiedra Bernal
// * Fecha Creacion:
// * Objetivo: Recupera una cifra valida para operaciones desde un formato moneda (X.XXX.XXX,YY --> XXXXXXX.YY)
// *
// * Parametros: importe: el String con el campo moneda.
// *
// * Retorno: String convertiido.
//*******************************************************************************
//*******************************************************************************
function fncCifraDesdeImporte(num) {
	num = num.toString().replace(/\./g, "");
	num = fncDecimalConPunto(num);
	return num;
}//Fin fncCifraDesdeImporte

//*******************************************************************************
// * Funcion: isUndefined()
// * Autor: I?aki Cantalapiedra Bernal
// * Fecha Creacion:
// * Objetivo: Comprueba si es nulo o no definido
// *
// * Parametros: a: el objeto
// *
// * Retorno: true si lo es, false en c.c.
//*******************************************************************************
//*******************************************************************************
function isUndefined(a) {
	return ((typeof a == "undefined") || (a == null));
}//Fin isUndefined

//*******************************************************************************
// * Funci?n: fncFormatearFechaCampo()
// * Autor: Eneko Rodriguez
// * Fecha Creaci?n:
// * Objetivo: Actualiza el campo pasado con una fecha valida.
// *			P.E: 01012001 = 01/01/2001
// * Par?metros: strPfFecha - valor del objeto fecha.
// *             strIdioma - idioma ('es' Castellano, 'eu' Euskera)
//*******************************************************************************
function fncFormatearFechaCampo(obj, strIdioma) {
	intIdioma = 0;
	if (strIdioma == "es") {
		intIdioma = 1;
	}
	if (strIdioma == "eu") {
		intIdioma = 2;
	}
	fecha = fncFormatearfecha(obj.value, intIdioma);
	obj.value = fecha;
}

//
//*******************************************************************************
// * Funci?n: fncz()
// * Autor: Lorea Alonso
// * Fecha Creaci?n:  13/02/2004
// * Objetivo: Comprueba que el formato de la cadena pasada por parametro
// * corresponda al de una fecha.
// * Par?metros: strPfFecha - valor del objeto fecha.
// *             intPfIdioma - idioma (1 Castellano, 2 Euskera, 3 Ingles)
//*******************************************************************************
function fncFormatearfecha(strPfFecha, intPfIdioma) {

	var strSigno;
	var anomodif;
	var intResul;
	var strCadena = strPfFecha;
	var bolEusk = (intPfIdioma == 3);
	var bolIng = (intPfIdioma == 2);
	if ((strPfFecha.indexOf("/") != -1) || (strPfFecha.indexOf("-") != -1)) { // Tiene signo
		if (strPfFecha.indexOf("/") != -1) {
			strSigno = "/";
		} else {
			if (strPfFecha.indexOf("-") != -1) {
				strSigno = "-";
			}
		}
		if (fncBuscarsigno(strPfFecha, strSigno) == true) {
			if ((strPfFecha.length == 8) || (strPfFecha.length == 10)) {
				if (strPfFecha.length == 8) { // Dos digitos anyo
					if (bolEusk || bolIng) {
						anomodif = strPfFecha.substring(0, 2);
					} else {
						anomodif = strPfFecha.substring(6, 8);
					}
					
					/*var mydate=new Date();
					
					var year=mydate.getYear();
					
					if (year < 100)
					year+=1900;*/
															
					intResul = 2050 - parseInt(anomodif, 10);
					
					strSiglo = 20;
					if (intResul < 2000) {
						strSiglo = 19;
					}
					if (bolEusk || bolIng) {
						strCadena = strSiglo + anomodif + "/" + strPfFecha.substring(3, 5) + "/" + strPfFecha.substring(6, 8);
					} else {
						strCadena = strPfFecha.substring(0, 2) + "/" + strPfFecha.substring(3, 5) + "/" + strSiglo + anomodif;
					}
				} else { // 4 digitos anyo
					if ((strPfFecha.length == 10) && (strPfFecha.indexOf("/") == -1) && (strPfFecha.indexOf("-") != -1)) {
						if (bolEusk || bolIng) {
							strCadena = strPfFecha.substring(0, 4) + "/" + strPfFecha.substring(5, 7) + "/" + strPfFecha.substring(8, 10);
						} else {
							strCadena = strPfFecha.substring(0, 2) + "/" + strPfFecha.substring(3, 5) + "/" + strPfFecha.substring(6, 10);
						}
					}
				}
			} else {
				glbolcadena = false;
			}
		} else {
			glbolcadena = false;
		}
	} else { // No tiene signo
		if ((strPfFecha.length == 6) || (strPfFecha.length == 8)) {
			if (fncValidarNumeros(strPfFecha) == true) {
				if (strPfFecha.length == 6) { // Anyo 2 digitos
					if (bolEusk || bolIng) {
						anomodif = strPfFecha.substring(0, 2);
					} else {
						anomodif = strPfFecha.substring(4, 6);
					}
					
					/*var mydate=new Date();
					
					var year=mydate.getYear();
					
					if (anomodif < 100)
					year+=1900;*/
					
					intResul = 2050 - parseInt(anomodif, 10);
					
					strSiglo = 20;
					if (intResul < 2000) {
						strSiglo = 19;
					}
					
					if (bolEusk || bolIng) {
						strCadena = strSiglo + anomodif + "/" + strPfFecha.substring(2, 4) + "/" + strPfFecha.substring(4, 6);
					} else {
						strCadena = strPfFecha.substring(0, 2) + "/" + strPfFecha.substring(2, 4) + "/" + strSiglo + anomodif;
					}
				} else {
					if (strPfFecha.length == 8) { // Anyo 4 digitos
						if (bolEusk || bolIng) {
							strCadena = strPfFecha.substring(0, 4) + "/" + strPfFecha.substring(4, 6) + "/" + strPfFecha.substring(6, 8);
						} else {
							strCadena = strPfFecha.substring(0, 2) + "/" + strPfFecha.substring(2, 4) + "/" + strPfFecha.substring(4, 8);
						}
					}
				}
			} else {
				glbolcadena = false;
			}
		} else {
			glbolcadena = false;
		}
	}
	return strCadena;
}//Fin fncFormatearfecha

//
//*******************************************************************************
// * Funcion: fncProcesarFecha()
// * Autor: Iker Larburu
// * Fecha Creaci?n:  05/09/2008
// * Objetivo: Devuelve la fecha procesada para cumplir con el formato YYYYMMDD
// * Par?metros: strPfFecha - valor del objeto fecha.
// *             strPfIdioma - idioma (es, eu)
//*******************************************************************************
function fncProcesarFecha(strPfFecha, strPfIdioma) {
	var ano = '';
	var mes = '';
	var dia = ''
	
	// se comprueba que la fecha tiene el tamao adecuado
	if (strPfFecha.length == 10) {
		var split = strPfFecha.split('/');
		// Se trocea segun idioma
		if (strPfIdioma == 'es') {
			ano = split[2];
			mes = split[1];
			dia = split[0];
		} else if (strPfIdioma == 'eu') {
			ano = split[0];
			mes = split[1];
			dia = split[2];
		}
	}
	
	var resultado = ano + mes + dia;
	return resultado;
} // Fin fncProcesarFecha

//*******************************************************************************
// * Funci?n: fncBuscarsigno()
// * Autor: Lorea Alonso
// * Fecha Creaci?n:  13/02/2004
// * Objetivo: Comprueba que la cadena pasada como parametro contenga el signo
// * pasado por parametro.
// * Par?metros: strPfCadena - cadena.
// * strPfSigno - signo.
//*******************************************************************************
function fncBuscarsigno(strPfCadena, strPfSigno) {
	var bolEncontrado = false;
	var intContador = fncContarsigno(strPfCadena, strPfSigno);
  //alert('contador:'+intContador+strPfCadena.charAt(2)+strPfCadena.charAt(5));
	if (intContador == 2) {
		if ((strPfCadena.charAt(2) == strPfSigno) && (strPfCadena.charAt(5) == strPfSigno)) {
			bolEncontrado = true;
		}
	}
	return bolEncontrado;
}//Fin fncBuscarsigno

//*******************************************************************************
// * Funci?n: fncContarsigno()
// * Autor: Lorea Alonso
// * Fecha Creaci?n:  13/02/2004
// * Objetivo: Cuenta el n?mero de beces que aparece el signo en la cadena pasada
// * por parametro.
// * Par?metros: strPfCadena - cadena.
// * strPfSigno - signo.
//*******************************************************************************
function fncContarsigno(strPfCadena, strPfSigno) {
	var intCont = 0;
	if (strPfCadena.indexOf(strPfSigno) != -1) {
		for (var i = 0; i <= (strPfCadena.length - 1); i++) {
			if (strPfCadena.charAt(i) == strPfSigno) {
				intCont = intCont + 1;
			}
		}
	}
	return intCont;
}//Fin fncContarsigno
function fncValidarNumeros(strPfNum) {
	var bolok = true;
	for (var i = 0; i < strPfNum.length; i++) {
		if (strPfNum.charCodeAt(i) < 48 || strPfNum.charCodeAt(i) > 57) {
			bolok = false;
			break;
		}
	}
	return bolok;
}//Fin fncValidarNumeros

// * Funcion: fncPasarMayusculas(obj)
// * Autor: Fernando Rodr?guez San Jos?
// * Fecha Creacion:  9 de enero de 2006
// * Objetivo: Pasar un campo alfanumerico a mayusculas
// *
// * Parametros: obj: el campo a transformar
//
function fncPasarMayusculas(obj) {
	//fncAdaptarCaracteresEspeciales(obj);
	obj.value = fncTrimCadena(obj.value);
	obj.value = obj.value.toUpperCase();
}//Fin fncPasarMayusculas


// * Funcion: fncAdaptarCaracteresEspeciales(obj)
// * Autor: Eneko Rodriguez
// * Fecha Creacion:  16 de enero de 2006
// * Objetivo: Prepara cualquier texto para q pueda ser utilizado en SQL
// *
// * Parametros: obj: el campo a transformar
//
function fncAdaptarCaracteresEspeciales(obj) {
	//Filtramos los caracteres de escape m?s comunes
	//?,",',%
	/*obj.value=obj.value.replace("%","\%");
	obj.value=obj.value.replace("?","?");
	obj.value=obj.value.replace("'","\'");
	obj.value=obj.value.replace(""","\"");*/
	obj.value = fncReplaceAll(obj.value, "'", "");
	obj.value = fncReplaceAll(obj.value, "?", "");
	obj.value = fncReplaceAll(obj.value, "'", "");
	obj.value = fncReplaceAll(obj.value, "\"", "");
	obj.value = fncReplaceAll(obj.value, "%", "");
	obj.value = fncReplaceAll(obj.value, "&", "");
	obj.value = fncReplaceAll(obj.value, "^", "");
	obj.value = fncReplaceAll(obj.value, "<", "");
}//Fin  fncAdaptarCaracteresEspeciales

// * Funcion: fncDesAdaptarCaracteresEspeciales(obj)
// * Autor: Eneko Rodriguez
// * Fecha Creacion:  16 de enero de 2006
// * Objetivo: Cambia caracteres especiales y los representa
//				P.E: Si parece un % lo presenta como %
// *
// * Parametros: obj: el campo a transformar
//
function fncDesAdaptarCaracteresEspeciales(obj) {
	//Filtramos los caracteres de escape m?s comunes
	//?,",',%
	obj.value = obj.value.replace("\\%", "%");
	obj.value = obj.value.replace("?", "");
	obj.value = obj.value.replace("\\'", "'");
	obj.value = obj.value.replace("\\\"", "\"");
}//Fin  fncAdaptarCaracteresEspeciales
function fncDeshabilitarLinks(obj) {
	var links = obj.getElementsByTagName("a");
	for (i = 0; i < links.length; i++) {
		links[i].href = "#";
		links[i].style.color = "#848484";
	}
}
/**
* Deshabilita o habilita texto para 3 campos determinados
* @param id1,id2,id3: Identificador de los campos a hablitar o deshabilitar
*/
function fncHabilitarText(id1, id2, id3) {
	document.getElementById(id1).disabled = false;
	document.getElementById(id2).disabled = true;
	document.getElementById(id3).disabled = true;
	document.getElementById(id2).value = "";
	document.getElementById(id3).value = "";
}

//*******************************************************************************
// * Funcion: fncParseaNumCuenta()
// * Autor: Iigo Rodriguez
// * Objetivo: Parsea el los n de cuenta de 4 digitos, 2 y 10 digitos
//*******************************************************************************
function fncParseaNumCuenta(numCuenta, digito) {
	valorNumCuenta = numCuenta.value;
	if (valorNumCuenta.length > 0) {
		var bucle = digito - valorNumCuenta.length;
		var rdo = "";
		for (var i = 0; i < bucle; i++) {
			rdo = rdo + "0";
		}
		rdo = rdo + valorNumCuenta;
		document.getElementById(numCuenta.name).value = rdo;
	} else {
		document.getElementById(numCuenta.name).value = "";
	}
}
function fncPonerDescCombo(idCombo, idHidden) {
	document.getElementById(idHidden).value = document.getElementById(idCombo).options[document.getElementById(idCombo).selectedIndex].text;
}
function fncArreglaAnchoBotones() {
	var nombres = new Array("boton", "accion", "accionDetalle", "botonDet", "botonNuevo", "botonDetNuevo", "action","boton2","botGuardar","botCancelar","botBorrar","botAtras");

	for(n = 0; n < nombres.length; n++){
		var botones = document.getElementsByName(nombres[n]);
		for (b = 0; b < botones.length; b++) {
			var boton = botones[b];
			var factor = (9 - eval(boton.value.length) / 10) + 0.8;
			boton.style.width = eval(boton.value.length) * eval(factor) + "px";
			boton.style.display = "";
		}
	}
	if($('Herramientas')!=null){
		$('Herramientas').style.display="block";
	}
}
function $() {
	var elements = new Array();
	for (var i = 0; i < arguments.length; i++) {
		var element = arguments[i];
		if (typeof element == "string") {
			element = document.getElementById(element);
		}
		if (arguments.length == 1) {
			return element;
		}
		elements.push(element);
	}
	return elements;
}

function fncObtenerListaMsgError(strPfError){
	var mensaje="";
	var arrFila=strPfError.split(";");
	for(var i=0;i<arrFila.length;i++){
		if(arrFila[i]!=""){
			mensaje=mensaje+"<li>"+arrFila[i]+"</li>"
		}
	}
	return mensaje;
}

 //*******************************************************************************
// * Funcion: fncValidaImporte()
// * Autor: I?aki Cantalapiedra Bernal
// * Fecha Creacion:
// * Objetivo: Valida que un importe sea valido (XXX || XXX,YY || XXX.YY || XXX.Y || XXX,Y)
// *
// * Parametros: importe: el String con el importe
// *
// * Retorno: true si valido, false en c.c.
//*******************************************************************************
//*******************************************************************************
function fncValidaImporte(importe){
OK1 = /^\d+((\.\d\d)|(\.\d))?$/.test(importe);
OK2 = /^\d+((\,\d\d)|(\,\d))?$/.test(importe);
if(OK1 || OK2) return 1;
else{
//v50Alert("comun.importenovalido","error",webrootv50);
return 0;
}
}//Fin fncValidaImporte

function habDesHabRadioTabla(tabla,flag){
//*******************************************************************************
// * Funcin: habDesHabRadioTabla()
// * Autor: Javier Roncal
// * Fecha Creacin:  05/12/2007
// * Objetivo: Funcin que habilita o deshabilita los radios de una tabla q estan 
// * en la celda "0" segn un flag q le pasas por parmetro
// * Variables: tabla -> el id de la tabla del jsp
// * 			flag  -> con una "h" le indicas q quieres habilitar todos los radios
// * 					 con una "d" le indicas q quieres deshabilitarlos
// *
//*******************************************************************************

	var hab;
	
	if (flag=="h"){
		hab=false;
	}else{
		hab=true;
	}

	var radio;

	var table = $(tabla);
	
	if (table.rows(1).cells[0].childNodes[0].type=="radio"){	
		for(var i=1; i<table.rows.length; i++){
			var radio = table.rows(i).cells[0].childNodes[0];
			radio.disabled = hab;
		}
	}

}
function habDesHabRadioTablaUnificadas(tabla,flag){
//*******************************************************************************
// * Funcin: habDesHabRadioTabla()
// * Autor: Oscar Martinez
// * Fecha Creacin:  05/12/2007
// * Objetivo: Funcin que habilita o deshabilita los radios de una tabla q estan 
// * en la celda "0" segn un flag q le pasas por parmetro. Los radios estan a partir 
// * de la segunda fila
// * Variables: tabla -> el id de la tabla del jsp
// * 			flag  -> con una "h" le indicas q quieres habilitar todos los radios
// * 					 con una "d" le indicas q quieres deshabilitarlos
// *
//*******************************************************************************

	var hab;
	
	if (flag=="h"){
		hab=false;
	}else{
		hab=true;
	}

	var radio;

	var table = $(tabla);
	
	if (table.rows(2).cells[0].childNodes[0].type=="radio"){	
		for(var i=2; i<table.rows.length; i++){
			var radio = table.rows(i).cells[0].childNodes[0];
			radio.disabled = hab;
		}
	}

}

/**
* Funcion que vacia un combo
*
* @param idSelect Id del combo
*/
function fncVaciarCombo (idSelect) {
var objCombo = document.getElementById(idSelect);
objCombo.options.length = 0;
// Para que funcione bien en Netscape, aadimos una vacia y la quitamos
fncAnadirOpcionCombo(idSelect, "", "");
objCombo.options.length = 0;
}
/**
* Funcion que anade una opcion en un combo
*
* @param idSelect Id del combo
* @param texto Texto a mostrar en la opcion
* @param valor Valor de la opcion
* @param seleccionado Valor de la opcion seleccionada
*/
function fncAnadirOpcionCombo (idSelect, texto, valor, seleccionado) {
var nuevaOpcion = new Option(texto, valor);
if (seleccionado==valor) nuevaOpcion.selected = "true";
var select = document.getElementById(idSelect);
if(select!=null)
{
	select.options[select.options.length] = nuevaOpcion;
}
}

/**
* Vacia el combo que indica el id pasado por parametro y se le anyade la opcion -1
* @param idPfCombo: id del combo a vaciar
*/
function fncInicializarCombo(idPfCombo){
fncVaciarCombo(idPfCombo);
fncAnadirOpcionCombo(idPfCombo, "", "");
}//Fin fncInicializarCombo

/**
* Funcion que anade una opcion en un combo NORA
*
* @param idSelect Id del combo
* @param texto Texto a mostrar en la opcion
* @param valor1 Valor de la opcion del primer combo
* @param valor2 Valor de la opcion del segundo combo
* @param seleccionado1 Valor de la primera opcion seleccionada
* @param seleccionado2 Valor de la segunda opcion seleccionada
*/
function fncAnadirOpcionComboNora (idSelect, texto, valor1, seleccionado1, valor2, seleccionado2, flag) {
	var nuevaOpcion = new Option(texto, valor1);
	
	//Pais y Provincia
	if (flag==1 || flag==2) {
		if (seleccionado1==valor1) {
			nuevaOpcion.selected = "true";
		}
	} 
	//Municipio
	else {
		if(seleccionado1==valor1 && seleccionado2==valor2) {
			nuevaOpcion.selected = "true";
		}
	}
	var select = document.getElementById(idSelect);
	select.options[select.options.length] = nuevaOpcion;
}

function sumarDiaFecha(fechaForm,dia,idioma){
//*******************************************************************************
// * Funcin: sumarDiaFecha(fechaForm,dia,idioma)
// * Autor: Javier Roncal
// * Fecha Creacin:  08/01/2008
// * Objetivo: Funcin que suma unos dias a una fecha dada
// * Variables: fechaForm -> la fecha a la q hay q sumar los dias
// * 			dia  -> n de das a sumar a la fecha
// *			idioma  -> idioma en el que est formateada la fecha introducida
//*******************************************************************************

 milisegundos=parseInt(dia*24*60*60*1000);
 fecha=new Date();
 var anyo;
 var mes;
 var dia;
var respuestaFecha = "true";

//alert(fechaForm);
var fechas = fechaForm.split("/");

//alert(fechas);

  if (fechas.length==3){
 if (idioma=='eu') {
		
/*		anyo = fechaForm.substring(0, 4); 
		mes =  fechaForm.substring(5, 7);
		dia = fechaForm.substring(8, 10);*/
		anyo = fechas[0];
		mes = fechas[1];
		dia = fechas[2];
			
	} else {
		
		/*dia = fechaForm.substring(0, 2); 
		mes =  fechaForm.substring(3, 5);
		anyo = fechaForm.substring(6, 10);*/
		anyo = fechas[2];
		mes = fechas[1];
		dia = fechas[0];
	}
		
		var mesStr = mes.toString();
		var diaStr = dia.toString();
		var anyoStr = anyo.toString();
		
		//alert(mesStr+"-"+diaStr+"-"+anyoStr);
		
		if (mesStr.length=="1"){
			mesStr = "0"+mesStr;
		}
		if (mesStr.length!="2"){
			respuestaFecha = "false";
		}
		
		if (diaStr.length=="1"){
			diaStr = "0"+diaStr;
		}
		if (diaStr.length!="2"){
			respuestaFecha = "false";
		}
		if (anyo<=50){
			anyo=anyo+2000;
		}
		if (anyo>50&&anyo<100){
			anyo=anyo+1900;
		}
		if (anyo>=100&&anyo<1000){
			anyo=anyo+1000;
		}
		if (anyoStr.length!="4"){
			respuestaFecha = "false";
		}
  	  if (isNaN(anyo)){
  	  		respuestaFecha = "false";
  	  }
	  temp = parseInt(mes);
  	  if (isNaN(mes)){
  	  		respuestaFecha = "false";
  	  }
	  temp = parseInt(dia);
  	  if (isNaN(dia)){
  	  		respuestaFecha = "false";
  	  }
  	  if (respuestaFecha=="true"){
	  if (dia.indexOf("/")==-1){
		 if (mes.indexOf("/")==-1){
			 if (anyo.indexOf("/")==-1){
			 
			 fecha.setMonth(mes-1);
			 fecha.setDate(dia);
			 fecha.setYear(anyo);  
			  
			 tiempo=fecha.getTime();
			 total=fecha.setTime(parseInt(tiempo+milisegundos));
			}else{
				fecha=fechaForm;
			}
		}else{
				fecha=fechaForm;
			}
	}else{
				fecha=fechaForm;
			}
  }else{
  fecha=fechaForm;
//  alert("mal");
  }
  }else{
  fecha=fechaForm;
  }
  return fecha;
 
 }
