
  /**
   * noraapi_provincias
   * Objeto NORA para modelar las provincias.
   * 
   * Parmetros:
   * 		baseUrl: direccin del servlet para lanzar las consultas a base de datos
   * 		onFailure: funcin a implementar para el tratamiento de una respuesta errnea
   * 		on406: funcin para tratar el error 406
   * 		onSuccess: funcin a implementar para tratar los datos que devuelve el servlet:
   * 								Se completa el objeto select de la pgina con todas las provincias
   *  
   * */
  //var noraapi_provincias;
  
   /**
   * noraapi_municipios
   * Objeto NORA para modelar los municipios.
   * 
   * Parmetros:
   * 		baseUrl: direccin del servlet para lanzar las consultas a base de datos
   * 		onFailure: funcin a implementar para el tratamiento de una respuesta errnea
   * 		on406: funcin para tratar el error 406
   * 		onSuccess: funcin a implementar para tratar los datos que devuelve el servlet:
   * 								Se completa el objeto select de la pgina con todos los municipios de la provincia
   *  
   * */  
  /**/
  //var noraapi_municipios;
  
  /**
 * Implementacin de la funcin para el tratamiento de error en la comunicacin con NORA
 * 
 * */
  function on_failure(response) {
     alert ("ERROR EN EL CANAL DE COMUNICACION DE NORA: "+response.responseText);
  }
  
  /**
   * Funcin para obtener todas los Paises
   * */
  function getPaises(idComboPais,valorSeleccionado){
    noraapi_pais = new NORA.pais({
     asynchronous: true,
     baseUrl: servidorNORA + '/t17iApiJSWar',
     onFailure: on_failure,
     on406: on_failure,
     onSuccess:  function (response) {
         var pais = response.responseText.evalJSON(true);
         if(valorSeleccionado == codEspania){
            	valorSeleccionado='';
            }
         for( var i=0;i < pais.data.length;i++) {
			fncAnadirOpcionCombo (idComboPais, fncPasarMayusculasNORA(pais.data[i].descripcionOficial),pais.data[i].id,valorSeleccionado);  
         } 
     }
  } );
     noraapi_pais.getByDesc("",{});
     
  }  

  /**
   * Funcin para obtener todas las provincias 
   * */
  function getAllProvincias(idComboTH,valorSeleccionado){
    noraapi_provincias = new NORA.provincia({
     asynchronous: true,
     baseUrl: servidorNORA + '/t17iApiJSWar',
     onFailure: on_failure,
     on406: on_failure,
     onSuccess:  function (response) {
         var provincias = response.responseText.evalJSON(true);
         for( var i=0;i < provincias.data.length;i++) {
			fncAnadirOpcionCombo (idComboTH, fncPasarMayusculasNORA(provincias.data[i].descripcionOficial),provincias.data[i].id,valorSeleccionado);  
         } 
     }
  } );
     noraapi_provincias.getByDesc("",{});

     
  }  
  
  /**
   * Funcin para obtener todas las provincias de la CAE
   * */
  function getProvinciasCAE(idComboTH,codCAE,valorSeleccionado){
    noraapi_provincias = new NORA.provincia({
     asynchronous: true,
     baseUrl: servidorNORA + '/t17iApiJSWar',
     onFailure: on_failure,
     on406: on_failure,
     onSuccess:  function (response) {
         var provincias = response.responseText.evalJSON(true);
         for( var i=0;i < provincias.data.length;i++) {
			fncAnadirOpcionCombo (idComboTH, fncPasarMayusculasNORA(provincias.data[i].descripcionOficial),provincias.data[i].id,valorSeleccionado);  
         } 
     }
  } );
     noraapi_provincias.getByDesc("",{autonomiaId:codCAE});

     
  }  
  
  /**
   * Funcin para obtener los municipios de la provincia seleccionada 
   * */
  function getMunicipiosProvincia(idComboMuni,codProv,valorSeleccionado){
  	
  	fncInicializarCombo(idComboMuni);
  	noraapi_municipios = new NORA.municipio({
     asynchronous: true,
     baseUrl: servidorNORA + '/t17iApiJSWar',
     onFailure: on_failure,
     on406: on_failure,
     onSuccess:  function (response) {
         var municipios = response.responseText.evalJSON(true);
         for( var i=0;i < municipios.data.length;i++) {
           		fncAnadirOpcionCombo (idComboMuni, fncPasarMayusculasNORA(municipios.data[i].descripcionOficial),municipios.data[i].id, valorSeleccionado);
     	 }
     }
  	} );
  	if(codProv!=''){
    	noraapi_municipios.getByDesc("",{provinciaId:codProv});
    }
  }

 // * Funcion: fncPasarMayusculas(obj)
// * Autor: Fernando Rodr?guez San Jos?
// * Fecha Creacion:  9 de enero de 2006
// * Objetivo: Pasar un campo alfanumerico a mayusculas
// *
// * Parametros: obj: el campo a transformar
//
function fncPasarMayusculasNORA(valor) {	
      valor = fncTrimCadena(valor);
	   try{
			valor =decodeURIComponent( escape(valor));
			valor = fncAdaptarCaracteresEspecialesNORA(valor);
			valor = valor.toUpperCase();
          }catch(e){
			valor = valor.toUpperCase();
			valor = fncAdaptarCaracteresEspecialesNORA(valor);
          }
	
	return valor;
	
}//Fin fncPasarMayusculas

// * Funcion: fncAdaptarCaracteresEspeciales(obj)
// * Autor: Eneko Rodriguez
// * Fecha Creacion:  16 de enero de 2006
// * Objetivo: Prepara cualquier texto para q pueda ser utilizado en SQL
// *
// * Parametros: obj: el campo a transformar
//
function fncAdaptarCaracteresEspecialesNORA(valor) {
	//Filtramos los caracteres de escape m?s comunes
	//?,",',%	
	valor = fncReemplazar(valor, "'", "");
	valor = fncReemplazar(valor, "?", "");
	valor = fncReemplazar(valor, "'", "");
	valor = fncReemplazar(valor, "\"", "");
	valor = fncReemplazar(valor, "%", "");
	valor = fncReemplazar(valor, "&", "");
	valor = fncReemplazar(valor, "^", "");
	
	return valor;
}//Fin  fncAdaptarCaracteresEspeciales


function fncQuitarTildes(valor){
	valor = fncReemplazar(valor, "", "A");
	valor = fncReemplazar(valor, "", "E");
	valor = fncReemplazar(valor, "", "I");
	valor = fncReemplazar(valor, "", "O");
	valor = fncReemplazar(valor, "", "U");
	
	return valor;
}

//*******************************************************************************
// * Funcion: fncReplaceAll()
// * Autor: Irune Prado
// * Objetivo: Realiza un replaceAll de una variable usando el replace de js
//*******************************************************************************
function fncReemplazar(string, charViejo, charNuevo) {
	temp = "" + string;
	while (temp.indexOf(charViejo) > -1) {
		pos = temp.indexOf(charViejo);
		temp = "" + (temp.substring(0, pos) + charNuevo + temp.substring((pos + charViejo.length), temp.length));
	}
	return temp;
}