package v50b.v50bOperacionesPaso.v50bgestion.v50busuariosregistrados;

import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import v50b.v50bBeans.V50bSuscriptorBean;
import v50b.v50bClasesComunes.V50bClsConstantes;
import v50b.v50bClasesComunes.V50bClsFecha;
import v50b.v50bClasesComunes.V50bClsInformes;
import v50b.v50bClasesComunes.V50bClsTrazas;
import es.ejie.frmk.listeners.base.Q70ListenerUtils;
import es.ejie.frmk.presentacion.operacion.paso.Q70ActionPasoOP;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;

/**
 * 
 * @author llaparra
 *
 */
public class V50bImprimirClavesAction extends Q70ActionPasoOP {
	/**
	 * @param contexto : Q70ContextoEJIE
	 * @param errors : ActionErrors
	 * @param mapping : ActionMapping
	 * @param form : ActionForm
	 * @param request : request
	 * @param response : response
	 * @throws Exception Se lanza la excepcin
	 */
	protected void processOP(Q70ContextoEJIE contexto, ActionErrors errors,
			ActionMapping mapping, ActionForm form, HttpServletRequest request,
			HttpServletResponse response) throws Exception {
		V50bClsTrazas.depura("V50bImprimirClavesAction.processOP() ");
		
		List lTextos=(ArrayList)contexto.get("v50bListaTextos");
		String textoC=(String)lTextos.get(0);
		String textoE=(String)lTextos.get(1);
				
		String coordinador="";

		//Idioma
		String idioma = Q70ListenerUtils.getLanguage(request);
		
		//Plantilla
		String strPlantilla=(String)contexto.get("v50bPlantillaClaves");
	
		//Parametros
		ArrayList arrParametros = new ArrayList();
		
		//Imagen
		StringBuffer imagenSB1 = new StringBuffer(Q70ListenerUtils.getApplicationProperty("RUTA_PLANTILLA"));
		imagenSB1.append(V50bClsConstantes.CONSTANTE_LOGO_IVAP);
		String imagenString1 = imagenSB1.toString();
		arrParametros.add(this.getClass().getResource(imagenString1).toString()); //parametro1
		
		StringBuffer imagenSB2 = new StringBuffer(Q70ListenerUtils.getApplicationProperty("RUTA_PLANTILLA"));
		imagenSB2.append(V50bClsConstantes.CONSTANTE_LOGO_GV);
		String imagenString2 = imagenSB2.toString();
		arrParametros.add(this.getClass().getResource(imagenString2).toString()); //parametro2
		
		StringBuffer imagenSB3 = new StringBuffer(Q70ListenerUtils.getApplicationProperty("RUTA_PLANTILLA"));
		imagenSB3.append(V50bClsConstantes.CONSTANTE_FIRMA_DIGITAL);
		String imagenString3 = imagenSB2.toString();
		arrParametros.add(this.getClass().getResource(imagenString3).toString()); //parametro3
		
		//Fecha
		String fecha=V50bClsFecha.fncFechaTexto(V50bClsFecha.fncObtenerFechaSistemaCorta(), idioma, null);
		arrParametros.add(fecha); //parametro2
		
		//Idioma
		arrParametros.add(idioma);
		
		//Literales
		ArrayList arrLiterales = new ArrayList();
		arrLiterales.add("comun.tituloCartaInscripcion");
		arrLiterales.add("aplicacion.titulo");		
		arrLiterales.add("comun.ivap");		
		arrLiterales.add("comun.usuarioCarta");
		arrLiterales.add("comun.contraseaCarta");
		arrLiterales.add("suscriptores.lagunHori");
		arrLiterales.add("suscriptores.agurra");
		arrLiterales.add("comun.ivap");
		
		//ArrayList Busqueda
		ArrayList arrDatosSuscriptoresInscritos=(ArrayList)contexto.get("v50bListaSuscriptoresClave");
		
		//para el formato del nombre y de la direccin
		String dirComp;
		
		for(int i=0; i<arrDatosSuscriptoresInscritos.size(); i++){
			V50bSuscriptorBean suscriptor = (V50bSuscriptorBean)arrDatosSuscriptoresInscritos.get(i);
			
			String nombre = suscriptor.getNombre();
			String ape1 = suscriptor.getApellido1();
			String ape2 = suscriptor.getApellido2();
			String nombreCompleto = nombre+" "+ape1+" "+ape2;
			suscriptor.setNomApeCarta(nombreCompleto);
			
			//tiene CP, municipio y provincia
			if(StringUtils.isNotEmpty(suscriptor.getCp()) && StringUtils.isNotEmpty(suscriptor.getNomMunicipio()) 
					&& StringUtils.isNotEmpty(suscriptor.getNomTh())) {
				dirComp = suscriptor.getCp()+" "+suscriptor.getNomMunicipio()+" ("+suscriptor.getNomTh()+")";
			//tiene municipio y provincia
			} else if(StringUtils.isEmpty(suscriptor.getCp()) && StringUtils.isNotEmpty(suscriptor.getNomMunicipio()) 
					&& StringUtils.isNotEmpty(suscriptor.getNomTh())) {
				dirComp = suscriptor.getNomMunicipio()+" ("+suscriptor.getNomTh()+")";
			//tiene CP y provincia
			} else if(StringUtils.isNotEmpty(suscriptor.getCp()) && StringUtils.isEmpty(suscriptor.getNomMunicipio()) 
					&& StringUtils.isNotEmpty(suscriptor.getNomTh())) {
				dirComp = suscriptor.getCp()+" ("+suscriptor.getNomTh()+")";
			//tiene CP y municipio
			}else if(StringUtils.isNotEmpty(suscriptor.getCp()) && StringUtils.isNotEmpty(suscriptor.getNomMunicipio()) 
					&& StringUtils.isEmpty(suscriptor.getNomTh())) {
				dirComp = suscriptor.getCp()+" "+suscriptor.getNomMunicipio();
			}
			//tiene solo CP
			else if(StringUtils.isNotEmpty(suscriptor.getCp()) && StringUtils.isEmpty(suscriptor.getNomMunicipio()) 
					&& StringUtils.isEmpty(suscriptor.getNomTh())) {
				dirComp = suscriptor.getCp();
			}
			//tiene solo municipio
			else if(StringUtils.isEmpty(suscriptor.getCp()) && StringUtils.isNotEmpty(suscriptor.getNomMunicipio()) 
					&& StringUtils.isEmpty(suscriptor.getNomTh())) {
				dirComp = suscriptor.getNomMunicipio();
			}
			//tiene solo provincia
			else if(StringUtils.isEmpty(suscriptor.getCp()) && StringUtils.isEmpty(suscriptor.getNomMunicipio()) 
					&& StringUtils.isNotEmpty(suscriptor.getNomTh())) {
				dirComp = suscriptor.getNomTh();
			}
			//no tiene ni CP, ni municipio, ni provincia
			else{
				dirComp = "";
			}
			
			suscriptor.setDireccionCompuesta(dirComp);
		}		
		
		arrParametros.add(coordinador);
		
		int contadorHasta=0, tamParrafoAnt=0, i=0;
		List lisParrafosC = new ArrayList();
		List lisParrafosE = new ArrayList();
		
		
		
		//-------------------------------------
		//- TEXTO CASTELLANO
		//-------------------------------------
		
		String textoAux = textoC;
		
		String parrafo = "", nuevoTexto = "";
								
		while(i < textoAux.length()-1) {			
			char indiceAct = textoAux.charAt(i);
			char indiceSig = textoAux.charAt(i+1);
			
			if(indiceAct=='\r' && indiceSig=='\n') {
				contadorHasta=i;
				parrafo = textoAux.substring(0,contadorHasta);
				tamParrafoAnt=tamParrafoAnt+parrafo.length();
				lisParrafosC.add(parrafo);
							
				//eliminamos el parrafo de nuestro texto
				nuevoTexto=textoAux.substring(contadorHasta+2);
				textoAux = nuevoTexto;
				
				i=-1;
			}
			i++;
		}
			
		if(textoAux!=null){
			parrafo = textoAux.substring(0);
			lisParrafosC.add(parrafo);
		}		
		
		if(lisParrafosC.size()<V50bClsConstantes.CINCO){
			for(int j=0; j < lisParrafosC.size(); j++){
				String unParrafo = (String)lisParrafosC.get(j);
				arrParametros.add(unParrafo);
			}
			for(int k=0; k < V50bClsConstantes.CINCO-lisParrafosC.size(); k++){
				arrParametros.add("");
			}
		} else {
			for(int j=0; j < V50bClsConstantes.CINCO; j++){
				String unParrafo = (String)lisParrafosC.get(j);
				arrParametros.add(unParrafo);
			}
		}
		
		
		
		//-------------------------------------
		//- TEXTO EUSKERA
		//-------------------------------------
		
		textoAux = textoE;
		parrafo = "";
		nuevoTexto = "";
								
		while(i < textoAux.length()-1) {			
			char indiceAct = textoAux.charAt(i);
			char indiceSig = textoAux.charAt(i+1);
			
			if(indiceAct=='\r' && indiceSig=='\n') {
				contadorHasta=i;
				parrafo = textoAux.substring(0,contadorHasta);
				tamParrafoAnt=tamParrafoAnt+parrafo.length();
				lisParrafosE.add(parrafo);
							
				//eliminamos el parrafo de nuestro texto
				nuevoTexto=textoAux.substring(contadorHasta+2);
				textoAux = nuevoTexto;
				
				i=-1;
			}
			i++;
		}
			
		if(textoAux!=null){
			parrafo = textoAux.substring(0);
			lisParrafosE.add(parrafo);
		}		
		
		if(lisParrafosE.size()<V50bClsConstantes.CINCO){
			for(int j=0; j < lisParrafosE.size(); j++){
				String unParrafo = (String)lisParrafosE.get(j);
				arrParametros.add(unParrafo);
			}
			for(int k=0; k < V50bClsConstantes.CINCO-lisParrafosE.size(); k++){
				arrParametros.add("");
			}
		} else {
			for(int j=0; j < V50bClsConstantes.CINCO; j++){
				String unParrafo = (String)lisParrafosE.get(j);
				arrParametros.add(unParrafo);
			}
		}
		
		
		
		
		
		
		int[] indRegistros = {1,1};
						
		//Generamos PDF
		V50bClsInformes.fncSacarListadoFOPPorPagina(response,idioma,Q70ListenerUtils.getApplicationProperty("RUTA_PLANTILLA")+strPlantilla,arrParametros,arrLiterales,arrDatosSuscriptoresInscritos,"v50bcomun",indRegistros,null);
		
		}
	
	/**
	 * @param contexto : Q70ContextoEJIE
	 * @param errors : ActionErrors
	 * @param mapping : ActionMapping
	 * @param form : ActionForm
	 * @param request : request
	 * @param response : response
	 * @return ActionForward
	 * @throws Exception Se lanza la excepcin
	 */
	protected ActionForward processForward(Q70ContextoEJIE contexto,
			ActionErrors errors, ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		
		if (errors.isEmpty()) {
			return mapping.findForward("ok");
		} else {
			return mapping.findForward("error");	
		}
	}
	
}