package v50b.v50bOperacionesPaso.v50bgestion.v50busuariosregistrados;

import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import v50b.v50bBeans.V50bSuscriptorBean;
import v50b.v50bClasesComunes.V50bClsConstantes;
import v50b.v50bClasesComunes.V50bClsMail;
import v50b.v50bClasesComunes.V50bClsSMS;
import v50b.v50bClasesComunes.V50bClsTrazas;
import v50b.v50bClasesComunes.v50bBeansComunes.V50bMailBean;
import v50b.v50bClasesComunes.v50bBeansComunes.V50bSMSBean;
import v50b.v50bComun.V50bActionPasoOP;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesException;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;
import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;
import es.ejie.frmk.infraestructura.traza.Q70Traza;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;

/**
 * 
 * @author llaparra
 *
 */
public class V50bEnviarClavesAction extends V50bActionPasoOP {
	
	/**
	 * 
	 * @param contexto Q70ContextoEJIE
	 * @return String string
	 * @throws Q70GestorMensajesException exception
	 */
	protected String getPrefijoTextoMensaje(Q70ContextoEJIE contexto) throws Q70GestorMensajesException {
		return "";
	}
	
	private static String COMPONENTE = "V50bEnviarClavesAction";
	private static Q70Traza traza = Q70Traza.getSingleton();
	
	/**
	 * 
	 * @param contexto : Q70ContextoEJIE
	 * @param errors : ActionErrors
	 * @param mapping : ActionMapping
	 * @param form : ActionForm
	 * @param request : request
	 * @param response : response
	 * @throws Exception Se lanza la excepcin
	 */
	protected void processOP(Q70ContextoEJIE contexto, ActionErrors errors,
			ActionMapping mapping, ActionForm form, HttpServletRequest request,
			HttpServletResponse response) throws Exception {
		
		V50bClsTrazas.depura("V50bEnviarClavesAction.processOP() ");
		
		this.doEnvioComunicacion(contexto, request);
	}
	
	/**
	 * 
	 * @param contexto : Q70ContextoEJIE
	 * @param errors : ActionErrors
	 * @param mapping : ActionMapping
	 * @param form : ActionForm
	 * @param request : request
	 * @param response : response
	 * @return ActionForward
	 * @throws Exception Se lanza la excepcin
	 */
	protected ActionForward processForward(Q70ContextoEJIE contexto,
			ActionErrors errors, ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		V50bClsTrazas.depura("V50bEnviarClavesAction.processForward() ");
		
		return mapping.findForward("ok");
	}
	
	/**
	 * doEnvioComunicacion
	 * @param contexto Q70ContextoEJIE contexto
	 * @param request HttpServletRequest request
	 * @throws Exception ex
	 */
	private void doEnvioComunicacion(Q70ContextoEJIE contexto, HttpServletRequest request) throws Exception {
		V50bClsTrazas.depura("V50bEnviarClavesAction.doEnvioComunicacion() ");
		
		final String strIdioma = (String)contexto.get(V50bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA) ;
		boolean error = false;
		boolean excluido = false;
		StringBuffer msgError = new StringBuffer(V50bClsConstantes.VEINTE);
		
		List lSuscriptores = (ArrayList)contexto.get("v50bListaSuscriptoresClave");
		
		//Se prepara el mail y el sms
		StringBuffer asunto = new StringBuffer();
		asunto.append("DUDA-MUDA")
				.append(" - ")
				.append(Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","suscriptores.mailAsuntoSuscriptor",strIdioma));
		
		StringBuffer saludo = new StringBuffer();
		saludo.append(Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","suscriptores.lagunHori",strIdioma));
		
		StringBuffer texto = new StringBuffer();
		texto.append(Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","suscriptores.texto",strIdioma));
		
		StringBuffer despedida = new StringBuffer();
		despedida.append(Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","suscriptores.agurra",strIdioma));
		
		V50bMailBean mailBean = new V50bMailBean();
		mailBean.setAsunto(asunto.toString());
		
		StringBuffer usuario = new StringBuffer();
		StringBuffer clave = new StringBuffer();
		StringBuffer cuerpo = new StringBuffer();
		
		V50bSMSBean smsBean = new V50bSMSBean();
		smsBean.setAcuseRecibo(false);
		smsBean.setIdioma(strIdioma);
		
		StringBuffer msgErrorTelefono = new StringBuffer(V50bClsConstantes.VEINTITRES);
		
		//Recorremos los usuarios a enviar
		for (int i=0; i<lSuscriptores.size(); i++){
			V50bSuscriptorBean suscriptor = (V50bSuscriptorBean)lSuscriptores.get(i);
			//Si prefiere por mail
			if(V50bClsConstantes.AVISO_EMAIL.equals(suscriptor.getRecibirNotif())){
				String email=suscriptor.getEmail();
				
				usuario.delete(0, usuario.length());
				usuario.append(Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","comun.usuario",strIdioma))
						.append(": ").append(suscriptor.getUsuario());
				
				clave.delete(0, clave.length());
				clave.append(Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","comun.contrasea",strIdioma))
						.append(": ").append(suscriptor.getClave());
							
				cuerpo.delete(0, cuerpo.length());
				cuerpo.append(saludo).append(": \n\n").append(texto).append("\n\n").append(usuario)
						.append("\n").append(clave).append("\n\n").append(despedida);
				
				mailBean.setCuerpoPlano(cuerpo.toString());
				mailBean.setEnviarA(email);
				mailBean.setEnviarCC("");
				mailBean.setEnviarCCO("");
				mailBean.setRemitente(contexto.get("v50bEmailRemitente").toString().trim());
				
				//Se envia el mail
				final int intEnvio=V50bClsMail.fncEnviarMail(mailBean);
				if(intEnvio==V50bClsConstantes.ENVIADO_INCORRECTO){			
					error = true;					
				}
			//Si prefiere por sms
			} else if(V50bClsConstantes.AVISO_MOVIL.equals(suscriptor.getRecibirNotif())){
				String movil=suscriptor.getMovil();
				
				usuario.delete(0, usuario.length());
				usuario.append(Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","comun.usuario",strIdioma))
						.append(": ").append(suscriptor.getUsuario());
				
				clave.delete(0, clave.length());
				clave.append(Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","comun.contrasea",strIdioma))
						.append(": ").append(suscriptor.getClave());
				
				cuerpo.delete(0, cuerpo.length());
				cuerpo.append(asunto).append("\n").append(usuario).append("\n").append(clave);
				
				smsBean.setNombreRemitente("DUDA-MUDA");
				smsBean.setTextoSMS(this.getPrefijoTextoMensaje(contexto) + cuerpo.toString());
				smsBean.setTelefono(movil);
				
				//Se enva el sms
				int envioSms = V50bClsSMS.fncEnviarSMS(request, smsBean);
				if(envioSms == V50bClsConstantes.ENVIADO_INCORRECTO) {
					error = true;	
					
					msgErrorTelefono.append("Receptor SMS(telefono):");
					//msgErrorTelefono.append(suscriptor.getUsuario());
					msgErrorTelefono.append(suscriptor.getCodigo());
					msgErrorTelefono.append("(");
					msgErrorTelefono.append(suscriptor.getMovil());
					msgErrorTelefono.append(")");
					msgError.append(msgErrorTelefono);
					msgError.append(". ");

					if (V50bEnviarClavesAction.traza.isTraceActive()) {
						V50bEnviarClavesAction.traza.trace(V50bEnviarClavesAction.COMPONENTE, Q70TraceLevel.ERROR, "ERROR:" + msgErrorTelefono);
					}
					msgErrorTelefono.delete(0, msgErrorTelefono.length()-1);
				} else {
					if (V50bEnviarClavesAction.traza.isTraceActive()) {
						V50bEnviarClavesAction.traza.trace(V50bEnviarClavesAction.COMPONENTE, Q70TraceLevel.DEBUG, 
							"SMS correcto (codigo/numero tlfno.):"
							+ suscriptor.getMovil());
					}
				}
			//Si prefiere no ser notificado
			} else {
				excluido = true;
			}
		}
		
		//Mensajes
		if(!error && !excluido) {
				contexto.set(V50bClsConstantes.MENSAJE_INFORMACION, "suscriptores.enviado");
		} else {
			if(error && excluido){
				contexto.set(V50bClsConstantes.MENSAJE_INFORMACION, "suscriptores.errorYExcluido");
				ArrayList listaArgs = new ArrayList(1);
				listaArgs.add(msgError.toString());
				contexto.set(V50bClsConstantes.MENSAJE_ARGS_INFORMACION, listaArgs);
				V50bClsTrazas.depura("V50bEnviarAction LISTA ERRORES "+msgError.toString());
			} else if(error){
					contexto.set(V50bClsConstantes.MENSAJE_INFORMACION, "suscriptores.error");
					ArrayList listaArgs = new ArrayList(1);
					listaArgs.add(msgError.toString());
					contexto.set(V50bClsConstantes.MENSAJE_ARGS_INFORMACION, listaArgs);
					V50bClsTrazas.depura("V50bEnviarAction LISTA ERRORES "+msgError.toString());
			} else if(excluido){
				if(lSuscriptores.size()>1) {
					contexto.set(V50bClsConstantes.MENSAJE_INFORMACION, "suscriptores.excluido");
				} else {
					contexto.set(V50bClsConstantes.MENSAJE_INFORMACION, "suscriptor.excluido");
				}
			}
		}
	}
	
}