package v50b.v50bOperacionesPaso.v50bgestion.v50busuariosregistrados;

import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.DynaActionForm;
import org.apache.struts.upload.FormFile;

import v50b.v50bBeans.V50bComunicacionBean;
import v50b.v50bBeans.V50bSuscriptorBean;
import v50b.v50bClasesComunes.V50bClsConstantes;
import v50b.v50bClasesComunes.V50bClsMail;
import v50b.v50bClasesComunes.V50bClsSMS;
import v50b.v50bClasesComunes.V50bClsTrazas;
import v50b.v50bClasesComunes.v50bBeansComunes.V50bMailBean;
import v50b.v50bClasesComunes.v50bBeansComunes.V50bSMSBean;
import v50b.v50bComun.V50bActionPasoOP;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesException;
import es.ejie.frmk.infraestructura.mail.Q70MailFile;
import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;
import es.ejie.frmk.infraestructura.traza.Q70Traza;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;

/**
 * 
 * @author llaparra
 *
 */
public class V50bEnviarAction extends V50bActionPasoOP {
	
	/**
	 * 
	 * @param contexto Q70ContextoEJIE
	 * @return String string
	 * @throws Q70GestorMensajesException exception
	 */
	protected String getPrefijoTextoMensaje(Q70ContextoEJIE contexto) throws Q70GestorMensajesException {
		return "";
	}
	
	private static String COMPONENTE = "V50bEnviarClavesAction";
	private static Q70Traza traza = Q70Traza.getSingleton();
	
	/**
	 * 
	 * @param contexto : Q70ContextoEJIE
	 * @param errors : ActionErrors
	 * @param mapping : ActionMapping
	 * @param form : ActionForm
	 * @param request : request
	 * @param response : response
	 * @throws Exception Se lanza la excepcin
	 */
	protected void processOP(Q70ContextoEJIE contexto, ActionErrors errors,
			ActionMapping mapping, ActionForm form, HttpServletRequest request,
			HttpServletResponse response) throws Exception {
		
		V50bClsTrazas.depura("V50bEnviarAction.processOP() ");
		
		this.doEnvioComunicacion(contexto, request, form);
	}
	
	/**
	 * 
	 * @param contexto : Q70ContextoEJIE
	 * @param errors : ActionErrors
	 * @param mapping : ActionMapping
	 * @param form : ActionForm
	 * @param request : request
	 * @param response : response
	 * @return ActionForward
	 * @throws Exception Se lanza la excepcin
	 */
	protected ActionForward processForward(Q70ContextoEJIE contexto,
			ActionErrors errors, ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		V50bClsTrazas.depura("V50bEnviarAction.processForward() ");
		
		return mapping.findForward("ok");
	}
	
	/**
	 * doEnvioComunicacion
	 * @param contexto Q70ContextoEJIE contexto
	 * @param request HttpServletRequest request
	 * @throws Exception ex
	 */
	private void doEnvioComunicacion(Q70ContextoEJIE contexto, HttpServletRequest request, ActionForm form) throws Exception {
		V50bClsTrazas.depura("V50bEnviarAction.doEnvioComunicacion() ");
		
		final String strIdioma = (String)contexto.get(V50bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA) ;
		boolean error = false;
		boolean excluido = false;
		StringBuffer msgError = new StringBuffer(V50bClsConstantes.VEINTE);
		
		List lSuscriptores = (ArrayList)contexto.get("v50bListaSuscriptoresClave");
		//String[] lSuscriptores= (String[])contexto.get((String) contexto.get("nombreListaBusqSel"));
		
		
		V50bComunicacionBean comunicacion = (V50bComunicacionBean)contexto.get("v50bComunicacionForm");
		
		//Se prepara el mail y el sms
		List lFiles = new ArrayList();
		final DynaActionForm formulario = ((DynaActionForm)form);
		FormFile anexo = (FormFile)formulario.get("fileAnexo");
		
		V50bMailBean mailBean = new V50bMailBean();
		mailBean.setAsunto(comunicacion.getAsunto());
		mailBean.setCuerpoPlano(comunicacion.getDetalle());
		mailBean.setEnviarCC("");
		mailBean.setEnviarCCO("");
		mailBean.setRemitente(contexto.get("v50bEmailRemitente").toString().trim());
		
		V50bSMSBean smsBean = new V50bSMSBean();
		smsBean.setAcuseRecibo(false);
		smsBean.setIdioma(strIdioma);
		smsBean.setTextoSMS(comunicacion.getTexto());
		
		//List lIncrust = new ArrayList();
		
		StringBuffer msgErrorTelefono = new StringBuffer(V50bClsConstantes.VEINTITRES);
		
		//Recorremos los usuarios a enviar
		for (int i=0; i<lSuscriptores.size(); i++){
			if(null!=anexo && anexo.getFileSize()>0){
				lFiles.add(this.fichAnexo(anexo));
			}
			V50bSuscriptorBean suscriptor = (V50bSuscriptorBean)lSuscriptores.get(i);
			//Si es envio por mail
			if(V50bClsConstantes.AVISO_EMAIL.equals(comunicacion.getMetodoEnvio())){
				if(V50bClsConstantes.AVISO_EMAIL.equals(suscriptor.getRecibirNotif())){
					mailBean.setEnviarA(suscriptor.getEmail());
								
					//Se envia el mail
					final int intEnvio=V50bClsMail.fncEnviarMailFicheros(mailBean, lFiles, null);
					if(intEnvio==V50bClsConstantes.ENVIADO_INCORRECTO){			
						error = true;					
					}
				} else {
					excluido = true;
				}
			//Si es envo por sms
			} else if(V50bClsConstantes.AVISO_MOVIL.equals(comunicacion.getMetodoEnvio())){
				if(V50bClsConstantes.AVISO_MOVIL.equals(suscriptor.getRecibirNotif())){
					smsBean.setTelefono(suscriptor.getMovil());
					
					//Se enva el sms
					int envioSms = V50bClsSMS.fncEnviarSMS(request, smsBean);
					if(envioSms == V50bClsConstantes.ENVIADO_INCORRECTO) {
						error = true;	
						
						msgErrorTelefono.append("Receptor SMS(telefono):");
						//msgErrorTelefono.append(suscriptor.getUsuario());
						msgErrorTelefono.append(suscriptor.getCodigo());
						msgErrorTelefono.append("(");
						msgErrorTelefono.append(suscriptor.getMovil());
						msgErrorTelefono.append(")");
						msgError.append(msgErrorTelefono);
						msgError.append(". ");

						if (V50bEnviarAction.traza.isTraceActive()) {
							V50bEnviarAction.traza.trace(V50bEnviarAction.COMPONENTE, Q70TraceLevel.ERROR, "ERROR:" + msgErrorTelefono);
						}
						msgErrorTelefono.delete(0, msgErrorTelefono.length()-1);
					} else {
						if (V50bEnviarAction.traza.isTraceActive()) {
							V50bEnviarAction.traza.trace(V50bEnviarAction.COMPONENTE, Q70TraceLevel.DEBUG, 
								"SMS correcto (codigo/numero tlfno.):"
								+ suscriptor.getMovil());
						}
					}
					
				} else {
					excluido = true;
				}
			//Si prefiere no ser notificado
			} else {
				excluido = true;
			}
		}
		
		//Mensajes
		if(!error && !excluido) {
			contexto.set(V50bClsConstantes.MENSAJE_INFORMACION, "suscriptores.comunicado");
		} else {
			if(error && excluido){
				contexto.set(V50bClsConstantes.MENSAJE_INFORMACION, "suscriptores.comunicadoErrorYExcluidoModo");
				V50bClsTrazas.depura("V50bEnviarAction LISTA ERRORES "+msgError.toString());
				ArrayList listaArgs = new ArrayList(1);
				listaArgs.add(msgError.toString());
				contexto.set(V50bClsConstantes.MENSAJE_ARGS_INFORMACION, listaArgs);
			} else if(error){
					contexto.set(V50bClsConstantes.MENSAJE_INFORMACION, "suscriptores.comunicadoError");
					V50bClsTrazas.depura("V50bEnviarAction LISTA ERRORES "+msgError.toString());
					ArrayList listaArgs = new ArrayList(1);
					listaArgs.add(msgError.toString());
					contexto.set(V50bClsConstantes.MENSAJE_ARGS_INFORMACION, listaArgs);
			} else if(excluido){
				if(lSuscriptores.size()>1) {
					contexto.set(V50bClsConstantes.MENSAJE_INFORMACION, "suscriptores.excluidoModo");
				} else {
					contexto.set(V50bClsConstantes.MENSAJE_INFORMACION, "suscriptor.excluidoModo");
				}
			}
		}
	}
	
	/**
	 * 
	 * @param anexo : FormFile
	 * @return Q70MailFile
	 * @throws Exception Se lanza la excepcin
	 */
	public Q70MailFile fichAnexo(FormFile anexo) throws Exception {
		
		return new Q70MailFile(anexo.getFileName(),anexo.getFileData(),anexo.getContentType());
	}
	
}