package v50b.v50bOperacionesPaso.v50bgestion.v50bbandejaentrada;

import java.util.ArrayList;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import v50b.v50bBeans.V50bConsultaBean;
import v50b.v50bClasesComunes.V50bClsConstantes;
import v50b.v50bClasesComunes.V50bClsFecha;
import v50b.v50bClasesComunes.V50bClsInformes;
import v50b.v50bClasesComunes.V50bClsTrazas;
import v50b.v50bComun.V50bActionPasoOP;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;
import es.ejie.frmk.listeners.base.Q70ListenerUtils;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;
/**
 * 
 * @author llaparra
 *
 */
public class V50bImpBandejaEntradaAction extends V50bActionPasoOP {
	/**
	 * 
	 * @param contexto : Q70ContextoEJIE
	 * @param errors : ActionErrors
	 * @param mapping : ActionMapping
	 * @param form : ActionForm
	 * @param request : request
	 * @param response : response
	 * @throws Exception Se lanza la excepcin
	 */
	protected void processOP(Q70ContextoEJIE contexto, ActionErrors errors,
			ActionMapping mapping, ActionForm form, HttpServletRequest request,
			HttpServletResponse response) throws Exception {
		V50bClsTrazas.depura("V50bImpBandejaEntradaAction.processOP() ");

		//Plantilla
		String strPlantilla = (String) contexto.get("v50bPlantillaBandejaEntrada");
	
		//Parametros
		ArrayList arrParametros = new ArrayList();
		
		//Imagen
		StringBuffer imagenSB = new StringBuffer(Q70ListenerUtils.getApplicationProperty("RUTA_PLANTILLA"));
		imagenSB.append(V50bClsConstantes.CONSTANTE_LOGO_IVAP);
		String imagenString = imagenSB.toString();
		String imagen = this.getClass().getResource(imagenString).toString();
		arrParametros.add(imagen); //parametro1
		
		//Fecha
		String fecha=V50bClsFecha.fncPresentarFechaSistemaCorta((String)contexto.get(V50bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA));
        arrParametros.add(fecha); //parametro2
		
		//Idioma
        String idioma = Q70ListenerUtils.getLanguage(request);
		arrParametros.add(idioma); //parametro3
				
		//Literales
		ArrayList arrLiterales = new ArrayList();
		arrLiterales.add("comun.pagina");
		arrLiterales.add("informe.gestion.bandejaEntrada.titulo");
		arrLiterales.add("comun.fConsultaDesde");
		arrLiterales.add("comun.fConsultaHasta");
		arrLiterales.add("comun.fRespuestaDesde");
		arrLiterales.add("comun.fRespuestaHasta");
		arrLiterales.add("comun.notificaciones");
		arrLiterales.add("comun.ambito");
		arrLiterales.add("comun.estado");
		arrLiterales.add("comun.abreviaturas");
		arrLiterales.add("comun.consulta");
		arrLiterales.add("comun.notif");
		arrLiterales.add("comun.fecha");
		arrLiterales.add("comun.dificultad");
		arrLiterales.add("comun.doc");
		arrLiterales.add("comun.si");
		arrLiterales.add("comun.no");

		//ArrayList de la busqueda. EL NOMBRE DE TU LISTA DE LA BUSQUEDA DE LOS EQUIPOS
		ArrayList arrDatosTablasBusquedas = (ArrayList) contexto.get("v50bListaConsultas");
		if(arrDatosTablasBusquedas == null){
			arrDatosTablasBusquedas = new ArrayList();
		}
		V50bConsultaBean criterio = (V50bConsultaBean) contexto.get("fBandejaEntradaBackup");
		
		//parametro4
		if(StringUtils.isBlank(criterio.getFechaConsultaD())){
			arrParametros.add(" ");
		}
		else {
			arrParametros.add(criterio.getFechaConsultaD());
		}
		
		//parametro5
		if(StringUtils.isBlank(criterio.getFechaConsultaH())){
			arrParametros.add(" ");
		}
		else {
			arrParametros.add(criterio.getFechaConsultaH());
		}
		
		//parametro6
		if(StringUtils.isBlank(criterio.getFechaRespuestaD())){
			arrParametros.add(" ");
		}
		else {
			arrParametros.add(criterio.getFechaRespuestaD());
		}
		
		//parametro7
		if(StringUtils.isBlank(criterio.getFechaRespuestaH())){
			arrParametros.add(" ");
		}
		else {
			arrParametros.add(criterio.getFechaRespuestaH());
		}
		
		 //parametro8
		if(StringUtils.isBlank(criterio.getNotificaciones())){
			arrParametros.add(" ");
		}
		else {
			if(V50bClsConstantes.CONSTANTE_SI.equals(criterio.getNotificaciones())){
				arrParametros.add(Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","comun.si",idioma));
			} else {
				arrParametros.add(Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","comun.no",idioma));
			}
		}
		
		//parametro9
		if(StringUtils.isBlank(criterio.getAmbito().getDesamc())){
			arrParametros.add(" ");
		}
		else {
			arrParametros.add(criterio.getAmbito().getDesamc());
		}
		
		//parametro10
		if(StringUtils.isBlank(criterio.getNomEstado())){
			arrParametros.add(" ");
		}
		else {
			arrParametros.add(criterio.getNomEstado());
		}
		
		//parametro11
		if(StringUtils.isEmpty(criterio.getAbreviaturas()) || (criterio.getAbreviaturas().equals(V50bClsConstantes.CONSTANTE_NO) )){
			arrParametros.add(Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","comun.no",idioma));
		} else {
			arrParametros.add(Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","comun.si",idioma)); 
		}	
		
		//parametro10
		if(StringUtils.isBlank(criterio.getConsulta())){
			arrParametros.add(" ");
		}
		else {
			arrParametros.add(criterio.getConsulta()); 
		}
		
		//Generamos PDF	
		V50bClsInformes.fncSacarListadoFOPBeanAnidado(request,response,idioma,
				Q70ListenerUtils.getApplicationProperty("RUTA_PLANTILLA")+strPlantilla,
					arrParametros,arrLiterales,arrDatosTablasBusquedas,"v50bcomun", null);
		
	}

	/**
	 * @param contexto : Q70ContextoEJIE
	 * @param errors : ActionErrors
	 * @param mapping : ActionMapping
	 * @param form : ActionForm
	 * @param request : request
	 * @param response : response
	 * @return ActionForward
	 * @throws Exception Se lanza la excepcin
	 */
	protected ActionForward processForward(Q70ContextoEJIE contexto,
			ActionErrors errors, ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		
		if (errors.isEmpty()){
			return mapping.findForward("ok");
		}else{
			return mapping.findForward("error");
		}
	}

}
