package v50b.v50bOperacionesPaso.v50bgestion.v50bbandejaentrada;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.upload.FormFile;
import org.apache.struts.validator.DynaValidatorForm;

import v50b.v50bBeans.V50bConsultaBean;
import v50b.v50bClasesComunes.V50bClsConstantes;
import v50b.v50bClasesComunes.V50bClsFichero;
import v50b.v50bClasesComunes.V50bClsTrazas;
import v50b.v50bClasesComunes.V50bPIDUtils;
import v50b.v50bComun.V50bActionPasoOP;
import es.ejie.frmk.presentacion.operacion.datos.Q70OPValidatorForm;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;
/**
 * 
 * @author dlopez
 *
 */
public class V50bCatalogarConsultaFicheroOP extends V50bActionPasoOP  {
	
	/**
	 * 
	 * @param contexto : Q70ContextoEJIE
	 * @param errors : ActionErrors
	 * @param mapping : ActionMapping
	 * @param form : ActionForm
	 * @param request : request
	 * @param response : response
	 * @throws Exception Se lanza la excepcin
	 */
	protected void processOP(Q70ContextoEJIE contexto, ActionErrors errors,
			ActionMapping mapping, ActionForm form, HttpServletRequest request,
			HttpServletResponse response) throws Exception {
	}
	
	/**
	 * 
	 * @param contexto : Q70ContextoEJIE
	 * @param errors : ActionErrors
	 * @param mapping : ActionMapping
	 * @param form : ActionForm
	 * @param request : request
	 * @param response : response
	 * @return ActionForward
	 * @throws Exception Se lanza la excepcin
	 */
	protected ActionForward processForward(Q70ContextoEJIE contexto,
			ActionErrors errors, ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		V50bClsTrazas.depura("V50bCatalogarConsultaFicheroOP.processForward() ");
		
		V50bConsultaBean formConsulta = (V50bConsultaBean)contexto.get("fCatalogacion");
		V50bConsultaBean formConsultaBack = (V50bConsultaBean)contexto.get("fCatalogacionBackup");
		DynaValidatorForm formulario = (Q70OPValidatorForm) form;
		
		if(StringUtils.isEmpty(formConsulta.getIndFichero())){
			//comprobar si se ha modificado, borrado o es un alta
			//Metemos el fichero respuesta en el bean
			FormFile file = (FormFile)formulario.get("fileFichAdicionalRes");
			if(null != file){
				V50bClsFichero fich = new V50bClsFichero();
				String oid = formConsultaBack.getFichRespuesta().getOid();
				if(StringUtils.isBlank(file.getFileName())){
					//borrado
					if(StringUtils.isNotBlank(oid)){
						V50bPIDUtils.deleteDocument(oid);
					}
				}else{
					fich.setNombreReal(file.getFileName());
					fich.setTamFich(file.getFileData().length/V50bClsConstantes.BYTES_POR_KILOBYTE);
					//comprobar si ya tiene oid para alta o modificacin
					if(StringUtils.isBlank(oid)){
						fich.setOid(V50bPIDUtils.addDocument(file.getFileName(), file.getFileData()));
					}else{
						fich.setOid(oid);
						V50bPIDUtils.modifyDocument(file.getFileName(), file.getFileData(), oid);
					}
				}
				formConsulta.setFichRespuesta(fich);
			}
			
		}
		
		if(StringUtils.isEmpty(formConsulta.getIndFicheroResolutor())){
			//comprobar si se ha modificado, borrado o es un alta
			//Metemos el fichero resolutor en el bean
			FormFile fileRes = (FormFile)formulario.get("fileFichRes");
			if(null != fileRes){
				V50bClsFichero fich = new V50bClsFichero();
				String oid = formConsultaBack.getFichResolutor().getOid();
				if(StringUtils.isBlank(fileRes.getFileName())){
					//borrado
					if(StringUtils.isNotBlank(oid)){
						V50bPIDUtils.deleteDocument(oid);
					}
				}else{
					fich.setNombreReal(fileRes.getFileName());
					//comprobar si ya tiene oid para alta o modificacin
					if(StringUtils.isBlank(oid)){
						fich.setOid(V50bPIDUtils.addDocument(fileRes.getFileName(), fileRes.getFileData()));
					}else{
						fich.setOid(oid);
						V50bPIDUtils.modifyDocument(fileRes.getFileName(), fileRes.getFileData(), oid);
					}
				}
				formConsulta.setFichResolutor(fich);
			}
		}
				
		contexto.set("fCatalogacion", formConsulta);
				
		return mapping.findForward("ok");
	}

}
