package v50b.v50bOperacionesPaso.v50bgestion.v50bEstadoConsultas;

import java.util.ArrayList;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;
import es.ejie.frmk.listeners.base.Q70ListenerUtils;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;
import v50b.v50bBeans.V50bConsultaBean;
import v50b.v50bClasesComunes.V50bClsConstantes;
import v50b.v50bClasesComunes.V50bClsFecha;
import v50b.v50bClasesComunes.V50bClsInformes;
import v50b.v50bClasesComunes.V50bClsTrazas;
import v50b.v50bComun.V50bActionPasoOP;


/**
 * 
 * @author alata
 *
 */
public class V50bImprimirBusquedaAction extends V50bActionPasoOP {
	
	/**
	 * 
	 * @param contexto : Q70ContextoEJIE
	 * @param arg1 : ActionErrors
	 * @param arg2 : ActionMapping
	 * @param arg3 : ActionForm
	 * @param req : request
	 * @param arg5 : response
	 * @throws Exception Se lanza la excepcin
	*/
	protected void processOP(Q70ContextoEJIE contexto, ActionErrors arg1,
			ActionMapping arg2, ActionForm arg3, HttpServletRequest req,
			HttpServletResponse arg5) throws Exception {
		
		V50bClsTrazas.depura("V50bImprimirBusquedaAction.processOP() ");
		
		//Plantilla
		String strPlantilla = (String) contexto.get("plantillaBusqueda");
	
		//Parametros
		ArrayList arrParametros = new ArrayList();
		
		//Imagen
		StringBuffer imagenSB = new StringBuffer(Q70ListenerUtils.getApplicationProperty("RUTA_PLANTILLA"));
		imagenSB.append(V50bClsConstantes.CONSTANTE_LOGO_IVAP);
		String imagenString = imagenSB.toString();
		String imagen = this.getClass().getResource(imagenString).toString();
		
		arrParametros.add(imagen);
		
		//Fecha
		String fecha=V50bClsFecha.fncPresentarFechaSistemaCorta((String)contexto.get(V50bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA));
	    arrParametros.add(fecha);
		
	    //Idioma
		String idioma = Q70ListenerUtils.getLanguage(req);
		arrParametros.add(idioma);
				
		//Literales
		ArrayList arrLiterales = new ArrayList();
		arrLiterales.add("comun.estadoConsultas");
		arrLiterales.add("comun.pagina");
		arrLiterales.add("comun.fecha");
		arrLiterales.add("comun.ambito");
		arrLiterales.add("comun.estado");
		arrLiterales.add("comun.dificultad");
		arrLiterales.add("comun.duracion");
		arrLiterales.add("estadoConsultas.fueraPlazo");
		arrLiterales.add("estadoConsultas.fPlazo");
	//	arrLiterales.add("estadoConsultas.horas");
		arrLiterales.add("comun.consulta");
		arrLiterales.add("estadoConsultas.dias");
		arrLiterales.add("estadoConsultas.resolutor");
		arrLiterales.add("comun.si");
		arrLiterales.add("comun.no");

		//ArrayList Busqueda
		ArrayList arrDatosTablasBusquedas = (ArrayList)contexto.get("v50bListaEstConsultas");
		
		V50bConsultaBean datosConsulta = (V50bConsultaBean)contexto.get("v50bConsultasBeanOrig");
				
		String fechaCosulta=datosConsulta.getFechaConsulta();
		String consulta=datosConsulta.getConsulta();
		String descAmbito=datosConsulta.getAmbito().getDesamc();
		String descDific = datosConsulta.getDificultad().getDescc();
		String duracion = datosConsulta.getDificultad().getDias();
		String resolutor = datosConsulta.getNomResolutor();
		String estado = datosConsulta.getNomEstado();
		String fueraPlazo = datosConsulta.getIndFinPlazo();
							
		if(fechaCosulta!=null && !"".equals(fechaCosulta)){
			arrParametros.add(fechaCosulta);
		}
		else{
			arrParametros.add("");
		}
		if(consulta!=null && !"".equals(consulta)){
			arrParametros.add(consulta);
		}
		else{
			arrParametros.add("");
		}
		
		if (descAmbito!=null && !"".equals(descAmbito)){
			arrParametros.add(descAmbito);
		}
		else{
			arrParametros.add("");
		}
		if (descDific!=null && !"".equals(descDific)){
			arrParametros.add(descDific);
		}
		else{
			arrParametros.add("");
		}
		if (duracion!=null && !"".equals(duracion)){
			arrParametros.add(duracion);
		}
		else{
			arrParametros.add("");
		}
		if (resolutor!=null && !"".equals(resolutor)){
			arrParametros.add(resolutor);
		}
		else{
			arrParametros.add("");
		}
		if (estado!=null && !"".equals(estado)){
			arrParametros.add(estado);
		}
		else{
			arrParametros.add("");
		}
		if(StringUtils.isEmpty(fueraPlazo)) {
			arrParametros.add("");
		}else if (fueraPlazo.equals(V50bClsConstantes.CONSTANTE_NO) ){
			arrParametros.add(Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","comun.no",idioma));
		} else {
			arrParametros.add(Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","comun.si",idioma)); 
		}
					
		//Generamos PDF
		V50bClsInformes.fncSacarListadoFOPBeanAnidado(req,arg5,idioma,Q70ListenerUtils.getApplicationProperty("RUTA_PLANTILLA")+strPlantilla,arrParametros,arrLiterales,arrDatosTablasBusquedas,"v50bcomun", null);
		
	}
	
	/**
	 * 
	 * @param contexto : Q70ContextoEJIE
	 * @param arg1 : ActionErrors
	 * @param mapping : ActionMapping
	 * @param arg3 : ActionForm
	 * @param request : request
	 * @param arg5 : response
	 * @return ActionForward
	 * @throws Exception Se lanza la excepcin
	 */
	protected ActionForward processForward(Q70ContextoEJIE contexto,
			ActionErrors arg1, ActionMapping mapping, ActionForm arg3,
			HttpServletRequest request, HttpServletResponse arg5)
			throws Exception {
		
		V50bClsTrazas.depura("V50bImprimirBusquedaAction.processForward() ");
		
		if (arg1.isEmpty()){
			String hayBusqueda=(String)contexto.get("busqRealizada");
			
			if("false".equals(hayBusqueda)){
				contexto.set("v50bListaEstConsultas",null);
			}
			return mapping.findForward("ok");
		}
		else{
			return mapping.findForward("error");
		}
	}
}

