package v50b.v50bOperacionesPaso.v50bgestion.v50bCatalogoConsultas;

import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;
import es.ejie.frmk.listeners.base.Q70ListenerUtils;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;
import v50b.v50bBeans.V50bConsultaBean;
import v50b.v50bClasesComunes.V50bClsConstantes;
import v50b.v50bClasesComunes.V50bClsExcel;
import v50b.v50bClasesComunes.V50bClsTrazas;
import v50b.v50bClasesComunes.v50bBeansComunes.V50bCeldaExcelBean;
import v50b.v50bClasesComunes.v50bBeansComunes.V50bExcelBean;
import v50b.v50bComun.V50bActionPasoOP;


/**
 * 
 * @author acompes
 *
 */
public class V50bImprimirBusquedaExcelAction extends V50bActionPasoOP {
	
	/**
	 * 
	 * @param contexto : Q70ContextoEJIE
	 * @param errors : ActionErrors
	 * @param mapping : ActionMapping
	 * @param form : ActionForm
	 * @param request : request
	 * @param response : response
	 * @throws Exception Se lanza la excepcin
	 */
	protected void processOP(Q70ContextoEJIE contexto, ActionErrors errors,
			ActionMapping mapping, ActionForm form, HttpServletRequest request,
			HttpServletResponse response) throws Exception {
	}
	
	/**
	 * 
	 * @param contexto : Q70ContextoEJIE
	 * @param errors : ActionErrors
	 * @param mapping : ActionMapping
	 * @param form : ActionForm
	 * @param request : request
	 * @param response : response
	 * @return ActionForward
	 * @throws Exception Se lanza la excepcin
	 */
	protected ActionForward processForward(Q70ContextoEJIE contexto,
			ActionErrors errors, ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		V50bClsTrazas.depura("V50bImprimirBusquedaExcelAction.processForward() ");
		
		String idioma = Q70ListenerUtils.getLanguage(request);
		V50bConsultaBean filtro = (V50bConsultaBean)contexto.get("consultaBeanOrig");
		List lista = (ArrayList)contexto.get("v50bListaConsultas");
		
		final V50bExcelBean libroExcelBean = new V50bExcelBean();
		libroExcelBean.setNombreLibro(Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","v50bExcelEjemplo",(String)contexto.get(V50bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA)));
		
		final List celdas = new ArrayList();
		
		//Ancho de las columnas
		List anchoCols = new ArrayList();
		String[] auxCol0 = {"0","22"};
		anchoCols.add(auxCol0);
		String[] auxCol1 = {"1","35"};
		anchoCols.add(auxCol1);
		String[] auxCol2 = {"2","3"};
		anchoCols.add(auxCol2);
		String[] auxCol3 = {"3","25"};
		anchoCols.add(auxCol3);
		String[] auxCol4 = {"4","45"};
		anchoCols.add(auxCol4);
		String[] auxCol5 = {"5","20"};
		anchoCols.add(auxCol5);
		String[] auxCol6 = {"6","20"};
		anchoCols.add(auxCol6);
		String[] auxCol7 = {"7","35"};
		anchoCols.add(auxCol7);
		String[] auxCol8 = {"8","10"};
		anchoCols.add(auxCol8);
		String[] auxCol9 = {"9","65"};
		anchoCols.add(auxCol9);
		String[] auxCol10 = {"10","30"};
		anchoCols.add(auxCol10);
		libroExcelBean.setAnchoColumnas(anchoCols);
		
		//Plantilla de celda para el nombre de parmetro
		final V50bCeldaExcelBean celdaParamName = new V50bCeldaExcelBean();
		celdaParamName.setNumeroHoja(0);
		celdaParamName.setColorFuente(V50bClsExcel.BLANCO);
		celdaParamName.setColorFondo(V50bClsExcel.GRIS_OSCURO);
		celdaParamName.setAlineacionHorizontal(V50bClsExcel.H_IZQUIERDA);
		
		//Plantilla de celda para el valor de parmetro
		final V50bCeldaExcelBean celdaParamValue = new V50bCeldaExcelBean();
		celdaParamValue.setNumeroHoja(0);
		celdaParamValue.setColorFuente(V50bClsExcel.NEGRO);
		celdaParamValue.setColorFondo(V50bClsExcel.GRIS_CLARO);
		celdaParamValue.setAlineacionHorizontal(V50bClsExcel.H_IZQUIERDA);
		
		//Plantilla de celda para el valor de lista
		final V50bCeldaExcelBean celdaListaValue = new V50bCeldaExcelBean();
		celdaParamValue.setNumeroHoja(0);
		
		
		
		//Creamos las celdas de los parmetros
		//mbito
		celdaParamName.setPosicionY(0);
		celdaParamName.setPosicionX(0);
		celdaParamName.setDato(Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","comun.ambito",idioma)+":");
		celdas.add(celdaParamName.clone());
		
		//Subgategora
		celdaParamName.setPosicionY(0);
		celdaParamName.setPosicionX(V50bClsConstantes.TRES);
		celdaParamName.setDato(Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","comun.subcategoria",idioma)+":");
		celdas.add(celdaParamName.clone());
		
		//Dificultad
		celdaParamName.setPosicionY(2);
		celdaParamName.setPosicionX(0);
		celdaParamName.setDato(Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","comun.dificultad",idioma)+":");
		celdas.add(celdaParamName.clone());
		
		//Fuera Plazo
		celdaParamName.setPosicionY(2);
		celdaParamName.setPosicionX(V50bClsConstantes.TRES);
		celdaParamName.setDato(Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","catalogoConsultas.fueraPlazo",idioma)+":");
		celdas.add(celdaParamName.clone());
		
		//Resolutor
		celdaParamName.setPosicionY(V50bClsConstantes.CUATRO);
		celdaParamName.setPosicionX(0);
		celdaParamName.setDato(Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","comun.resolutor",idioma)+":");
		celdas.add(celdaParamName.clone());
		
		//Abreviaturas
		celdaParamName.setPosicionY(V50bClsConstantes.CUATRO);
		celdaParamName.setPosicionX(V50bClsConstantes.TRES);
		celdaParamName.setDato(Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","catalogoConsultas.abreviaturas",idioma)+":");
		celdas.add(celdaParamName.clone());
		
		//F. Consulta Desde
		celdaParamName.setPosicionY(V50bClsConstantes.SEIS);
		celdaParamName.setPosicionX(0);
		celdaParamName.setDato(Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","comun.fConsultaDesde",idioma)+":");
		celdas.add(celdaParamName.clone());
		
		//F. Consulta Hasta
		celdaParamName.setPosicionY(V50bClsConstantes.SEIS);
		celdaParamName.setPosicionX(V50bClsConstantes.TRES);
		celdaParamName.setDato(Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","comun.fConsultaHasta",idioma)+":");
		celdas.add(celdaParamName.clone());
		
		//F. Respuesta Desde
		celdaParamName.setPosicionY(V50bClsConstantes.OCHO);
		celdaParamName.setPosicionX(0);
		celdaParamName.setDato(Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","comun.fRespuestaDesde",idioma)+":");
		celdas.add(celdaParamName.clone());
		
		//F. Respuesta Hasta
		celdaParamName.setPosicionY(V50bClsConstantes.OCHO);
		celdaParamName.setPosicionX(V50bClsConstantes.TRES);
		celdaParamName.setDato(Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","comun.fRespuestaHasta",idioma)+":");
		celdas.add(celdaParamName.clone());
		
		//Consulta
		celdaParamName.setPosicionY(V50bClsConstantes.DIEZ);
		celdaParamName.setPosicionX(0);
		celdaParamName.setDato(Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","comun.consulta",idioma)+":");
		celdas.add(celdaParamName.clone());
		
		
		
		//Filtros
		//mbito
		celdaParamValue.setPosicionY(0);
		celdaParamValue.setPosicionX(1);
		celdaParamValue.setDato(filtro.getAmbito().getDesamc());
		celdas.add(celdaParamValue.clone());
		
		//Subgategora
		celdaParamValue.setPosicionY(0);
		celdaParamValue.setPosicionX(V50bClsConstantes.CUATRO);
		celdaParamValue.setDato(filtro.getSubcategoria().getDesCas());
		celdas.add(celdaParamValue.clone());
		
		//Dificultad
		celdaParamValue.setPosicionY(2);
		celdaParamValue.setPosicionX(1);
		celdaParamValue.setDato(filtro.getDificultad().getDescc());
		celdas.add(celdaParamValue.clone());
		
		//Fuera plazo
		celdaParamValue.setPosicionY(2);
		celdaParamValue.setPosicionX(V50bClsConstantes.CUATRO);
		if(StringUtils.isEmpty(filtro.getIndFinPlazo())) {
			celdaParamValue.setDato("");
		}else if(filtro.getIndFinPlazo().equals(V50bClsConstantes.CONSTANTE_NO)){
			celdaParamValue.setDato(Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","comun.no",idioma));
		} else {
			celdaParamValue.setDato(Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","comun.si",idioma)); 
		}
		celdas.add(celdaParamValue.clone());
		
		//Resolutor
		celdaParamValue.setPosicionY(V50bClsConstantes.CUATRO);
		celdaParamValue.setPosicionX(1);
		celdaParamValue.setDato(filtro.getNomResolutor());
		celdas.add(celdaParamValue.clone());
		
		//Abreviaturas
		celdaParamValue.setPosicionY(V50bClsConstantes.CUATRO);
		celdaParamValue.setPosicionX(V50bClsConstantes.CUATRO);
		if(StringUtils.isEmpty(filtro.getAbreviaturas())) {
			celdaParamValue.setDato("");
		}else if(filtro.getAbreviaturas().equals(V50bClsConstantes.CONSTANTE_NO)){
			celdaParamValue.setDato(Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","comun.no",idioma));
		} else {
			celdaParamValue.setDato(Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","comun.si",idioma)); 
		}
		celdas.add(celdaParamValue.clone());
		
		//F. Consulta Desde
		celdaParamValue.setPosicionY(V50bClsConstantes.SEIS);
		celdaParamValue.setPosicionX(1);
		celdaParamValue.setDato(filtro.getFechaConsultaD());
		celdas.add(celdaParamValue.clone());
		
		//F. Consulta Hasta
		celdaParamValue.setPosicionY(V50bClsConstantes.SEIS);
		celdaParamValue.setPosicionX(V50bClsConstantes.CUATRO);
		celdaParamValue.setDato(filtro.getFechaConsultaH());
		celdas.add(celdaParamValue.clone());
		
		//F. Respuesta Desde
		celdaParamValue.setPosicionY(V50bClsConstantes.OCHO);
		celdaParamValue.setPosicionX(1);
		celdaParamValue.setDato(filtro.getFechaRespuestaD());
		celdas.add(celdaParamValue.clone());
		
		//F. Respuesta Hasta
		celdaParamValue.setPosicionY(V50bClsConstantes.OCHO);
		celdaParamValue.setPosicionX(V50bClsConstantes.CUATRO);
		celdaParamValue.setDato(filtro.getFechaRespuestaH());
		celdas.add(celdaParamValue.clone());
		
		//Consulta
		celdaParamValue.setPosicionY(V50bClsConstantes.DIEZ);
		celdaParamValue.setPosicionX(1);
		celdaParamValue.setDato(filtro.getConsulta());
		celdas.add(celdaParamValue.clone());
		
		
		
		//CABECERA
		//24 horas
		celdaParamName.setPosicionY(V50bClsConstantes.TRECE);
		celdaParamName.setPosicionX(0);
		celdaParamName.setPosicionYAbajo(0);
		celdaParamName.setDato(Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","catalogoConsultas.horas",idioma));
		celdas.add(celdaParamName.clone());
		//Fuera Plazo
		celdaParamName.setPosicionY(V50bClsConstantes.TRECE);
		celdaParamName.setPosicionX(1);
		celdaParamName.setDato(Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","catalogoConsultas.fueraPlazo",idioma));
		celdas.add(celdaParamName.clone());
		//Fecha
		celdaParamName.setPosicionY(V50bClsConstantes.TRECE);
		celdaParamName.setPosicionX(2);
		celdaParamName.setPosicionXDerecha(1);
		celdaParamName.setDato(Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","comun.fecha",idioma));
		celdas.add(celdaParamName.clone());
		//Consulta
		celdaParamName.setPosicionY(V50bClsConstantes.TRECE);
		celdaParamName.setPosicionX(V50bClsConstantes.CUATRO);
		celdaParamName.setPosicionXDerecha(0);
		celdaParamName.setDato(Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","comun.consulta",idioma));
		celdas.add(celdaParamName.clone());
		//mbito
		celdaParamName.setPosicionY(V50bClsConstantes.TRECE);
		celdaParamName.setPosicionX(V50bClsConstantes.CINCO);
		celdaParamName.setPosicionXDerecha(1);
		celdaParamName.setDato(Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","comun.ambito",idioma));
		celdas.add(celdaParamName.clone());
		//Dificultad
		celdaParamName.setPosicionY(V50bClsConstantes.TRECE);
		celdaParamName.setPosicionX(V50bClsConstantes.SIETE);
		celdaParamName.setPosicionXDerecha(0);
		celdaParamName.setDato(Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","comun.dificultad",idioma));
		celdas.add(celdaParamName.clone());
		//Das
		celdaParamName.setPosicionY(V50bClsConstantes.TRECE);
		celdaParamName.setPosicionX(V50bClsConstantes.OCHO);
		celdaParamName.setDato(Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","comun.dias",idioma));
		celdas.add(celdaParamName.clone());
		//Resolutor
		celdaParamName.setPosicionY(V50bClsConstantes.TRECE);
		celdaParamName.setPosicionX(V50bClsConstantes.NUEVE);
		celdaParamName.setDato(Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","catalogoConsultas.resolutor",idioma));
		celdas.add(celdaParamName.clone());
		
		
		//LISTA
		int filaInicio = V50bClsConstantes.CATORCE;
		for(int i=0; i<lista.size(); i++){
			V50bConsultaBean auxBean = (V50bConsultaBean)lista.get(i);
			
			//24 horas
			celdaListaValue.setPosicionY(filaInicio+i);
			celdaListaValue.setPosicionX(0);
			if(V50bClsConstantes.CONSTANTE_SI.equals(auxBean.getHoras24())){
				celdaListaValue.setDato(Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","comun.si",idioma));
			} else {
				celdaListaValue.setDato(Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","comun.no",idioma));
			}
			celdas.add(celdaListaValue.clone());
			//Fuera plazo
			celdaListaValue.setPosicionY(filaInicio+i);
			celdaListaValue.setPosicionX(1);
			if(V50bClsConstantes.CONSTANTE_SI.equals(auxBean.getIndFinPlazo())){
				celdaListaValue.setDato(Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","comun.si",idioma));
			} else {
				celdaListaValue.setDato(Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","comun.no",idioma));
			}
			celdas.add(celdaListaValue.clone());
			//Fecha
			celdaListaValue.setPosicionY(filaInicio+i);
			celdaListaValue.setPosicionX(2);
			celdaListaValue.setPosicionXDerecha(1);
			celdaListaValue.setDato(auxBean.getFechaConsulta());
			celdas.add(celdaListaValue.clone());
			//Consulta
			celdaListaValue.setPosicionY(filaInicio+i);
			celdaListaValue.setPosicionX(V50bClsConstantes.CUATRO);
			celdaListaValue.setPosicionXDerecha(0);
			celdaListaValue.setDato(auxBean.getConsultaCompleta());
			celdas.add(celdaListaValue.clone());
			//mbito
			celdaListaValue.setPosicionY(filaInicio+i);
			celdaListaValue.setPosicionX(V50bClsConstantes.CINCO);
			celdaListaValue.setPosicionXDerecha(1);
			celdaListaValue.setDato(auxBean.getDescAmbito());
			celdas.add(celdaListaValue.clone());
			//Dificultad
			celdaListaValue.setPosicionY(filaInicio+i);
			celdaListaValue.setPosicionX(V50bClsConstantes.SIETE);
			celdaListaValue.setPosicionXDerecha(0);
			celdaListaValue.setDato(auxBean.getDescDificultad());
			celdas.add(celdaListaValue.clone());
			//Das
			celdaListaValue.setPosicionY(filaInicio+i);
			celdaListaValue.setPosicionX(V50bClsConstantes.OCHO);
			celdaListaValue.setDato(auxBean.getDias());
			celdas.add(celdaListaValue.clone());
			//Resolutor
			celdaListaValue.setPosicionY(filaInicio+i);
			celdaListaValue.setPosicionX(V50bClsConstantes.NUEVE);
			celdaListaValue.setDato(auxBean.getNomResolutor());
			celdas.add(celdaListaValue.clone());
			
		}
		
		libroExcelBean.setCeldas(celdas);
		libroExcelBean.setNombresHojas(new String[]{"hoja1"});
		
		V50bClsExcel.fncGenerarExcel(libroExcelBean, response);
		
		return null;
	}

}
