package v50b.v50bOperacionesPaso.v50bgestion.v50bCatalogoConsultas;

import java.util.ArrayList;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;
import es.ejie.frmk.listeners.base.Q70ListenerUtils;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;
import v50b.v50bBeans.V50bConsultaBean;
import v50b.v50bClasesComunes.V50bClsConstantes;
import v50b.v50bClasesComunes.V50bClsFecha;
import v50b.v50bClasesComunes.V50bClsInformes;
import v50b.v50bClasesComunes.V50bClsTrazas;
import v50b.v50bComun.V50bActionPasoOP;


/**
 * 
 * @author acompes
 *
 */
public class V50bImprimirBusquedaAction extends V50bActionPasoOP {
	
	/**
	 * 
	 * @param contexto : Q70ContextoEJIE
	 * @param arg1 : ActionErrors
	 * @param arg2 : ActionMapping
	 * @param arg3 : ActionForm
	 * @param req : request
	 * @param arg5 : response
	 * @throws Exception Se lanza la excepcin
	*/
	protected void processOP(Q70ContextoEJIE contexto, ActionErrors arg1,
			ActionMapping arg2, ActionForm arg3, HttpServletRequest req,
			HttpServletResponse arg5) throws Exception {
		
		V50bClsTrazas.depura("V50bImprimirBusquedaAction.processOP() ");
		
		//Plantilla
		String strPlantilla = (String) contexto.get("plantillaBusqueda");
	
		//Parametros
		ArrayList arrParametros = new ArrayList();
		
		//Imagen
		StringBuffer imagenSB = new StringBuffer(Q70ListenerUtils.getApplicationProperty("RUTA_PLANTILLA"));
		imagenSB.append(V50bClsConstantes.CONSTANTE_LOGO_IVAP);
		String imagenString = imagenSB.toString();
		String imagen = this.getClass().getResource(imagenString).toString();
		
		arrParametros.add(imagen);
		
		//Fecha
		String fecha=V50bClsFecha.fncPresentarFechaSistemaCorta((String)contexto.get(V50bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA));
	    arrParametros.add(fecha);
		
	    //Idioma
		String idioma = Q70ListenerUtils.getLanguage(req);
		arrParametros.add(idioma);
				
		//Literales
		ArrayList arrLiterales = new ArrayList();
		arrLiterales.add("comun.catalogoConsultas");
		arrLiterales.add("comun.pagina");
		arrLiterales.add("comun.fecha");
		arrLiterales.add("comun.ambito");
		arrLiterales.add("comun.subcategoria");
		arrLiterales.add("comun.fConsultaDesde");
		arrLiterales.add("comun.fConsultaHasta");
		arrLiterales.add("comun.fRespuestaDesde");
		arrLiterales.add("comun.fRespuestaHasta");
		arrLiterales.add("comun.dificultad");
		arrLiterales.add("catalogoConsultas.fueraPlazo");
		arrLiterales.add("catalogoConsultas.abreviaturas");
		arrLiterales.add("catalogoConsultas.horas");
		arrLiterales.add("comun.consulta");
		arrLiterales.add("comun.dias");
		arrLiterales.add("catalogoConsultas.resolutor");
		arrLiterales.add("comun.si");
		arrLiterales.add("comun.no");

		//ArrayList Busqueda
		ArrayList arrDatosTablasBusquedas = (ArrayList)contexto.get("v50bListaConsultas");
		
		V50bConsultaBean datosConsulta = (V50bConsultaBean)contexto.get("consultaBeanOrig");
		
		String descAmbito=datosConsulta.getAmbito().getDesamc();
		String descSubCat=datosConsulta.getSubcategoria().getDesCas();
		String resolutor = datosConsulta.getNomResolutor();
		String fConDesde = datosConsulta.getFechaConsultaD();
		String fConHasta = datosConsulta.getFechaConsultaH();
		String fResDesde = datosConsulta.getFechaRespuestaD();
		String fResHasta = datosConsulta.getFechaRespuestaH();
		String descDific = datosConsulta.getDificultad().getDescc();
		String indFinPlazo = datosConsulta.getIndFinPlazo();
		String abreviaturas = datosConsulta.getAbreviaturas();
		String consulta=datosConsulta.getConsulta();
		String fechaCosulta=datosConsulta.getFechaConsulta();
		
		if (descAmbito!=null && !"".equals(descAmbito)){
			arrParametros.add(descAmbito);
		}
		else{
			arrParametros.add("");
		}
		
		if (descSubCat!=null && !"".equals(descSubCat)){
			arrParametros.add(descSubCat);
		}
		else{
			arrParametros.add("");
		}
		
		if (resolutor!=null && !"".equals(resolutor)){
			arrParametros.add(resolutor);
		}
		else{
			arrParametros.add("");
		}
		
		if(fConDesde!=null && !"".equals(fConDesde)){
			arrParametros.add(fConDesde);
		}
		else{
			arrParametros.add("");
		}
		
		if(fConHasta!=null && !"".equals(fConHasta)){
			arrParametros.add(fConHasta);
		}
		else{
			arrParametros.add("");
		}
		
		if(fResDesde!=null && !"".equals(fResDesde)){
			arrParametros.add(fResDesde);
		}
		else{
			arrParametros.add("");
		}
		
		if(fResHasta!=null && !"".equals(fResHasta)){
			arrParametros.add(fResHasta);
		}
		else{
			arrParametros.add("");
		}
		
		if (descDific!=null && !"".equals(descDific)){
			arrParametros.add(descDific);
		}
		else{
			arrParametros.add("");
		}
		
		if(StringUtils.isEmpty(indFinPlazo)) {
			arrParametros.add("");
		}else if (indFinPlazo.equals(V50bClsConstantes.CONSTANTE_NO) ){
			arrParametros.add(Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","comun.no",idioma));
		} else {
			arrParametros.add(Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","comun.si",idioma)); 
		}
		
		if(StringUtils.isEmpty(abreviaturas)) {
			arrParametros.add("");
		}else if (abreviaturas.equals(V50bClsConstantes.CONSTANTE_NO) ){
			arrParametros.add(Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","comun.no",idioma));
		} else {
			arrParametros.add(Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","comun.si",idioma)); 
		}
		
		if(consulta!=null && !"".equals(consulta)){
			arrParametros.add(consulta);
		}
		else{
			arrParametros.add("");
		}
		
		if(fechaCosulta!=null && !"".equals(fechaCosulta)){
			arrParametros.add(fechaCosulta);
		}
		else{
			arrParametros.add("");
		}
					
		//Generamos PDF
		V50bClsInformes.fncSacarListadoFOP(req,arg5,idioma,Q70ListenerUtils.getApplicationProperty("RUTA_PLANTILLA")+strPlantilla,arrParametros,arrLiterales,arrDatosTablasBusquedas,"v50bcomun", null);
		
	}
	
	/**
	 * 
	 * @param contexto : Q70ContextoEJIE
	 * @param arg1 : ActionErrors
	 * @param mapping : ActionMapping
	 * @param arg3 : ActionForm
	 * @param request : request
	 * @param arg5 : response
	 * @return ActionForward
	 * @throws Exception Se lanza la excepcin
	 */
	protected ActionForward processForward(Q70ContextoEJIE contexto,
			ActionErrors arg1, ActionMapping mapping, ActionForm arg3,
			HttpServletRequest request, HttpServletResponse arg5)
			throws Exception {
		
		V50bClsTrazas.depura("V50bImprimirBusquedaAction.processForward() ");
		
		if (arg1.isEmpty()){
			String hayBusqueda=(String)contexto.get("busqRealizada");
			
			if("false".equals(hayBusqueda)){
				contexto.set("v50bListaConsultas",null);
			}
			return mapping.findForward("ok");
		}
		else{
			return mapping.findForward("error");
		}
	}
}

