package v50b.v50bOperacionesPaso.v50bgestion.v50bCatalogoConsultas;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;
import v50b.v50bBeans.V50bDificultadBean;
import v50b.v50bBeans.V50bResolutoresBean;
import v50b.v50bBeans.V50bSubcategoriasBean;
import v50b.v50bClasesComunes.V50bClsConstantes;
import v50b.v50bClasesComunes.V50bClsTrazas;
import v50b.v50bComun.V50bActionPasoOP;

/**
 * 
 * @author brey
 *
 */
public class V50bComboSubcatResolDificPostAjaxAction extends V50bActionPasoOP{
	
	/**
	 * 
	 * @param contexto : Q70ContextoEJIE
	 * @param errors : ActionErrors
	 * @param mapping : ActionMapping
	 * @param form : ActionForm
	 * @param request : request
	 * @param response : response
	 * @throws Exception Se lanza la excepcin
	 */
	protected void processOP(Q70ContextoEJIE contexto, ActionErrors errors,
			ActionMapping mapping, ActionForm form, HttpServletRequest request,
			HttpServletResponse response) throws Exception {
	}
	
	/**
	 * 
	 * @param contexto : Q70ContextoEJIE
	 * @param errors : ActionErrors
	 * @param mapping : ActionMapping
	 * @param form : ActionForm
	 * @param request : request
	 * @param response : response
	 * @return ActionForward
	 * @throws Exception Se lanza la excepcin
	 */
	protected ActionForward processForward(Q70ContextoEJIE contexto,
			ActionErrors errors, ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		V50bClsTrazas.depura("V50bComboSubcatResolDificPostAjaxAction.processForward() ");
		
		String idioma = (String)contexto.get(V50bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA);
		List lCombos = (ArrayList)contexto.get("v50bListaSubcategoriasResolutoresDificultades");
		List lSubcategorias = (ArrayList)lCombos.get(0);
		List lResolutores = (ArrayList)lCombos.get(1);
		List lDificultades = (ArrayList)lCombos.get(2);
		
		String busqueda = (String)contexto.get("busqRealizada");
		if(!"true".equals(busqueda) || lSubcategorias.size()>0) {
			contexto.set("v50bListaSubcategoriasAmbito", lSubcategorias);
			contexto.set("v50bListaResolutoresAmbito", lResolutores);
			contexto.set("v50bListaDificultadesAmbito", lDificultades);
		}
		
		final StringBuffer xml = new StringBuffer(450);
		xml.append("<?xml version=\"1.0\" encoding=\"ISO-8859-15\"?>");
		xml.append("<ajax-response><responseCombosSubcategoriaResolutorDificultad>");
		
		xml.append("<tamSubcategorias>");
		xml.append(lSubcategorias.size());
		xml.append("</tamSubcategorias>");
		
		xml.append("<tamResolutores>");
		xml.append(lResolutores.size());
		xml.append("</tamResolutores>");
		
		xml.append("<tamDificultades>");
		xml.append(lDificultades.size());
		xml.append("</tamDificultades>");
		
		for (int i=0; i<lSubcategorias.size(); i++){
			V50bSubcategoriasBean subcategoria = (V50bSubcategoriasBean)lSubcategorias.get(i);
			xml.append("<lSubcategoria"+i+">");
			if(V50bClsConstantes.CONSTANTE_CASTELLANO.equals(idioma)){
				xml.append(subcategoria.getDesCas());
			} else {
				xml.append(subcategoria.getDesEus());
			}
			xml.append("</lSubcategoria"+i+">");
			xml.append("<vSubcategoria"+i+">");
			xml.append(subcategoria.getCodSub());
			xml.append("</vSubcategoria"+i+">");
		}
		
		for (int i=0; i<lResolutores.size(); i++){
			V50bResolutoresBean resolutor = (V50bResolutoresBean)lResolutores.get(i);
			xml.append("<lResolutor"+i+">");
			if ("".equals(resolutor.getNombreApellidos())) {
				xml.append("null");
			}else {
				xml.append(resolutor.getNombreApellidos());
			}
			xml.append("</lResolutor"+i+">");
			xml.append("<vResolutor"+i+">");
			xml.append(resolutor.getCodResol());
			xml.append("</vResolutor"+i+">");
		}
		
		for (int i=0; i<lDificultades.size(); i++){
			V50bDificultadBean dificultad = (V50bDificultadBean)lDificultades.get(i);
			xml.append("<lDificultad"+i+">");
			if(V50bClsConstantes.CONSTANTE_CASTELLANO.equals(idioma)){
				xml.append(dificultad.getDescc());
			} else {
				xml.append(dificultad.getDesce());
			}
			xml.append("</lDificultad"+i+">");
			xml.append("<vDificultad"+i+">");
			xml.append(dificultad.getCoddif());
			xml.append("</vDificultad"+i+">");
		}
		
		xml.append("</responseCombosSubcategoriaResolutorDificultad></ajax-response>");
		response.setContentType("text/xml");
		response.setHeader("Cache-Control", "no-cache");
		PrintWriter pw = response.getWriter();
		pw.write(xml.toString());
		pw.close();

		return null;
	}

}
