package v50b.v50bOperacionesPaso.v50bconsultas.v50bIndicadoresGestion;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;
import es.ejie.frmk.listeners.base.Q70ListenerUtils;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;
import v50b.v50bBeans.V50bAmbitoBean;
import v50b.v50bBeans.V50bConsultaBean;
import v50b.v50bBeans.V50bConsultaEdadPorcentajeBean;
import v50b.v50bBeans.V50bConsultaGraficoBarraPorcentajeBean;
import v50b.v50bBeans.V50bConsultaGraficoPorcentajeBean;
import v50b.v50bBeans.V50bConsultaRespuestasPorTecnicoPorcentajeBean;
import v50b.v50bBeans.V50bCriteriosConsultaBean;
import v50b.v50bClasesComunes.V50bClsConstantes;
import v50b.v50bClasesComunes.V50bClsExcelGrafico;
import v50b.v50bClasesComunes.V50bClsTrazas;
import v50b.v50bComun.V50bActionPasoOP;
/**
 * 
 * @author mmonge
 *
 */
public class V50bExcelIndicadoresGestion extends V50bActionPasoOP {
	


	/**
	 * Este metodo sirve para crear una casilla
	 * 
	 * @author ilarburu
	 * @param x
	 *            La posicion x
	 * @param y
	 *            La posicion y
	 * @param string
	 *            El string de la casilla
	 * @return La datos de la casilla
	 */
	private List crearCasilla(int x, int y, String string) {
		List arrFila = new ArrayList();
		arrFila.add(Integer.toString(x));
		arrFila.add(Integer.toString(y));
		arrFila.add(string);
		return (arrFila);
	}

	/**
	 * Este metodo crea una columna de casillas
	 * 
	 * @author ilarburu
	 * @param x
	 *            Las posiciones x
	 * @param y
	 *            La posicion y
	 * @param string
	 *            El string
	 * @param datos
	 *            El array de datos
	 */
	private void crearColumna(int[] x, int y, String string, List datos) {
		for (int index = 0; index < x.length; index++) {
			datos.add(this.crearCasilla(x[index], y, string));
		}
	}

	
	/**
	 * Este metodo crea una fila de casillas
	 * 
	 * @author ilarburu
	 * @param x
	 *            La posicion x
	 * @param y
	 *            Las posiciones y
	 * @param string
	 *            El string
	 * @param datos
	 *            El array de datos
	 */
	private void crearFila(int x, int[] y, String string, List datos) {
		for (int index = 0; index < y.length; index++) {
			datos.add(this.crearCasilla(x, y[index], string));
		}
	}

	/**
	 * Este metodo sirve para cargar una lista de literales en el array de datos
	 * 
	 * @author ilarburu
	 * @param datos
	 *            El array de datos
	 * @param idioma
	 *            El idioma
	 * @param literales
	 *            La lista de literales
	 * @throws Exception
	 *             Cualquier excepcion
	 */
	private void cargarLiterales(List datos, String idioma, String[] literales)
			throws Exception {
		for (int index = 0; index < literales.length; index++) {
			datos.add(Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun", literales[index], idioma));
		}
	}


	/**
	 * 
	 * <p>Ttulo: </p>
	 * <p>Descripcin: </p>
	 * <p>Copyright: Copyright (c) Dec 16, 2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author mmonge
	 * @version 1.0
	 * @param contexto contexto
	 * @param request request
	 * @param response response
	 * @param radio radio
	 * @throws Exception Exception
	 */
	public void crearExcelPorEstadosConsulta(Q70ContextoEJIE contexto,HttpServletRequest request, HttpServletResponse response,String radio)throws Exception{
	
		V50bConsultaBean datosForm= (V50bConsultaBean)contexto.get("v50bindicadoresGestionBean");
		List lista = (ArrayList)contexto.get("v50bListaGraficos");
		List arrDatos = new ArrayList();
		List arrPosicion = new ArrayList();
		List arrDatos2 = new ArrayList();
		List arrPosicion2 = new ArrayList();
		
		
		// COLUMNA 0
		this.crearColumna(new int[] { 0, 1, 2, V50bClsConstantes.TRES,V50bClsConstantes.CUATRO,V50bClsConstantes.CINCO,V50bClsConstantes.SEIS },0, "CABECERA", arrPosicion);
		this.cargarLiterales(arrDatos, (String) contexto.get(V50bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA),new String[] { "comun.estado","","comun.th","", "comun.fechaDesde","","comun.dificultad"});
		// COLUMNA 1
		this.crearColumna(new int[] { 0, 1, 2,V50bClsConstantes.TRES,V50bClsConstantes.CUATRO,V50bClsConstantes.CINCO,V50bClsConstantes.SEIS },1, "STRING", arrPosicion);
		arrDatos.add(datosForm.getNomEstado());
		arrDatos.add("");
		arrDatos.add(datosForm.getSuscriptor().getNomTh());
		arrDatos.add("");
		arrDatos.add(datosForm.getFechaConsultaD());
		arrDatos.add("");
		arrDatos.add(datosForm.getDescDificultad());		
		// COLUMNA 2
		this.crearColumna(new int[] { 0, 1, 2, V50bClsConstantes.TRES,V50bClsConstantes.CUATRO,V50bClsConstantes.CINCO,V50bClsConstantes.SEIS},2, "CABECERA", arrPosicion);
		this.cargarLiterales(arrDatos, (String) contexto.get(V50bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA),new String[] { "comun.ambito","","comun.municipio", "","comun.fechaHasta","",""});
		// COLUMNA 3
		this.crearColumna(new int[] { 0, 1, 2,V50bClsConstantes.TRES,V50bClsConstantes.CUATRO,V50bClsConstantes.CINCO,V50bClsConstantes.SEIS },V50bClsConstantes.TRES, "STRING", arrPosicion);
		arrDatos.add(datosForm.getDescAmbito());
		arrDatos.add("");
		arrDatos.add(datosForm.getSuscriptor().getNomMunicipio());
		arrDatos.add("");
		arrDatos.add(datosForm.getFechaConsultaH());
		arrDatos.add("");
		arrDatos.add("");
		// CABECERA TABLA
		this.crearFila(V50bClsConstantes.NUEVE,new int[] { 0, 1, 2}, "CABECERA", arrPosicion);
		this.cargarLiterales(arrDatos, (String) contexto.get(V50bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA),	new String[] { "comun.estadoSuscriptor", "comun.nConsultas","comun.porcentaje" });
		// DATOS TABLA
		for (int index = 0; index < lista.size(); index++) {
			V50bConsultaGraficoPorcentajeBean  prueba = (V50bConsultaGraficoPorcentajeBean ) lista.get(index);
			int fila = V50bClsConstantes.DIEZ + index;
			arrPosicion.add(this.crearCasilla(fila, 0, "STRING"));
			arrDatos.add(prueba.getTituloGraf());
			arrPosicion2.add(this.crearCasilla(index, 0, "STRING"));
			arrDatos2.add(prueba.getTituloGraf());
			arrPosicion.add(this.crearCasilla(fila, 1, "NUMERIC"));
			arrDatos.add(prueba.getCountGraf());	
			arrPosicion2.add(this.crearCasilla(index, 1, "NUMERIC"));
			arrDatos2.add(prueba.getCountGraf());	
			arrPosicion.add(this.crearCasilla(fila, 2, "STRING"));			
			arrDatos.add(prueba.getPorcentajeGraf(prueba.getCountGraf()));
					
		}
		
		V50bClsExcelGrafico docExcel = new V50bClsExcelGrafico();
		String plantilla;
		if(V50bClsConstantes.ESTADO_CONSULTAS.equals(radio))
		{
			plantilla = (String) contexto.get("v50bPlantillaExcelPorEstado");
		}
		else {
			plantilla = (String) contexto.get("v50bPlantillaExcelIncorpCatalogo");
		}
		String strRutaExcel = Q70ListenerUtils.getApplicationProperty("RUTA_EXCEL")+ plantilla;
		HSSFWorkbook libro = new HSSFWorkbook();
		libro = docExcel.fncConectarExcel(strRutaExcel);
		libro.setSheetName(0, "Datos");
		libro.setSheetName(1,"Grafico");
		docExcel.fncEscribirExcelStyleFree(libro.getSheetAt(0),arrPosicion,arrDatos);
		docExcel.fncEscribirExcelStyleFree(libro.getSheetAt(1),arrPosicion2,arrDatos2);
		byte[] bytExcel = docExcel.fncGuardarExcel(libro);
		response.setContentType("application/vnd.ms-excel");
		response.setHeader("Content-disposition","inline;filename=GraficoPorEstadosConsulta.xls");
		response.getOutputStream().write(bytExcel);
	}
	
	
	/**
	 * 
	 * <p>Ttulo: </p>
	 * <p>Descripcin: </p>
	 * <p>Copyright: Copyright (c) Dec 29, 2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author mmonge
	 * @version 1.0
	 * @param contexto cntexto
	 * @param request request
	 * @param response response
	 * @throws Exception exception
	 */
	public void crearExcelPorLocalidad(Q70ContextoEJIE contexto,HttpServletRequest request, HttpServletResponse response)throws Exception{
		
		V50bConsultaBean datosForm= (V50bConsultaBean)contexto.get("v50bindicadoresGestionBean");
		List lista = (ArrayList)contexto.get("v50bListaGraficos");
		V50bCriteriosConsultaBean mibean= (V50bCriteriosConsultaBean)contexto.get("v50bCriteriosBean");
		String municipio= mibean.getLocalizacionMunicipio();
		List arrDatos1 = new ArrayList();
		List arrPosicion = new ArrayList();
		List arrDatos2 = new ArrayList();
		List arrPosicion2 = new ArrayList();
		
		
		// COLUMNA 0
		this.crearColumna(new int[] { 0, 1, 2, V50bClsConstantes.TRES,V50bClsConstantes.CUATRO,V50bClsConstantes.CINCO,V50bClsConstantes.SEIS },0, "CABECERA", arrPosicion);
		this.cargarLiterales(arrDatos1, (String) contexto.get(V50bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA),new String[] { "comun.estado","","comun.th","", "comun.fechaDesde","","comun.dificultad"});
		// COLUMNA 1
		this.crearColumna(new int[] { 0, 1, 2,V50bClsConstantes.TRES,V50bClsConstantes.CUATRO,V50bClsConstantes.CINCO,V50bClsConstantes.SEIS },1, "STRING", arrPosicion);
		arrDatos1.add(datosForm.getNomEstado());
		arrDatos1.add("");
		arrDatos1.add(datosForm.getSuscriptor().getNomTh());
		arrDatos1.add("");
		arrDatos1.add(datosForm.getFechaConsultaD());
		arrDatos1.add("");
		arrDatos1.add(datosForm.getDescDificultad());		
		// COLUMNA 2
		this.crearColumna(new int[] { 0, 1, 2, V50bClsConstantes.TRES,V50bClsConstantes.CUATRO,V50bClsConstantes.CINCO,V50bClsConstantes.SEIS},2, "CABECERA", arrPosicion);
		this.cargarLiterales(arrDatos1, (String) contexto.get(V50bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA),new String[] { "comun.ambito","","comun.municipio", "","comun.fechaHasta","",""});
		// COLUMNA 3
		this.crearColumna(new int[] { 0, 1, 2,V50bClsConstantes.TRES,V50bClsConstantes.CUATRO,V50bClsConstantes.CINCO,V50bClsConstantes.SEIS },V50bClsConstantes.TRES, "STRING", arrPosicion);
		arrDatos1.add(datosForm.getDescAmbito());
		arrDatos1.add("");
		arrDatos1.add(datosForm.getSuscriptor().getNomMunicipio());
		arrDatos1.add("");
		arrDatos1.add(datosForm.getFechaConsultaH());
		arrDatos1.add("");
		arrDatos1.add("");
		// CABECERA TABLA
		if ("".equals(municipio)){
			this.crearFila(V50bClsConstantes.NUEVE,new int[] { 0, 1, 2}, "CABECERA", arrPosicion);
			this.cargarLiterales(arrDatos1, (String) contexto.get(V50bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA),	new String[] { "comun.localidad", "comun.nLocalidades","comun.porcentajeLocalidades" });
			// DATOS TABLA
			for (int index = 0; index < lista.size(); index++) {
				V50bConsultaGraficoPorcentajeBean  prueba = (V50bConsultaGraficoPorcentajeBean ) lista.get(index);
				int fila = V50bClsConstantes.DIEZ + index;
				arrPosicion.add(this.crearCasilla(fila, 0, "STRING"));
				arrDatos1.add(prueba.getTituloGraf());
				arrPosicion2.add(this.crearCasilla(index, 0, "STRING"));
				arrDatos2.add(prueba.getTituloGraf());
				arrPosicion.add(this.crearCasilla(fila, 1, "NUMERIC"));
				arrDatos1.add(prueba.getCountGraf());	
				arrPosicion2.add(this.crearCasilla(index, 1, "NUMERIC"));
				arrDatos2.add(prueba.getCountGraf());	
				arrPosicion.add(this.crearCasilla(fila, 2, "STRING"));			
				arrDatos1.add(prueba.getPorcentajeGraf(prueba.getCountGraf()));
					
		}
		}
		else
		{		this.crearFila(V50bClsConstantes.NUEVE,new int[] { 0, 1, 2}, "CABECERA", arrPosicion);
				this.cargarLiterales(arrDatos1, (String) contexto.get(V50bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA),	new String[] { "comun.localidad", "comun.nLocalidades","comun.porcentajeLocalidades" });
				// DATOS TABLA
				for (int index = 0; index < lista.size(); index++) {
					V50bConsultaGraficoPorcentajeBean  prueba = (V50bConsultaGraficoPorcentajeBean ) lista.get(index);
					int fila = V50bClsConstantes.DIEZ + index;
					arrPosicion.add(this.crearCasilla(fila, 0, "STRING"));
					arrDatos1.add(prueba.getTituloGraf());
					arrPosicion2.add(this.crearCasilla(index, 0, "STRING"));
					arrDatos2.add(prueba.getTituloGraf());
					arrPosicion.add(this.crearCasilla(fila, 1, "NUMERIC"));
					arrDatos1.add(prueba.getCountGraf());	
					arrPosicion2.add(this.crearCasilla(index, 1, "NUMERIC"));
					arrDatos2.add(prueba.getCountGraf());	
					arrPosicion.add(this.crearCasilla(fila, 2, "STRING"));			
					arrDatos1.add(prueba.getPorcentajeGraf(prueba.getCountGraf()));
							
				}
			
		}
		
		
		V50bClsExcelGrafico docExcel = new V50bClsExcelGrafico();
		String plantilla = (String) contexto.get("v50bPlantillaExcelPorLocalidad");
		String strRutaExcel = Q70ListenerUtils.getApplicationProperty("RUTA_EXCEL")+ plantilla;
		HSSFWorkbook libro = new HSSFWorkbook();
		libro = docExcel.fncConectarExcel(strRutaExcel);
		libro.setSheetName(0, "Datos");
		libro.setSheetName(1,"Grafico");
		docExcel.fncEscribirExcelStyleFree(libro.getSheetAt(0),arrPosicion,arrDatos1);
		docExcel.fncEscribirExcelStyleFree(libro.getSheetAt(1),arrPosicion2,arrDatos2);
		byte[] bytExcel = docExcel.fncGuardarExcel(libro);
		response.setContentType("application/vnd.ms-excel");
		response.setHeader("Content-disposition","inline;filename=GraficoPorLocalidad.xls");
		response.getOutputStream().write(bytExcel);
	}
	/**
	 * 
	 * <p>Ttulo: </p>
	 * <p>Descripcin: </p>
	 * <p>Copyright: Copyright (c) Dec 16, 2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author mmonge
	 * @version 1.0
	 * @param contexto contexto
	 * @param request request
	 * @param response response
	 * @throws Exception Exception
	 */
	public void crearExcelPorSexo(Q70ContextoEJIE contexto,HttpServletRequest request, HttpServletResponse response)throws Exception{
		V50bConsultaBean datosForm= (V50bConsultaBean)contexto.get("v50bindicadoresGestionBean");
		List lista = (ArrayList)contexto.get("v50bListaGraficos");
		List arrDatos21 = new ArrayList();
		List arrPosicion = new ArrayList();
		List arrDatos2 = new ArrayList();
		List arrPosicion2 = new ArrayList();
		
		
		// COLUMNA 0
		this.crearColumna(new int[] { 0, 1, 2, V50bClsConstantes.TRES,V50bClsConstantes.CUATRO,V50bClsConstantes.CINCO,V50bClsConstantes.SEIS },0, "CABECERA", arrPosicion);
		this.cargarLiterales(arrDatos21, (String) contexto.get(V50bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA),new String[] { "comun.estado","","comun.th","", "comun.fechaDesde","","comun.dificultad"});
		// COLUMNA 1
		this.crearColumna(new int[] { 0, 1, 2,V50bClsConstantes.TRES,V50bClsConstantes.CUATRO,V50bClsConstantes.CINCO,V50bClsConstantes.SEIS },1, "STRING", arrPosicion);
		arrDatos21.add(datosForm.getNomEstado());
		arrDatos21.add("");
		arrDatos21.add(datosForm.getSuscriptor().getNomTh());
		arrDatos21.add("");
		arrDatos21.add(datosForm.getFechaConsultaD());
		arrDatos21.add("");
		arrDatos21.add(datosForm.getDescDificultad());		
		// COLUMNA 2
		this.crearColumna(new int[] { 0, 1, 2, V50bClsConstantes.TRES,V50bClsConstantes.CUATRO,V50bClsConstantes.CINCO,V50bClsConstantes.SEIS},2, "CABECERA", arrPosicion);
		this.cargarLiterales(arrDatos21, (String) contexto.get(V50bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA),new String[] { "comun.ambito","","comun.municipio", "","comun.fechaHasta","",""});
		// COLUMNA 3
		this.crearColumna(new int[] { 0, 1, 2,V50bClsConstantes.TRES,V50bClsConstantes.CUATRO,V50bClsConstantes.CINCO,V50bClsConstantes.SEIS },V50bClsConstantes.TRES, "STRING", arrPosicion);
		arrDatos21.add(datosForm.getDescAmbito());
		arrDatos21.add("");
		arrDatos21.add(datosForm.getSuscriptor().getNomMunicipio());
		arrDatos21.add("");
		arrDatos21.add(datosForm.getFechaConsultaH());
		arrDatos21.add("");
		arrDatos21.add("");
		// CABECERA TABLA
		this.crearFila(V50bClsConstantes.NUEVE,new int[] { 0, 1, 2}, "CABECERA", arrPosicion);
		this.cargarLiterales(arrDatos21, (String) contexto.get(V50bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA),	new String[] { "comun.sexoSuscriptor", "comun.nSuscriptores","comun.porcentaje" });
		int totalMujeres = 0;
		int totalHombres = 0;
		int totalNoInformados = 0;		
		
		// DATOS TABLA
		for (int index = 0; index < lista.size(); index++) {
			V50bConsultaGraficoPorcentajeBean  prueba = (V50bConsultaGraficoPorcentajeBean ) lista.get(index);
			int fila = V50bClsConstantes.DIEZ + index;
			double mujeres = 0;
			double hombres = 0;
			double noInformados =0;			
			String titulo=prueba.getTituloGraf();
			if ("M".equals(titulo))
			{
				mujeres = Double.parseDouble(prueba.getCountGraf());
			}
			else if("H".equals(titulo))
			{
				hombres = Double.parseDouble(prueba.getCountGraf());
			}
			else{
				noInformados =Double.parseDouble(prueba.getCountGraf());
			}					
			totalMujeres += mujeres;
			totalHombres += hombres;
			totalNoInformados+= noInformados;		
			arrPosicion.add(this.crearCasilla(fila, 0, "STRING"));
			arrDatos21.add(prueba.getTituloGraf());
			arrPosicion2.add(this.crearCasilla(index, 0, "STRING"));
			arrDatos2.add(prueba.getTituloGraf());
			arrPosicion.add(this.crearCasilla(fila, 1, "NUMERIC"));
			arrDatos21.add(prueba.getCountGraf());	
			arrPosicion2.add(this.crearCasilla(index, 1, "NUMERIC"));
			arrDatos2.add(prueba.getCountGraf());	
			arrPosicion.add(this.crearCasilla(fila, 2, "STRING"));			
			arrDatos21.add(prueba.getPorcentajeGraf(prueba.getCountGraf()));
					
		}
		
		V50bClsExcelGrafico docExcel = new V50bClsExcelGrafico();
		String plantilla = (String) contexto.get("v50bPlantillaExcelPorSexo");
		String strRutaExcel = Q70ListenerUtils.getApplicationProperty("RUTA_EXCEL")+ plantilla;
		HSSFWorkbook libro = new HSSFWorkbook();
		libro = docExcel.fncConectarExcel(strRutaExcel);
		libro.setSheetName(0, "Datos");
		libro.setSheetName(1,"Grafico");
		docExcel.fncEscribirExcelStyleFree(libro.getSheetAt(0),arrPosicion,arrDatos21);
		docExcel.fncEscribirExcelStyleFree(libro.getSheetAt(1),arrPosicion2,arrDatos2);
		byte[] bytExcel = docExcel.fncGuardarExcel(libro);
		response.setContentType("application/vnd.ms-excel");
		response.setHeader("Content-disposition","inline;filename=GraficoPorSexoSuscriptor.xls");
		response.getOutputStream().write(bytExcel);
	}

	/**
	 * 
	 * <p>Ttulo: </p>
	 * <p>Descripcin: </p>
	 * <p>Copyright: Copyright (c) Jan 7, 2009</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author mmonge
	 * @version 1.0
	 * @param contexto contexto
	 * @param request request
	 * @param response response
	 * @throws Exception exception
	 */
	public void crearExcelPorRespuestasTecnicos(Q70ContextoEJIE contexto,HttpServletRequest request, HttpServletResponse response)throws Exception{
		V50bConsultaBean datosForm= (V50bConsultaBean)contexto.get("v50bindicadoresGestionBean");
		List lista = (ArrayList)contexto.get("v50bListaGraficos");
		List arrDatos3 = new ArrayList();
		List arrPosicion = new ArrayList();
		List arrDatos2 = new ArrayList();
		List arrPosicion2 = new ArrayList();
		
		
		// COLUMNA 0
		this.crearColumna(new int[] { 0, 1, 2, V50bClsConstantes.TRES,V50bClsConstantes.CUATRO,V50bClsConstantes.CINCO,V50bClsConstantes.SEIS },0, "CABECERA", arrPosicion);
		this.cargarLiterales(arrDatos3, (String) contexto.get(V50bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA),new String[] { "comun.estado","","comun.th","", "comun.fechaDesde","","comun.dificultad"});
		// COLUMNA 1
		this.crearColumna(new int[] { 0, 1, 2,V50bClsConstantes.TRES,V50bClsConstantes.CUATRO,V50bClsConstantes.CINCO,V50bClsConstantes.SEIS },1, "STRING", arrPosicion);
		arrDatos3.add(datosForm.getNomEstado());
		arrDatos3.add("");
		arrDatos3.add(datosForm.getSuscriptor().getNomTh());
		arrDatos3.add("");
		arrDatos3.add(datosForm.getFechaConsultaD());
		arrDatos3.add("");
		arrDatos3.add(datosForm.getDescDificultad());		
		// COLUMNA 2
		this.crearColumna(new int[] { 0, 1, 2, V50bClsConstantes.TRES,V50bClsConstantes.CUATRO,V50bClsConstantes.CINCO,V50bClsConstantes.SEIS},2, "CABECERA", arrPosicion);
		this.cargarLiterales(arrDatos3, (String) contexto.get(V50bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA),new String[] { "comun.ambito","","comun.municipio", "","comun.fechaHasta","",""});
		// COLUMNA 3
		this.crearColumna(new int[] { 0, 1, 2,V50bClsConstantes.TRES,V50bClsConstantes.CUATRO,V50bClsConstantes.CINCO,V50bClsConstantes.SEIS },V50bClsConstantes.TRES, "STRING", arrPosicion);
		arrDatos3.add(datosForm.getDescAmbito());
		arrDatos3.add("");
		arrDatos3.add(datosForm.getSuscriptor().getNomMunicipio());
		arrDatos3.add("");
		arrDatos3.add(datosForm.getFechaConsultaH());
		arrDatos3.add("");
		arrDatos3.add("");
		// CABECERA TABLA
		this.crearFila(V50bClsConstantes.NUEVE,new int[] { 0, 1, 2}, "CABECERA", arrPosicion);
		this.cargarLiterales(arrDatos3, (String) contexto.get(V50bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA),	new String[] { "comun.idResolutor", "comun.nResolutores","comun.porcentaje" });
	
		
		// DATOS TABLA
		for (int index = 0; index < lista.size(); index++) {
			V50bConsultaRespuestasPorTecnicoPorcentajeBean  prueba = (V50bConsultaRespuestasPorTecnicoPorcentajeBean ) lista.get(index);
			int fila = V50bClsConstantes.DIEZ + index;
			arrPosicion.add(this.crearCasilla(fila, 0, "STRING"));
			arrDatos3.add(prueba.getTituloRespuestas());
			arrPosicion2.add(this.crearCasilla(index, 0, "STRING"));
			arrDatos2.add(prueba.getTituloRespuestas());
			arrPosicion.add(this.crearCasilla(fila, 1, "NUMERIC"));
			arrDatos3.add(prueba.getCountRespuestas());	
			arrPosicion2.add(this.crearCasilla(index, 1, "NUMERIC"));
			arrDatos2.add(prueba.getCountRespuestas());	
			arrPosicion.add(this.crearCasilla(fila, 2, "STRING"));			
			arrDatos3.add(prueba.getPorcentajeRespuestas(prueba.getCountRespuestas()));
					
		}
		
		V50bClsExcelGrafico docExcel = new V50bClsExcelGrafico();
		String plantilla = (String) contexto.get("v50bPlantillaExcelPorRespuestasTecnico");
		String strRutaExcel = Q70ListenerUtils.getApplicationProperty("RUTA_EXCEL")+ plantilla;
		HSSFWorkbook libro = new HSSFWorkbook();
		libro = docExcel.fncConectarExcel(strRutaExcel);
		libro.setSheetName(0, "Datos");
		libro.setSheetName(1,"Grafico");
		docExcel.fncEscribirExcelStyleFree(libro.getSheetAt(0),arrPosicion,arrDatos3);
		docExcel.fncEscribirExcelStyleFree(libro.getSheetAt(1),arrPosicion2,arrDatos2);
		byte[] bytExcel = docExcel.fncGuardarExcel(libro);
		response.setContentType("application/vnd.ms-excel");
		response.setHeader("Content-disposition","inline;filename=GraficoPorRespuestasTecnico.xls");
		response.getOutputStream().write(bytExcel);
	}


	/**
	 * 
	 * <p>Ttulo: </p>
	 * <p>Descripcin: </p>
	 * <p>Copyright: Copyright (c) Dec 30, 2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author mmonge
	 * @version 1.0
	 * @param contexto contexto
	 * @param request request
	 * @param response response
	 * @param radio radio
	 * @throws Exception exception
	 */
	public void crearExcelPorReenvios(Q70ContextoEJIE contexto,HttpServletRequest request, HttpServletResponse response, String radio)throws Exception{
		V50bConsultaBean datosForm= (V50bConsultaBean)contexto.get("v50bindicadoresGestionBean");
		List lista = (ArrayList)contexto.get("v50bListaGraficos");
		List arrDatos4 = new ArrayList();
		List arrPosicion = new ArrayList();
		List arrDatos2 = new ArrayList();
		List arrPosicion2 = new ArrayList();
		
		
		// COLUMNA 0
		this.crearColumna(new int[] { 0, 1, 2, V50bClsConstantes.TRES,V50bClsConstantes.CUATRO,V50bClsConstantes.CINCO,V50bClsConstantes.SEIS },0, "CABECERA", arrPosicion);
		this.cargarLiterales(arrDatos4, (String) contexto.get(V50bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA),new String[] { "comun.estado","","comun.th","", "comun.fechaDesde","","comun.dificultad"});
		// COLUMNA 1
		this.crearColumna(new int[] { 0, 1, 2,V50bClsConstantes.TRES,V50bClsConstantes.CUATRO,V50bClsConstantes.CINCO,V50bClsConstantes.SEIS },1, "STRING", arrPosicion);
		arrDatos4.add(datosForm.getNomEstado());
		arrDatos4.add("");
		arrDatos4.add(datosForm.getSuscriptor().getNomTh());
		arrDatos4.add("");
		arrDatos4.add(datosForm.getFechaConsultaD());
		arrDatos4.add("");
		arrDatos4.add(datosForm.getDescDificultad());		
		// COLUMNA 2
		this.crearColumna(new int[] { 0, 1, 2, V50bClsConstantes.TRES,V50bClsConstantes.CUATRO,V50bClsConstantes.CINCO,V50bClsConstantes.SEIS},2, "CABECERA", arrPosicion);
		this.cargarLiterales(arrDatos4, (String) contexto.get(V50bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA),new String[] { "comun.ambito","","comun.municipio", "","comun.fechaHasta","",""});
		// COLUMNA 3
		this.crearColumna(new int[] { 0, 1, 2,V50bClsConstantes.TRES,V50bClsConstantes.CUATRO,V50bClsConstantes.CINCO,V50bClsConstantes.SEIS },V50bClsConstantes.TRES, "STRING", arrPosicion);
		arrDatos4.add(datosForm.getDescAmbito());
		arrDatos4.add("");
		arrDatos4.add(datosForm.getSuscriptor().getNomMunicipio());
		arrDatos4.add("");
		arrDatos4.add(datosForm.getFechaConsultaH());
		arrDatos4.add("");
		arrDatos4.add("");
		// CABECERA TABLA
		this.crearFila(V50bClsConstantes.NUEVE,new int[] { 0, 1, 2}, "CABECERA", arrPosicion);
		if (V50bClsConstantes.CAUSAS_REENVIOS.equals(radio))
		{
			this.cargarLiterales(arrDatos4, (String) contexto.get(V50bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA),	new String[] { "comun.causasReenvios", "comun.nReenvios","comun.porcentaje" });
		}
		else if (V50bClsConstantes.CAUSAS_DENEGACION.equals(radio)){
			this.cargarLiterales(arrDatos4, (String) contexto.get(V50bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA),	new String[] { "comun.causasDengaciones", "comun.nDenegaciones","comun.porcentaje" });
		}
		else if (V50bClsConstantes.CAUSAS_RECHAZOS.equals(radio)){
			this.cargarLiterales(arrDatos4, (String) contexto.get(V50bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA),	new String[] { "comun.causasRechazos", "comun.nRechazos","comun.porcentaje" });
		}
			// DATOS TABLA
		for (int index = 0; index < lista.size(); index++) {
			V50bConsultaGraficoPorcentajeBean  prueba = (V50bConsultaGraficoPorcentajeBean ) lista.get(index);
			int fila = V50bClsConstantes.DIEZ + index;
			arrPosicion.add(this.crearCasilla(fila, 0, "STRING"));
			arrDatos4.add(prueba.getTituloGraf());
			arrPosicion2.add(this.crearCasilla(index, 0, "STRING"));
			arrDatos2.add(prueba.getTituloGraf());
			arrPosicion.add(this.crearCasilla(fila, 1, "NUMERIC"));
			arrDatos4.add(prueba.getCountGraf());	
			arrPosicion2.add(this.crearCasilla(index, 1, "NUMERIC"));
			arrDatos2.add(prueba.getCountGraf());	
			arrPosicion.add(this.crearCasilla(fila, 2, "STRING"));			
			arrDatos4.add(prueba.getPorcentajeGraf(prueba.getCountGraf()));
					
		}
		
		V50bClsExcelGrafico docExcel = new V50bClsExcelGrafico();
		String plantilla = (String) contexto.get("v50bPlantillaExcelPorEstado");
		String strRutaExcel = Q70ListenerUtils.getApplicationProperty("RUTA_EXCEL")+ plantilla;
		HSSFWorkbook libro = new HSSFWorkbook();
		libro = docExcel.fncConectarExcel(strRutaExcel);
		libro.setSheetName(0, "Datos");
		libro.setSheetName(1,"Grafico");
		docExcel.fncEscribirExcelStyleFree(libro.getSheetAt(0),arrPosicion,arrDatos4);
		docExcel.fncEscribirExcelStyleFree(libro.getSheetAt(1),arrPosicion2,arrDatos2);
		byte[] bytExcel = docExcel.fncGuardarExcel(libro);
		response.setContentType("application/vnd.ms-excel");
		response.setHeader("Content-disposition","inline;filename=GraficoPorReenvios.xls");
		response.getOutputStream().write(bytExcel);
		
	}


	/**
	 * 
	 * <p>Ttulo: </p>
	 * <p>Descripcin: </p>
	 * <p>Copyright: Copyright (c) Jan 8, 2009</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author mmonge
	 * @version 1.0
	 * @param contexto contexto
	 * @param request request
	 * @param response response
	 * @throws Exception exception
	 */
	public void crearExcelPorTipoTrabajoProfesion(Q70ContextoEJIE contexto,HttpServletRequest request, HttpServletResponse response)throws Exception{
		V50bConsultaBean datosForm= (V50bConsultaBean)contexto.get("v50bindicadoresGestionBean");
		List lista = (ArrayList)contexto.get("v50bListaGraficos");
		List arrDatos5 = new ArrayList();
		List arrPosicion = new ArrayList();
		List arrDatos2 = new ArrayList();
		List arrPosicion2 = new ArrayList();

		
		// COLUMNA 0
		this.crearColumna(new int[] { 0, 1, 2, V50bClsConstantes.TRES,V50bClsConstantes.CUATRO,V50bClsConstantes.CINCO,V50bClsConstantes.SEIS },0, "CABECERA", arrPosicion);
		this.cargarLiterales(arrDatos5, (String) contexto.get(V50bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA),new String[] { "comun.estado","","comun.th","", "comun.fechaDesde","","comun.dificultad"});
		// COLUMNA 1
		this.crearColumna(new int[] { 0, 1, 2,V50bClsConstantes.TRES,V50bClsConstantes.CUATRO,V50bClsConstantes.CINCO,V50bClsConstantes.SEIS },1, "STRING", arrPosicion);
		arrDatos5.add(datosForm.getNomEstado());
		arrDatos5.add("");
		arrDatos5.add(datosForm.getSuscriptor().getNomTh());
		arrDatos5.add("");
		arrDatos5.add(datosForm.getFechaConsultaD());
		arrDatos5.add("");
		arrDatos5.add(datosForm.getDescDificultad());		
		// COLUMNA 2
		this.crearColumna(new int[] { 0, 1, 2, V50bClsConstantes.TRES,V50bClsConstantes.CUATRO,V50bClsConstantes.CINCO,V50bClsConstantes.SEIS},2, "CABECERA", arrPosicion);
		this.cargarLiterales(arrDatos5, (String) contexto.get(V50bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA),new String[] { "comun.ambito","","comun.municipio", "","comun.fechaHasta","",""});
		// COLUMNA 3
		this.crearColumna(new int[] { 0, 1, 2,V50bClsConstantes.TRES,V50bClsConstantes.CUATRO,V50bClsConstantes.CINCO,V50bClsConstantes.SEIS },V50bClsConstantes.TRES, "STRING", arrPosicion);
		arrDatos5.add(datosForm.getDescAmbito());
		arrDatos5.add("");
		arrDatos5.add(datosForm.getSuscriptor().getNomMunicipio());
		arrDatos5.add("");
		arrDatos5.add(datosForm.getFechaConsultaH());
		arrDatos5.add("");
		arrDatos5.add("");
		// CABECERA TABLA
		this.crearFila(V50bClsConstantes.NUEVE,new int[] { 0, 1, 2,V50bClsConstantes.TRES,V50bClsConstantes.CUATRO,V50bClsConstantes.CINCO}, "CABECERA", arrPosicion);
		this.cargarLiterales(arrDatos5, (String) contexto.get(V50bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA),	new String[] { "comun.tipoTrabajo", "comun.nSuscriptores","comun.porcentaje" ,"comun.tipoProfesion", "comun.nSuscriptores","comun.porcentaje"});
		// DATOS TABLA
		List aux= new ArrayList();
		aux=(List)lista.get(0);//Aki esta tipo Trabajo
		for (int index = 0; index < aux.size(); index++) {
			V50bConsultaGraficoPorcentajeBean  prueba = (V50bConsultaGraficoPorcentajeBean ) aux.get(index);
			int fila = V50bClsConstantes.DIEZ + index;
			arrPosicion.add(this.crearCasilla(fila, 0, "STRING"));
			arrDatos5.add(prueba.getTituloGraf());
			arrPosicion2.add(this.crearCasilla(index+1, 0, "STRING"));
			arrDatos2.add(prueba.getTituloGraf());
			arrPosicion.add(this.crearCasilla(fila, 1, "NUMERIC"));
			arrDatos5.add(prueba.getCountGraf());	
			arrPosicion2.add(this.crearCasilla(index+1, 1, "NUMERIC"));
			arrDatos2.add(prueba.getCountGraf());	
			arrPosicion.add(this.crearCasilla(fila, 2, "STRING"));			
			arrDatos5.add(prueba.getPorcentajeGraf(prueba.getCountGraf()));
					
		}
		
		List aux1= new ArrayList();
		aux1=(List)lista.get(1);//Aki esta tipo profesion
		for (int index = 0; index < aux1.size(); index++) {
			V50bConsultaGraficoPorcentajeBean  prueba = (V50bConsultaGraficoPorcentajeBean ) aux1.get(index);
			int fila = V50bClsConstantes.DIEZ + index;
			arrPosicion.add(this.crearCasilla(fila, V50bClsConstantes.TRES, "STRING"));
			arrDatos5.add(prueba.getTituloGraf());
			arrPosicion2.add(this.crearCasilla(index+1, 2, "STRING"));
			arrDatos2.add(prueba.getTituloGraf());
			arrPosicion.add(this.crearCasilla(fila, V50bClsConstantes.CUATRO, "NUMERIC"));
			arrDatos5.add(prueba.getCountGraf());	
			arrPosicion2.add(this.crearCasilla(index+1, V50bClsConstantes.TRES, "NUMERIC"));
			arrDatos2.add(prueba.getCountGraf());	
			arrPosicion.add(this.crearCasilla(fila, V50bClsConstantes.CINCO, "STRING"));			
			arrDatos5.add(prueba.getPorcentajeGraf(prueba.getCountGraf()));
					
		}
		
		V50bClsExcelGrafico docExcel = new V50bClsExcelGrafico();
		String plantilla = (String) contexto.get("v50bPlantillaExcelPorTipoTrabajoProfesion");
		String strRutaExcel = Q70ListenerUtils.getApplicationProperty("RUTA_EXCEL")+ plantilla;
		HSSFWorkbook libro = new HSSFWorkbook();
		libro = docExcel.fncConectarExcel(strRutaExcel);
		libro.setSheetName(0, "Datos");
		libro.setSheetName(1,"Grafico");
		docExcel.fncEscribirExcelStyleFree(libro.getSheetAt(0),arrPosicion,arrDatos5);
		docExcel.fncEscribirExcelStyleFree(libro.getSheetAt(1),arrPosicion2,arrDatos2);
		byte[] bytExcel = docExcel.fncGuardarExcel(libro);
		response.setContentType("application/vnd.ms-excel");
		response.setHeader("Content-disposition","inline;filename=GraficoPorTipoTrabajoProfesion.xls");
		response.getOutputStream().write(bytExcel);
		
	}


	
	/**
	 * 
	 * <p>Ttulo: </p>
	 * <p>Descripcin: </p>
	 * <p>Copyright: Copyright (c) Jan 12, 2009</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author mmonge
	 * @version 1.0
	 * @param contexto contexto
	 * @param request request
	 * @param response response
	 * @throws Exception exception
	 */
	public void crearExcelPorEdad(Q70ContextoEJIE contexto,HttpServletRequest request, HttpServletResponse response)throws Exception{
		V50bConsultaBean datosForm= (V50bConsultaBean)contexto.get("v50bindicadoresGestionBean");
		List lista = (ArrayList)contexto.get("v50bListaGraficos");
		List arrDatos6 = new ArrayList();
		List arrPosicion = new ArrayList();
		List arrDatos2 = new ArrayList();
		List arrPosicion2 = new ArrayList();
		
		
		// COLUMNA 0
		this.crearColumna(new int[] { 0, 1, 2, V50bClsConstantes.TRES,V50bClsConstantes.CUATRO,V50bClsConstantes.CINCO,V50bClsConstantes.SEIS },0, "CABECERA", arrPosicion);
		this.cargarLiterales(arrDatos6, (String) contexto.get(V50bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA),new String[] { "comun.estado","","comun.th","", "comun.fechaDesde","","comun.dificultad"});
		// COLUMNA 1
		this.crearColumna(new int[] { 0, 1, 2,V50bClsConstantes.TRES,V50bClsConstantes.CUATRO,V50bClsConstantes.CINCO,V50bClsConstantes.SEIS },1, "STRING", arrPosicion);
		arrDatos6.add(datosForm.getNomEstado());
		arrDatos6.add("");
		arrDatos6.add(datosForm.getSuscriptor().getNomTh());
		arrDatos6.add("");
		arrDatos6.add(datosForm.getFechaConsultaD());
		arrDatos6.add("");
		arrDatos6.add(datosForm.getDescDificultad());		
		// COLUMNA 2
		this.crearColumna(new int[] { 0, 1, 2, V50bClsConstantes.TRES,V50bClsConstantes.CUATRO,V50bClsConstantes.CINCO,V50bClsConstantes.SEIS},2, "CABECERA", arrPosicion);
		this.cargarLiterales(arrDatos6, (String) contexto.get(V50bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA),new String[] { "comun.ambito","","comun.municipio", "","comun.fechaHasta","",""});
		// COLUMNA 3
		this.crearColumna(new int[] { 0, 1, 2,V50bClsConstantes.TRES,V50bClsConstantes.CUATRO,V50bClsConstantes.CINCO,V50bClsConstantes.SEIS },V50bClsConstantes.TRES, "STRING", arrPosicion);
		arrDatos6.add(datosForm.getDescAmbito());
		arrDatos6.add("");
		arrDatos6.add(datosForm.getSuscriptor().getNomMunicipio());
		arrDatos6.add("");
		arrDatos6.add(datosForm.getFechaConsultaH());
		arrDatos6.add("");
		arrDatos6.add("");
		// CABECERA TABLA
		this.crearFila(V50bClsConstantes.NUEVE,new int[] { 0, 1, 2}, "CABECERA", arrPosicion);
		this.cargarLiterales(arrDatos6, (String) contexto.get(V50bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA),	new String[] { "comun.RangoEdad", "comun.nEdad","comun.porcentaje" });
		// DATOS TABLA
		for (int index = 0; index < lista.size(); index++) {
			V50bConsultaEdadPorcentajeBean  prueba = (V50bConsultaEdadPorcentajeBean ) lista.get(index);
			int fila = V50bClsConstantes.DIEZ + index;
			arrPosicion.add(this.crearCasilla(fila, 0, "STRING"));
			arrDatos6.add(prueba.getTituloEdad());
			arrPosicion2.add(this.crearCasilla(index, 0, "STRING"));
			arrDatos2.add(prueba.getTituloEdad());
			arrPosicion.add(this.crearCasilla(fila, 1, "NUMERIC"));
			arrDatos6.add(prueba.getContEdad());	
			arrPosicion2.add(this.crearCasilla(index, 1, "NUMERIC"));
			arrDatos2.add(prueba.getContEdad());	
			arrPosicion.add(this.crearCasilla(fila, 2, "STRING"));			
			arrDatos6.add(prueba.getPorcentajeEstados((prueba.getContEdad())));
					
		}
		
		V50bClsExcelGrafico docExcel = new V50bClsExcelGrafico();
		String plantilla = (String) contexto.get("v50bPlantillaExcelPorEdad");
		String strRutaExcel = Q70ListenerUtils.getApplicationProperty("RUTA_EXCEL")+ plantilla;
		HSSFWorkbook libro = new HSSFWorkbook();
		libro = docExcel.fncConectarExcel(strRutaExcel);
		libro.setSheetName(0, "Datos");
		libro.setSheetName(1,"Grafico");
		docExcel.fncEscribirExcelStyleFree(libro.getSheetAt(0),arrPosicion,arrDatos6);
		docExcel.fncEscribirExcelStyleFree(libro.getSheetAt(1),arrPosicion2,arrDatos2);
		byte[] bytExcel = docExcel.fncGuardarExcel(libro);
		response.setContentType("application/vnd.ms-excel");
		response.setHeader("Content-disposition","inline;filename=GraficoPorEdad.xls");
		response.getOutputStream().write(bytExcel);
		
	}

	/**
	 * 
	 * <p>Ttulo: </p>
	 * <p>Descripcin: </p>
	 * <p>Copyright: Copyright (c) Jan 12, 2009</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author mmonge
	 * @version 1.0
	 * @param contexto contexto
	 * @param request request
	 * @param response response
	 * @throws Exception exception
	 */
	
	public void crearExcelPorMultiterm(Q70ContextoEJIE contexto,HttpServletRequest request, HttpServletResponse response)throws Exception{
		V50bConsultaBean datosForm= (V50bConsultaBean)contexto.get("v50bindicadoresGestionBean");
		List lista = (ArrayList)contexto.get("v50bListaGraficos");
		List arrDatos7 = new ArrayList();
		List arrPosicion = new ArrayList();
		List arrDatos2 = new ArrayList();
		List arrPosicion2 = new ArrayList();
		
		
		// COLUMNA 0
		this.crearColumna(new int[] { 0, 1, 2, V50bClsConstantes.TRES,V50bClsConstantes.CUATRO,V50bClsConstantes.CINCO,V50bClsConstantes.SEIS },0, "CABECERA", arrPosicion);
		this.cargarLiterales(arrDatos7, (String) contexto.get(V50bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA),new String[] { "comun.estado","","comun.th","", "comun.fechaDesde","","comun.dificultad"});
		// COLUMNA 1
		this.crearColumna(new int[] { 0, 1, 2,V50bClsConstantes.TRES,V50bClsConstantes.CUATRO,V50bClsConstantes.CINCO,V50bClsConstantes.SEIS },1, "STRING", arrPosicion);
		arrDatos7.add(datosForm.getNomEstado());
		arrDatos7.add("");
		arrDatos7.add(datosForm.getSuscriptor().getNomTh());
		arrDatos7.add("");
		arrDatos7.add(datosForm.getFechaConsultaD());
		arrDatos7.add("");
		arrDatos7.add(datosForm.getDescDificultad());		
		// COLUMNA 2
		this.crearColumna(new int[] { 0, 1, 2, V50bClsConstantes.TRES,V50bClsConstantes.CUATRO,V50bClsConstantes.CINCO,V50bClsConstantes.SEIS},2, "CABECERA", arrPosicion);
		this.cargarLiterales(arrDatos7, (String) contexto.get(V50bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA),new String[] { "comun.ambito","","comun.municipio", "","comun.fechaHasta","",""});
		// COLUMNA 3
		this.crearColumna(new int[] { 0, 1, 2,V50bClsConstantes.TRES,V50bClsConstantes.CUATRO,V50bClsConstantes.CINCO,V50bClsConstantes.SEIS },V50bClsConstantes.TRES, "STRING", arrPosicion);
		arrDatos7.add(datosForm.getDescAmbito());
		arrDatos7.add("");
		arrDatos7.add(datosForm.getSuscriptor().getNomMunicipio());
		arrDatos7.add("");
		arrDatos7.add(datosForm.getFechaConsultaH());
		arrDatos7.add("");
		arrDatos7.add("");
		// CABECERA TABLA
		this.crearFila(V50bClsConstantes.NUEVE,new int[] { 0, 1, 2}, "CABECERA", arrPosicion);
		this.cargarLiterales(arrDatos7, (String) contexto.get(V50bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA),	new String[] { "comun.EMultiterm", "comun.nConsultas","comun.porcentaje" });
		// DATOS TABLA
		for (int index = 0; index < lista.size(); index++) {
			V50bConsultaGraficoPorcentajeBean  prueba = (V50bConsultaGraficoPorcentajeBean ) lista.get(index);
			int fila = V50bClsConstantes.DIEZ + index;
			arrPosicion.add(this.crearCasilla(fila, 0, "STRING"));
			arrDatos7.add(prueba.getTituloGraf());
			arrPosicion2.add(this.crearCasilla(index, 0, "STRING"));
			arrDatos2.add(prueba.getTituloGraf());
			arrPosicion.add(this.crearCasilla(fila, 1, "NUMERIC"));
			arrDatos7.add(prueba.getCountGraf());	
			arrPosicion2.add(this.crearCasilla(index, 1, "NUMERIC"));
			arrDatos2.add(prueba.getCountGraf());	
			arrPosicion.add(this.crearCasilla(fila, 2, "STRING"));			
			arrDatos7.add(prueba.getPorcentajeGraf((prueba.getCountGraf())));
					
		}
		
		V50bClsExcelGrafico docExcel = new V50bClsExcelGrafico();
		String plantilla = (String) contexto.get("v50bPlantillaExcelPorMultiterm");
		String strRutaExcel = Q70ListenerUtils.getApplicationProperty("RUTA_EXCEL")+ plantilla;
		HSSFWorkbook libro = new HSSFWorkbook();
		libro = docExcel.fncConectarExcel(strRutaExcel);
		libro.setSheetName(0, "Datos");
		libro.setSheetName(1,"Grafico");
		docExcel.fncEscribirExcelStyleFree(libro.getSheetAt(0),arrPosicion,arrDatos7);
		docExcel.fncEscribirExcelStyleFree(libro.getSheetAt(1),arrPosicion2,arrDatos2);
		byte[] bytExcel = docExcel.fncGuardarExcel(libro);
		response.setContentType("application/vnd.ms-excel");
		response.setHeader("Content-disposition","inline;filename=GraficoPorMultiterm.xls");
		response.getOutputStream().write(bytExcel);
		
	}
	/**
	 * 
	 * <p>Ttulo: </p>
	 * <p>Descripcin: </p>
	 * <p>Copyright: Copyright (c) Jan 13, 2009</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author mmonge
	 * @version 1.0
	 * @param contexto contexto
	 * @param request request
	 * @param response response
	 * @throws Exception exception
	 */
	public void crearExcelPorDificultad(Q70ContextoEJIE contexto,HttpServletRequest request, HttpServletResponse response)throws Exception{
		
		V50bConsultaBean datosForm= (V50bConsultaBean)contexto.get("v50bindicadoresGestionBean");
		List lista = (ArrayList)contexto.get("v50bListaGraficos");
		List arrDatos8 = new ArrayList();
		List arrPosicion = new ArrayList();
		List arrDatos2 = new ArrayList();
		List arrPosicion2 = new ArrayList();
		
		
		// COLUMNA 0
		this.crearColumna(new int[] { 0, 1, 2, V50bClsConstantes.TRES,V50bClsConstantes.CUATRO,V50bClsConstantes.CINCO,V50bClsConstantes.SEIS },0, "CABECERA", arrPosicion);
		this.cargarLiterales(arrDatos8, (String) contexto.get(V50bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA),new String[] { "comun.estado","","comun.th","", "comun.fechaDesde","","comun.dificultad"});
		// COLUMNA 1
		this.crearColumna(new int[] { 0, 1, 2,V50bClsConstantes.TRES,V50bClsConstantes.CUATRO,V50bClsConstantes.CINCO,V50bClsConstantes.SEIS },1, "STRING", arrPosicion);
		arrDatos8.add(datosForm.getNomEstado());
		arrDatos8.add("");
		arrDatos8.add(datosForm.getSuscriptor().getNomTh());
		arrDatos8.add("");
		arrDatos8.add(datosForm.getFechaConsultaD());
		arrDatos8.add("");
		arrDatos8.add(datosForm.getDescDificultad());		
		// COLUMNA 2
		this.crearColumna(new int[] { 0, 1, 2, V50bClsConstantes.TRES,V50bClsConstantes.CUATRO,V50bClsConstantes.CINCO,V50bClsConstantes.SEIS},2, "CABECERA", arrPosicion);
		this.cargarLiterales(arrDatos8, (String) contexto.get(V50bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA),new String[] { "comun.ambito","","comun.municipio", "","comun.fechaHasta","",""});
		// COLUMNA 3
		this.crearColumna(new int[] { 0, 1, 2,V50bClsConstantes.TRES,V50bClsConstantes.CUATRO,V50bClsConstantes.CINCO,V50bClsConstantes.SEIS },V50bClsConstantes.TRES, "STRING", arrPosicion);
		arrDatos8.add(datosForm.getDescAmbito());
		arrDatos8.add("");
		arrDatos8.add(datosForm.getSuscriptor().getNomMunicipio());
		arrDatos8.add("");
		arrDatos8.add(datosForm.getFechaConsultaH());
		arrDatos8.add("");
		arrDatos8.add("");
		// CABECERA TABLA
		this.crearFila(V50bClsConstantes.NUEVE,new int[] { 0, 1, 2}, "CABECERA", arrPosicion);
		this.cargarLiterales(arrDatos8, (String) contexto.get(V50bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA),	new String[] { "comun.dificultadConsulta", "comun.nConsultas","comun.porcentaje" });
		// DATOS TABLA
		for (int index = 0; index < lista.size(); index++) {
			V50bConsultaGraficoPorcentajeBean  prueba = (V50bConsultaGraficoPorcentajeBean ) lista.get(index);
			int fila = V50bClsConstantes.DIEZ + index;
			arrPosicion.add(this.crearCasilla(fila, 0, "STRING"));
			arrDatos8.add(prueba.getTituloGraf());
			arrPosicion2.add(this.crearCasilla(index, 0, "STRING"));
			arrDatos2.add(prueba.getTituloGraf());
			arrPosicion.add(this.crearCasilla(fila, 1, "NUMERIC"));
			arrDatos8.add(prueba.getCountGraf());	
			arrPosicion2.add(this.crearCasilla(index, 1, "NUMERIC"));
			arrDatos2.add(prueba.getCountGraf());	
			arrPosicion.add(this.crearCasilla(fila, 2, "STRING"));			
			arrDatos8.add(prueba.getPorcentajeGraf(prueba.getCountGraf()));
					
		}
		
		V50bClsExcelGrafico docExcel = new V50bClsExcelGrafico();
		String plantilla = (String) contexto.get("v50bPlantillaExcelPorDificultad");		
		String strRutaExcel = Q70ListenerUtils.getApplicationProperty("RUTA_EXCEL")+ plantilla;
		HSSFWorkbook libro = new HSSFWorkbook();
		libro = docExcel.fncConectarExcel(strRutaExcel);
		libro.setSheetName(0, "Datos");
		libro.setSheetName(1,"Grafico");
		docExcel.fncEscribirExcelStyleFree(libro.getSheetAt(0),arrPosicion,arrDatos8);
		docExcel.fncEscribirExcelStyleFree(libro.getSheetAt(1),arrPosicion2,arrDatos2);
		byte[] bytExcel = docExcel.fncGuardarExcel(libro);
		response.setContentType("application/vnd.ms-excel");
		response.setHeader("Content-disposition","inline;filename=GraficoPorDificultad.xls");
		response.getOutputStream().write(bytExcel);
	}
	/**
	 * 
	 * <p>Ttulo: </p>
	 * <p>Descripcin: </p>
	 * <p>Copyright: Copyright (c) Jan 13, 2009</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author mmonge
	 * @version 1.0
	 * @param contexto contexto 
	 * @param request request
	 * @param response reponse
	 * @throws Exception exception
	 */
	public void crearExcelPorMediosLlegada(Q70ContextoEJIE contexto,HttpServletRequest request, HttpServletResponse response)throws Exception{
		
		V50bConsultaBean datosForm= (V50bConsultaBean)contexto.get("v50bindicadoresGestionBean");
		List lista = (ArrayList)contexto.get("v50bListaGraficos");
		List arrDatos9 = new ArrayList();
		List arrPosicion = new ArrayList();
		List arrDatos2 = new ArrayList();
		List arrPosicion2 = new ArrayList();
		
		
		// COLUMNA 0
		this.crearColumna(new int[] { 0, 1, 2, V50bClsConstantes.TRES,V50bClsConstantes.CUATRO,V50bClsConstantes.CINCO,V50bClsConstantes.SEIS },0, "CABECERA", arrPosicion);
		this.cargarLiterales(arrDatos9, (String) contexto.get(V50bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA),new String[] { "comun.estado","","comun.th","", "comun.fechaDesde","","comun.dificultad"});
		// COLUMNA 1
		this.crearColumna(new int[] { 0, 1, 2,V50bClsConstantes.TRES,V50bClsConstantes.CUATRO,V50bClsConstantes.CINCO,V50bClsConstantes.SEIS },1, "STRING", arrPosicion);
		arrDatos9.add(datosForm.getNomEstado());
		arrDatos9.add("");
		arrDatos9.add(datosForm.getSuscriptor().getNomTh());
		arrDatos9.add("");
		arrDatos9.add(datosForm.getFechaConsultaD());
		arrDatos9.add("");
		arrDatos9.add(datosForm.getDescDificultad());		
		// COLUMNA 2
		this.crearColumna(new int[] { 0, 1, 2, V50bClsConstantes.TRES,V50bClsConstantes.CUATRO,V50bClsConstantes.CINCO,V50bClsConstantes.SEIS},2, "CABECERA", arrPosicion);
		this.cargarLiterales(arrDatos9, (String) contexto.get(V50bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA),new String[] { "comun.ambito","","comun.municipio", "","comun.fechaHasta","",""});
		// COLUMNA 3
		this.crearColumna(new int[] { 0, 1, 2,V50bClsConstantes.TRES,V50bClsConstantes.CUATRO,V50bClsConstantes.CINCO,V50bClsConstantes.SEIS },V50bClsConstantes.TRES, "STRING", arrPosicion);
		arrDatos9.add(datosForm.getDescAmbito());
		arrDatos9.add("");
		arrDatos9.add(datosForm.getSuscriptor().getNomMunicipio());
		arrDatos9.add("");
		arrDatos9.add(datosForm.getFechaConsultaH());
		arrDatos9.add("");
		arrDatos9.add("");
		// CABECERA TABLA
		this.crearFila(V50bClsConstantes.NUEVE,new int[] { 0, 1, 2}, "CABECERA", arrPosicion);
		this.cargarLiterales(arrDatos9, (String) contexto.get(V50bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA),	new String[] { "comun.mediosLlegada", "comun.nConsultas","comun.porcentaje" });
		// DATOS TABLA
		for (int index = 0; index < lista.size(); index++) {
			V50bConsultaGraficoPorcentajeBean  prueba = (V50bConsultaGraficoPorcentajeBean ) lista.get(index);
			int fila = V50bClsConstantes.DIEZ + index;
			arrPosicion.add(this.crearCasilla(fila, 0, "STRING"));
			arrDatos9.add(prueba.getTituloGraf());
			arrPosicion2.add(this.crearCasilla(index, 0, "STRING"));
			arrDatos2.add(prueba.getTituloGraf());
			arrPosicion.add(this.crearCasilla(fila, 1, "NUMERIC"));
			arrDatos9.add(prueba.getCountGraf());	
			arrPosicion2.add(this.crearCasilla(index, 1, "NUMERIC"));
			arrDatos2.add(prueba.getCountGraf());	
			arrPosicion.add(this.crearCasilla(fila, 2, "STRING"));			
			arrDatos9.add(prueba.getPorcentajeGraf(prueba.getCountGraf()));
					
		}
		
		V50bClsExcelGrafico docExcel = new V50bClsExcelGrafico();
		String plantilla = (String) contexto.get("v50bPlantillaExcelPorMedios");		
		String strRutaExcel = Q70ListenerUtils.getApplicationProperty("RUTA_EXCEL")+ plantilla;
		HSSFWorkbook libro = new HSSFWorkbook();
		libro = docExcel.fncConectarExcel(strRutaExcel);
		libro.setSheetName(0, "Datos");
		libro.setSheetName(1,"Grafico");
		docExcel.fncEscribirExcelStyleFree(libro.getSheetAt(0),arrPosicion,arrDatos9);
		docExcel.fncEscribirExcelStyleFree(libro.getSheetAt(1),arrPosicion2,arrDatos2);
		byte[] bytExcel = docExcel.fncGuardarExcel(libro);
		response.setContentType("application/vnd.ms-excel");
		response.setHeader("Content-disposition","inline;filename=GraficoPorMediosLlegada.xls");
		response.getOutputStream().write(bytExcel);
	}
	/**
	 * 
	 * <p>Ttulo: </p>
	 * <p>Descripcin: </p>
	 * <p>Copyright: Copyright (c) Jan 19, 2009</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author mmonge
	 * @version 1.0
	 * @param contexto contexto
	 * @param request request
	 * @param response response
	 * @param radio radio
	 * @throws Exception exception
	 */
	public void crearExcelPorEvolucionConsulta(Q70ContextoEJIE contexto,HttpServletRequest request, HttpServletResponse response,String radio)throws Exception{
		V50bConsultaBean datosForm= (V50bConsultaBean)contexto.get("v50bindicadoresGestionBean");
		List lista = (ArrayList)contexto.get("v50bListaGraficos");
		List arrDatos10 = new ArrayList();
		List arrPosicion = new ArrayList();
		List arrDatos2 = new ArrayList();
		List arrPosicion2 = new ArrayList();		
		// COLUMNA 0
		this.crearColumna(new int[] { 0, 1, 2, V50bClsConstantes.TRES,V50bClsConstantes.CUATRO,V50bClsConstantes.CINCO,V50bClsConstantes.SEIS },0, "CABECERA", arrPosicion);
		this.cargarLiterales(arrDatos10, (String) contexto.get(V50bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA),new String[] { "comun.estado","","comun.th","", "comun.fechaDesde","","comun.dificultad"});
		// COLUMNA 1
		this.crearColumna(new int[] { 0, 1, 2,V50bClsConstantes.TRES,V50bClsConstantes.CUATRO,V50bClsConstantes.CINCO,V50bClsConstantes.SEIS },1, "STRING", arrPosicion);
		arrDatos10.add(datosForm.getNomEstado());
		arrDatos10.add("");
		arrDatos10.add(datosForm.getSuscriptor().getNomTh());
		arrDatos10.add("");
		arrDatos10.add(datosForm.getFechaConsultaD());
		arrDatos10.add("");
		arrDatos10.add(datosForm.getDescDificultad());		
		// COLUMNA 2
		this.crearColumna(new int[] { 0, 1, 2, V50bClsConstantes.TRES,V50bClsConstantes.CUATRO,V50bClsConstantes.CINCO,V50bClsConstantes.SEIS},2, "CABECERA", arrPosicion);
		this.cargarLiterales(arrDatos10, (String) contexto.get(V50bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA),new String[] { "comun.ambito","","comun.municipio", "","comun.fechaHasta","",""});
		// COLUMNA 3
		this.crearColumna(new int[] { 0, 1, 2,V50bClsConstantes.TRES,V50bClsConstantes.CUATRO,V50bClsConstantes.CINCO,V50bClsConstantes.SEIS },V50bClsConstantes.TRES, "STRING", arrPosicion);
		arrDatos10.add(datosForm.getDescAmbito());
		arrDatos10.add("");
		arrDatos10.add(datosForm.getSuscriptor().getNomMunicipio());
		arrDatos10.add("");
		arrDatos10.add(datosForm.getFechaConsultaH());
		arrDatos10.add("");
		arrDatos10.add("");
		// CABECERA TABLA
		this.crearFila(V50bClsConstantes.NUEVE,new int[] { 0, 1, 2,V50bClsConstantes.TRES}, "CABECERA", arrPosicion);
		if (V50bClsConstantes.EVOL_CONSULTAS_RESPUESTAS.equals(radio)){
			this.cargarLiterales(arrDatos10, (String) contexto.get(V50bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA),	new String[] { "comun.consultas", "comun.nconsultas","comun.respuestas" ,"comun.nRespuestas"});
		}
		else {
			this.cargarLiterales(arrDatos10, (String) contexto.get(V50bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA),	new String[] { "comun.altas", "comun.naltas","comun.bajas" ,"comun.nBajas"});

		}
			// DATOS TABLA
		String DatoC="";
		String DatoR="";
		String DatoC2="";
		String DatoR2="";
		for (int index = 0; index < lista.size(); index++) {
			V50bConsultaGraficoBarraPorcentajeBean  prueba = (V50bConsultaGraficoBarraPorcentajeBean ) lista.get(index);
			int fila = V50bClsConstantes.DIEZ + index;
			String anyo= prueba.getFecha().substring(V50bClsConstantes.CINCO, V50bClsConstantes.SIETE);
			if (V50bClsConstantes.EVOL_CONSULTAS_RESPUESTAS.equals(radio)){
				String strConsultas = Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","comun.consultas",(String) contexto.get(V50bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA));
				String strRespuestas = Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","comun.respuestas",(String) contexto.get(V50bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA));
				DatoC = strConsultas.concat(" ").concat(prueba.getMes().toUpperCase().concat(" '").concat(anyo));
				DatoR = strRespuestas.concat(" ").concat(prueba.getMes().toUpperCase().concat(" '").concat(anyo));
			}
			else{
				String strAltas = Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","comun.altaGrafico",(String) contexto.get(V50bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA));
				String strBajas = Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","comun.bajaGrafico",(String) contexto.get(V50bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA));
				DatoC = strAltas.concat(" ").concat(prueba.getMes().toUpperCase().concat(" '").concat(anyo));
				DatoR = strBajas.concat(" ").concat(prueba.getMes().toUpperCase().concat(" '").concat(anyo));
		
			}
				arrPosicion.add(this.crearCasilla(fila, 0, "STRING"));
				arrDatos10.add(DatoC);
				arrPosicion.add(this.crearCasilla(fila, 1, "NUMERIC"));
				arrDatos10.add(prueba.getCountC());	
				arrPosicion.add(this.crearCasilla(fila, 2, "STRING"));			
				arrDatos10.add(DatoR);
				arrPosicion.add(this.crearCasilla(fila, V50bClsConstantes.TRES, "STRING"));			
				arrDatos10.add(prueba.getCountR());
					
		}
		//datos grafico
		int filaGraf=0;
		for (int i=0; i < lista.size(); i++) {			
			if((i+1)%2!=0){
				V50bConsultaGraficoBarraPorcentajeBean  prueba = (V50bConsultaGraficoBarraPorcentajeBean ) lista.get(i);
				String anyo= prueba.getFecha().substring(V50bClsConstantes.CINCO, V50bClsConstantes.SIETE);
				if (V50bClsConstantes.EVOL_CONSULTAS_RESPUESTAS.equals(radio)){
					String consultas = Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","comun.consultas",(String) contexto.get(V50bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA));
					String respuestas = Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","comun.respuestas",(String) contexto.get(V50bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA));
					DatoC = consultas.concat(" ").concat(prueba.getMes().toUpperCase().concat(" '").concat(anyo));
					DatoR = respuestas.concat(" ").concat(prueba.getMes().toUpperCase().concat(" '").concat(anyo));
				}
				else {
					String altas = Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","comun.altaGrafico",(String) contexto.get(V50bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA));
					String bajas = Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","comun.bajaGrafico",(String) contexto.get(V50bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA));
					DatoC = altas.concat(" ").concat(prueba.getMes().toUpperCase().concat(" '").concat(anyo));
					DatoR = bajas.concat(" ").concat(prueba.getMes().toUpperCase().concat(" '").concat(anyo));			
				}
				arrPosicion2.add(this.crearCasilla(filaGraf, 0, "STRING"));
				arrDatos2.add(DatoC);			
				arrPosicion2.add(this.crearCasilla(filaGraf+1, 0, "STRING"));
				arrDatos2.add(DatoR);
				arrPosicion2.add(this.crearCasilla(filaGraf+2, 0, "STRING"));
				arrDatos2.add(prueba.getMes());
				arrPosicion2.add(this.crearCasilla(filaGraf, 1, "NUMERIC"));
				arrDatos2.add(prueba.getCountC());			
				arrPosicion2.add(this.crearCasilla(filaGraf+1, 1, "NUMERIC"));
				arrDatos2.add(prueba.getCountR());
			}
			else {
				V50bConsultaGraficoBarraPorcentajeBean  prueba2 = (V50bConsultaGraficoBarraPorcentajeBean ) lista.get(i);
				String anyo2= prueba2.getFecha().substring(V50bClsConstantes.CINCO, V50bClsConstantes.SIETE);
				if (V50bClsConstantes.EVOL_CONSULTAS_RESPUESTAS.equals(radio)){
					String consultas = Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","comun.consultas",(String) contexto.get(V50bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA));
					String respuestas = Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","comun.respuestas",(String) contexto.get(V50bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA));
					DatoC2 = consultas.concat(" ").concat(prueba2.getMes().toUpperCase().concat(" '").concat(anyo2));
					DatoR2 = respuestas.concat(" ").concat(prueba2.getMes().toUpperCase().concat(" '").concat(anyo2));
				}
				else {
					String altas = Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","comun.altaGrafico",(String) contexto.get(V50bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA));
					String bajas = Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","comun.bajaGrafico",(String) contexto.get(V50bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA));
					DatoC2 = altas.concat(" ").concat(prueba2.getMes().toUpperCase().concat(" '").concat(anyo2));
					DatoR2 = bajas.concat(" ").concat(prueba2.getMes().toUpperCase().concat(" '").concat(anyo2));		
				}
				arrPosicion2.add(this.crearCasilla(filaGraf, 2, "STRING"));
				arrDatos2.add(DatoC2);			
				arrPosicion2.add(this.crearCasilla(filaGraf+1,2, "STRING"));
				arrDatos2.add(DatoR2);
				arrPosicion2.add(this.crearCasilla(filaGraf+2, 2, "STRING"));
				arrDatos2.add(prueba2.getMes());
				arrPosicion2.add(this.crearCasilla(filaGraf, V50bClsConstantes.TRES, "NUMERIC"));
				arrDatos2.add(prueba2.getCountC());			
				arrPosicion2.add(this.crearCasilla(filaGraf+1,  V50bClsConstantes.TRES, "NUMERIC"));
				arrDatos2.add(prueba2.getCountR());
				filaGraf= filaGraf+V50bClsConstantes.DOCE;
			}	
		}		
		V50bClsExcelGrafico docExcel = new V50bClsExcelGrafico();
		String plantilla;
		plantilla = (String) contexto.get("v50bPlantillaExcelEvolucionConsultas");
		String strRutaExcel = Q70ListenerUtils.getApplicationProperty("RUTA_EXCEL")+ plantilla;
		HSSFWorkbook libro = new HSSFWorkbook();
		libro = docExcel.fncConectarExcel(strRutaExcel);
		libro.setSheetName(0, "Datos");
		libro.setSheetName(1,"Grafico");
		docExcel.fncEscribirExcelStyleFree(libro.getSheetAt(0),arrPosicion,arrDatos10);
		docExcel.fncEscribirExcelStyleFree(libro.getSheetAt(1),arrPosicion2,arrDatos2);
		byte[] bytExcel = docExcel.fncGuardarExcel(libro);
		response.setContentType("application/vnd.ms-excel");
		if (V50bClsConstantes.EVOL_CONSULTAS_RESPUESTAS.equals(radio)){
			response.setHeader("Content-disposition","inline;filename=GraficoPorEvolucionConsultas.xls");

		}
		else {
			response.setHeader("Content-disposition","inline;filename=GraficoPorEvolucionUsuariariosRegistrados.xls");

				}
		response.getOutputStream().write(bytExcel);
	}
	/**
	 * 
	 * <p>Ttulo: </p>
	 * <p>Descripcin: </p>
	 * <p>Copyright: Copyright (c) Jan 23, 2009</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author mmonge
	 * @version 1.0
	 * @param contexto contexto
	 * @param request request
	 * @param response response
	 * @param radio radio
	 * @throws Exception exception
	 */
	public void crearExcelPorTiempoMedioRespuesta(Q70ContextoEJIE contexto,HttpServletRequest request, HttpServletResponse response,String radio)throws Exception{
		V50bConsultaBean datosForm= (V50bConsultaBean)contexto.get("v50bindicadoresGestionBean");
		List lista = (ArrayList)contexto.get("v50bListaGraficos");
		List arrDatos11 = new ArrayList();
		List arrPosicion = new ArrayList();
		List arrDatos2 = new ArrayList();
		List arrPosicion2 = new ArrayList();		
		// COLUMNA 0
		this.crearColumna(new int[] { 0, 1, 2, V50bClsConstantes.TRES,V50bClsConstantes.CUATRO,V50bClsConstantes.CINCO,V50bClsConstantes.SEIS },0, "CABECERA", arrPosicion);
		this.cargarLiterales(arrDatos11, (String) contexto.get(V50bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA),new String[] { "comun.estado","","comun.th","", "comun.fechaDesde","","comun.dificultad"});
		// COLUMNA 1
		this.crearColumna(new int[] { 0, 1, 2,V50bClsConstantes.TRES,V50bClsConstantes.CUATRO,V50bClsConstantes.CINCO,V50bClsConstantes.SEIS },1, "STRING", arrPosicion);
		arrDatos11.add(datosForm.getNomEstado());
		arrDatos11.add("");
		arrDatos11.add(datosForm.getSuscriptor().getNomTh());
		arrDatos11.add("");
		arrDatos11.add(datosForm.getFechaConsultaD());
		arrDatos11.add("");
		arrDatos11.add(datosForm.getDescDificultad());		
		// COLUMNA 2
		this.crearColumna(new int[] { 0, 1, 2, V50bClsConstantes.TRES,V50bClsConstantes.CUATRO,V50bClsConstantes.CINCO,V50bClsConstantes.SEIS},2, "CABECERA", arrPosicion);
		this.cargarLiterales(arrDatos11, (String) contexto.get(V50bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA),new String[] { "comun.ambito","","comun.municipio", "","comun.fechaHasta","",""});
		// COLUMNA 3
		this.crearColumna(new int[] { 0, 1, 2,V50bClsConstantes.TRES,V50bClsConstantes.CUATRO,V50bClsConstantes.CINCO,V50bClsConstantes.SEIS },V50bClsConstantes.TRES, "STRING", arrPosicion);
		arrDatos11.add(datosForm.getDescAmbito());
		arrDatos11.add("");
		arrDatos11.add(datosForm.getSuscriptor().getNomMunicipio());
		arrDatos11.add("");
		arrDatos11.add(datosForm.getFechaConsultaH());
		arrDatos11.add("");
		arrDatos11.add("");
		// CABECERA TABLA
		this.crearFila(V50bClsConstantes.NUEVE,new int[] { 0, 1,}, "CABECERA", arrPosicion);
		this.cargarLiterales(arrDatos11, (String) contexto.get(V50bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA),	new String[] { "comun.trespuesta", "comun.nconsultas"});
		// DATOS TABLA
		String DatoX="";
		for (int index = 0; index < lista.size(); index++) {
			V50bConsultaGraficoPorcentajeBean  prueba = (V50bConsultaGraficoPorcentajeBean ) lista.get(index);
			int fila = V50bClsConstantes.DIEZ + index;
			if(!"1".equals(prueba.getTituloGraf())){
				String dias = Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","criterios.dias",(String)contexto.get(V50bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA));
				DatoX=prueba.getTituloGraf().concat(" ").concat(dias);
			}
			else{
				String dia = Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","criterios.dia",(String)contexto.get(V50bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA));
				DatoX= prueba.getTituloGraf().concat(" ").concat(dia);
			}
			arrPosicion.add(this.crearCasilla(fila, 0, "STRING"));
			arrDatos11.add(DatoX);
			arrPosicion.add(this.crearCasilla(fila, 1, "NUMERIC"));
			arrDatos11.add(prueba.getCountGraf());				
		}
		//datos grafico
		int filaGraf=0;	
		for (int index = 0; index < lista.size(); index++) {
			V50bConsultaGraficoPorcentajeBean  prueba = (V50bConsultaGraficoPorcentajeBean ) lista.get(index);
			if(!"1".equals(prueba.getTituloGraf())){
				String dias = Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","criterios.dias",(String)contexto.get(V50bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA));
				DatoX=prueba.getTituloGraf().concat(" ").concat(dias);
			}
			else{
				String dia = Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","criterios.dia",(String)contexto.get(V50bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA));
				DatoX= prueba.getTituloGraf().concat(" ").concat(dia);
			}
			arrPosicion2.add(this.crearCasilla(filaGraf+index, 0, "STRING"));
			arrDatos2.add(DatoX);
			arrPosicion2.add(this.crearCasilla(filaGraf+index, 1, "NUMERIC"));
			arrDatos2.add(prueba.getCountGraf());				
		}
		arrPosicion2.add(this.crearCasilla(0, 2, "STRING"));
		String tiempoRespuesta = Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","criterios.tiempoMedRespuesta",(String) contexto.get(V50bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA));
		arrDatos2.add(tiempoRespuesta);			
		V50bClsExcelGrafico docExcel = new V50bClsExcelGrafico();
		String plantilla;
		plantilla = (String) contexto.get("v50bPlantillaExcelTiempoMedioRespuesta");
		String strRutaExcel = Q70ListenerUtils.getApplicationProperty("RUTA_EXCEL")+ plantilla;
		HSSFWorkbook libro = new HSSFWorkbook();
		libro = docExcel.fncConectarExcel(strRutaExcel);
		libro.setSheetName(0, "Datos");
		libro.setSheetName(1,"Grafico");
		docExcel.fncEscribirExcelStyleFree(libro.getSheetAt(0),arrPosicion,arrDatos11);
		docExcel.fncEscribirExcelStyleFree(libro.getSheetAt(1),arrPosicion2,arrDatos2);
		byte[] bytExcel = docExcel.fncGuardarExcel(libro);
		response.setContentType("application/vnd.ms-excel");
		response.setHeader("Content-disposition","inline;filename=GraficoPorTiempoMedioRespuesta.xls");
		response.getOutputStream().write(bytExcel);
	}
	
	/**
	 * 
	 * <p>Ttulo: </p>
	 * <p>Descripcin: </p>
	 * <p>Copyright: Copyright (c) Jan 27, 2009</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author mmonge
	 * @version 1.0
	 * @param contexto contexto
	 * @return String string
	 */
	private String fncObtenerListaAmbitosConcatenados(Q70ContextoEJIE contexto)
	{
		String[] ambitosSel=(String[])contexto.get("comboAmbito");
		List listaAmbitos=(List)contexto.get("v50bListaAmbitosGR");
		String result="";
		for(int i=0; i<listaAmbitos.size();i++){
			V50bAmbitoBean ambito=(V50bAmbitoBean) listaAmbitos.get(i);

			if(ambitosSel.length!=0){
				for(int j=0;j<ambitosSel.length;j++){
					if((ambitosSel[j]).equals(ambito.getCambit())){
						if(j!=ambitosSel.length-1){
							result= result.concat(ambito.getDesamc()).concat(", ");
						}
						else{
							result= result.concat(ambito.getDesamc());
						}
					}
				}
			}
		}
		return result;
	}
	
	/**
	 * 
	 * <p>Ttulo: </p>
	 * <p>Descripcin: </p>
	 * <p>Copyright: Copyright (c) Jan 28, 2009</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author brey
	 * @version 1.0
	 * @param contexto contexto
	 * @return String string
	 */
	private String fncObtenerDificultad(Q70ContextoEJIE contexto)
	{   
		V50bConsultaBean consulta=(V50bConsultaBean)contexto.get("v50bConsultasBean");
		String dificultaCod=consulta.getDificultad().getCoddif();
		List listaDificultad=(List)contexto.get("v50bListaDificultadesAmbito");
		String result="";
		if(listaDificultad!=null){
			for(int i=0; i<listaDificultad.size();i++){
				V50bConsultaBean dificultad=(V50bConsultaBean) listaDificultad.get(i);
				if(!"".equals(dificultaCod)&&dificultaCod!=null){
					if((dificultaCod).equals(dificultad.getDificultad().getCoddif())){
						result=dificultad.getDificultad().getDescc();
						break;
					}			
				}
			}
		}
		return result;
		
	}
	
	/**
	 * @param contexto Q70ContextoEJIE
	 * @param errors ActionErrors
	 * @param mapping ActionMapping
	 * @param form ActionForm
	 * @param request HttpServletRequest
	 * @param response HttpServletResponse
	 * @throws Exception excepcion
	 */
	public void processOP(Q70ContextoEJIE contexto, ActionErrors errors,ActionMapping mapping, ActionForm form, HttpServletRequest request,HttpServletResponse response) throws Exception 
	{
		V50bClsTrazas.depura("V50bExcelIndicadoresGestion.processOP() ");
		

	}	
	/**
	 * 
	 * @param contexto : Q70ContextoEJIE
	 * @param errors : ActionErrors
	 * @param mapping : ActionMapping
	 * @param form : ActionForm
	 * @param request : request
	 * @param response : response
	 * @return ActionForward
	 * @throws Exception Se lanza la excepcin
	 */
	public ActionForward processForward(Q70ContextoEJIE contexto,ActionErrors errors, ActionMapping mapping, ActionForm form,HttpServletRequest request, HttpServletResponse response)throws Exception 
	{
		V50bClsTrazas.depura("V50bExcelIndicadoresGestion.processForward() ");
		V50bCriteriosConsultaBean aux= (V50bCriteriosConsultaBean)contexto.get("v50bCriteriosBean");
		String radio= aux.getRadio();
		String concatAmbitos=this.fncObtenerListaAmbitosConcatenados(contexto);
		String dificultad=this.fncObtenerDificultad(contexto);
		V50bConsultaBean miBean= (V50bConsultaBean)contexto.get("v50bindicadoresGestionBean");
		if(!"".equals(concatAmbitos))	{
			miBean.setDescAmbito(concatAmbitos);
		}
		if(!"".equals(dificultad))	{
			miBean.setDescDificultad(dificultad);
		}
		contexto.set("v50bindicadoresGestionBean", miBean);
		if(V50bClsConstantes.ESTADO_CONSULTAS.equals(radio)){
			this.crearExcelPorEstadosConsulta(contexto, request, response,radio);
		}
		else if(V50bClsConstantes.POR_SEXO.equals(radio)){
			this.crearExcelPorSexo(contexto, request, response);
		}
		else if(V50bClsConstantes.POR_LOCALIZACION.equals(radio)){
			this.crearExcelPorLocalidad(contexto, request, response);
		}
		else if(V50bClsConstantes.CAUSAS_REENVIOS.equals(radio)){
			this.crearExcelPorReenvios(contexto, request, response, radio);
		}
		else if(V50bClsConstantes.RESPUESTAS_TECNICOS.equals(radio)){
			this.crearExcelPorRespuestasTecnicos(contexto, request, response);
		}
		else if(V50bClsConstantes.TIPO_TRABAJO.equals(radio)){
			this.crearExcelPorTipoTrabajoProfesion(contexto, request, response);
		}
		else if(V50bClsConstantes.POR_EDADES.equals(radio)){
			this.crearExcelPorEdad(contexto, request, response);
		}
		else if(V50bClsConstantes.EXTRAIDOS_MULTITERM.equals(radio)){
			this.crearExcelPorMultiterm(contexto, request, response);
		}
		else if(V50bClsConstantes.INCORP_CATALOGO.equals(radio)){
			this.crearExcelPorEstadosConsulta(contexto, request, response,radio);
		}
		else if(V50bClsConstantes.CAUSAS_DENEGACION.equals(radio)){
			this.crearExcelPorReenvios(contexto, request, response,radio);
		}
		else if(V50bClsConstantes.CAUSAS_RECHAZOS.equals(radio)){
			this.crearExcelPorReenvios(contexto, request, response,radio);
		}
		else if(V50bClsConstantes.DIFICULTAD.equals(radio)){
			this.crearExcelPorDificultad(contexto, request, response);
		}
		else if(V50bClsConstantes.MEDIOS_LLEGADA_CONSULTA.equals(radio)){
			this.crearExcelPorMediosLlegada(contexto, request, response);
		}
		else if(V50bClsConstantes.EVOL_CONSULTAS_RESPUESTAS.equals(radio)){
			this.crearExcelPorEvolucionConsulta(contexto, request, response, radio);
		}
		else if(V50bClsConstantes.EVOL_USUARIOS_REG.equals(radio)){
			this.crearExcelPorEvolucionConsulta(contexto, request, response, radio);
		}
		else if(V50bClsConstantes.TIEMPO_MEDIO_RESPUESTA.equals(radio)){
			this.crearExcelPorTiempoMedioRespuesta(contexto, request, response, radio);
		}
		return null;	
		}
	}


