package v50b.v50bOperacionesPaso.v50bconsultas.v50bHistoricoConsultas;

import java.util.ArrayList;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import v50b.v50bBeans.V50bConsultaBean;
import v50b.v50bClasesComunes.V50bClsConstantes;
import v50b.v50bClasesComunes.V50bClsFecha;
import v50b.v50bClasesComunes.V50bClsInformes;
import v50b.v50bClasesComunes.V50bClsTrazas;
import v50b.v50bComun.V50bActionPasoOP;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;
import es.ejie.frmk.listeners.base.Q70ListenerUtils;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;


/**
 * 
 * @author alata
 *
 */
public class V50bImprimirBusquedaAction extends V50bActionPasoOP {
	
	/**
	 * 
	 * @param contexto : Q70ContextoEJIE
	 * @param arg1 : ActionErrors
	 * @param arg2 : ActionMapping
	 * @param arg3 : ActionForm
	 * @param req : request
	 * @param arg5 : response
	 * @throws Exception Se lanza la excepcin
	*/
	protected void processOP(Q70ContextoEJIE contexto, ActionErrors arg1,
			ActionMapping arg2, ActionForm arg3, HttpServletRequest req,
			HttpServletResponse arg5) throws Exception {
		
		V50bClsTrazas.depura("V50bImprimirBusquedaAction.processOP() ");
		
		//Plantilla
		String strPlantilla = (String) contexto.get("plantillaBusqueda");
	
		//Parametros
		ArrayList arrParametros = new ArrayList();
		
		//Imagen
		StringBuffer imagenSB = new StringBuffer(Q70ListenerUtils.getApplicationProperty("RUTA_PLANTILLA"));
		imagenSB.append(V50bClsConstantes.CONSTANTE_LOGO_IVAP);
		String imagenString = imagenSB.toString();
		String imagen = this.getClass().getResource(imagenString).toString();
		
		arrParametros.add(imagen);
		
		//Fecha
		String fecha=V50bClsFecha.fncPresentarFechaSistemaCorta((String)contexto.get(V50bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA));
	    arrParametros.add(fecha);
		
	    //Idioma
		String idioma = Q70ListenerUtils.getLanguage(req);
		arrParametros.add(idioma);
				
		//Literales
		ArrayList arrLiterales = new ArrayList();
		arrLiterales.add("comun.historicoConsultas");
		arrLiterales.add("comun.pagina");
		arrLiterales.add("comun.dni");
		arrLiterales.add("comun.nombre");
		arrLiterales.add("historicoConsultas.apellidoUno");
		arrLiterales.add("historicoConsultas.apellidoDos");
		arrLiterales.add("comun.subcategoria");
		arrLiterales.add("comun.estado");
		arrLiterales.add("comun.fConsultaDesde");
		arrLiterales.add("comun.fConsultaHasta");
		arrLiterales.add("comun.fRespuestaDesde");
		arrLiterales.add("comun.fRespuestaHasta");
		arrLiterales.add("comun.recibidoDesde");
		arrLiterales.add("comun.abreviaturas");
		arrLiterales.add("comun.dificultad");
		arrLiterales.add("estadoConsultas.fueraPlazo");
		arrLiterales.add("historicoConsultas.multiterm");
		arrLiterales.add("comun.visibleINET");
		arrLiterales.add("comun.motivosDenegacion");
		arrLiterales.add("comun.motivosRechazo");
		arrLiterales.add("comun.motivosReenvio");
		arrLiterales.add("comun.fecha");
		arrLiterales.add("comun.consulta");
		arrLiterales.add("comun.ambito");
		arrLiterales.add("comun.idioma");
		arrLiterales.add("comun.dificultad");		
		arrLiterales.add("historicoConsultas.dias");
		arrLiterales.add("comun.resolutor");
		arrLiterales.add("comun.pClave");
		
		arrLiterales.add("comun.si");
		arrLiterales.add("comun.no");

		//ArrayList Busqueda
		ArrayList arrDatosTablasBusquedas = (ArrayList)contexto.get("v50bListaHistConsultas");
		
		V50bConsultaBean datosConsulta = (V50bConsultaBean)contexto.get("v50bHistConsultasBeanOrig");
		
		String dni = datosConsulta.getSuscriptor().getNifOtros();
		String nombre = datosConsulta.getSuscriptor().getNombre();
		String ape1 = datosConsulta.getSuscriptor().getApellido1();
		String ape2 = datosConsulta.getSuscriptor().getApellido2();
		String fechaCosulta = datosConsulta.getFechaConsulta();
		String consulta = datosConsulta.getConsulta();
		String descAmbito = datosConsulta.getAmbito().getDesamc();
		String descSubcat = datosConsulta.getSubcategoria().getDesCas();
		String descDific = datosConsulta.getDificultad().getDescc();
		String resolutor = datosConsulta.getNomResolutor();
		String estado = datosConsulta.getNomEstado();
		String descIdioma = datosConsulta.getDescIdioma();
		String motDenegacion = datosConsulta.getDescMotivDenegar();
		String motRechazo = datosConsulta.getDescMotivRechazo();
		String motReenvio = datosConsulta.getDescMotivReenvio();
		String fueraPlazo = datosConsulta.getIndFinPlazo();
		String multiterm = datosConsulta.getMultiterm();
		String visible = datosConsulta.getPublicado();
		String recibido = datosConsulta.getRecepcion();
		String abreviaturas = datosConsulta.getAbreviaturas();
		String palabrasClave = datosConsulta.getPalabrasClave();
		
		//parametro4
		if(dni!=null && !"".equals(dni)){
			arrParametros.add(dni);
		}
		else{
			arrParametros.add("");
		}
		//parametro5
		if(nombre!=null && !"".equals(nombre)){
			arrParametros.add(nombre);
		}
		else{
			arrParametros.add("");
		}
		//parametro6
		if(ape1!=null && !"".equals(ape1)){
			arrParametros.add(ape1);
		}
		else{
			arrParametros.add("");
		}
		//parametro7
		if(ape2!=null && !"".equals(ape2)){
			arrParametros.add(ape2);
		}
		else{
			arrParametros.add("");
		}
		//parametro8
		if(fechaCosulta!=null && !"".equals(fechaCosulta)){
			arrParametros.add(fechaCosulta);
		}
		else{
			arrParametros.add("");
		}
		//parametro9
		if(consulta!=null && !"".equals(consulta)){
			arrParametros.add(consulta);
		}
		else{
			arrParametros.add("");
		}
		//parametro10
		if (descAmbito!=null && !"".equals(descAmbito)){
			arrParametros.add(descAmbito);
		}
		else{
			arrParametros.add("");
		}
		//parametro11
		if (descSubcat!=null && !"".equals(descSubcat)){
			arrParametros.add(descSubcat);
		}
		else{
			arrParametros.add("");
		}
		//parametro12
		if(StringUtils.isBlank(datosConsulta.getFechaConsultaD())){
			arrParametros.add(" ");
		}
		else {
			arrParametros.add(datosConsulta.getFechaConsultaD());
		}
		//parametro13
		if(StringUtils.isBlank(datosConsulta.getFechaConsultaH())){
			arrParametros.add(" ");
		}
		else {
			arrParametros.add(datosConsulta.getFechaConsultaH());
		}
		//parametro14
		if(StringUtils.isBlank(datosConsulta.getFechaRespuestaD())){
			arrParametros.add(" ");
		}
		else {
			arrParametros.add(datosConsulta.getFechaRespuestaD());
		}
		//parametro15
		if(StringUtils.isBlank(datosConsulta.getFechaRespuestaH())){
			arrParametros.add(" ");
		}
		else {
			arrParametros.add(datosConsulta.getFechaRespuestaH());
		}
		//parametro16
		if (descDific!=null && !"".equals(descDific)){
			arrParametros.add(descDific);
		}
		else{
			arrParametros.add("");
		}
		//parametro17
		if (resolutor!=null && !"".equals(resolutor)){
			arrParametros.add(resolutor);
		}
		else{
			arrParametros.add("");
		}
		//parametro18
		if (estado!=null && !"".equals(estado)){
			arrParametros.add(estado);
		}
		else{
			arrParametros.add("");
		}
		//parametro19
		if (motDenegacion!=null && !"".equals(motDenegacion)){
			arrParametros.add(motDenegacion);
		}
		else{
			arrParametros.add("");
		}
		//parametro20
		if (motRechazo!=null && !"".equals(motRechazo)){
			arrParametros.add(motRechazo);
		}
		else{
			arrParametros.add("");
		}
		//parametro21
		if (motReenvio!=null && !"".equals(motReenvio)){
			arrParametros.add(motReenvio);
		}
		else{
			arrParametros.add("");
		}
		//parametro22
		if (descIdioma!=null && !"".equals(descIdioma)){
			arrParametros.add(descIdioma);
		}
		else{
			arrParametros.add("");
		}
		//parametro23
		if(StringUtils.isEmpty(fueraPlazo)) {
			arrParametros.add("");
		}else if (fueraPlazo.equals(V50bClsConstantes.CONSTANTE_NO) ){
			arrParametros.add(Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","comun.no",idioma));
		} else {
			arrParametros.add(Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","comun.si",idioma)); 
		}
		//parametro24
		if(StringUtils.isEmpty(multiterm)){
			arrParametros.add("");
		}
		else if (multiterm.equals(V50bClsConstantes.CONSTANTE_NO)){
			arrParametros.add(Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","comun.no",idioma));
		} else {
			arrParametros.add(Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","comun.si",idioma)); 
		}	
		//parametro25
		if(StringUtils.isEmpty(visible)){
			arrParametros.add("");
		}else if (visible.equals(V50bClsConstantes.CONSTANTE_NO)){
			arrParametros.add(Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","comun.no",idioma));
		} else {
			arrParametros.add(Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","comun.si",idioma)); 
		}	
		//parametro26
		if (recibido!=null && !"".equals(recibido)){
			if (recibido.equals(V50bClsConstantes.RECEPCION_CORREO)){
				arrParametros.add(Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","comun.correo",idioma));
			}
			else if (recibido.equals(V50bClsConstantes.RECEPCION_TELEFONO)){
				arrParametros.add(Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","comun.telefono",idioma));
			}
			else if (recibido.equals(V50bClsConstantes.RECEPCION_INICIATIVA)){
				arrParametros.add(Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","comun.iniciativaPropia",idioma));
			}
			else if (recibido.equals(V50bClsConstantes.RECEPCION_PROPUESTA)){
				arrParametros.add(Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","comun.propuesta",idioma));
			}
			else if (recibido.equals(V50bClsConstantes.RECEPCION_MIGRACION)){
				arrParametros.add(Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","comun.migracionInicial",idioma));
			}
		}
		else{
			arrParametros.add("");
		}
		//parametro27
		if(StringUtils.isEmpty(abreviaturas)){
			arrParametros.add("");
		}else if (abreviaturas.equals(V50bClsConstantes.CONSTANTE_NO)){
			arrParametros.add(Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","comun.no",idioma));
		} else {
			arrParametros.add(Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","comun.si",idioma)); 
		}
		
		//parametro28
		if(palabrasClave!=null && !"".equals(palabrasClave)){
			arrParametros.add(palabrasClave);
		}
		else{
			arrParametros.add("");
		}
					
		//Generamos PDF
		V50bClsInformes.fncSacarListadoFOPBeanAnidado(req,arg5,idioma,Q70ListenerUtils.getApplicationProperty("RUTA_PLANTILLA")+strPlantilla,arrParametros,arrLiterales,arrDatosTablasBusquedas,"v50bcomun", null);
		
	}
	
	/**
	 * 
	 * @param contexto : Q70ContextoEJIE
	 * @param arg1 : ActionErrors
	 * @param mapping : ActionMapping
	 * @param arg3 : ActionForm
	 * @param request : request
	 * @param arg5 : response
	 * @return ActionForward
	 * @throws Exception Se lanza la excepcin
	 */
	protected ActionForward processForward(Q70ContextoEJIE contexto,
			ActionErrors arg1, ActionMapping mapping, ActionForm arg3,
			HttpServletRequest request, HttpServletResponse arg5)
			throws Exception {
		
		V50bClsTrazas.depura("V50bImprimirBusquedaAction.processForward() ");
		
		if (arg1.isEmpty()){
			String hayBusqueda=(String)contexto.get("busqRealizada");
			
			if("false".equals(hayBusqueda)){
				contexto.set("v50bListaHistConsultas",null);
			}
			return mapping.findForward("ok");
		}
		else{
			return mapping.findForward("error");
		}
	}
}